' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.




        '* * * * * *
        ' This routine handles port and console key input.  Doing
        ' analsis for special when-caller-on keys, and logging to a
        ' file if desired.
        '
        ' p  -2 when you don't want to use the function keys below
        '       (example, WFC has its own keys).
        '    -3 when you only want 'normal' keystrokes allowed from
        '       the console.  A -3, and a check for -1 upon return,
        '       effectively shuts down the console keyboard for this
        '       node.
        '    -4 for 'like 0 but with <ctrl>Fx keys'
        '    -5 for 'like -2 but with <ctrl>Fx keys'
        '    -6 to just pass on what get--no filtering at all.
        '    returns -1 if from KB, 0 if from Port or none.
        '
        ' returns  -1          for no input
        '          0 - 255     for ASCII input
        '          <> -1, <> 0 for keyboard extended key input
        '
        ' For input from port, the values are -1, 0 to 255.  Never
        ' anything else, so 'large' values can be assumed to have come
        ' from the KB.
        '
        ' When no user is logged in, the arrow keys act like normal
        ' arrow keys.
        '
        ' The additional 'THEN IF's are to try to maximize speed by not
        ' doing unnecessary calls (since this routine must be maximized
        ' for speed).
        '
        ' Date last checked for perfection: Sep 18 1992
        '
FUNCTION CommIn% (p)

  K9 = p
  '16 bits:
  '   1 1 when ON, to filter all <esc>'s from the remote end--allowing only
  '       arrow keys (which we then return using the sysop arrow key codes).
  '       [since the sysop arrow keys are processed here, normally, it is
  '       no problem/confusion.]
  '   2 2 don't check for the <esc> key combinations (<esc><esc>, <esc>c, etc.)
  '       actually, this may not be needed--since we don't call anything, but
  '       merely return a 327xx value, or hang up.
  '   3 4 don't check for <control>Fx keys.
  '   4 8 to stop special keyboard input (except F9)
  '   5 16 to stop all keyboard input
  '   6 32 to allow detection of net mail call signals.
  '   7 64 to ignore <alt>c
  '   8 128 to allow special keys to pass on through (only works when bit 4
  '         is also ON.
  '   9 256 to allow <alt>c to chat--only allowed at menus.
  '  10 512 to just send what come's in the port directly through.
  '  11 1024 to not process the keyboard (push it off till later).
  '  12 2048 if in UserEdit--so F9 and F10 are passed thru.
  '          (and pgup, pgdn, and f1).
  '  13 4096 for window viewing: allows esc, pgup,pgdn,home,end
  '  14 8192
  '  15 16384
  '  16 -'ve
  '
  IF NOT BitTest(Settings.Toggles2,11) THEN CALL BitSet(K9,4)
  '
  ' Check the keyboard.
  '
  IF NOT BitTest(K9,11) THEN K = KBIn _
                        ELSE K = 0
  SELECT CASE K
    CASE 0
         IF CommPort = 0 THEN p = -1 : _
                              CommIn = -1 : _
                              EXIT FUNCTION
         K = -1
    CASE ELSE : IF BitTest(K9,5) THEN K = -1
  END SELECT
  '
  ' <esc><esc> to logoff user handling.  Identical to <alt>h, but a lot more
  ' easier and fun.
  '
  SELECT CASE K
    CASE 27
         IF BitTest(K9,12) OR BitTest(K9,13) THEN CommIn = 27 : _
                                                  EXIT FUNCTION
         SELECT CASE BitTest(K9,2)
           CASE 0
                DO : K = KBIn
                LOOP UNTIL K <> 0 OR NoCarrier
                SELECT CASE K
                  CASE 27 : K = 8960
                  CASE 99 : K = 32766
                  CASE 49 : K = 32765
                  CASE 50 : K = 32764
                  CASE ELSE : K = -1
                END SELECT
         END SELECT
  END SELECT
  SELECT CASE BitTest(K9,3)
    CASE 0
         K0 = 0
         SELECT CASE K
           CASE 24064 : K0 = 851                '<ctrl>F1 sysop defined.
           CASE 24320 : K0 = 852                '<ctrl>F2 sysop defined.
           CASE 24576 : K0 = 853                '<ctrl>F3 sysop defined.
           CASE 24832 : K0 = 854                '<ctrl>F4 sysop defined.
           CASE 25088 : K0 = 855                '<ctrl>F5 sysop defined.
           CASE 25344 : K0 = 856                '<ctrl>F6 sysop defined.
           CASE 25600 : K0 = 857                '<ctrl>F7 sysop defined.
           CASE 25856 : K0 = 858                '<ctrl>F8 sysop defined.
           CASE 26112 : K0 = 859                '<ctrl>F9 sysop defined.
           CASE 26368 : K0 = 860                '<ctrl>F10 sysop defined.
         END SELECT
         IF K0 <> 0 THEN CommIn = K : _
                         TT$ = Short$(K0) : _
                         EXIT FUNCTION
  END SELECT
  SELECT CASE BitTest(k9,4)
    CASE -1 : IF NOT BitTest(K9,8) _
                 THEN IF (K < 0 OR K > 255) AND K <> 17152 THEN K = -1
    CASE 0
         K7 = 0
         SELECT CASE K
           CASE 0 TO 255
           CASE 32764, 32765, 32766             'For when in Chat.
           CASE UpSC, DownSC, RightSC, LeftSC : K7 = 1
'|eliminated functionality (I'm so loath to give it up, so I mark it).
'|           CASE UpSC, DownSC, RightSC, LeftSC
'|                SELECT CASE ConnectCPS
'|                  CASE 11500 : K7 = 1       'If at console.
'|                  CASE ELSE
'|                       SELECT CASE K
'|                         CASE UpSC                 '+5 mins to user.
'|                              IF CommPort <> 0 _
'|                                 THEN User.Elapsed = User.Elapsed - 5 : _
'|                                      GlobalStuff$(17) = Short$(600)
'|                         CASE DownSC               '-5 mins to user.
'|                              IF CommPort <> 0 _
'|                                 THEN User.Elapsed = User.Elapsed + 5 : _
'|                                      GlobalStuff$(17) = Short$(601)
'|                         CASE RightSC              '+1 SL
'|                              IF CommPort <> 0 _
'|                                 THEN IF UserSL <> LevelsSize _
'|                                         THEN UserSL = UserSL + 1 : _
'|                                              GlobalStuff$(17) = Short$(607) _
'|                                         ELSE GlobalStuff$(17) = Short$(608)
'|                         CASE LeftSC                '-1 SL
'|                              IF CommPort <> 0 _
'|                                 THEN IF UserSL <> 1 _
'|                                         THEN UserSL = UserSL - 1 : _
'|                                              GlobalStuff$(17) = Short$(610) _
'|                                         ELSE GlobalStuff$(17) = Short$(655)
'|                       END SELECT
'|                END SELECT
           CASE 7936                            '<alt>s  shell to DOS.
                TT$ = Short$(577) + Form$(20,Settings.Sysop) + Lines$(174)
                CALL CommOut(TT$)
                CALL AnsiTT
                TT$ = Null$
                CALL ShellDosTT(1)
                TT$ = Short$(578) + Lines$(175)
                CALL CommOut(TT$)
                CALL AnsiTT
                IF BitTest(K9,7) THEN CALL CursorOn
           CASE 8960                            '<alt>h  hang up caller.
                CALL Quote(0)
           CASE 11776                           '<alt>c  chat with caller.
                IF BitTest(K9,9) AND NOT BitTest(K9,7) THEN CALL Chat1 : _
                                                            K = 13
           CASE 6400                            '<alt>p
                IF NOT BitTest(K9,7) THEN CALL PortDebugger : _
                                          K = 13
           CASE 12288                           '<alt>b  beep the caller.
                TT$ = C7$ + C7$
                CALL CommOut(TT$)
                CALL AnsiTT
           CASE 18688, 20736, 18176, 20224, 15104
                IF K <> 15104 AND BitTest(K9,13) THEN CommIn = K : _
                                                      EXIT FUNCTION
                SELECT CASE K
                  CASE 18688                            '<pgup>  send text file.
                       IF BitTest(K9,12) THEN K7 = 1 _
                                  ELSE CALL Keyboarding(4,4)
                  CASE 20736, 15104                     '<pgdn> or <f1>  trap all toggle.
                       SELECT CASE BitTest(K9,12)
                         CASE -1 : K7 = 1
                         CASE ELSE
                       CALL BitToggle(Settings.Toggles2,8)
                       IF BitTest(Settings.Toggles2,8) AND NOT BitTest(User.Attr,6) _
                          THEN TT = 10959 : _
                               Handle(1) = FileOpenW(FileNames(51)) _
                          ELSE TT = 10960 : _
                               CALL FileCloseW(Handle(1)) : _
                               CALL BitClear(User.Attr,6)
                       CALL AnsiTT
                      END SELECT
                END SELECT
           CASE 15360                           'F2  trap chat toggle.
                CALL BitToggle(Settings.Toggles1,5)
                IF BitTest(Settings.Toggles1,5) AND NOT BitTest(User.Attr,5) _
                   THEN TT = 10903 _
                   ELSE TT = 10639 : _
                        CALL BitClear(User.Attr,5)
                CALL AnsiTT
           CASE 15616                           'F3  sysop chat avail. toggle.
                CALL BitToggle(Settings.Toggles1,4)
           CASE 16128                           'F5  sysop on next toggle.
                CALL BitToggle(Settings.Toggles2,3)
           CASE 16384                           'F6  blank the screen toggle.
                IF NOT BitTest(K9,7) _
                   THEN TT = 10067 : _
                        CALL AnsiTT : _
                        CALL BitToggle(Settings.Toggles2,2) : _
                        TT = 10067 : _
                        CALL AnsiTT
           CASE 11520                           '<alt>x immediate exit to DOS.
                '
                ' We don't want to be doing any disk writes/etc.  Since the
                ' sysop may be doing this as an emergency to, say, undelete
                ' a file.
                '
                IF CommPort = 0 OR BitTest(Settings.Toggles2,15) _
                   THEN TT$ = Null$ : _
                        CALL ShellDosTT(2)
           CASE 11264                              '<alt>z  exit to dos
                IF CommPort = 0 OR BitTest(Settings.Toggles2,15) _
                   THEN CommPort = Settings.CommPort : _
                        CALL CommOut(RTRIM$(Settings.ModemOffHook) + C1310$) : _
                        CALL Delay : _
                        TT$ = Null$ : _
                        CALL ShellDosTT(2)
           CASE 5632                             '<alt>u  user maintenance
                SELECT CASE BitTest(K9,7)
                  CASE 0
                       IF GInUse > 0 THEN TT = 10064 : _
                                          CALL AnsiTT
                       K = CommPort
                       CommPort = 0
                       zzz$ = User.UserName
                       CALL AlterTheUsersData(zzz$)
                       CommPort = K
                       K = 13
                END SELECT
           CASE 9472                             '<alt>k  kill user
                CALL BitSet(User.Attr,1)
                TT = 10117
                CALL AnsiTT
           CASE 29440                            '<ctrl><left>   ''
                IF NOT BitTest(K9,7) THEN K = 27
           CASE 17408                            '<F10> show hot-keys
                SELECT CASE BitTest(K9,12)
                  CASE -1 : K7 = 1
                  CASE ELSE
                       IF GInUse > 0 THEN CALL GSetMode(0,0,0) : _
                                          GInUse = 0
                       IF BitTest(K9,7) THEN CALL Ansi2(GetBlock$(2,72)) _
                                        ELSE CALL Ansi2(GetBlock$(2,71))
                END SELECT
'|           CASE 17152                            '<F9>
'|                IF BitTest(K9,12) THEN K7 = 1
         END SELECT
         IF K > 255 AND K < 32764 AND K7 = 0 THEN K = -1
  END SELECT
  '
  ' Check the port.  &H2000 returns -1 for an empty port, and 0 when
  ' Comm Port = 0.
  '
  p = 0
  SELECT CASE (K = -1 AND CommPort > 0)
    CASE -1
         K = FosIntAX(CommPort,&H2000)
         IF K >= 0 AND BitTest(K9,10) THEN p = -1 : _
                                           CommIn = K : _
                                           EXIT FUNCTION
         SELECT CASE BitTest(K9,6) + BitTest(Settings.Toggles3,1)
           CASE -2
                '
                ' Net protocol codes.  For net mail.
                '
                SELECT CASE K
                  CASE 174, 241
                       IF LEN(RTRIM$(User.UserName)) = 0 _
                          THEN CALL NetMailInBoundHandler(K)
                  CASE 69 TO 83   'EMSI_INQ all that matters.
                       GlobalStuff$(24) = RIGHT$(GlobalStuff$(24) + Chars$(K),7)
                       IF GlobalStuff$(24) = Short$(119) _
                          THEN GlobalStuff$(24) = Null$ : _
                               CALL NetMailInBoundHandler(-1)
                END SELECT
         END SELECT
         SELECT CASE K
           CASE 27  'ANSI codes.  For arrow keys.
                SELECT CASE BitTest(K9,1)
                  CASE -1
                       DO : K = FosIntAX(CommPort,&H2000)
                       LOOP UNTIL K >= 0 OR NoCarrier    'Get past the '['
                       DO : K = FosIntAX(CommPort,&H2000)
                       LOOP UNTIL K >= 0 OR NoCarrier    'Get the important character.
                       SELECT CASE K
                         CASE 65 : K = UpSC
                         CASE 66 : K = DownSC
                         CASE 67 : K = RightSC
                         CASE 68 : K = LeftSC
                       END SELECT
                END SELECT
         END SELECT
    CASE ELSE : p = -1
  END SELECT
  IF K >= 0 AND K < 256 _
     THEN IF BitTest(Settings.Toggles2,8) _
             THEN IF DriveSpc&(FileNames(51)) > Settings.MinSpace _
                     THEN CALL FilePutSEnd(Handle(1),Chars$(K))
  CommIn = K

END FUNCTION
        '
        '* * * *


'these are common at-keyboard commands, both in and out of overlays.
'p = where called from:
'    1 = comm prog
'    2 = port debugger
'    3 = WFC
'    4 = commin
'p0 = what to do.
SUB Keyboarding (p,p0)

  SELECT CASE p0
    CASE 1                              'upload.
         K20 = CommPort
         CommPort = 0
         TT = 10986
         CALL SendTT
         K3 = 0
         K3& = 0
         K4 = 0
         z$ = GlobalStuff$(1)
         TT$ = Short$(962) + z$ + Short$(963)
         z2$ = UCASE$(LineEditTT$(1))
         IF LEN(z2$) > 0 THEN GlobalStuff$(1) = z2$ : _
                              z$ = z2$
         K2$ = Null$
         K1 = 0
         DO
           TT$ = Short$(964) + z$ + Short$(965) + IntToStr$(K3) + _
                 Short$(978) + Commas$(K3&) + Short$(980)
           SELECT CASE ConfirmFile(K0$)
             CASE -1
                  K2$ = K2$ + K0$ + C1310$
                  K1 = -1
                  K5 = FindF(K0$,FFile)
                  IF K5 <> 0 THEN DO : _
                                    K3 = K3 + 1 : _
                                    K3& = K3& + FFile.FSize : _
                                  LOOP UNTIL FindF(Null$,FFile) = 0
           END SELECT
         LOOP UNTIL LEN(K0$) = 0
         CALL BuildFnamesCtl(K2$)
         CommPort = K20
         CALL AdjustProtocol(z$)
         z$ = MID$(TT$,54,40)
         IF K1 THEN FileIndex = 1 : _
                    TT$ = Null$ : _
                    CALL ShellDosTT(3) : _
                    CALL KillFile(z$)
         TT = 10240
         CALL AnsiTT
    CASE 2                               'download.
         K20 = CommPort
         CommPort = 0
         z$ = GlobalStuff$(2)
         TT = 10986
         CALL SendTT
         CALL DispDriveSpace
         TT$ = Short$(987) + z$ + Short$(963)
         LESpecial = 32
         z2$ = RTRIM$(LTRIM$(LineEditTT$(64)))
         SELECT CASE TGot
           CASE 27 : CommPort = K20
           CASE ELSE
                IF LEN(z2$) > 0 THEN GlobalStuff$(2) = z2$ : _
                                     z$ = z2$
                IF AscRight(z$) <> 92 THEN z$ = z$ + Chars$(92)
                CALL DirCreate(z$)
                z$ = ChopRight1$(z$)
                IF AscRight(z$) = 92 THEN z$ = ChopRight1$(z$)
                CALL DirUse(z$ + C0$)
                z$ = GlobalStuff$(1)
                TT$ = Short$(988) + z$ + Short$(963)
                LESpecial = 32
                z2$ = UCASE$(LineEditTT$(1))
                CommPort = K20
                SELECT CASE TGot
                  CASE IS <> 27
                       IF LEN(z2$) > 0 THEN GlobalStuff$(1) = z2$ : _
                                            z$ = z2$
                       CALL AdjustProtocol(z$)
                       z$ = MID$(TT$,54,40)
                       FileIndex = 1
                       TT$ = Null$
                       CALL ShellDosTT(4)
                       CALL KillFile(z$)
                END SELECT
         END SELECT
         TT = 10240
         CALL AnsiTT
    CASE 3 : z$ = TT$
             TT$ = Null$
             CALL ShellDosTT(1)       'shell to DOS.
             TT$ = z$
    CASE 4                                'send a text file.
         K20 = CommPort
         CommPort = 0
         TT = 10617
         IF NOT ConfirmFile(K0$) _
            THEN CommPort = K20 _
            ELSE CommPort = K20 : _
                 K = FileOpenR(K0$) : _
                 K& = FFile.FSize : _
                 K0& = 0 : _
                 DO : _
                   TT$ = FileGetBlock$(K,K0&,K&) : _
                   CALL SendTT : _
                 LOOP UNTIL K0& = K& : _
                 CALL FileCloseR(K)
   END SELECT

END SUB



'p = 1 if calling from startup (show at bottom)
'p = 2 if calling from wfc (so show what occurs)
'p = 3 for callback
'p = 4 for commprog
'p = 5 for startup after first startup
'p = 6 for commprog's multiple attempts
'7 for netmail 1
'8 for netmail 2
'etc., always show in appropriate place.
'returns a null p$ if timeout or sysop hits a key.
'returns p = -1 if sysop hits a key to abort.
SUB GetModemLine (p$,p)

  p$ = Null$
  IF CommPort = 0 THEN EXIT SUB
  K$ = TIME$
  DO
    K3 = 14                    'only allow console 0-255 keys.  any abort.
    IF NOT BitTest(Settings.Toggles2,4) _
       THEN IF p <> 3 AND p <> 4 AND p <> 6 AND p <> 7 AND p <> 8 _
               THEN K3 = K3 + 1024
    K = CommIn(K3)
    IF K3 <> 0 THEN p$ = Null$ : _
                    p = -1 : _
                    EXIT DO
    IF BitTest(FosIntAX(Settings.CommPort,&H300),7) _
       THEN p$ = Short$(910) : _
            EXIT DO
    SELECT CASE K
      CASE 13, IS > 31
           IF K = 13 THEN z$ = RIGHT$(p$ + LEFT$(Short$(127),1),39) _
                     ELSE p$ = p$ + Chars$(K) : _
                          z$ = RIGHT$(p$,39)
           TT$ = WordsGet$(Short$(127),p + 1,0)
           CALL TTInsertStr1(WordsGet$(Short$(127),p + 1,0),z$)
           CALL AnsiTT
    END SELECT
    KK = ElapsedTime(K$,K0)
'    IF (p = 1 AND K0 = 10) OR (p <> 1 AND KK = Settings.LogoTimeOut) _
'       THEN p$ = Null$ : _
'            EXIT DO
    IF K0 = 10 _
       THEN p$ = Null$ : _
            EXIT DO
  LOOP UNTIL LEN(p$) = 128 OR (K = 10 AND LEN(p$) > 0)
  TT = 10068
  CALL AnsiTT

END SUB





        '* * * * * *
        ' This routine dials a phone number.
        '
        ' p$  phone number to dial.
        '     > 12 chars have nothing added in front (intl calls)
        '     > 8 chars have '1-' added in front (LD calls)
        '     rest are assumed local calls
        '     p$ is changed
        '
        ' p value to send on to getmodemline.
        '   if p < 0 then we don't try to add a '1-' to the number.
        '
        ' returns: 1 if RING detected.
        '          2 if modem contact failed (timed out).
        '          3 if sysop aborted (or got VOICE or 3 RINGING's, etc.)
        '          4 if we got a BUSY
        '          0 if connected (same as checking for IF NOT NoCarrier
        '
        ' Date last checked for perfection: Sep 22 1992
        '
FUNCTION ContactPhoneNumber% (p$,p)

  DialSuccess = 0
  IF LEN(p$) = 0 THEN EXIT FUNCTION
  IF LEN(p$) < 13 AND p >= 0 THEN K1$ = Short$(164 + (LEN(p$) < 9)) + p$ _
                             ELSE K1$ = Short$(163) + p$ : _
                                  p = - p
  CommPort = Settings.CommPort
  K = 0
  '
  ' We do three attempts to get past a NO DIAL TONE
  '
zz = p
'put in a 1 minute time-out.
'for call-back, do 3 attempts.
  DO
    K = K + 1
    IF K = 4 THEN EXIT DO
    CALL PurgeComIO(CommPort)
    CALL CommOut(RTRIM$(Settings.ModemInit) + C1310$)                 'ATZ
p = zz
    DO : CALL GetModemLine(K$,p)
    LOOP UNTIL K$ = Short$(909) OR p = -1 OR LEN(K$) = 0
    IF p = -1 OR LEN(K$) = 0 THEN EXIT DO
    CALL Delay
    CALL CommOut(UCASE$(Short$(821) + K1$ + C1310$))     'Dial string.
    K1 = 0
kk$ = time$
    DO
p = zz
      CALL GetModemLine(K$,p)
      IF NOT NoCarrier OR K$ = Short$(31) THEN EXIT DO  'connect or BUSY
      IF p = -1 OR K$ = Short$(910) THEN EXIT DO        'sysop abort or RING
      IF K$ = Short$(911) THEN K1 = K1 + 1              'RINGING


 '0030VOICE
 '0031BUSY
 '0032NO DIAL
'0033NO CARRIER
'0909OK
 '0910RING
 '0911RINGING


      IF LEFT$(K$,7) = Short$(32) OR K$ = Short$(30) OR K1 = 3 _
         THEN CALL HangUp : _
              p = -1 : _
              CALL Delay : _
              EXIT DO      'NO DIAL TONE or VOICE or 3 RINGING's
    LOOP UNTIL ElapsedTime(kk$,0) >= Settings.LogoTimeOut
  LOOP UNTIL NOT NoCarrier OR p = -1 OR K$ = Short$(31) OR K$ = Short$(910)
  IF p = -1 THEN ContactPhoneNumber% = 3 : _
                 EXIT FUNCTION
  IF LEN(K$) = 0 THEN ContactPhoneNumber% = 2 : _
                      EXIT FUNCTION
  IF K$ = Short$(31) THEN CALL Delay : _
                          ContactPhoneNumber% = 4 : _
                          EXIT FUNCTION
  IF K$ = Short$(910) THEN ContactPhoneNumber% = 1 : _
                      EXIT FUNCTION     'Incoming call, has priority.
  IF NOT NoCarrier THEN DialSuccess = -1
  ContactPhoneNumber% = 0

END FUNCTION
        '
        '* * * *





'kn returns:
'   1 if RING detected
'   3 if sysop aborted
'p0 returns -1 if someone calling (so check this and NoCarrier)
'p$ phone number to dial
SUB Dialer (p0,p$,kn)

  TT = 10763
  K0$ = LineEditTT$(5)
  IF LEN(K0$) = 0 THEN kn2 = 5 _
                  ELSE kn2 = Val2&(K0$)
  CALL DispCRLF
  CALL DispCRLF
  kn = 1
  DO
    SELECT CASE kn
      CASE IS <> 1
           FOR kn3 = 1 TO kn2
             CALL TTInsertStr1(Short$(157),IntToStr$(kn3))
             CALL AnsiTT
             CALL Delay
             IF CommIn(8 + 4 + 2 + 512) > 0 THEN kn = 3 : _
                                                 EXIT FOR
             Kz = FosIntAX(CommPort,&H300)
             IF BitTest(Kz,6) + BitTest(Kz,7) + BitTest(Kz,8) < 0 _
                THEN p0 = -1 : _
                     EXIT FOR
           NEXT
    END SELECT
    IF p0 = 0 AND kn <> 3 THEN kn = ContactPhoneNumber(p$,6)
  LOOP UNTIL NOT NoCarrier OR kn = 1 OR kn = 3 OR p0 = -1

END SUB


