' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.



'job: return the toscreen and toport strings given the main string and
'a position in it.
'we really just process the ansi string, ignoring any trailing text to
'be processed by the calling routine on the next loop.


        '* * * * * *
        ' This routine converts ANSI codes to/from Avatar codes.
        '
        ' p$   full string working on.
        '
        ' p0$  string planing to output to the screen
        '
        ' p1$  string planing to output to the port
        '
        ' p    position in p$
        '
        ' Date last checked for perfection: Sep 18 1992
        '
SUB AnsiProcessor (p$,p0$,p1$,p)



'p$ is full string being worked on (not altered).
'p  is location in string--altered to point past ANSI command.
'p0$ is what to send to the screen upon return (if anything).
'p1$ is what to send to the port upon return (if anything).
'this routine handles only the ANSI string, and controls what is sent out/
'display for that ANSI code.
'




  ' For Avatar conversions, the following converstions are done:
  '    ANSI     Avatar  Save
  ' ----------  ------  ----
  ' [0m[2J    ^L       7    Clear screen.  Reset colors.
  ' [xm        ^V^Ax   1-2   Set single color (fore/back/etc.)
  ' [x;ym      ^V^Ax   3-5   Set multiple colors (fore/back/etc.)
  ' [x;y;zm    ^V^Ax   5-7   Set multiple colors (fore/back/etc.)
  ' [w;x;y;zm  ^V^Ax   7-9   Set multiple colors (fore/back/etc.)
  ' [x;yf      ^V^Hxy  2-4   Position the cursor.
  ' [x;yH      ^V^Hxy  2-4   Position the cursor.
  ' [A         ^V^C     1    Cursor up one line.
  ' [B         ^V^D     1    Cursor down one line.
  ' [C         ^V^E     1    Cursor left one column.
  ' [D         ^V^F     1    Cursor right one column.
  ' [0K        ^V^G     2    Clear to end of line.
  ' <4+ dups>   ^Yxy     1+   Run-length-encoding.
  '
  ' Notes: Blink is handled with ^V^Ax and the 8th bit set. (NOT)
  '        Single position codes such as [14H aren't converted.
  '        Other ANSI or Avatar codes not mentioned aren't supported.
  '        Under ANSI above, wxyz are numbers from 0 to 80.
  '        Under Avatar above, xy are ASCII codes ranging from 0 to 255.
  '        Only the follow color codes can be done (the rest require
  '        knowledge of what the user's terminal is showing:
  '          [0;1;3x;4ym      --not doing: too rare
  '          [1;3x;4ym
  '          [0;3x;4ym
  '          [0;3xm           --not doing: too rare
  '          [0;4xm           --not doing: too rare
  '          [0m
  '
  ' Avatar color attribute byte:
  ' 8 bits:  1 
  '          2  foreground color bits
  '          3 
  '          4  intensity bit (0 = normal, 1 = bright)
  '          5 
  '          6  background color bits
  '          7 
  '          8  blink (0 = off, 1 = on)
  '
  ' Color values:
  ' Number   ANSI    Avatar
  ' ------  -------  ------
  '   0     Black    Black
  '   1     Red      Blue
  '   2     Green    Green
  '   3     Brown    Cyan
  '   4     Blue     Red
  '   5     Magenta  Magenta
  '   6     Cyan     Brown
  '   7     White    White
  'Black is Grey when bright.
  'Brown is Yellow when bright.
  '
  p = p + 1
  K = p
  K9 = LEN(p$)
  DO
    p = p + 1
    K5 = AscMid(p$,p)
  LOOP UNTIL K5 < 48 OR K5 > 59 OR p = K9
  p0$ = Chars$(27) + MID$(p$,K,p - K + 1)
  K2 = BitTest(User.Toggles,15)
  '
  ' Strip out the 'evil' ANSI codes.
  '
  IF K5 = 104 OR K5 = 108 OR K5 = 112 THEN K2 = 0 : _
                                           p0$ = C1$ : _
                                           MID$(p$,p,1) = C1$
  p = p + 1  'exit with p pointing to first char past ansi string.
  IF CommPort = 0 THEN EXIT SUB
  p1$ = p0$
  '
  ' Test for the special '2 ansi' CLS command.
  '
  IF K2 THEN IF p0$ = Short$(68) _
                THEN K2 = 1 : _
                     IF MID$(p$,p,4) = Short$(548) _
                        THEN p1$ = Chars$(12) : _
                             p = p + 4 : _
                             p0$ = Short$(67) _
                        ELSE p1$ = Chars$(22) + C1$ + C7$
  '
  ' Test for the other ansi commands.
  '
  SELECT CASE K2
    CASE -1
         SELECT CASE K5
           CASE 109
                '
                ' Ansi 'm' change color commands.
                '
                SELECT CASE AscMid(p0$,3)
                  CASE 48, 49
                       K2 = 0
                       K7 = 0
                       K8 = 0
                       DO
                         K2 = StrSrch2(K2,p0$,59)
                         IF K2 > 0 THEN K6 = Val2&(LEFT$(p0$,K2 - 1)) _
                                   ELSE K6 = Val2&(ChopRight1$(p0$))
                         SELECT CASE K6
                           CASE 1 : CALL BitSet(K7,4)  'High intensity.
                           CASE 5 : K7 = -1            'Blink.
                                    K2 = 0
                           CASE 30 TO 37               'Forground.
                                SELECT CASE K6
                                  CASE 31 : K6 = 34
                                  CASE 33 : K6 = 36
                                  CASE 34 : K6 = 31
                                  CASE 36 : K6 = 33
                                END SELECT
                                K7 = K7 + K6 - 30
                                K8 = K8 + 1
                           CASE 40 TO 47               'Background.
                                SELECT CASE K6
                                  CASE 41 : K6 = 44
                                  CASE 43 : K6 = 46
                                  CASE 44 : K6 = 41
                                  CASE 46 : K6 = 43
                                END SELECT
                                K7 = K7 + BitsShl(K6 - 40,4)
                                K8 = K8 + 1
                         END SELECT
                       LOOP UNTIL K2 = 0
                       IF K7 >= 0 AND K7 < 256 AND K8 = 2 _
                          THEN p1$ = Chars$(22) + C1$ + Chars$(K7)
                END SELECT
           CASE 102, 72
                '
                ' Ansi 'f' and 'H' positioning commands.
                '
                K2 = StrSrch1(p0$,59)
                IF K2 > 1 _
                   THEN K2 = Val2&(LEFT$(p0$,K2 - 1)) : _
                        K6 = Val2&(ChopRight1$(p0$)) : _
                        IF K2 < 256 AND K6 < 256 _
                           THEN p1$ = Chars$(22) + C8$ + Chars$(K2) + Chars$(K6)
           CASE 65 TO 68
                '
                ' Arrow keys.
                '
                IF p0$ = Short$(126 + K5) _
                   THEN p1$ = Chars$(22) + Chars$(K5 - 62)
           CASE 75 : IF p0$ = Short$(195) THEN p1$ = Chars$(22) + C7$
         END SELECT
  END SELECT

END SUB
        '
        '* * * *

