; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will count the number of space-deliminated words in a string.
;
; Usage:  Result% = WordsCnt(Input$)
; Where Input$ is the string to check, and Result% contains the number of
; words in that string.
;

.Model Medium, Basic
.Code

            PUBLIC  WordsCnt          ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

 WordsCnt   proc    uses DS, Descriptor

            mov     ax,Descriptor     ;Get the input string's descriptor.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     ds,dx
            xor     dx,dx             ;Set our counter to zero.
            mov     cx,di
            jcxz    Done              ;If a null string, then exit.
            xchg    si,ax             ;Put the string's address in SI.

            mov     bx,dx             ;Set zero flag--not on word.
        R1: lodsb                     ;Get the next character into AL.
            cmp     al,20H            ;Looking for spaces.
            jz      R2                ;If it is a space, then jump.
            dec     bx                ;A non-space, so set the flag.
            jmp     R3                ;Get next character.
        R2: or      bx,bx             ;If BX is zero (not in a word),
            jz      R3                ;then get the next character.
            xor     bx,bx             ;Zero out our 'in word' flag.
            inc     dx                ;Add to our number of words count.
        R3: loop    R1                ;Get next character.
            or      bx,bx             ;If BX is zero (not in a word),
            jz      Done              ;then go finish up.
            inc     dx                ;End of line is like a space.

      Done: xchg    ax,dx             ;Exit with the count in AX.
            ret

WordsCnt    endp                      ;End of routine.

End

