; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will replace the characters in one string with the characters
; in in another, defining, string.
;
; Usage:  CALL StrXLate(String$, DefString$)
; Where String$ is the text to work on, and DefString$ is a 256 length
; string containing the new values.  String$ is mapped to DefString$ by
; it's ASCII value.  Thus an "a", CHR$(97), will get the character stored
; in position 97 of DefString$--could be "a", "A", or any other of the
; 256 ASCII codes.
;
; DefString$ need not be 256 characters in length.  But since no sophisticated
; checking is done, be very sure the ASCII values of your input string don't
; contain values greater then the length of DefString$ if you use a length
; less than 256 characters.
;

.Model Medium, Basic
.Code

            PUBLIC  StrXLate          ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

StrXLate    proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            push    ds

            cld                       ;We'll move forward in the string.

            mov     ax,[bp + 08]      ;Get String$'s descriptor.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done              ;If zero, then exit.

            push    cx
            push    dx
            push    ax

            mov     ax,[bp + 06]      ;Get DefString$'s descriptor.
            push    ax
            call    StringAddress
            mov     ds,dx
            xchg    ax,bx

            pop     si
            pop     es
            pop     cx

        R1: mov al,es:[si]
            inc si
            xlat                      ;AL = [BX + AL]  That is, get the value
                                      ;of our DefString$ at position AL (ASCII
                                      ;number) and move it to AL.  BX is the
                                      ;location of DefString$, AL an offset.
            mov es:[si - 01],al       ;Lodsb +1'd to SI, so we need to
                                      ;subtract before replacing the original
                                      ;ASCII value.
            loop    R1                ;Decrement CX, repeat until zero.

      Done: pop     ds
            pop     bp
            ret     4                 ;Pop-return past our input parameters.

StrXLate    endp                      ;End of routine.

End

