; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine searches for an ASCII code inside a string.
; 
; Usage:  Result% = StrSrch1(Source$, Find%)
; Declare:  DECLARE FUNCTION StrSrch1% (Source$, BYVAL Find%)
;
; Where Source$ is our string to search, Find% is the ASCII code to look for,
; and Result% is where the code is located in the source string.
;
; It always starts at position one, it requires an ascii code, and it
; searches forward.
;
; A Find% value outside the range of 0 to 255 will not crash this, since
; we only use the low order bit, but it will cause confusing results.
;

.Model Medium, Basic
.Code

            PUBLIC  StrSrch1          ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

StrSrch1    proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            cld                       ;A forward string search.

            mov     ax,[bp + 08]      ;Get Source$'s descriptor.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done              ;If null, then exit.
            mov     es,dx
            mov     di,ax

            mov     bx,di             ;Save Source$'s address for later.
            mov     al,[bp + 06]      ;Get our character to find into AL.
            repne   scasb             ;Compare AL until find (or not) a match.
            jnz     Done              ;No match found, exit.
            mov     cx,di             ;Location of found string -> AX.
            sub     cx,bx             ;Subtract off the address.
      Done: xchg    ax,cx             ;Exit with the position (or zero).
            pop     bp
            ret     4                 ;Pop-return past our input parameters.

StrSrch1    endp                      ;End of routine.

End

