; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine returns the display length of a string--ignoring ANSI codes
; and "x" codes.  It only knocks off 2 for "|" codes though.
; 
; This needs to be redone, as there are some "" codes it doesn't handle
; properly (such as !) and it filters out for two "}x" codes, w/o checking
; what "x" is (that it's valid).
;
; Usage:  Result% = StripLen(Input$)
; Declare:  DECLARE FUNCTION StripLen% (Input$)
;
; Where Result% is the display length, and Input$ is the string to use.
;
; It does the codes on the cheap (all }x codes, not just }1 to }9), so fix
; this up in the future.
;

.Model Medium, Basic


.Code

            PUBLIC  StripLen          ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

StripLen    proc    uses DS, Descriptor

            cld

            mov     ax,Descriptor     ;Descriptor of Input$.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            mov     si,ax
            xor     ax,ax
            jcxz    Done

            mov     bx,cx             ;BX contains our length.
            mov     ds,dx

        R1: lodsb
            cmp     al,20             ;"x" not counted.
            je      R2
            cmp     al,'}'            ;"}x" not counted.
            je      R2
        R3: cmp     al,27             ;"<esc>[etc.x" not counted.
            jne     R7

            dec     bx                ;remove ansi code--first the <esc>,
                                      ;LOOP reduces the CX for this.
        R4: dec     cx                ;One less char (the next one).
            jcxz    D1                ;No chars left, so exit.
            dec     bx                ;then whatever character (will be) on.
            lodsb
            cmp     al,'['
            je      R4
            cmp     al,';'
            je      R4
            cmp     al,'0'
            jb      R7
            cmp     al,'9'
            ja      R7
            jmp     R4

        R2: dec     bx               ;don't count two chars.
            dec     cx
            jcxz    D1
            dec     bx
            lodsb                    ;skip past a char.  AL <- (DS:SI)

        R7: loop    R1

        D1: xchg    ax,bx

      Done: ret

StripLen    endp                      ;End of routine.

End


