; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;declare function strcrc16% (st$)

.Model Medium, Basic
.Code

            PUBLIC  StrCRC16          ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

StrCRC16    proc    uses DS, Descriptor

            mov     ax,Descriptor     ;Get descriptor of the input string.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            mov     ds,dx
            xor     dx,dx             ;Start our CRC at zero.
            jcxz    Done              ;If a null string, then exit.

            mov     si,ax

        R1: lodsb
            push    cx

            xchg    dh,dl             ;CRC = Swap(CRC) XOR Ord(Ch)
            xor     dl,al

            mov     al,dl             ;CRC = CRC XOR ( Lo(CRC) SHR 4 )
            mov     cl,4
            shr     al,cl
            xor     dl,al

            mov     bl,dl             ;CRC = CRC XOR ( Swap(Lo(CRC)) SHL 4 )
            mov     ah,dl             ;      XOR ( Lo(CRC) SHL 5 )
            shl     ah,cl
            xor     dh,ah
            xor     bh,bh
            inc     cl
            shl     bx,cl
            xor     dx,bx

            pop     cx
            loop    R1

      Done: mov     ax,dx
            ret

StrCRC16    endp                      ;End of routine.

End


