; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will write a data string to a file at a specific location.
;
; Usage:  CALL FilePutSLoc(Handle%, Location&, Output$)
; Declare: DECLARE SUB FilePutSLoc (BYVAL Handle%, BYVAL Location&, Output$)
;
; Where Handle% is the file handle to use, Location& is the location - 1 to
; write to, and Output$ contains the data to write out.
;
; We only write out for the length of Output$.
;
; Location& specifies the location to write the data to--using a 0..n scale,
; which means we actually write to location Location& + 1.
;
; It does no negative number checking.  A zero put's it at position 1.  A 3
; put's it on the 4th character, and so on.  Thus, no more need for the "+ 1"
; when doing: (rec - 1) * len + 1   to position it, now (rec - 1) * len does
; it.
;
; Because null strings are ignored, this routine cannot be used to truncate a
; file.  To do that, use FilePutLoc with a size field of zero.  A null string
; just means a quick exit.
;

.Model Medium, Basic
.Code

            PUBLIC  FilePutSLoc       ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc
            extrn   Delay:far

FilePutSLoc proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     bx,[bp + 0CH]     ;Get the file handle into BX.
            mov     ax,4200H          ;Subfunction to seek to loc in file.
            mov     dx,[bp + 08]      ;Low order word of long offset.
            mov     cx,[bp + 0AH]     ;High order word of long offset.
            int     21H               ;Call DOS Services to do it.


            mov     ax,[bp + 06]      ;Descriptor of Output$.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done              ;Quick exit if a null string.

            push    cx
            push    dx
            push    ax

            mov     di,cx             ;Low order word of long length.
            xor     si,si             ;High order word of long length.
            mov     dx,[bp + 08]      ;Low order word of long offset.
            mov     cx,[bp + 0AH]     ;High order word of long offset.
            mov     bx,[bp + 0CH]     ;Get the file handle into BX.
        R0: mov     ax,5C00H          ;Subfunction to lock a loc in file.
            int     21H               ;Call DOS Services to do it.
            jnc     R1                ;No errors, so continue.
            cmp     ax,33             ;Region already locked, try again.
            jne     R1
            call    delay
            jmp     R0

        R1: pop     ax
            pop     dx
            pop     cx

            mov     bx,[bp + 0CH]     ;Get the file handle into BX.
            push    ds
            mov     ds,dx
            mov     dx,ax             ;Data buffer to write out.
        R2: mov     ah,40H            ;Subfunction to write to a file.
            int     21H               ;CALL DOS Services to do it.
            jnc     R3                ;No errors, so continue.
            cmp     ax,5              ;Access Denied, try again.
            jne     R3
            call    Delay
            jmp     R2

        R3: pop     ds

            mov     ax,5C01H          ;Subfunction to unlock a loc in file.
            mov     di,cx             ;Low order word of long length.
            xor     si,si             ;High order word of long length.
            mov     dx,[bp + 08]      ;Low order word of long offset.
            mov     cx,[bp + 0AH]     ;High order word of long offset.
            mov     bx,[bp + 0CH]     ;Get the file handle into BX.
            int     21H               ;Call DOS Services to do it.

      Done: pop     bp
            ret     8                 ;Pop-return past our input parameters.

FilePutSLoc endp                      ;End of routine.

End

