; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine writes a specified number of bytes from a variable to a file.
;
; Usage:  CALL FilePutRec(Handle%, RecNum%, Size%, Variable)
; Declare:  DECLARE SUB FilePutRec(BYVAL Handle%, BYVAL RecNum%, BYVAL Size%, Variable AS ANY)
;
; Where Handle% is then files handle, RecNum% is the record number to start at,
; Size% is the number of bytes to write, and Variable is any non-string variable
; type in which to store the string.
;
; The file must be opened using FileOpen before calling this.
;
; The equivalent basic code:  PUT #Handle%,RecNum%,Variable
;
; No negative number checking is done.  A zero resulting location will start
; at position 1.  A resulting 1 starts at position 2, etc.  Thus, positional
; calculation is: (rec - 1) * len  (vs. (rec - 1) * len + 1)
;
; RecNum must be greater than zero.  If zero, we exit.
;
; Don't use this for strings or substrings of a type (eg. strng AS STRING * 5).
; Does work with integer or long substring types (eg. size AS INTEGER).
;
; Variable will put Size% bytes at location (RecNum% - 1) * Size%.
;




.Model Medium, Basic
.Code

            PUBLIC  FilePutRec        ;Make this routine available to LINK.

            extrn   Delay:far

FilePutRec  proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     bx,[bp + 0CH]     ;Get the file handle into BX.

            mov     cx,[bp + 08]      ;Put size into CX.
            jcxz    Done              ;Nothing to do, so we quit.
            mov     di,cx
            push    cx

            mov     ax,[bp + 0AH]     ;Put the RecNum% into AX.
            dec     ax                ;Adjust for method.
            mul     cx                ;DX:AX <= AX * source
            mov     cx,dx             ;DOS wants offset (location) in CX:DX.
            mov     dx,ax
            push    dx

            mov     ax,4200H          ;Subfunction to seek to loc in file.
            int     21H               ;Call DOS Services to do it.

            pop     dx                ;Re-build our DX.

            xor     si,si             ;High order word of long length.
        R0: mov     ax,5C00H          ;Subfunction to lock a loc in file.
            int     21H               ;Call DOS Services to do it.
            jnc     R1                ;No errors, so continue.
            cmp     ax,33             ;Region already locked, try again.
            jne     R1
            call    Delay
            jmp     R0

        R1: pop     ax
            push    cx
            push    dx

            xchg    ax,cx             ;Length to write out.
            mov     dx,[bp + 06]      ;Address of data to write out.
        R2: mov     ah,40H            ;Subfunction to write to a file.
            int     21H               ;CALL DOS Services to do it.
            jnc     R3                ;No errors, so continue.
            cmp     ax,5              ;Access Denied, try again.
            jne     R3
            call    Delay
            jmp     R2

        R3: pop     dx
            pop     cx
            mov     ax,5C01H          ;Subfunction to lock a loc in file.
            int     21H               ;Call DOS Services to do it.

      Done: pop     bp
            ret     8                 ;Pop-return past our input parameters.

FilePutRec  endp                      ;End of routine.

End

