; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will write data to a file at a specific location.
;
; Usage:  CALL FilePutLoc(Handle%, Location&, Size%, x)
; Declare: DECLARE SUB FilePutLoc (BYVAL Handle%, BYVAL Location&, BYVAL Size%, x AS ANY)
;
; Where Handle% is the file handle to use, Location& is the location - 1 to
; write to, Size% is the data to write out, and x is any non-string variable.
;
; Location& specifies the location to write the data to--using a 0..n scale,
; which means we actually write to location Location& + 1.
;
; It does no negative number checking.  A zero put's it at position 1.  A 3
; put's it on the 4th character, and so on.  Thus, no more need for the "+ 1"
; when doing: (rec - 1) * len + 1   to position it, now (rec - 1) * len does
; it.
;
; Use a size field of zero to truncate a file at the location.  But a zero
; field attempt to lock files causes a lock-up, so we jump that.
;

.Model Medium, Basic
.Code

            PUBLIC  FilePutLoc        ;Make this routine available to LINK.

            extrn   Delay:far

FilePutLoc  proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     bx,[bp + 0EH]     ;Get the file handle into BX.
            mov     ax,4200H          ;Subfunction to seek to loc in file.
            mov     dx,[bp + 0AH]     ;Low order word of long offset.
            mov     cx,[bp + 0CH]     ;High order word of long offset.
            int     21H               ;Call DOS Services to do it.


            mov     di,[bp + 08]      ;Low order word of long length.
            cmp     di,0              ;Zero length to-lock = trouble.
            je      R1
            xor     si,si             ;High order word of long length.
            mov     dx,[bp + 0AH]     ;Re-build our DX.
        R0: mov     ax,5C00H          ;Subfunction to lock a loc in file.
            int     21H               ;Call DOS Services to do it.
            jnc     R1                ;No errors, so continue.
            cmp     ax,33             ;Region already locked, try again.
            jne     R1
            call    Delay
            jmp     R0


        R1: mov     cx,[bp + 08]      ;Length to write out.
            mov     dx,[bp + 06]      ;Address of data to write out.
        R2: mov     ah,40H            ;Subfunction to write to a file.
            int     21H               ;CALL DOS Services to do it.
            jnc     R3                ;No errors, so continue.
            cmp     ax,5              ;Access Denied, try again.
            jne     R3
            call    Delay
            jmp     R2


        R3: cmp     di,0              ;Zero length to-lock = trouble.
            je      Done
            mov     ax,5C01H          ;Subfunction to unlock a loc in file.
            mov     dx,[bp + 0AH]     ;Re-build our DX.
            mov     cx,[bp + 0CH]     ;Re-build our CX.
            int     21H               ;Call DOS Services to do it.


      Done: pop     bp
            ret     0AH               ;Pop-return past our input parameters.

FilePutLoc   endp                     ;End of routine.

End

