; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will check for a key from the keyboard/console, if one exists
; it'll return with it.
;
; Usage:  Result% = KBIn
; Declare: DECLARE FUNCTION KBIn% ()
;
; Where Result% contains the key hit.  0 if no key hit, 1-255 if regular
; ASCII character key hit.  < 0 or > 255 if extended key hit.
;

.Model Medium
.Code

            PUBLIC  KBIn              ;Make this routine available to LINK.

KBIn        proc    far               ;Beginning of routine.

            mov     ah,0BH            ;Set up for INT 21H, subfunction 0BH.
            int     21H               ;Check status of StdIn.
            cmp     al,00             ;If no key waiting,
            je      D1                ;  then exit with a zero.
            mov     ah,08H            ;Set up for INT 21H, subfunction 08H.
            int     21H               ;Get the key waiting.
            cmp     al,00             ;If not a zero,
            jne     D1                ;  then exit.
            int     21H               ;Get the extended key.
            mov     ah,al             ;Put it high,
            mov     al,00             ; and zero low.
            jmp     Done              ;End it.

        D1: mov     ah,00             ;Zero high.
      Done: ret

KBIn        endp                      ;End of routine.

End


