; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will compare two integers, replacing the first integer with
; the greater of the two.
;
; Usage:  CALL IntMax (Value1%, Value2%)
; Declare: DECLARE SUB IntMax (Value1%, BYVAL Value2%)
;
; It should work correctly with negative or positive numbers.
;
; The equivalent Basic code:
;
; IF Value2% > Value1% THEN Value1% = Value2%
; Although more likely: IF X% > LEN(X$) THEN X% = LEN(X$) type of usage.
;

.Model Medium, Basic
.Code

            PUBLIC  IntMax            ;Make this routine available to LINK.

IntMax      proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            mov     si,[bp + 08]      ;Get the address of Value1% into SI.
            mov     ax,[bp + 06]      ;Get Value2% into AX.
            cmp     ax,[si]           ;If Value2% <= Value1%,
            jle     Done              ; then exit.
            mov     [si],ax           ;Otherwise, set Value1% = Value2%.
      Done: pop     bp
            ret     4                 ;Pop-return past our input parameter.

IntMax      endp                      ;End of routine.

End


