; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine gets a specified number of bytes into a variable from a file.
;
; Usage:  CALL FileGetRec(Handle%, RecNum%, Size%, Variable)
; Declare:  DECLARE SUB FileGetRec(BYVAL Handle%, BYVAL RecNum%, BYVAL Size%, Variable AS ANY)
;
; Where Handle% is then files handle, RecNum% is the record number to start at,
; Size% is the number of bytes to get, and Variable is any non-string variable
; type in which to store the string.
;
; The file must be opened using FileOpen before calling this.
;
; The equivalent basic code:  GET #Handle%,RecNum%,Variable
;
; No negative number checking is done.  A zero resulting location will start
; at position 1.  A resulting 1 starts at position 2, etc.  Thus, positional
; calculation is: (rec - 1) * len  (vs. (rec - 1) * len + 1)
;
; RecNum must be greater than zero.
;
; Don't use this for strings or substrings of a type (eg. strng AS STRING * 5).
; Does work with integer or long substring types (eg. size AS INTEGER).
;
; Variable will get Size% bytes at location (RecNum% - 1) * Size%.
;

.Model Medium, Basic
.Code

            PUBLIC  FileGetRec        ;Make this routine available to LINK.

            extrn   Delay:far

FileGetRec  proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     bx,[bp + 0CH]     ;Get the file handle into BX.

            mov     cx,[bp + 08]      ;Put size into CX.
            push    cx

            mov     ax,[bp + 0AH]     ;Put the RecNum% into AX.
            dec     ax                ;Adjust for method.
            mul     cx                ;DX:AX <= AX * source
            mov     cx,dx             ;DOS wants offset (location) in CX:DX.
            mov     dx,ax

            mov     ax,4200H          ;Subfunction to seek to loc in file.
            int     21H               ;Call DOS Services to do it.

            pop     cx                ;Length to read in.
            mov     dx,[bp + 06]      ;Address of data to read in.
        R0: mov     ah,3FH            ;Subfunction to read from a file.
            int     21H               ;CALL DOS Services to do it.
            jnc     Done              ;No errors, so continue.
            cmp     ax,5              ;Access Denied, try again.
            jne     Done
            call    Delay
            jmp     R0

      Done: pop     bp
            ret     8                 ;Pop-return past our input parameters.

FileGetRec  endp                      ;End of routine.

End



