; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will delete a directory.
;
; Usage:  CALL DirDelete (Input$)
;
; Where Input$ is a "\" terminated directory name to create.
;
; Upon exit, the final "\" will have been turned into a CHR$(0).
;
; It's assumed there is a "x:\" for the first 3 characters of Input$.
;

.Model Medium, Basic
.Code

            PUBLIC  DirDelete         ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

DirDelete   proc    uses DS, Descriptor

            mov     ax,Descriptor     ;Get descriptor of the string.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done

            mov     ds,dx
            xchg    ax,dx

            mov     bx,dx             ;Point to start of string.
            add     bx,cx             ;Move to last "\" + 1.
            dec     bx                ;Move onto last "\".
            mov     byte ptr [bx],0   ;Add the "Z" in ASCIIZ.
            mov     ah,3AH            ;DOS subfunction 3AH.
            int     21H               ;Remove directory at DS:DX.
            mov     byte ptr [bx],92  ;Put the "\" back.

      Done: ret

DirDelete   endp                      ;End of routine.

End


