; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will create a directory.
;
; Usage:  CALL DirCreate (Input$)
;
; Where Input$ is a "\" terminated directory name to create.
;
; If the parent directories don't exist, they too are created.
;
; It's assumed there is a "x:\" for the first 3 characters of Input$.
;

.Model Medium, Basic
.Code

            PUBLIC  DirCreate         ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

DirCreate   proc    uses DS, Descriptor

            mov     ax,Descriptor     ;Descriptor of Input$.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done

            mov     ds,dx
            xchg    ax,si             ;Address of Input$.
            mov     dx,si             ;DOS call wants DS:DX.

            inc     si                ;Past the "x" in "x:\".
            inc     si                ;Past the ":" in "x:\".
            inc     si                ;Past the "\" in "x:\".
            dec     cx                ;Three less characters to do.
            dec     cx
            dec     cx
            dec     cx
            js      Done              ;There weren't 3 chars to start with.
            inc     cx

            cld                       ;Forward string work.
        R1: lodsb                     ;get the character.  AL <- (DS:SI)
            cmp     al,'\'            ;if a path terminator,
            je      R2                ;then create the path so far.
        R3: loop    R1                ;check out each character.
            jmp     Done

        R2: dec     si                ;Point SI to the '\'
            mov     ah,0              ;Replace with an ASCII 0.
            mov     [si],ah
            mov     ah,39H            ;Subfunction to create directories.
            int     21H               ;CALL DOS Services to do it.
            mov     ah,'\'            ;Replace the ASCII 0 with a '\'.
            mov     [si],ah
            inc     si
            jmp     R3                ;continue working on our string.

      Done: ret

DirCreate   endp                      ;End of routine.

End





