; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will convert an integer form of a date back into 3 integers
; making up it's day, month, and year.  Note, this is not DOS standard date
; format.  It's bit's form: YYYYYYYMMMMDDDDD, which is DOS standard, but
; unlike DOS, which starts it's year's at 1980, I start my year at 1900.
; Thus, the routine can handle the time period from 1/1/1900 to 12/31/2027.
;
; Usage:  CALL DateDMY(Input%, Day%, Month%, Year%)
; Declare:  DECLARE SUB DateDMY(BYVAL Input%, Day%, Month%, Year%)
;
; Where Input% is our input integer, and Day%, Month%, and Year% is our output
; values for day, month, and year, respectively.
;

.Model Medium, Basic
.Code

            PUBLIC  DateDMY           ;Make this routine available to LINK.

DateDMY     proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            mov     ax,[bp + 0CH]     ;Move Input% to AX.
            mov     dx,ax             ;Copy AX to DX.
            and     ax,1FH            ;Screen out all but right 5 bits.
            mov     bx,[bp + 0AH]     ;Get Day%'s address.
            mov     [bx],ax           ;Put AX into Day%.
            mov     cl,05             ;Shift original five positions right.
            shr     dx,cl             ;Do actual shift.
            mov     ax,dx             ;Put work done into AX.
            and     ax,0FH            ;Screen out all but right 4 bits.
            mov     bx,[bp + 08]      ;Get Month%'s address.
            mov     [bx],ax           ;Put AX into Month%.
            mov     cl,04             ;Shift DX over another 4 bits.
            shr     dx,cl             ;Do actual shift.
            mov     bx,[bp + 06]      ;Get Year%'s address.
            mov     [bx],dx           ;Put DX into Year%.
            pop     bp
            ret     8                 ;Pop-return past our 4 parameters.

DateDMY     endp                      ;End of routine.

End

