; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will shift an integer left a specified number of bit positions.
;
; Usage:  Result% = BitsShl(Input%,ShiftLeft%)
; Declare: DECLARE FUNCTION BitsShl% (BYVAL Input%, BYVAL ShiftLeft%)
;
; Where Result% contains our new number, Input% contains the number to
; alter, and ShiftLeft% contains the number of bits to shift.
;
; The left bit is shifted over and a zero moved in.  ShiftLeft% of 0
; does nothing, of 16 returns a zero.
;

.Model Medium, Basic
.Code

            PUBLIC  BitsShl           ;Make this routine available to LINK.

BitsShl     proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            mov     cx,[bp + 06]      ;Get size, all we really want is CL.
            mov     ax,[bp + 08]      ;Get what we should shift.
            shl     ax,cl             ;Do shift for size sent.
            pop     bp
            ret     4                 ;Pop-return past our input parameters.

BitsShl     endp                      ;End of routine.

End


