(*****************************************************************************)
(* InsaneNet functions - RoboZapp - 9/5/92                                   *)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
program test;

uses
  crt, dos, overlay;

const
clasicnode:string[20]='2.7.0.1.0.0';

type
astr=string[160];

function cstr(i:integer):astr;
var c:string[16];
begin
  str(i,c);
  cstr:=c;
end;

function fivepers(node:astr):boolean;
var oksofar:boolean;
    i:byte;
begin
  oksofar:=TRUE;
  for i:=1 to 5 do begin
    if(pos('.',node)=0) then begin
      oksofar:=FALSE;
    end else begin
      node:=copy(node,pos('.',node)+1,length(node)-pos('.',node));
    end;
  end;
  fivepers:=oksofar;
end;

function nodelev(node:astr; level:byte):byte;
var i,y,y1:integer;
begin
  for i:=1 to (level-1) do begin
    node:=copy(node,pos('.',node)+1,length(node)-pos('.',node));
  end;
  if(level<6) then begin
    val(copy(node,1,pos('.',node)-1),y,y1);
  end else begin
    val(node,y,y1);
  end;
{  sprompt('DEBUG - Nodelev('+cstr(level)+') : '+cstr(y)); }
  nodelev:=y;
end;

function sigpos(node:astr):byte;
var sigsofar,i:byte;
begin
  sigsofar:=0;
  for i:=1 to 6 do begin
    if(nodelev(node,i)<>0) then begin
      sigsofar:=i;
    end;
  end;
{  sprompt('DEBUG - Sigpos: '+cstr(sigsofar)); }
  sigpos:=sigsofar;
end;

function replace(node:astr; reppos,repwith:byte):astr;
var newnode:astr;
    i:byte;
begin
  newnode:='';
  for i:=1 to (reppos-1) do begin
    newnode:=newnode+copy(node,1,pos('.',node));
    node:=copy(node,pos('.',node)+1,length(node)-pos('.',node));
  end;
  node:=copy(node,pos('.',node)+1,length(node)-pos('.',node));
  if(reppos<6) then begin
    newnode:=newnode+cstr(repwith)+'.';
    for i:=(reppos+1) to 5 do begin
      newnode:=newnode+copy(node,1,pos('.',node));
      node:=copy(node,pos('.',node)+1,length(node)-pos('.',node));
    end;
    newnode:=newnode+node;
  end else begin
    newnode:=newnode+cstr(repwith);
  end;
  replace:=newnode;
end;

function nextup(node:astr):astr;
var new:astr;
begin
  new:=replace(node,sigpos(node),0);
  nextup:=new;
end;

function nextnode(node:astr):astr;  { This deal will calculate the next node a }
var i,pert:byte;                         { Message will need to go to, to reach NODE }
    oksofar:boolean;                { If it is currently on CLASICNODE }
begin
 if(node<>clasicnode) then begin
   if(sigpos(node)<sigpos(clasicnode)) then begin
     nextnode:=nextup(clasicnode);
   end else begin
     oksofar:=TRUE;
     for i:=1 to sigpos(clasicnode) do begin
       if(nodelev(node,i)<>nodelev(clasicnode,i)) then begin
	 oksofar:=FALSE;
       end;
     end;
     if(oksofar) then begin
       pert:=0;
       for i:=sigpos(clasicnode)+1 to 6 do begin
         if(pert=0) then begin
           if(nodelev(node,i)<>0) then pert:=i;
         end;
       end;
       nextnode:=replace(clasicnode,pert,nodelev(node,pert));
     end else begin
       nextnode:=nextup(clasicnode);
     end;
   end;
 end else begin
   nextnode:=clasicnode;
 end;
end;

begin
  writeln(nextnode('2.0.0.0.0.0'));

end.