(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP7M .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: Menu editor -- "M" command (modify commands)          <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop7m;

interface

uses
  crt, dos, overlay,
  common,
  file9,
  menus2,
  sysop1;

procedure memm(scurmenu:astr; var menuchanged:boolean);

implementation

procedure memm(scurmenu:astr; var menuchanged:boolean);
var i1,i2,ii,z:integer;
    c:char;
    s:astr;
    b:byte;
    bb:boolean;
begin
  prt('Begin editing at which? (1-'+cstr(noc)+') : '); inu(ii);
  c:=' ';
  if (ii>=1) and (ii<=noc) then begin
    while (c<>'Q') and (not hangup) do begin
      repeat
	with cmdr^[ii] do begin
          if (c<>'?') then begin
            cls;
            sprint(#3#3+'Menu filename: '+scurmenu);
            print('Command #'+cstr(ii)+' of '+cstr(noc));
            nl;
	    with cmdr^[ii] do begin
              sprint('^01. ^3Prompt descr  ^4 ^5'+ldesc);
              sprint('^02. ^3Short descr   ^4 ^5'+sdesc);
              sprint('^03. ^3Cmd letters   ^4 ^5'+ckeys);
              sprint('^04. ^3ACS required  ^4 ^5"'+acs+'"');
              sprint('^05. ^3Cmdkeys       ^4 ^5'+cmdkeys);
              sprint('^06. ^3MString       ^4 ^5'+mstring);
              s:='';
              if (hidden in commandflags) then s:='[H]idden';
              if (unhidden in commandflags) then begin
                if (s<>'') then s:=s+', ';
                s:=s+'[U]nhidden';
              end;
              if (s='') then s:='None';
              sprint('^07. ^3Flags         ^4 ^5'+s);
              sprint('Q. Quit');
            end;
          end;
          nl;
          prt('Edit menu (?=help) : ');
          onek(c,'Q1234567[]FJL?'^M);
          nl;
          case c of
            '1':begin
                  sprint('^3New prompt description');
                  prt('^4 ^5'); inputwnwc(ldesc,70,menuchanged);
                end;
            '2':begin
                  prt('^3New short description ^4 ^5');
                  inputwnwc(sdesc,35,menuchanged);
                end;
            '3':begin
                  prt('^3New command letters ^4 ^5'); mpl(14); input(s,14);
                  if (s<>'') then begin ckeys:=s; menuchanged:=TRUE; end;
                end;
            '4':begin
                  prt('^3New ACS ^4 ^5'); mpl(20);
                  inputwn(acs,20,menuchanged);
                end;
            '5':begin
                  prt('^3New command type ^4 ^5'); mpl(2); input(s,2);
                  if (length(s)=2) then begin cmdkeys:=s; menuchanged:=TRUE; end;
                end;
            '6':begin
                  prt('^3New MString ^4 ^5'); mpl(50);
                  inputwnwc(mstring,50,menuchanged);
                end;
            '7':begin
                  print('[H]idden command  -  [U]nhidden command');
                  nl;
                  prt('^3Choose ^4 ^5'); onek(c,'QHU'^M);
                  bb:=menuchanged; menuchanged:=TRUE;
                  case c of
                    'H':if (hidden in commandflags) then
                          commandflags:=commandflags-[hidden]
                     else commandflags:=commandflags+[hidden];
                    'U':if (unhidden in commandflags) then
                          commandflags:=commandflags-[unhidden]
                     else commandflags:=commandflags+[unhidden];
                  else
                        menuchanged:=bb;
                  end;
                  c:=#0;
                end;
            '[':if (ii>1) then dec(ii) else c:=' ';
            ']':if (ii<noc) then inc(ii) else c:=' ';
            'F':if (ii<>1) then ii:=1 else c:=' ';
            'J':begin
                  prt('Jump to entry: ');
                  input(s,3);
                  if (value(s)>=1) and (value(s)<=noc) then ii:=value(s) else c:=' ';
                end;
            'L':if (ii<>noc) then ii:=noc else c:=' ';
            '?':ee_help;
          end;
        end;
      until (c in ['Q','[',']','F','J','L']) or (hangup);
    end;
  end;
end;

end.
