(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP3  .PAS -  re-Written by Raven                                    <*)
(*>                                                                         <*)
(*>  SysOp functions: User Editor.                                          <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop3;

interface

uses
  crt, dos, overlay,
  common;

procedure bardmake(bi,bl:integer);
procedure restric_list;
procedure uedit1;
procedure autoval(var u:userrec; un:integer);
procedure showuserinfo(typ,usern:integer; user1:userrec);
procedure uedit(usern:integer);

implementation


uses
  mail0,
  misc3, misc4, miscx,
  cuser;

var expired:boolean;
    bard2,bard:string[30];

procedure bardmake(bi,bl:integer);
var
  h:integer;
begin
  bard:='';   
  for h:=1 to bi do
    bard:=bard+'';
  while length(bard)<bl do bard:=bard+''; 
end;

procedure bardmake2(bi,bl:integer);
var
  h:integer;
begin
  bard2:='';   
  for h:=1 to bi do
    bard2:=bard2+'';
  while length(bard2)<bl do bard2:=bard2+'';
end;


procedure uedit1;
begin
  uedit(usernum);
end;

procedure restric_list;
begin
  begin
    nl;
    sprint(#3#3+'Restrictions:');
    nl;
    lcmds(27,3,'LCan logon ONLY once/day','CCan''t page SysOp');
    lcmds(27,3,'VPosts marked unvalidated','Back/downspacing restricted');
    lcmds(27,3,'ACan''t add to BBS list','*Can''t post/send anon.');
    lcmds(27,3,'PCan''t post at all','ECan''t send email');
    lcmds(27,3,'KCan''t vote','MAutomatic mail deletion');
    nl;
    sprint(#3#3+'Special:');
    nl;
    lcmds(27,3,'1No UL/DL ratio check','2No post/call ratio check');
    lcmds(27,3,'3No file points check','4Protection from deletion');
    nl;
  end;
end;

function spflags(u:userrec):astr;
var r:uflags;
    s:astr;
begin
  s:='';
  for r:=rlogon to rmsg do
    if r in u.ac then
      s:=s+copy('LCVBA*PEKM',ord(r)+1,1)
    else s:=s+'-';
  s:=s+'/';
  for r:=fnodlratio to fnodeletion do
    if r in u.ac then
      s:=s+copy('1234',ord(r)-19,1)
    else s:=s+'-';
  spflags:=s;
end;

procedure autoval(var u:userrec; un:integer);
begin
  autovalidate(u,un);
end;

procedure showuserinfo(typ,usern:integer; user1:userrec);
var ii:array[1..5] of astr;
    g:array[1..6] of string[15];
    ud,ul,i:integer;
    abort,next:boolean;

procedure callgraph;
var  j:integer;
begin
  for j:=1 to 6 do
  begin
    g[j]:='';
  end;
  with user1 do
    begin
      for j:=1 to calla do
        g[1]:=g[1]+'';
      for j:=1 to callb do
        g[2]:=g[2]+'';
      for j:=1 to callc do
        g[3]:=g[3]+'';
      for j:=1 to calld do
        g[4]:=g[4]+'';
      for j:=1 to calle do
        g[5]:=g[5]+'';
      for j:=1 to ((callf+callg) div 2) do
        g[6]:=g[6]+'';
    end;
end;
  
  procedure shi1(var i:integer);
  var c:char;
      thisdater:string[8];
      r:uflags;
      thisday,thismonth,thisyear,a,b:integer;
  begin
    expired:=false;
    thisdater:=date;
    thismonth:=value(copy(thisdater,1,2));
    thisday:=value(copy(thisdater,4,2));
    thisyear:=value(copy(thisdater,7,2));
    with user1 do
      case i of
        1:begin
            if (d<=thisday) and (m<=thismonth) and (y<=thisyear) then begin
              sl:=systat.autosl;
              dsl:=systat.autodsl;
              expired:=true;
            end;
            
            {
            ii[1]:=#3#9+' '+#3#5+'User # '+cstr(usern)+' of '+cstr(filesize(uf)-1)+#3#4+'  Current Status : ';
            }
            
            ii[1]:='';
            if (deleted) then ii[1]:=ii[1]+#3#8+'Deleted' else
              if (trapactivity) and ((usern<>usernum) or (usernum=1)) then
                if (trapseperate) then ii[1]:=ii[1]+#3#8+'Trapping [S]'
                else ii[1]:=ii[1]+#3#8+'Trapping [C]'
              else
                if (lockedout) then ii[1]:=ii[1]+#3#8+'Locked Out' else
                  if (alert in ac) then ii[1]:=ii[1]+#3#8+'Alert!' else
                    if expired then ii[1]:=ii[1]+#3#8+'Expired!' else
                    ii[1]:=ii[1]+#3#0+'Normal';
            {
            ii[1]:=ii[1]+#3#4+'  User Level:'+#3#0+cstr(sl)+#3#4+'  File Level:'+#3#0+cstr(dsl);
            }
          end;

        2:ii[2]:=spflags(user1);
        
        3:begin 
            ii[3]:='';
            for c:='A' to 'Z' do
              if c in ar then ii[3]:=ii[3]+c else ii[3]:=ii[3]+' ';
          end;
        4:ii[4]:=sex+'-'+cstr(ageuser(bday))+' Years old ['+bday+']';
        5:begin     
            if lockedout then ii[1]:=ii[1]+#3#8+lockedfile+'.MSG';
          end;
      end;
    inc(i);
  end;

  procedure shi2(var i:integer);
  begin
    shi1(i);
  end;

begin
  abort:=FALSE;
  i:=1;
  cls;

  case typ of
    1:while (i<=5) and (not abort) do shi1(i);
    2:while (i<=3) and (not abort) do shi2(i);
  end;
  (* Put the screen in here *)
  if user1.downloads=0 then ud:=1 else ud:=user1.downloads;
  if user1.loggedon=0 then ul:=1 else ul:=user1.loggedon;
  callgraph;
  printacr(#3#4+'Ŀ',abort,next);
  printacr('^4 '+#3#5+mln(cstr(usern)+' of '+cstr(filesize(uf)-1),12)+
    '^4 ^0'+mln(caps(user1.name),36)+' ^4 '+#3#4+'Lvl:'+#3#3+mln(cstr(user1.sl),3)+#3#4+'  File Lvl:'+#3#3+
    mln(cstr(user1.dsl),3)+#3#0+' ^4',abort,next);
  printacr('^4Ĵ',abort,next);
  printacr('^4^05a'+#3#9+mln(g[1],15)+'^4 ^0Uploads                       Post/Call Ratio            ^4',abort,next);
  bardmake((user1.uploads div 50)*10,27);
  bardmake2(((user1.msgpost div ul)*4),26);
  printacr('^4^010'+#3#9+mln(g[2],15)+'^4^0 '+mln(bard,27)+'   '+mln(bard2,26)+' ^4',abort,next);
  printacr('^4^0Nn'+#3#9+mln(g[3],15)+'^4^0 Downloads                     Upload/Download Ratio      ^4',abort,next);
  bardmake((user1.downloads div 50)*10,27);
  bardmake2(((user1.uploads div ud)*10),26);
  printacr('^4^03p'+#3#9+mln(g[4],15)+#3#0+'^4^0 '+mln(bard,27)+'   '+mln(bard2,26)+' ^4',abort,next);
  printacr('^4^06p'+#3#9+mln(g[5],15)+#3#0+'^4Ĵ',abort,next);
  printacr('^4^011'+#3#9+mln(g[6],15)+#3#0+'^4 '+#3#4+'Access Conditions    Access Flags'+#3#0+
  '                        ^4',abort,next);
  printacr('^4 '+#3#5+'Time of Call '+#3#4+' '+mln(ii[2],17)+'    '+mln(ii[3],26)+'          ^4',abort,next);
  printacr('^4Ŀ '+#3#4+'City & State'+#3#0+'                                             ^4',abort,next);
  printacr('^4     '+#3#3+mln(user1.laston,8)+#3#4+'       ^0'+mln(user1.citystate,23)+
  '                                ^4',abort,next);
  printacr('^4 '+#3#0+'Last Called '+#3#4+' '+#3#4+'References'+
    '                Real name                      ^4',abort,next);
  printacr('^4Ŀ^0   '+mln(user1.wherebbs,25)+' '+mln(user1.realname,28)+' ^4',abort,next);
  printacr('^4 '+#3#3+mln(ii[1],15)+'^4  '+#3#4+'Password'+#3#0+
  '                                                 ^4',abort,next);
  printacr('^4 '+#3#5+'Status '+#3#4+'^0   '+mln(user1.pw,20)+'                                   ^4',abort,next);
  printacr('^4Ŀ '+#3#4+'Age/Birthdate'+#3#0+'                                            ^4',abort,next);
  printacr('^4     '+#3#3+mln(cstr(user1.m)+'/'+cstr(user1.d)+'/'+cstr(user1.y),8)+#3#0+
  '    ^4   ^0'+mln(ii[4],25)+'                              ^4',abort,next);
  printacr('^4 '+#3#5+'Subscrip Exp. '+#3#4+' '+#3#4+'Phone Number : '+#3#0+mln(user1.ph,12)+
  '                              ^4',abort,next);
  printacr('^4 '+#3#4+'Account Note     : '+#3#0+mln(user1.note,30)+'                          ^4',abort,next);
  printacr('^4 '+#3#4+'Group Membership : '+#3#0+mln(user1.groups,20)+'                                    ^4',abort,next);
  printacr('^4 '+#3#4+'Modem Speed      : '+#3#0+mln(user1.occupation,5)+
   '                                                   ^4',abort,next);
  printacr('^4'+#3#3+'Insanity v'+ver+' User Editor'+#3#4+'',abort,next);
end;

procedure uedit(usern:integer);
type f_statusflagsrec=(fs_deleted,fs_trapping,fs_chatbuffer,
                       fs_lockedout,fs_alert,fs_slogging);
const autolist:boolean=TRUE;
      userinfotyp:byte=1;
      f_state:array[0..14] of boolean=
        (FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,
         FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE);
      f_gentext:string[30]='';
      f_acs:string[50]='';
      f_sl1:word=0; f_sl2:word=255;
      f_dsl1:word=0; f_dsl2:word=255;
      f_ar:set of acrq=[];
      f_ac:set of uflags=[];
      f_status:set of f_statusflagsrec=[];
      f_laston1:word=0; f_laston2:word=65535;
      f_firston1:word=0; f_firston2:word=65535;
      f_numcalls1:word=0; f_numcalls2:word=65535;
      f_age1:word=0; f_age2:word=65535;
      f_gender:char='M';
      f_postratio1:word=0; f_postratio2:word=65535;
      f_dlkratio1:word=0; f_dlkratio2:word=65535;
      f_dlratio1:word=0; f_dlratio2:word=65535;
var user,user1:userrec;
    r:uflags;
    f:file;
    ii,is,s:astr;
    i,i1,x,oldusern:integer;
    byt:byte;
    c:char;
    save,save1,abort,next:boolean;

  function unam:astr;
  begin
    unam:=caps(user.name)+' #'+cstr(usern);
  end;

  function searchtype(i:integer):string;
  var s:string;
  begin
    case i of
      0:s:='General Text';           1:s:='Search ACS';
      2:s:='User Level';             3:s:='User File Level';
      4:s:='User AR Flags';          5:s:='User AC Flags';
      6:s:='User Status';            7:s:='Days since last on';
      8:s:='Days since first on';    9:s:='Number of calls';
     10:s:='User Age';               11:s:='User Gender';
     12:s:='# 1/10''s call/post';    13:s:='#k DL/1k UL';
     14:s:='# DLs/1 UL';
    end;
    searchtype:=s;
  end;

  function find_fs:string;
  var fsf:f_statusflagsrec;
      s:string;
  begin
    s:='';
    for fsf:=fs_deleted to fs_slogging do
      if (fsf in f_status) then
        case fsf of
          fs_deleted   :s:=s+'deleted,';
          fs_trapping  :s:=s+'trapping,';
          fs_chatbuffer:s:=s+'chat buffering,';
          fs_lockedout :s:=s+'locked out,';
          fs_alert     :s:=s+'alert,';
          fs_slogging  :s:=s+'sep. SysOp Log,';
        end;
    if (s<>'') then s:=copy(s,1,length(s)-1) else s:='None.';
    find_fs:=s;
  end;

  procedure pcuropt;
  var r:uflags;
      s:string;
      i:integer;
      c:char;
      abort,next:boolean;
  begin
    nl;
    sprint(#3#5+'--(< Search limiting options >)--');
    i:=-1;
    abort:=FALSE; next:=FALSE;
    while ((i<14) and (not abort) and (not hangup)) do begin
      inc(i);
      if (i in [0..9]) then c:=chr(i+48) else
        case i of 10:c:='A'; 11:c:='G'; 12:c:='P'; 13:c:='K'; 14:c:='N'; end;
      if (i=1) then cl(3);
      sprompt(c+'. '+#3#1+mln(searchtype(i),19)+': '); s:='';
      if (not f_state[i]) then
        s:='Inactive!'
      else begin
        case i of
          0:s:='"'+f_gentext+'"';
          1:s:='"'+f_acs+'"';
          2:s:=cstr(f_sl1)+' User Level ... '+cstr(f_sl2);
          3:s:=cstr(f_dsl1)+' File Level ... '+cstr(f_dsl2);
          4:for c:='A' to 'Z' do
              if (c in f_ar) then s:=s+c else s:=s+'-';
          5:begin
              for r:=rlogon to rmsg do
                if (r in f_ac) then s:=s+copy('LCVBA*PEKM',ord(r)+1,1)
                else s:=s+'-';
              s:=s+'/';
              for r:=fnodlratio to fnodeletion do begin
                if (r in f_ac) then s:=s+copy('1234',ord(r)-19,1)
                else s:=s+'-';
              end;
            end;
          6:s:=find_fs;
          7:s:=cstr(f_laston1)+' days ... '+cstr(f_laston2)+' days';
          8:s:=cstr(f_firston1)+' days ... '+cstr(f_firston2)+' days';
          9:s:=cstr(f_numcalls1)+' calls ... '+cstr(f_numcalls2)+' calls';
         10:s:=cstr(f_age1)+' years ... '+cstr(f_age2)+' years';
         11:s:=aonoff(f_gender='M','Male','Female');
         12:s:=cstr(f_postratio1)+' ... '+cstr(f_postratio2);
         13:s:=cstr(f_dlkratio1)+' ... '+cstr(f_dlkratio2);
         14:s:=cstr(f_dlratio1)+' ... '+cstr(f_dlratio2);
        end;
        cl(3);
      end;
      sprint(s);
      wkey(abort,next);
    end;
    nl;
  end;

  function okusr(x:integer):boolean;
  var fsf:f_statusflagsrec;
      u:userrec;
      i,j:longint;
      ok:boolean;

    function nofindit(s:string):boolean;
    begin
      nofindit:=(pos(allcaps(f_gentext),allcaps(s))=0);
    end;

  begin
    with u do begin
      seek(uf,x); read(uf,u); ok:=TRUE;
      i:=-1;
      while ((ok) and (i<14)) do begin
        inc(i);
        if (f_state[i]) then
          case i of
            0:if ((nofindit(name)) and (nofindit(realname)) and
                  (nofindit(street)) and (nofindit(citystate)) and
                  (nofindit(zipcode)) and (nofindit(computer)) and
                  (nofindit(ph)) and (nofindit(note)) and
                  (nofindit(occupation)) and (nofindit(wherebbs))) then
                ok:=FALSE;
            1:if (not aacs1(u,x,f_acs)) then ok:=FALSE;
            2:if ((sl<f_sl1) or (sl>f_sl2)) then ok:=FALSE;
            3:if ((dsl<f_dsl1) or (dsl>f_dsl2)) then ok:=FALSE;
            4:if (not (ar>=f_ar)) then ok:=FALSE;
            5:if (not (ac>=f_ac)) then ok:=FALSE;
            6:for fsf:=fs_deleted to fs_slogging do
                if (fsf in f_status) then
                  case fsf of
                    fs_deleted   :if (not deleted) then ok:=FALSE;
                    fs_trapping  :if (not trapactivity) then ok:=FALSE;
                    fs_chatbuffer:if (not chatauto) then ok:=FALSE;
                    fs_lockedout :if (not lockedout) then ok:=FALSE;
                    fs_alert     :if (not (alert in ac)) then ok:=FALSE;
                    fs_slogging  :if (not slogseperate) then ok:=FALSE;
                  end;
            7:if ((daynum(laston)>daynum(date)-f_laston1) or
                  (daynum(laston)<daynum(date)-f_laston2)) then ok:=FALSE;
            8:if ((daynum(firston)>daynum(date)-f_firston1) or
                  (daynum(firston)<daynum(date)-f_firston2)) then ok:=FALSE;
            9:if ((loggedon<f_numcalls1) or (loggedon>f_numcalls2)) then ok:=FALSE;
           10:if (((ageuser(bday)<f_age1) or (ageuser(bday)>f_age2)) and
                  (ageuser(bday)<>0)) then
                ok:=FALSE;
           11:if (sex<>f_gender) then ok:=FALSE;
           12:begin
                j:=msgpost; if (j=0) then j:=1; j:=loggedon div j;
                if ((j<f_postratio1) or (j>f_postratio2)) then ok:=FALSE;
              end;
           13:begin
                j:=uk; if (j=0) then j:=1; j:=dk div j;
                if ((j<f_dlkratio1) or (j>f_dlkratio2)) then ok:=FALSE;
              end;
           14:begin
                j:=uploads; if (j=0) then j:=1; j:=downloads div j;
                if ((j<f_dlratio1) or (j>f_dlratio2)) then ok:=FALSE;
              end;
          end;
      end;
    end;
    okusr:=ok;
  end;

  procedure search(i:integer);
  var u:userrec;
      n:integer;
      c:char;
  begin
    n:=usern;
    repeat
      inc(usern,i);
      if (usern<=0) then usern:=filesize(uf)-1;
      if (usern>=filesize(uf)) then usern:=1;
    until ((okusr(usern)) or (usern=n));
  end;

  procedure clear_f;
  var i:integer;
  begin
    for i:=0 to 14 do f_state[i]:=FALSE;

    f_gentext:=''; f_acs:='';
    f_sl1:=0; f_sl2:=255; f_dsl1:=0; f_dsl2:=255;
    f_ar:=[]; f_ac:=[]; f_status:=[];
    f_laston1:=0; f_laston2:=65535; f_firston1:=0; f_firston2:=65535;
    f_numcalls1:=0; f_numcalls2:=65535; f_age1:=0; f_age2:=65535;
    f_gender:='M';
    f_postratio1:=0; f_postratio2:=65535; f_dlkratio1:=0; f_dlkratio2:=65535;
    f_dlratio1:=0; f_dlratio2:=65535;
  end;

  procedure stopt;
  var fsf:f_statusflagsrec;
      i,usercount:integer;
      c,ch:char;
      done:boolean;
      s:astr;

    procedure chbyte(var x:integer);
    var s:astr;
        i:integer;
    begin
      input(s,3); i:=x;
      if (s<>'') then i:=value(s);
      if ((i>=0) and (i<=255)) then x:=i;
    end;

    procedure chword(var x:word);
    var s:astr;
        w:word;
    begin
      input(s,5);
      if (s<>'') then begin
        w:=value(s);
        if ((w>=0) and (w<=65535)) then x:=w;
      end;
    end;

    procedure inp_range(var w1,w2:word; r1,r2:word);
    begin
      print('Range: '+cstr(r1)+'..'+cstr(r2));
      prt('Lower limit ['+cstr(w1)+'] : '); chword(w1);
      prt('Upper limit ['+cstr(w2)+'] : '); chword(w2);
    end;
  
    function get_f_ac:string;
    var r:uflags;
        s:string;
    begin
      for r:=rlogon to rmsg do
        if (r in f_ac) then s:=s+copy('LCVBA*PEKM',ord(r)+1,1)
        else s:=s+'-';
      s:=s+'/';
      for r:=fnodlratio to fnodeletion do begin
        if (r in f_ac) then s:=s+copy('1234',ord(r)-19,1)
        else s:=s+'-';
      end;
      get_f_ac:=s;
    end;

  begin
    done:=FALSE;
    pcuropt;
    repeat
      prt('Change (?=help) : '); onek(c,'Q0123456789AGPKN?CLTU'^M);
      nl;
      case c of
        '0'..'9':i:=ord(c)-48;
        'A':i:=10; 'G':i:=11; 'P':i:=12; 'K':i:=13; 'N':i:=14;
      else
            i:=-1;
      end;
      if (i<>-1) then begin
        sprompt(#3#5+'[> '+#3#0);
        if (f_state[i]) then
          sprint(searchtype(i))
        else begin
          f_state[i]:=TRUE;
          sprint(searchtype(i)+' is now *ON*');
        end;
{        nl;}
      end;

      case c of
        '0':begin
              print('General text ["'+f_gentext+'"]');
              prt(':'); input(s,30);
              if (s<>'') then f_gentext:=s;
            end;
        '1':begin
              prt('Search ACS ["'+f_acs+'"]');
              prt(':'); inputl(s,50);
              if (s<>'') then f_acs:=s;
            end;
        '2':begin
              prt('Lower limit ['+cstr(f_sl1)+'] : ');
              chword(f_sl1);
              prt('Upper limit ['+cstr(f_sl2)+'] : ');
              chword(f_sl2);
            end;
        '3':inp_range(f_dsl1,f_dsl2,0,255);
        '4':repeat
              prt('Which AR flag? <CR>=Quit : ');
              onek(ch,^M'ABCDEFGHIJKLMNOPQRSTUVWXYZ');
              if (ch<>^M) then
                if (ch in ['A'..'Z']) then
                  if (ch in f_ar) then f_ar:=f_ar-[ch] else f_ar:=f_ar+[ch];
            until ((ch=^M) or (hangup));
        '5':begin
              repeat
                prt('Restrictions ['+get_f_ac+'] [?]Help [Q]uit :');
                onek(c,'Q LCVBA*PEKM1234?'^M);
                case c of
                  ^M,' ','Q': ;
                  '?':restric_list;
                else
                      if (tacch(c) in f_ac) then f_ac:=f_ac-[tacch(c)]
                      else f_ac:=f_ac+[tacch(c)];
                end;
              until ((c in [^M,' ','Q']) or (hangup));
            end;
        '6':repeat
              s:=find_fs;
              sprint(#3#4+'Current flags: '+#3#3+s);
              prt('Toggle (?=help) : '); onek(ch,'QACDLST? '^M);
              if (pos(ch,'ACDLST')<>0) then begin
                case ch of
                  'A':fsf:=fs_alert;
                  'C':fsf:=fs_chatbuffer;
                  'D':fsf:=fs_deleted;
                  'L':fsf:=fs_lockedout;
                  'S':fsf:=fs_slogging;
                  'T':fsf:=fs_trapping;
                end;
                if (fsf in f_status) then f_status:=f_status-[fsf]
                  else f_status:=f_status+[fsf];
              end else
                if (ch='?') then begin
                  nl;
                  lcmds(15,3,'Alert','Chat-buffering');
                  lcmds(15,3,'Deleted','Locked-out');
                  lcmds(15,3,'Seperate SysOp logging','Trapping');
                  nl;
                end;
            until ((ch in ['Q',' ',^M]) or (hangup));
        '7':inp_range(f_laston1,f_laston2,0,65535);
        '8':inp_range(f_firston1,f_firston2,0,65535);
        '9':inp_range(f_numcalls1,f_numcalls2,0,65535);
        'A':inp_range(f_age1,f_age2,0,65535);
        'G':begin
              prt('Gender ['+f_gender+'] : ');
              onek(c,'QMF'^M); nl;
              if (c in ['F','M']) then f_gender:=c;
            end;
        'P':inp_range(f_postratio1,f_postratio2,0,65535);
        'K':inp_range(f_dlkratio1,f_dlkratio2,0,65535);
        'N':inp_range(f_dlratio1,f_dlratio2,0,65535);
        'C':if pynq('Are you sure? [No] ') then clear_f;
        ^M,'L':pcuropt;
        'T':begin
              prt('Which? '); onek(ch,'Q0123456789AGPKN'^M);
              case ch of
                '0'..'9':i:=ord(ch)-48;
                'A':i:=10; 'G':i:=11; 'P':i:=12; 'K':i:=13; 'N':i:=14;
              else
                    i:=-1;
              end;
              if (i<>-1) then begin
                f_state[i]:=not f_state[i];
                sprompt(#3#5+'[> '+#3#0+searchtype(i)+' is now *');
                if (f_state[i]) then print('ON*') else print('OFF*');
              end;
              nl;
            end;
        'U':begin
              abort:=FALSE; usercount:=0;
              for i:=1 to filesize(uf)-1 do begin
                if (okusr(i)) then begin
                  seek(uf,i); read(uf,user1);
                  printacr(#3#3+caps(user1.name)+' #'+cstr(i),abort,next);
                  inc(usercount);
                end;
                if (abort) then i:=filesize(uf)-1;
              end;
              if (not abort) then
                sprint('@M^7 ** '+#3#5+cstr(usercount)+' Users.@M');
            end;
        'Q':done:=TRUE;
        '?':begin
              sprint(#3#3+'0-9,AGPKN'+#3#1+': Change option');
              lcmds(14,3,'List options','Toggle options on/off');
              lcmds(14,3,'Clear options','User''s who match');
              lcmds(14,3,'Quit','');
              nl;
            end;
      end;
      if (pos(c,'C0123456789AGPKN')<>0) then nl;
    until ((done) or (hangup));
  end;

  procedure killusermail;
  var u:userrec;
      pinfo:pinforec;
      mixr:msgindexrec;
      i,j:longint;
  begin
    savepinfo(pinfo);
    initbrd(-1);
    for i:=0 to himsg do begin
      seek(mixf,i); blockread(mixf,mixr,1);
      j:=mixr.messagenum;
      if ((miexist in mixr.msgindexstat) and (j=usern)) then s:=rmail(i);
(*      begin
        mixr.msgindexstat:=mixr.msgindexstat-[miexist];
        seek(mixf,filepos(mixf)-1); write(mixf,mixr);
        if ((j>=1) and (j<=filesize(uf)-1)) then begin
          seek(uf,j); read(uf,u);
          dec(u.waiting);
          seek(uf,j); write(uf,u);
        end;
      end;*)
    end;
    loadpinfo(pinfo);
  end;

  procedure killuservotes;
  var vdata:file of vdatar;
      vd:vdatar;
      i:integer;
  begin
    assign(vdata,systat.gfilepath+'voting.dat');
    {$I-} reset(vdata); {$I+}
    if (ioresult=0) then begin
      for i:=1 to filesize(vdata) do
        if (user.vote[i]>0) then begin
          seek(vdata,i-1); read(vdata,vd);
          dec(vd.answ[user.vote[i]].numres);
          seek(vdata,i-1); write(vdata,vd);
          user.vote[i]:=0;
        end;
      close(vdata);
    end;
  end;

  procedure delusr;
  var i:integer;
  begin
    if (not user.deleted) then begin
      save:=TRUE; user.deleted:=TRUE;
      dsr(user.name);
      sysoplog('* Deleted user: '+caps(user.name)+' #'+cstr(usern));
      i:=usernum; usernum:=usern;
      rsm;
      usernum:=i;
      user.waiting:=0;

      killusermail;
      killuservotes;
    end;
  end;

  procedure renusr;
  begin
    if (user.deleted) then print('Can''t rename deleted users.')
    else begin
      nl; prt('Enter new name: '); input(ii,36);
      if (ii<>'') and (ii[1] in ['A'..'Z','?']) then begin
        dsr(user.name); isr(ii,usern);
        user.name:=ii; save:=TRUE;
        if (usern=usernum) then thisuser.name:=ii;
      end;
    end;
  end;

  procedure chhflags;
  var done:boolean;
      c:char;
  begin
    nl;
    done:=FALSE;
    repeat
      prt('Restrictions ['+spflags(user)+'] [?]Help [Q]uit :');
      onek(c,'Q LCVBA*PEKM1234?'^M);
      case c of
        ^M,' ','Q':done:=TRUE;
        '?':restric_list;
      else
            begin
              if (c='4') and (not so) then print('You can''t change that!')
              else begin
                acch(c,user);
                save:=TRUE;
              end;
            end;
      end;
    until (done) or (hangup);
    save:=TRUE;
  end;

  procedure chhsl;
  begin
    prt('Enter new SL: '); ini(byt);
    if (not badini) then begin
      save:=TRUE;
      if (byt<thisuser.sl) or (usernum=1) then begin
        if (usernum=usern) and (byt<thisuser.sl) then
          if not pynq('Lower your own SL level? [No] ') then exit;
        user.sl:=byt;
      end else begin
        sysoplog('UEDIT: Illegal SL change- '+caps(user.name)+' #'+cstr(usern)+
                 ' to '+cstr(byt));
        print('Access denied.'^G);
      end;
    end;
  end;

  procedure chhdsl;
  begin
    prt('Enter new DSL: '); ini(byt);
    if (not badini) then begin
      save:=TRUE;
      if (byt<thisuser.dsl) or (usernum=1) then begin
        if (usernum=usern) and (byt<thisuser.sl) then
          if not pynq('Lower your own DSL level? [No] ') then exit;
        user.dsl:=byt;
      end else begin
        sysoplog('UEDIT: Illegal DSL change- '+caps(user.name)+' #'+cstr(usern)+
                 ' to '+cstr(byt));
        print('Access denied.'^G);
      end;
    end;
  end;

  procedure chrecords(beg:byte);
  var on:byte;
      done:boolean;
      c:char;
      i:integer;
  begin
    on:=beg;
    done:=FALSE;
    with user do
      repeat
        nl;
        case on of
          1:begin
              sprint(#3#5+'Call records:');
              print('(0)Total calls: '+mn(loggedon,5)+' (1)Total time on:   '+mn(trunc(ttimeon),8));
              print('(2)Calls today: '+mn(ontoday,5)+ ' (3)Time left today: '+mn(tltoday,5));
              print('(4)Illegal logon attempts: '+mn(illegal,5));
              nl;
              prt('Select: (0-4) [M]ail [F]ile [Q]uit :');
              onek(c,'Q01234MF'^M);
            end;
          2:begin
              sprint(#3#5+'Mail records:');
              print('(0)Pub. posts: '+mn(msgpost,5)+' (1)Priv. posts:  '+mn(emailsent,5));
              print('(2)Fback sent: '+mn(feedback,5)+' (3)Mail waiting: '+mn(waiting,5));
              nl;
              prt('Select: (0-3) [C]all [F]ile [Q]uit :');
              onek(c,'Q0123CF'^M);
            end;
          3:begin
              sprint(#3#5+'File records:');
              print('(0)# of DLs: '+mn(downloads,5)+' (1)DL k: '+cstr(trunc(dk)));
              print('(2)# of ULs: '+mn(uploads,5)+' (3)UL k: '+cstr(trunc(uk)));
              nl;
              prt('Select: (0-3) [C]all [M]ail [Q]uit :');
              onek(c,'Q0123CM'^M);
            end;
        end;
        case c of
          'Q',^M:done:=TRUE;
          'C':on:=1;
          'M':on:=2;
          'F':on:=3;
          '0'..'4':begin
            nl; prt('New value: '); inu(i);
            if not badini then
              case on of
                1:case value(c) of
                    0:loggedon:=i; 1:ttimeon:=i; 2:ontoday:=i; 3:tltoday:=i;
                    4:illegal:=i;
                  end;
                2:case value(c) of
                    0:msgpost:=i; 1:emailsent:=i; 2:feedback:=i; 3:waiting:=i;
                  end;
                3:case value(c) of
                    0:downloads:=i; 1:dk:=i; 2:uploads:=i; 3:uk:=i;
                  end;
              end;
          end;
        end;
      until (done) or (hangup);
  end;

  function onoff(b:boolean; s1,s2:astr):astr;
  begin
    if b then onoff:=s1 else onoff:=s2;
  end;

  procedure lcmds3(len,c:byte; c1,c2,c3:astr);
  var s:astr;
  begin
    s:='';
    s:=s+#3#1+'('+#3+chr(c)+c1[1]+#3#1+')'+mln(copy(c1,2,lenn(c1)-1),len-1);
    if (c2<>'') then
      s:=s+#3#1+'('+#3+chr(c)+c2[1]+#3#1+')'+mln(copy(c2,2,lenn(c2)-1),len-1);
    if (c3<>'') then
      s:=s+#3#1+'('+#3+chr(c)+c3[1]+#3#1+')'+copy(c3,2,lenn(c3)-1);
    printacr(s,abort,next);
  end;

begin
  reset(uf);
  if ((usern<1) or (usern>filesize(uf)-1)) then begin close(uf); exit; end;
  if (usern=usernum) then begin
    user:=thisuser;
    seek(uf,usern); write(uf,user);
  end;
  seek(uf,usern); read(uf,user);

  clear_f;

  oldusern:=0;
  save:=FALSE;
  repeat
    abort:=FALSE;
    if (autolist) or (usern<>oldusern) or (c=^M) then begin
      nl; nl;
      showuserinfo(userinfotyp,usern,user);
      oldusern:=usern;
    end;
    sprompt(#3#4+'Editor command  '+#3#9);
    onek(c,'Q?[]={}*^@!ABCDEFGHIJKLMNOPRSTUVWYZ$123''#&-_;:\~'^M);
    cls;
    case c of
      '?':begin
            cls;
            nl;
            sprint(#3#5+'Insanity v'+ver+' User Editor Commands'); 
            sprint(#3#0+'');
            nl;
            print('[RETURN] Redisplay User');
            lcmds3(21,3,';New List Mode',':Autolist Mode Togg.','BSubscriptions');
            lcmds3(21,3,'[Back 1 User',']Forward 1 User','=Oops (Reload Old Data)');
            lcmds3(21,3,'{Search Backward','}Search Forward','*Auto-Validate User');
            lcmds3(21,3,'~Trap/Chat Logging','@Lockout/Unlockout','!Toggle ALERT Status');
            lcmds3(21,3,'AYears Modem Experience','City & State','DFile Level');
            lcmds3(21,3,'EAC Change','FAccess Restr. Flags','GSex/Age');
            lcmds3(21,3,'IModem Speed/Type','KAccount Note','Laston Date');
            lcmds3(21,3,'Mailbox','Name or Handle','OSearch Options');
            lcmds3(21,3,'Phone Number','Real Name','SUser Level');
            lcmds3(21,3,'Type of Computer','UGoto User Name/#','WReference(s)');
            lcmds3(21,3,'YSponsor Message Bases','Zip-Code','$Password');
            lcmds3(21,3,'1Call Records','2Mail Records','3File Records');
            lcmds3(21,3,'''User Colors','#File Points','&System Bank');
            lcmds3(21,3,'^Delete/Restore User','-New User Infoform','_Other Q. Answers');
            lcmds3(21,3,'\Show Sysop Log','JEdit Nukes','HSpinning Cursor');
            lcmds3(21,3,'Quit User Editor','VPurge Users','');
            pausescr;
            save:=FALSE;
          end;
      '[',']','{','}','U','Q':begin
            if save then begin
              seek(uf,usern); write(uf,user);
              if usern=usernum then thisuser:=user;
              save:=FALSE;
            end;
            case c of
              '[':begin
                    dec(usern);
                    if (usern<=0) then usern:=filesize(uf)-1;
                  end;
              ']':begin
                    inc(usern);
                    if (usern>=filesize(uf)) then usern:=1;
                  end;
              '{':begin
                    nl; prompt('Searching ... ');
                    search(-1); nl;
                  end;
              '}':begin
                    nl; prompt('Searching ... ');
                    search(1);  nl;
                  end;
              'U':begin
                    prt('Enter user name, #, or partial search string: ');
                    finduserws(i);
                    if (i>0) then begin
                      seek(uf,i); read(uf,user);
                      usern:=i;
                    end else begin
                      pausescr;
                    end;
                  end;
            end;
            seek(uf,usern); read(uf,user);
            if (usern=usernum) then thisuser:=user;
          end;
      '=':if pynq('@M'+#3#7+'Reload old user data? [No] ') then begin
            seek(uf,usern); read(uf,user);
            if (usern=usernum) then thisuser:=user;
            save:=FALSE;
            sprint(#3#7+'Old data reloaded.');
          end;
      'O','-','_',';',':','\':
          begin
            case c of
              'O':stopt;
              '-':begin
                    readasw(usern,systat.afilepath+'newuser');
                    pausescr;
                  end;
              '_':begin
                    nl;
                    prt('Print questionairre file: '); mpl(8); input(s,8); nl;
                    readasw(usern,systat.afilepath+s);
                    pausescr;
                  end;
              ';':begin
                    nl;
                    prt('(L)ong or (S)hort list mode : ');
                    onek(c,'QSL '^M);
                    case c of
                      'S':userinfotyp:=2;
                      'L':userinfotyp:=1;
                    end;
                  end;
              ':':autolist:=not autolist;
              '\':begin
                    s:=systat.trappath+'slog'+cstr(usern)+'.log';
                    printf(s);
                    if (nofile) then print('"'+s+'": file not found.');
                    pausescr;
                  end;
            end;
          end;
      '*','^','@','!','A','B','C','D','E','F','G','H','I','J','K','L','M',
      'N','P','R','S','T','V','W','Y','Z','$','1','2','3','''','#','&','~':
          begin
            if ((thisuser.sl<=user.sl) or (thisuser.dsl<=user.dsl)) and
               (usernum<>1) and (usernum<>usern) then begin
              sysoplog('UEDIT: Tried to modify '+
                       caps(user.name)+' #'+cstr(usern));
              print('Access denied.');
            end else begin
              save1:=save; save:=TRUE;
              case c of
                '*':begin
                      autoval(user,usern);
                      ssm(abs(usern),^G'You were validated on '+date+' '+time+'.'^G);
                    end;
                '^':if (user.deleted) then begin
                      print('User is currently deleted.');
                      nl;
                      if pynq('Restore this user? [No] ') then begin
                        isr(user.name,usern);
                        user.deleted:=FALSE;
                      end else
                        save:=save1;
                    end else
                      if (fnodeletion in user.ac) then begin
                        print('Access denied - This user is protected from deletion.');
                        sysoplog('* Attempt to delete user: '+caps(user.name)+
                                 ' #'+cstr(usern));
                        nl; pausescr;
                        save:=save1;
                      end else begin
                        print('User is not currently deleted.');
                        nl;
                        print('NOTE: If this user is deleted, ALL VOTING RECORDS,');
                        print('AND ANY EMAIL TO OR FROM THIS USER WILL BE DELETED.');
                        nl;
                        if pynq('*DELETE* this user? [No] ') then delusr
                        else save:=save1;
                      end;
                '@':begin
                      nl;
                      user.lockedout:=not user.lockedout;
                      if (user.lockedout) then begin
                        print('User is now LOCKED out.');
                        nl;
                        print('Each time the user logs on from now on, a text file will');
                        print('be displayed before connection is terminated.');
                        nl;
                        prt('Enter lockout filename: ');
                        mpl(8); input(ii,8);
                        if (ii='') then user.lockedout:=FALSE
                        else begin
                          user.lockedfile:=ii;
                          sysoplog('UEDIT: Locked '+unam+' out: Lockfile "'+ii+'"');
                        end;
                      end;
                      if (not user.lockedout) then
                        print('User is no longer locked out of system.');
                      nl;
                      pausescr;
                    end;
                '!':if (alert in user.ac) then user.ac:=user.ac-[alert]
                                else user.ac:=user.ac+[alert];
                'A':cstuff(1,3,user);
                'B':begin
                      sprint('Subscription expiration date entry.');
                      nl;
                      sprint(' -- After expiration date, user level drops to default --');
                      nl;
                      sprint('Today''s date is '+date);
                      sprompt('This user''s expiration date is '+cstr(user.m)+'/'+cstr(user.d)+
                        '/'+cstr(user.y));
                      nl;
                      prt('Enter expiration year [CR=No change]  :');
                      ini(byt);
                      if (not badini) then user.y:=byt; 
                      prt('Enter expiration month [CR=No change] :');
                      ini(byt);
                      if (not badini) then user.m:=byt;
                      prt('Enter expiration day [CR=No change]   :');
                      ini(byt);
                      if (not badini) then user.d:=byt;
                      prt('User level during subscription [CR=No change] :');
                      ini(byt);
                      if (not badini) then user.sl:=byt;
                      prt('File level during subscription [CR=No change] :');
                      ini(byt);
                      if (not badini) then user.dsl:=byt;
                    end;
                'C':cstuff(4,3,user);
                'D':chhdsl;
                'E':chhflags;
                'F':begin
                      nl;
                      repeat
                        prt('Which AR flag? <CR>=Quit : ');
                        onek(c,'ABCDEFGHIJKLMNOPQRSTUVWXYZ'^M);
                        if (c<>^M) then
                          if (not (c in thisuser.ar)) and (usernum<>1) then begin
                            sysoplog('UEDIT: Tried to give '+caps(user.name)+
                                     ' #'+cstr(usern)+' AR flag "'+c+'"');
                            print('Access denied.'^G)
                          end else
                            if (c in ['A'..'Z']) then
                              if (c in user.ar) then user.ar:=user.ar-[c]
                                                else user.ar:=user.ar+[c];
                      until (c=^M) or (hangup);
                      c:=#0;
                    end;
                'G':begin
                      cstuff(2,3,user);
                      cstuff(12,3,user);
                    end;
                'H':begin
                      nl;
                      sprompt('Spinning cursor is now ');
                      if user.cursor=true then sprint('ON.') else sprint('OFF.');
                      nl;
                      if pynq('Turn ON spinning cursor? [No] ') then user.cursor:=true
                      else user.cursor:=false;
                    end;
                'I':cstuff(6,3,user);
                'J':begin
                      nl;
                      if user.nukes=0 then sprint('This user has NO nukes.') else
                      sprint('This user has '+cstr(user.nukes)+' nuke(s) total.');
                      nl;
                      sprint('REMEMBER: This user is locked out one day for each nuke.'); 
                      nl;
                      prt('Enter new # of Nukes : ');
                      inu(i);
                      if (not badini) then user.nukes:=i;
                    end; 
                'K':begin
                      nl;
                      print('New SysOp Note: ');
                      prt(':'); mpl(39); inputl(s,39);
                      if (s<>'') then user.note:=s;
                    end;
                'L':begin
                      nl;
                      print('New Laston date, in the form MM/DD/YY:');
                      prt(':'); 
                      mpl(8); 
                      inputl(s,8);
                      if (s<>'') and (daynum(s)<>0) then user.laston:=s;
                    end;
                'M':cstuff(15,3,user);
                'N':renusr;
                'P':cstuff(8,3,user);
                'R':cstuff(10,3,user);
                'S':chhsl;
                'T':cstuff(5,3,user);
                'V':begin
                      (*
                      utemp:=0;
                      sprint('All inactive users will be deleted.');
                      sprint('Enter date to purge before in form MM/DD/YY');
                      prt(':');
                      mpl(8);
                      inputl(s,8);
                      repeat
                        inc(utemp);
                        seek(uf,utemp);
                        read(uf,user);
                        if val(copy(user.laston,7,2)) < val(copy(s,7,2)) then user.deleted:=true; 
                        if val(copy(user.laston,1,2)) < val(copy(s,1,2)) then user.deleted:=true;
                        if val(copy(user.laston,5,2)) < val(copy(s,5,2)) then user.deleted:=true;
                      until eof(uf);
                      *)
                    end;
                'W':cstuff(13,3,user);
                'Y':begin
                      nl;
                      prt('Message base SysOp:'); nl;
                      nl;
                      for i:=1 to 5 do prompt(cstr(i)+') '+cstr(user.boardsysop[i])+'  ');
                      nl; print('(-1 is inactive)');
                      nl;
                      prt('Which number? (1-5) :'); ini(byt); i:=byt;
                      if (not badini) then begin
                        prt('Which message base? (1-'+cstr(numboards)+') :'); ini(byt);
                        if (not badini) then
                          if ((byt>=1) and (byt<=numboards)) or (byt=-1) then
                            user.boardsysop[i]:=byt;
                      end;
                    end;
                'Z':cstuff(14,3,user);
                '$':cstuff(9,3,user);
                '1'..'3':chrecords(value(c));
                '''':cstuff(21,3,user);
                '#':begin
                      nl;
                      sprint(caps(user.name)+' has '+cstr(user.filepoints)+'.');
                      nl;
                      prt('Enter new amount of file points.'); nl;
                      prt(':'); mpl(5); inu(i);
                      if (not badini) then user.filepoints:=i;
                    end;
                '&':begin
                      nl;
                      prt('Enter new amount of time in time bank.'); nl;
                      prt(':'); mpl(5); inu(i);
                      if (not badini) then user.timebank:=i;
                    end;
                '~':begin
                      repeat
                        nl;
                        sprint('1. Trapping status: '+
                          onoff(user.trapactivity,
                          #3#7+onoff(user.trapseperate,
                          'Trapping to TRAP'+cstr(usern)+'.MSG',
                          'Trapping to TRAP.MSG'),
                          'Off')+onoff(systat.globaltrap,#3#8+' <GLOBAL>',''));
                        sprint('2. Auto-chat state: '+onoff(user.chatauto,
                          onoff(user.chatseperate,
                          #3#7+'Output to CHAT'+cstr(usern)+'.MSG',
                          #3#7+'Output to CHAT.MSG'),'Off')+
                          onoff(systat.autochatopen,#3#8+' <GLOBAL>',''));
                        sprint('3. SysOp Log state: '+onoff(user.slogseperate,
                          #3#7+'Logging to SLOG'+cstr(usern)+'.LOG',
                          #3#3+'Normal output'));
                        nl;
                        prt('Select (1-3,Q=Quit) : '); onek(c,'Q123'^M);
                        if (c in ['1'..'3']) then begin
                          nl;
                          case c of
                            '1':begin
                                  dyny:=user.trapactivity;
                                  user.trapactivity:=
                                    pynq('Trap user activity? [No] ');
                                  if (user.trapactivity) then begin
                                    dyny:=user.trapseperate;
                                    user.trapseperate:=
                                      pynq('Log to seperate file? [No] ');
                                  end else
                                    user.trapseperate:=FALSE;
                                end;
                            '2':begin
                                  dyny:=user.chatauto;
                                  user.chatauto:=
                                    pynq('Auto-chat buffer open? [No] ');
                                  if (user.chatauto) then begin
                                    dyny:=user.chatseperate;
                                    user.chatseperate:=
                                      pynq('Seperate buffer file? [No] ');
                                  end else
                                    user.chatseperate:=FALSE;
                                end;
                            '3':begin
                                  dyny:=user.slogseperate;
                                  user.slogseperate:=
                                    pynq('Output SysOp Log seperately? [No] ');
                                end;
                          end;
                        end;
                      until ((not (c in ['1'..'3'])) or (hangup));
                      c:=#0;
                    end;
                else
                      save:=save1;
              end;
            end;
          end;
    end;
    if (usern=usernum) then thisuser:=user;
  until (c='Q') or hangup;
  close(uf);
  topscr;
end;

end.

