(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2S .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "S" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2s;

interface

uses
  crt, dos, overlay,
  common, ansifont;

procedure postring;

implementation

const
  aresure='Are you sure this is what you want? [No] ';

procedure instring(p:astr; var v:astr; len:integer);
var changed:boolean;
begin
  sprint('^3Enter new "'+p+'" string ^4 ^5');
  inputwnwc(v,len,changed);
end;

procedure postring;
var fstringf:file of fstringrec;
    s,s2:astr;
    onpage:integer;
    c:char;
    abort,next,done:boolean;

  function cc(s:astr):astr;
  begin
    while pos('^',s)>0 do s[pos('^',s)]:=#3;
    cc:=#3#1+s;
  end;

  procedure showstrings;
  begin
    abort:=FALSE; next:=FALSE;
    with fstring do
      case onpage of
        1:begin
            printacr('^0A. ^3Logon line    ^4 ^5'+cc(ansiq),abort,next);
            printacr('^0B. ^3BIG msg title ^4 ^5'+cc(note[1]),abort,next);
	    printacr('^0   ^3BIG message   ^4 ^5'+cc(note[2]),abort,next);
	    printacr('^0   ^3BIG font      ^4 ^5'+cstr(ansifont),abort,next);
	    printacr('^0C. ^3Matrix prompt ^4 ^5'+cc(lprompt),abort,next);
	    printacr('^0D. ^3Echo chr      ^4 ^5'+cc(echoc),abort,next);
	    printacr('^0E. ^3SysOp IN      ^4 ^5'+cc(sysopin),abort,next);
	    printacr('^0F. ^3SysOp OUT     ^4 ^5'+cc(sysopout),abort,next);
	    printacr('^0G. ^3Engage chat   ^4 ^5'+cc(engage),abort,next);
	    printacr('^0H. ^3Exit chat     ^4 ^5'+cc(endchat),abort,next);
	    printacr('^0I. ^3Sysop working ^4 ^5'+cc(wait),abort,next);
	    printacr('^0J. ^3Pause screen  ^4 ^5'+cc(pause),abort,next);
            printacr('^0K. ^3DOS-sim dir   ^4 ^5'+cc(systat.startdir),abort,next);
	    nl;
	    prt('^3Enter selection [A-J,[,]],[Q]uit ^4 ^5');
	    onek(c,'QABCDEFGHIJ[]');
	  end;
	2:begin                              
	    printacr('^0A. ^3Message entry L#1 ^4 ^5'+cc(entermsg1),abort,next);
	    printacr('^0B. ^3Message entry L#2 ^4 ^5'+cc(entermsg2),abort,next);
	    printacr('^0C. ^3NewScan start     ^4 ^5'+cc(newscan1),abort,next);
	    printacr('^0D. ^3NewScan done      ^4 ^5'+cc(newscan2),abort,next);
	    printacr('^0E. ^3Read msgs prompt  ^4 ^5'+cc(scanmessage),abort,next);
	    printacr('^0F. ^3Last user message ^4 ^5'+cc(automsgt),abort,next);
	    printacr('^0G. ^3BIG message char  ^4 ^5'+autom,abort,next);
	    nl;
	    prt('^3Enter selection [A-G,[,]],[Q]uit ^4 ^5');
	    onek(c,'QABCDEFG[]');
	  end;
	3:begin
	    printacr('^0A. ^3Shell to DOS L#1  ^4 ^5'+cc(shelldos1),abort,next);
	    printacr('^0B. ^3Shell to DOS L#2  ^4 ^5'+cc(shelldos2),abort,next);
	    printacr('^0C. ^3Chat call L#1     ^4 ^5'+cc(chatcall1),abort,next);
	    printacr('^0D. ^3Chat call L#2     ^4 ^5'+cc(chatcall2),abort,next);
	    printacr('^0E. ^3"List 3" in New.  ^4 ^5'+cc(guestline),abort,next);
	    printacr('^0F. ^3Name not found    ^4 ^5'+cc(namenotfound),abort,next);
	    printacr('^0G. ^3Bulletin line     ^4 ^5'+cc(bulletinline),abort,next);
	    printacr('^0H. ^3Thanks for voting ^4 ^5'+cc(thanxvote),abort,next);
	    nl;
	    prt('^3Enter selection [A-H,[,]],[Q]uit ^4 ^5');
	    onek(c,'QABCDEFGH[]');
	  end;
	4:begin
	    printacr('^0A. ^3List line         ^4 ^5'+cc(listline),abort,next);
	    printacr('^0B. ^3File NewScan line ^4 ^5'+cc(newline),abort,next);
	    printacr('^0C. ^3Search line       ^4 ^5'+cc(searchline),abort,next);
	    printacr('^0D. ^3Find Descrip. L#1 ^4 ^5'+cc(findline1),abort,next);
	    printacr('^0E. ^3Find Descrip. L#2 ^4 ^5'+cc(findline2),abort,next);
	    printacr('^0F. ^3Download line     ^4 ^5'+cc(downloadline),abort,next);
	    printacr('^0G. ^3Upload line       ^4 ^5'+cc(uploadline),abort,next);
	    printacr('^0H. ^3Newuser yes/no Q. ^4 ^5'+cc(newyes),abort,next);
	    printacr('^0I. ^3Insuff. file pts  ^4 ^5'+cc(nofilepts),abort,next);
	    printacr('^0J. ^3Bad UL/DL ratio   ^4 ^5'+cc(unbalance),abort,next);
	    nl;
	    prt('^3Enter selection [A-J,[,]],[Q]uit ^4 ^5');
	    onek(c,'QABCDEFGHIJ[]');
	  end;
	5:begin
	    printacr('^0A. ^3P/N file info     ^4 ^5'+cc(pninfo),abort,next);
	    printacr('^0B. ^3Get filespec L#1  ^4 ^5'+cc(gfnline1),abort,next);
	    printacr('^0C. ^3Get filespec L#2  ^4 ^5'+cc(gfnline2),abort,next);
	    printacr('^0D. ^3Add to batch      ^4 ^5'+cc(batchadd),abort,next);
	    printacr('^0E. ^3Form letter #1    ^4 ^5'+cc(form1),abort,next);
	    printacr('^0F. ^3Form letter #2    ^4 ^5'+cc(form2),abort,next);
	    printacr('^0G. ^3Form letter #3    ^4 ^5'+cc(form3),abort,next);
	    printacr('^0H. ^3Form letter #4    ^4 ^5'+cc(form4),abort,next);
	    nl;                               
	    prt('^3Enter selection [A-H,[,]],[Q]uit ^4 ^5');
	    onek(c,'QABCDEFGH[]');
	  end;
      end;
  end;

  procedure dostringstuff;
  begin
{    cl(4);}
    case c of
      'Q':done:=TRUE;
      '[':begin
            dec(onpage);
            if (onpage<1) then onpage:=5;
          end;
      ']':begin
            inc(onpage);
            if (onpage>5) then onpage:=1;
          end;
    end;
    with fstring do
      case onpage of
        1:case c of
            'A':instring('Logon line (ie. Insanity Rules!) ',ansiq,80);
            'B':begin
		  instring('Enter BIG message title.',note[1],79);
		  instring('Enter the BIG message.',note[2],10);
		  ansifont:=getfont;
		end;
	    'C':instring('Matrix prompt',lprompt,40);
	    'D':begin
		  prt('Enter new echo character: ');
		  mpl(1); inputl(s,1);
		  if (s<>'') then echoc:=s[1];
		end;
	    'E':instring('SysOp IN',sysopin,80);
	    'F':instring('SysOp OUT',sysopout,80);
            'G':instring('Engage chat',engage,80);
            'H':instring('End chat',endchat,80);
            'I':instring('SysOp working',wait,80);
            'J':instring('Pause',pause,80);
            'K':instring('DOS simulator directory',systat.startdir,10);
            'Q':done:=TRUE;
          end;
        2:case c of
            'A':instring('Message entry line 1',entermsg1,80);
            'B':instring('Message entry line 2',entermsg2,80);
            'C':instring('NewScan line 1',newscan1,80);
            'D':instring('NewScan line 2',newscan2,80);
	    'E':instring('Read message prompt',scanmessage,80);
            'F':instring('Last user message title',automsgt,80);
            'G':begin
                  print('Enter BIG message creation character:');
                  inputl(s,1);
                  if (s<>'') then autom:=s[1];
                end;
          end;
        3:case c of
            'A':instring('Shell to DOS line 1',shelldos1,80);
            'B':instring('Shell to DOS line 2',shelldos2,80);
            'C':instring('Chat call line 1',chatcall1,80);
            'D':instring('Chat call line 2',chatcall2,80);
            'E':instring('"List 3" at Newuser Logon',guestline,80);
            'F':instring('Name not found line during logon',namenotfound,80);
            'G':instring('Bulletins prompt line',bulletinline,80);
            'H':instring('Thanks for voting',thanxvote,80);
          end;
        4:case c of
            'A':instring('List line',listline,80);
            'B':instring('File NewScan line',newline,80);
            'C':instring('Search line',searchline,80);
            'D':instring('Find description line 1',findline1,80);
            'E':instring('Find description line 2',findline2,80);
            'F':instring('Download line',downloadline,80);
            'G':instring('Upload line',uploadline,80);
            'H':instring('Newuser yes/no question',newyes,80);
            'I':instring('Insufficient file points',nofilepts,80);
            'J':instring('Upload/Download ratio unbalanced',unbalance,80);
          end;
        5:case c of
            'A':instring('P / N file information',pninfo,80);
            'B':instring('Get filespec line 1',gfnline1,80);
            'C':instring('Get filespec line 2',gfnline2,80);
            'D':instring('Add to batch queue',batchadd,80);
            'E':instring('Name of form letter #1',form1,75);
            'F':instring('Name of form letter #2',form2,75);
            'G':instring('Name of form letter #3',form3,75);
            'H':instring('Name of form letter #4',form4,75);
          end;
      end;
  end;

begin
  onpage:=1; done:=FALSE;
  repeat
    cls;
    sprint(#3#5+'String configuration - page '+cstr(onpage)+' of 5');
    nl;
    showstrings;
    nl;
    dostringstuff;
  until ((done) or (hangup));
  assign(fstringf,systat.gfilepath+'string.dat');
  reset(fstringf); seek(fstringf,0); write(fstringf,fstring); close(fstringf);
end;

end.
