(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2I .PAS -  Written by Martin Pollard                              <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "I" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2i;

interface

uses
  crt, dos, sysop2a, overlay,
  common;

procedure pofido;

implementation

procedure incolor(msg:string; var i:byte);
var c:char;
begin
  prt('Enter new '+msg+' color (0-9) : ');
  onek(c,^M'0123456789');
  if (c<>^M) then i:=ord(c)-48;
end;

function toggle(b:boolean):boolean;
begin
  if (b) then toggle:=FALSE else toggle:=TRUE;
end;

procedure pofido;
var fidorf:file of fidorec;
    c:char;
    cc:integer;
    s:string[27];
    abort,next,done,changed:boolean;
begin
  done:=FALSE;
  repeat
    with fidor do begin
      cls;
      sprint(#3#5+'INSANEnet configuration');
      nl;
      abort:=FALSE; next:=FALSE;
      s:=cstr(zone)+':'+cstr(net)+'/'+cstr(node)+'.'+cstr(point);
      printacr('^3INSANEnet address     ^4 ^5'+clasicnode,abort,next);
      printacr('^0A. ^3Origin line        ^4 ^5"'+origin+'"',abort,next);
      printacr('^0B. ^3Net callout string ^4 ^5'+systat.netcall,abort,next);
      printacr('^0C. ^3Use HSlink for net ^4 ^5'+onoff(systat.hslinknetcall),abort,next);
      nl;
      prt('^3Enter selection [A-C,1-4] [Q]uit ^4 ^5');
      onek(c,'QABC'^M);
      nl;
      case c of
        'Q':done:=TRUE;
        'A':begin
              sprint('^3Enter new origin line');
              prt('^4 ^5'); mpl(50); inputwn(origin,50,changed);
            end;
        'B':newmodemstring(systat.netcall,'net callout',80);
        'C':begin
              sprint('^8Note: ^3You should ^8NOT ^3use HSlink if you are going to be using HST');
              systat.hslinknetcall:=pynq('Use HSlink for netcalls?  [No] ');
            end;
      end;
    end;
  until ((done) or (hangup));
  assign(fidorf,systat.gfilepath+'FIDONET.DAT');
  reset(fidorf);
  seek(fidorf,0);
  write(fidorf,fidor);
  close(fidorf);
end;

end.
