(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2H .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "H" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2h;

interface

uses
  crt, dos, overlay,
  common;

procedure pomisc1;

implementation

procedure pomisc1;
var c:char;
    abort,next,done,changed:boolean;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'Miscellaneous configuration');
      nl;
      abort:=FALSE;                                
      printacr('^0A. ^3System start-out menu        ^4 ^5'+allstartmenu,abort,next);
      printacr('^0B. ^3SysOp chat color-filter      ^4 ^5'+chatcfilter1,abort,next);
      printacr('^0C. ^3User chat color-filter       ^4 ^5'+chatcfilter2,abort,next);
      printacr('^0D. ^3Default bulletin prefix file ^4 ^5'+bulletprefix,abort,next);
      nl;
      prt('^3Enter selection [A-D] [Q]uit ^4 ^5'); onek(c,'QABCD'^M);
      nl;
      case c of
        'Q':done:=TRUE;
        'A'..'D':begin
                   sprint('^3Enter new ^4 ^5');
                   case c of
                     'A':inputwn(allstartmenu,8,changed);
                     'B':inputwn(chatcfilter1,12,changed);
                     'C':inputwn(chatcfilter2,12,changed);
                     'D':inputwn(bulletprefix,8,changed);
                   end;
                 end;
      end;
    end;
  until ((done) or (hangup));
end;

end.
