(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2F .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "F" command.           <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2f;

interface

uses
  crt, dos, overlay,
  sysop2fa,
  common;

procedure pofilesconfig;

implementation

procedure pofilesconfig;
var s:string[80];
    i:integer;
    c:char;
    b:byte;
    abort,next,done,changed:boolean;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'File section configuration');
      nl;
      abort:=FALSE;
      printacr('^1A. ^3Archive configuration',abort,next);
      printacr('^1B. ^3Upload/download ratio           ^4 ^5'+aonoff(uldlratio,'Active','In-active'),abort,next);
      printacr('^1C. ^3Auto file point compensation    ^4 ^5'+aonoff(fileptratio,'Active','In-active'),abort,next);
      printacr('^1D. ^3File point compensation ratio   ^4 ^5'+cstr(fileptcomp)+' to 1',abort,next);
      printacr('^1E. ^3Base file size per 1 file point ^4 ^5'+cstr(fileptcompbasesize)+'k',abort,next);
      printacr('^1F. ^3Upload time refund percent      ^4 ^5'+cstr(ulrefund)+'%',abort,next);
      s:='^1G. ^3"To-SysOp" file base            ^4 ^5';
      if (tosysopdir=255) then s:=s+'*None*' else s:=s+cstr(tosysopdir);
      printacr(s,abort,next);
      printacr('^1H. ^3Auto-validate ALL files ULed?   ^4 ^5'+syn(validateallfiles),abort,next);
      printacr('^1I. ^3Remote DOS re-direction device  ^4 ^5'+systat.remdevice,abort,next);
      printacr('^1J. ^3Max k-bytes allowed in TEMP\3\  ^4 ^5'+cstr(systat.maxintemp),abort,next);
      printacr('^1K. ^3Min k-bytes to save for resume  ^4 ^5'+cstr(systat.minresume),abort,next);
      printacr('^1L. ^3File point commision amount     ^4 ^5'+cstr(systat.commamount),abort,next);
      printacr('^5        ---- PrISM AutoValidation Point Assignments ----',abort,next);
      printacr('^1N. ^3Points to - if name in trashcan      ^4 ^5'+cstr(systat.trashpt),abort,next);
      printacr('^1O. ^3Points to + if name NOT in trashcan  ^4 ^5'+cstr(systat.trashptclr),abort,next);
      printacr('^1P. ^3Points to + if references are found  ^4 ^5'+cstr(systat.refpt),abort,next);
      printacr('^1R. ^3Points to + if >= default age        ^4 ^5'+cstr(systat.agept),abort,next);
      printacr('^1S. ^3User''s age >= to this age            ^4 ^5'+cstr(systat.defage),abort,next); 
      printacr('^1T. ^3Points to + if user is calling LD    ^4 ^5'+cstr(systat.ldpt),abort,next);
      printacr('^1U. ^3Points to + if user is calling local ^4 ^5'+cstr(systat.localpt),abort,next);
      printacr('^1V. ^3Points to + if baud is 2400          ^4 ^5'+cstr(systat.tfpt),abort,next);
      printacr('^1W. ^3Points to + if baud is 9600          ^4 ^5'+cstr(systat.nspt),abort,next);
      printacr('^1X. ^3Points to + if baud is 14.4          ^4 ^5'+cstr(systat.fpfpt),abort,next);
      printacr('^1Y. ^3Points to + if baud is 38.4          ^4 ^5'+cstr(systat.tepfpt),abort,next);
      printacr('^1Z. ^3Total points to equal up to          ^4 ^5'+cstr(systat.totpt),abort,next);
      nl;
      prt('^3Enter selection [A-Z] [Q]uit ^4 ^5'); onek(c,'QABCDEFGHIJKLNOPQRSTUVWXYZ'^M);
      nl;
      case c of
        'Q':done:=TRUE;
        'A':poarcconfig;
        'B':uldlratio:=not uldlratio;
        'C':fileptratio:=not fileptratio;
        'D'..'G':begin
              if (c<>'G') then prt('Range [0-255]') else
                prt('Range [0-'+cstr(maxulb)+']  [255 to disable]');
              nl; prt('^3New value ^4 ^5'); mpl(3); ini(b);
              if (not badini) then
                case c of
                  'D':fileptcomp:=b;
                  'E':fileptcompbasesize:=b;
                  'F':ulrefund:=b;
                  'G':if ((b>=0) and (b<=maxulb)) or (b=255) then
                        tosysopdir:=b;
                end;
            end;
        'H':validateallfiles:=not validateallfiles;
        'I':begin
              sprint(#3#5+'This should be "GATE1" (or "GATE2", etc) if you have it.');
              sprint(#3#5+'OTHERWISE, it should be "COM1" (or "COM2", etc).');
              nl;
              prt('^3New device ^4 ^5'); mpl(10);
              inputwn(remdevice,10,changed);
            end;
        'J':begin
              prt('^3New max k-bytes ^4 ^5'); inu(i);
              if (not badini) then systat.maxintemp:=i;
            end;
        'K':begin
              prt('^3New min resume k-bytes ^4 ^5'); inu(i);
              if (not badini) then systat.minresume:=i;
            end;
        'L':begin
              prt('^3New File Point Commision Amount ^4 ^5'); inu(i);
              if (not badini) then systat.commamount:=i;
            end;
        'N':begin
              sprint('This many points will be SUBTRACTED when user''s name is found in trashcan.');
              nl;
              prt('^3New points ^4 ^5');
              ini(b);
              if not badini then systat.trashpt:=b;
            end;
        'O':begin
              sprint('This many points will be awarded when user clears trashcan with OK.');
              nl;
              prt('^3New points ^4 ^5');
              ini(b);
              if not badini then systat.trashptclr:=b;
              
            end;
        'P':begin
              sprint('This many points will awarded PER reference found in reference string.');
              nl;
              prt('^3New points ^4 ^5');
              ini(b);
              if not badini then systat.refpt:=b;
            
            end;
        'R':begin
              sprint('This many points will be awarded if age checks OK.');
              nl;
              prt('^3New points ^4 ^5');
              ini(b);
              if not badini then systat.agept:=b;
            
            end;
        'S':begin
              sprint('The user''s age will be checked against this age to determine if the user');
              sprint('qualifies for the age requirement points in auto-validation.');
              nl;
              prt('^3New default age ^4 ^5');
              ini(b);
              if not badini then systat.defage:=b;
            
            end;
        'T':begin
              sprint('This many points is awarded if user is calling LD.');
              nl;
              prt('^3New points ^4 ^5');
              ini(b);
              if not badini then systat.ldpt:=b;
            
            end;
        'U':begin
              sprint('This many points (if any) is awarded if user is calling local.');
              nl;
              prt('^3New points ^4 ^5');
              ini(b);
              if not badini then systat.localpt:=b;
            
            end;
        'V':begin
              prt('^3New points ^4 ^5');
              ini(b);
              if not badini then systat.tfpt:=b;
            
            end;
        'W':begin
              prt('^3New points ^4 ^5');
              ini(b);
              if not badini then systat.nspt:=b;
            
            end;
        'X':begin
              prt('^3New points ^4 ^5');
              ini(b);
              if not badini then systat.fpfpt:=b;
            
            end;
        'Y':begin
              prt('^3New points ^4 ^5');
              ini(b);
              if not badini then systat.tepfpt:=b;
            
            end;
        'Z':begin
              sprint('WARNING!  The default points have been calculated and tested.');
              sprint('  When changing point values, PLEASE be sure to test out ALL');
              sprint('  possibilties, so that you don''t delete a deserving user.');
              nl;
              prt('^3New total points ^4 ^5');
              ini(b);
              if not badini then systat.totpt:=b;
            
            end;
        end;
    end;
  until (done) or (hangup);
end;

end.
