(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2E .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "E" command.           <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2e;

interface

uses
  crt, dos, overlay,
  common;

procedure poflagfunc;

implementation

function sltype(i:integer):string;
begin
  case i of
    0:sltype:='File only';
    1:sltype:='Printer & File';
    2:sltype:='Printer only';
  end;
end;

procedure poflagfunc;
var s:string[80];
    c,cc:char;
    nuu,i:integer;
    abort,next,done:boolean;
    bbb:byte;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'System flagged functions');
      nl;
      abort:=FALSE; next:=FALSE;
      printacr('^1A. ^3Special effects           ^4 ^5'+onoff(specialfx)+
             '^1  B. ^3Use FOSSIL comm driver     ^4 ^5'+onoff(fossil),abort,next);
      printacr('^1C. ^3Handles allowed on system ^4 ^5'+onoff(allowalias)+
             '^1  D. ^3Phone number in logon      ^4 ^5'+onoff(phonepw),abort,next);
      printacr('^1E. ^3Local security protection ^4 ^5'+onoff(localsec)+
             '^1  F. ^3Local screen security      ^4 ^5'+onoff(localscreensec),abort,next);
      printacr('^1G. ^3Global activity trapping  ^4 ^5'+onoff(globaltrap)+
             '^1  H. ^3Auto chat buffer open      ^4 ^5'+onoff(autochatopen),abort,next);
      printacr('^1I. ^3AutoMessage in logon      ^4 ^5'+onoff(autominlogon)+
             '^1  J. ^3Bulletins in logon         ^4 ^5'+onoff(bullinlogon),abort,next);
      printacr('^1K. ^3Last few callers in logon ^4 ^5'+onoff(lcallinlogon)+
             '^1  L. ^3"Your info" in logon       ^4 ^5'+onoff(yourinfoinlogon),abort,next);
      printacr('^1M. ^3BBS is multi-tasking      ^4 ^5'+onoff(multitask)+
             '^1  N. ^3Offhook in local logon     ^4 ^5'+onoff(offhooklocallogon),abort,next);
      printacr('^1O. ^3Mandatory voting          ^4 ^5'+onoff(forcevoting)+
             '^1  P. ^3Compress file/msg numbers  ^4 ^5'+onoff(compressbases),abort,next);
      printacr('^1R. ^3UL duplicate file search  ^4 ^5'+onoff(searchdup)+
             '^1  S. ^3SysOp Log type             ^4 ^5'+sltype(slogtype),abort,next);
      printacr('^1T. ^3Strip color off SysOp log ^4 ^5'+onoff(stripclog)+
             '^1  U. ^3Use WFC menu logo          ^4 ^5'+onoff(usewfclogo),abort,next);
      printacr('^1V. ^3Use BIOS for video output ^4 ^5'+onoff(usebios)+
             '^1  W. ^3Suppress snow on CGA       ^4 ^5'+onoff(cgasnow),abort,next);
      printacr('^1X. ^3Use EMS for overlay file  ^4 ^5'+onoff(useems)+
             '^1  Y. ^3Reboot recovery on error   ^4 ^5'+onoff(rebootrecovery),abort,next);
      printacr('^1Z. ^3Scan all drives in WFC    ^4 ^5'+onoff(scanalldrives),abort,next);

      printacr('',abort,next);
      s:='^11. ^3New user message sent to  ^4 ^5';
      if (newapp=-1) then s:=s+'Off' else s:=s+mn(newapp,3);
      s:=s+'^1  2. ^3Guest user number          ^4 ^5';
      if (guestuser=-1) then s:=s+'Off' else s:=s+mn(guestuser,3);
      printacr(s,abort,next);
      s:='^13. ^3Mins before timeout bell  ^4 ^5';
      if (timeoutbell=-1) then s:=s+'Off' else s:=s+mn(timeoutbell,3);
      s:=s+'  ^14. ^3Mins before timeout        ^4 ^5';
      if (timeout=-1) then s:=s+'Off' else s:=s+mn(timeout,3);
      printacr(s,abort,next);
      printacr('^15. ^3Challenge-Response Auth   ^4 ^5'+onoff(cras)+
             '^1  6. ^3LOGON.BAT/LOGOFF.BAT       ^4 ^5'+onoff(logonenable),abort,next);

      nl;
      prt('^3Enter selection (A-Z,1-6) [Q]uit ^4 ^5');
      onek(c,'QABCDEFGHIJKLMNOPRSTUVWXYZ123456'^M); nl;

      case c of
        'Q':done:=TRUE;
        'A':specialfx:=not specialfx;
        'B':begin
              remove_port;
              fossil:=not fossil;
              iport;
            end;
	'C':allowalias:=not allowalias;
        'D':phonepw:=not phonepw;
        'E':localsec:=not localsec;
        'F':localscreensec:=not localscreensec;
        'G':globaltrap:=not globaltrap;
        'H':autochatopen:=not autochatopen;
        'I':autominlogon:=not autominlogon;
        'J':bullinlogon:=not bullinlogon;
        'K':lcallinlogon:=not lcallinlogon;
        'L':yourinfoinlogon:=not yourinfoinlogon;
        'M':multitask:=not multitask;
        'N':offhooklocallogon:=not offhooklocallogon;
        'O':forcevoting:=not forcevoting;
        'P':begin
              compressbases:=not compressbases;
              nl;
              if (compressbases) then print(' ^4 ^5Compressing bases...')
                else print(' ^4 ^5De-compressing bases...');
              newcomptables;
            end;
	'R':searchdup:=not searchdup;
        'S':begin
              sprint('^3Current SysOp Log type ^4 ^5'+sltype(slogtype));
              nl;
              for i:=0 to 2 do sprint('^3'+cstr(i)+' ^4 ^5'+sltype(i));
              nl;
              prt('^3New type ^4 ^5'); ini(bbb);
              if ((not badini) and (bbb in [0..2])) then slogtype:=bbb;
            end;
        'T':stripclog:=not stripclog;
        'U':usewfclogo:=not usewfclogo;
        'V':begin
              usebios:=not usebios;
              directvideo:=not usebios;
            end;
        'W':begin
              cgasnow:=not cgasnow;
              checksnow:=cgasnow;
            end;
	'X':useems:=not useems;
        'Y':rebootrecovery:=not rebootrecovery;
	'Z':scanalldrives:=not scanalldrives;
        '5':cras:=not cras;
        '6':logonenable:=not logonenable;
        '1'..'4':
          begin
            prt('[E]nable [D]isable this function: ');
            onek(cc,'Q ED'^M);
            if cc in ['E','D'] then begin
              badini:=FALSE;
              case cc of
                'D':i:=-1;
                'E':begin
                      prt('^3Range ^4 ^5');
                      case c of
                        '1','2':begin
                             reset(uf); nuu:=filesize(uf)-1; close(uf);
                             prt('[1-'+cstr(nuu)+']');
                           end;
                        '3','4':prt('[1-20]');
                      else
                           prt('[0-32767]');
                      end;
                      nl; prt('^3Enter value for this function ^4 ^5');
                      inu(i);
                    end;
              end;
              if (not badini) then
                case c of
                  '1':if ((i>=1) and (i<=nuu)) or (cc='D') then newapp:=i;
                  '2':if ((i>=1) and (i<=nuu)) or (cc='D') then guestuser:=i;
                  '3':if ((i>=1) and (i<=20)) or (cc='D') then timeoutbell:=i;
                  '4':if ((i>=1) and (i<=20)) or (cc='D') then timeout:=i;
                end;
            end
            else print('No change.');
          end;
      end;
    end;
  until (done) or (hangup);
end;

end.
