(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2D .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "D" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2d;

interface

uses
  crt, dos, overlay,
  common;

procedure pogenvar;

implementation

procedure pogenvar;
var c:char;
    i:integer;
    bbb:byte;
    abort,next,done:boolean;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'System variables');
      nl;
      abort:=FALSE; next:=FALSE;
      printacr('^1A. ^3Max private sent per call ^4 ^5'+mn(maxprivpost,3)+
        '^1  B. ^3Max feedback sent per call ^4 ^5'+mn(maxfback,3),abort,next);
      printacr('^1C. ^3Max public posts per call ^4 ^5'+mn(maxpubpost,3)+
        '^1  D. ^3Max chat attempts per call ^4 ^5'+mn(maxchat,3),abort,next);
      printacr('^1E. ^3Normal max mail waiting   ^4 ^5'+mn(maxwaiting,3)+
        '^1  F. ^3CoSysOp max mail waiting   ^4 ^5'+mn(csmaxwaiting,3),abort,next);
      printacr('^1G. ^3Normal max lines/message  ^4 ^5'+mn(maxlines,3)+
        '^1  H. ^3CoSysOp max lines/message  ^4 ^5'+mn(csmaxlines,3),abort,next);
      printacr('^1I. ^3Number of logon attempts  ^4 ^5'+mn(maxlogontries,3)+
        '^1  J. ^3Backspace delay            ^4 ^5'+mn(bsdelay,3),abort,next);
      printacr('^1K. ^3SysOp chat color          ^4 ^5'+mn(sysopcolor,3)+
        '^1  L. ^3User chat color            ^4 ^5'+mn(usercolor,3),abort,next);
      printacr('^1M. ^3Min. space for posts      ^4 ^5'+mn(minspaceforpost,4)+
        '^1 N. ^3Min. space for uploads     ^4 ^5'+mn(minspaceforupload,4),abort,next);
      printacr('^1O. ^3Back SysOp Log keep days  ^4 ^5'+mn(backsysoplogs,3)+
        '^1  P. ^3Blank WFC menu minutes     ^4 ^5'+mn(wfcblanktime,4),abort,next);
      printacr('^1R. ^3Default video line length ^4 ^5'+mn(linelen,3)+
	'^1  S. ^3Default video page length  ^4 ^5'+mn(pagelen,3),abort,next);
      printacr('^1T. ^3Yes votes required in NUV ^4 ^5'+mn(nuvyes,3)+
	'^1  U. ^3No votes required in NUV   ^4 ^5'+mn(nuvno,3),abort,next);
      printacr('^1V. ^3Min words to count msg    ^4 ^5'+mn(minwpm,3)+
	'^1  W. ^3Minutes between net calls  ^4 ^5'+mn(betweenet,3),abort,next);
      printacr('^1X. ^3Net call attempts         ^4 ^5'+mn(netattempt,3)+
	'^1  Y. ^3Dials per net call attempt ^4 ^5'+mn(nettriesperattempt,3),abort,next);
      nl;
      prt('^3Enter selection [A-Y] [Q]uit ^4 ^5');
      onek(c,'QABCDEFGHIJKLMNOPRSTUVWXY'^M); nl;

      case c of
	'Q':done:=TRUE;
	'A'..'P','R'..'Y':
	  begin
	    prt('Range ');
	    case c of
	      'G','H':prt('[1-160]');
	      'K','L':prt('[0-9]');
	      'M','N':prt('[0-32767]');
              'O':prt('[1-99]');
              'R':prt('[32-132]');
              'S':prt('[4-50]');
	      'T':prt('[1-80]');
	      'U':prt('[1-80]');
	    else
		  prt('[0-255]');
            end;
            nl; prt('^3New value ^4 ^5');
	    case c of
              'M','N':inu(i);
            else
                 ini(bbb);
            end;
            if (not badini) then
              case c of
		'A':maxprivpost:=bbb;
		'B':maxfback:=bbb;
		'C':maxpubpost:=bbb;
		'D':maxchat:=bbb;
		'E':maxwaiting:=bbb;
		'F':csmaxwaiting:=bbb;
		'G':if (bbb in [1..160]) then maxlines:=bbb;
		'H':if (bbb in [1..160]) then csmaxlines:=bbb;
		'I':maxlogontries:=bbb;
		'J':bsdelay:=bbb;
		'K':if (bbb in [0..9]) then sysopcolor:=bbb;
		'L':if (bbb in [0..9]) then usercolor:=bbb;
		'M':if (i>0) then minspaceforpost:=i;
		'N':if (i>0) then minspaceforupload:=i;
		'O':if (bbb in [1..99]) then backsysoplogs:=bbb;
		'P':if (bbb in [0..255]) then wfcblanktime:=bbb;
		'R':if (bbb in [32..132]) then linelen:=bbb;
		'S':if (bbb in [4..50]) then pagelen:=bbb;
		'T':nuvyes:=bbb;
		'U':nuvno:=bbb;
		'V':minwpm:=bbb;
		'W':betweenet:=bbb;
		'X':netattempt:=bbb;
		'Y':nettriesperattempt:=bbb;
	      end;
	  end;
      end;
    end;
  until (done) or (hangup);
end;

end.
