(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2C .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "C" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2c;

interface

uses
  crt, dos, overlay,
  common;

procedure poslsettings;

implementation

function qq(s:string):string;
var ss:string[22];
begin
  ss:='"'+s+'"';
  if (length(ss)<14) then ss:=mln(ss,14);
  qq:=ss;
end;

procedure poslsettings;
var s:acstring;
    c:char;
    abort,next,done:boolean;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'System ACS settings');
      nl;
      abort:=FALSE; next:=FALSE;
      printacr('^1A. ^3Full SysOp          ^4 ^5'+qq(sop)+
               '^1B. ^3Full Co-SysOp       ^4 ^5'+qq(csop),abort,next);
      printacr('^1C. ^3Message base SysOp  ^4 ^5'+qq(msop)+
               '^1D. ^3File base SysOp     ^4 ^5'+qq(fsop),abort,next);
      printacr('^1E. ^3SysOp PW at logon   ^4 ^5'+qq(spw)+
               '^1F. ^3See PW''s remotely   ^4 ^5'+qq(seepw),abort,next);
      printacr('^1G. ^3Post public         ^4 ^5'+qq(normpubpost)+
               '^1H. ^3Send e-mail         ^4 ^5'+qq(normprivpost),abort,next);
      printacr('^1I. ^3See anon pub post   ^4 ^5'+qq(anonpubread)+
               '^1J. ^3See anon E-mail     ^4 ^5'+qq(anonprivread),abort,next);
      printacr('^1K. ^3Post anon ANY base  ^4 ^5'+qq(anonpubpost)+
               '^1L. ^3E-mail anon         ^4 ^5'+qq(anonprivpost),abort,next);
      printacr('^1M. ^3See unval. files    ^4 ^5'+qq(seeunval)+
               '^1N. ^3DL unval. files     ^4 ^5'+qq(dlunval),abort,next);
      printacr('^1O. ^3No UL/DL ratio      ^4 ^5'+qq(nodlratio)+
               '^1P. ^3No post/call ratio  ^4 ^5'+qq(nopostratio),abort,next);
      printacr('^1R. ^3No file pt checking ^4 ^5'+qq(nofilepts)+
               '^1S. ^3ULs auto-credited   ^4 ^5'+qq(ulvalreq),abort,next);
      nl;
      prt('^3Enter selection [A-S] [Q]uit ^4 ^5');
      onek(c,'QABCDEFGHIJKLMNOPRS'^M);

      if (c='Q') then done:=TRUE;

      nl;
      if (not done) then
        if (c in ['A'..'P','R'..'S']) then begin
          prt('^3New ACS ^4 ^5'); inputl(s,20);
          if (s<>'') then
            case c of
              'A':sop:=s;           'B':csop:=s;
              'C':msop:=s;          'D':fsop:=s;
              'E':spw:=s;           'F':seepw:=s;
              'G':normpubpost:=s;   'H':normprivpost:=s;
              'I':anonpubread:=s;   'J':anonprivread:=s;
              'K':anonpubpost:=s;   'L':anonprivpost:=s;
              'M':seeunval:=s;      'N':dlunval:=s;
              'O':nodlratio:=s;     'P':nopostratio:=s;
              'R':nofilepts:=s;     'S':ulvalreq:=s;
            end;
        end;
    end;
  until (done) or (hangup);
end;

end.
