(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2B .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "B" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2b;

interface

uses
  crt, dos, overlay, sysop2a,
  sysop3,
  common;

procedure pofile;

implementation

const
  aresure='Are you sure this is what you want? ';

function wantit:boolean;
begin
  nl; wantit:=pynq(aresure);
end;

procedure noch;
begin
  print('No change.');
end;

function phours(s:astr; lotime,hitime:integer):astr;
begin
  if (lotime<>hitime) then
    phours:=tch(cstr(lotime div 60))+':'+tch(cstr(lotime mod 60))+'...'+
            tch(cstr(hitime div 60))+':'+tch(cstr(hitime mod 60))
  else
    phours:=s;
end;

procedure gettimerange(s:astr; var st1,st2:integer);
var t1,t2,t1h,t1m,t2h,t2m:integer;
begin
  if pynq(s) then begin
    nl; nl;
    print('All entries in 24 hour time.  Hour: (0-23), Minute: (0-59)');
    nl;
    prompt('Starting time:');
    prt('  ^3Hour   ^4 '); mpl(5); inu(t1h);
    if (t1h<0) or (t1h>23) then t1h:=0;
    prt('                ^3Minute ^4 '); mpl(5); inu(t1m);
    if (t1m<0) or (t1m>59) then t1m:=0;
    nl;
    prompt('Ending time:  ');
    prt('  ^3Hour   ^4 '); mpl(5); inu(t2h);
    if (t2h<0) or (t2h>23) then t2h:=0;
    prt('                ^3Minute ^4 '); mpl(5); inu(t2m);
    if (t2m<0) or (t2m>59) then t2m:=0;
    t1:=t1h*60+t1m; t2:=t2h*60+t2m;
  end
  else begin t1:=0; t2:=0; end;
  nl;
  prompt('Hours: '+phours('Undeclared',t1,t2));
  if (wantit) then begin
    st1:=t1;
    st2:=t2;
  end;
end;

procedure pofile;
var s:string[80];
    i:integer;
    c:char;
    abort,next,done:boolean;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'BBS configuration and file paths');
      nl;
      abort:=FALSE;
      printacr('^1A. ^3BBS name & number   ^4 ^5'+bbsname+#3#3+' ['+bbsphone+']',abort,next);
      printacr('^1B. ^3SysOp''s name/alias  ^4 ^5'+mln(sysopname+'',15)+
               '^1P. ^3Use Chrome Bars     ^4 ^5'+aonoff(chrome,'Yes','No'),abort,next);
      printacr('^1C. ^3SysOp chat hours    ^4 ^5'+mln(phours('*None*',lowtime,hitime),15)+
               '^1G. ^3300 baud hours      ^4 ^5'+phours('Always allowed',b300lowtime,b300hitime),abort,next);
      printacr('^1D. ^3Regular DL hours    ^4 ^5'+mln(phours('Always allowed',dllowtime,dlhitime),15)+
               '^1H. ^3300 baud DL hours   ^4 ^5'+phours('Always allowed',b300dllowtime,b300dlhitime),abort,next);
      printacr('^1E. ^3Matrix Logon is     ^4 ^5'+mln(aonoff(shuttlelog,'Active','In-active'),15)+
               '^1I. ^3New users are       ^4 ^5'+aonoff(closedsystem,'Rejected','Accepted'),abort,next);
      printacr('^1!. ^3LOCKOUT BAUDS                        '+
               '^1J. ^3Swap shell function ^4 ^5'+aonoff(swapshell,'Active','In-active'),abort,next);
      printacr('^1F. ^3BBS Passwords                        '+
               '^1K. ^3Pre-event warning   ^4 ^5'+cstr(eventwarningtime)+' seconds',abort,next);
      printacr('^1L. ^3PrISM System is     ^4 ^5'+mln(aonoff(useprism,'Active','In-active'),15)+
	       '^1M. ^3Use DOS Simulator   ^4 ^5'+aonoff(dossim,'Active','In-active'),abort,next);
      printacr('^1N. ^3Chance PrISM chat   ^4 ^5'+mln(cstr(prismchance)+'% chance',15)+
	       '^1O. ^3Use SoundBlaster    ^4 ^5'+aonoff(sb,'Yes','No'),abort,next);
      printacr('^1S. ^3Use Spinning Cursor ^4 ^5'+aonoff(spincur,'Yes','No'),abort,next);
      printacr('^1T. ^3Use Pulldown Matrix ^4 ^5'+aonoff(pulls,'Yes','No'),abort,next);
      {printacr('U. Net Call Out String:'+netcall,abort,next);}
      printacr('^1U. ^3Lockout baud PW     ^4 ^5'+lockoutpass,abort,next);
      printacr('^1V. ^3New user voting is  ^4 ^5'+aonoff(usenuv,'Active','In-active'),abort,next);
      printacr(' ^10. ^3Swap shell directory     ^4 ^5"'+swappath+'"',abort,next);
      printacr(' ^11. ^3Main data files dir.     ^4 ^5"'+gfilepath+'"',abort,next);
      printacr(' ^12. ^3Alternate text file dir. ^4 ^5"'+afilepath+'"',abort,next);
      printacr(' ^13. ^3Priv/pub msgs directory  ^4 ^5"'+msgpath+'"',abort,next);
      printacr(' ^14. ^3Menu file directory      ^4 ^5"'+menupath+'"',abort,next);
      printacr(' ^15. ^3Text-file section dir.   ^4 ^5"'+tfilepath+'"',abort,next);
      printacr(' ^16. ^3Trap/log/chat directory  ^4 ^5"'+trappath+'"',abort,next);
      printacr(' ^17. ^3Temporary directory      ^4 ^5"'+temppath+'"',abort,next);
      printacr(' ^18. ^3Soundblaster directory   ^4 ^5"'+soundpath+'"',abort,next);
      printacr(' ^1-. ^3Last text-file edit date ^4 ^5'+tfiledate,abort,next);
(*      printacr(' 9. High message pointer: (A):'+hmsg.ltr+' (B):'+cstr(hmsg.number)+' (C):'+cstr(hmsg.ext),abort,next);*)
      nl;
      prt('Enter selection (A-V,!,-,1-8) [Q]uit : ');
      onek(c,'QABCDEFGHIJKLMNOPSTUV!012345678-'); nl;
      case c of
        'Q':done:=TRUE;
        'A':begin
              print('New BBS name:');
              prt('^4 ^5'); inputwc(s,80);
              if (s<>'') then bbsname:=s else noch;
              nl;
              print('New BBS phone number, entered in the following format:');
              print(' ###-###-####');
              prt('^4 ^5'); mpl(12); input(s,12);
              if (s<>'') then bbsphone:=s else noch;
            end;
        'B':begin
              prt('^3New SysOp name ^4 ^5'); mpl(30); inputl(s,30);
              if (s<>'') then sysopname:=s else noch;
            end;
        'C':if (incom) then
              sprint(#3#7+'This can only be changed locally.')
            else
              gettimerange('Do you want to declare sysop hours? ',
                            lowtime,hitime);
        'D':gettimerange('Do you want to declare download hours? ',
                          dllowtime,dlhitime);
        'E':begin
              shuttlelog:=pynq('Should Shuttle Logon be activated? [No] ');
              if shuttlelog then begin
                pulls:=FALSE;
                dossim:=FALSE;
              end;
            end;
        '!':begin
              sprint(#3#5+'If callers are locked out by baud rate, NO300.MSG/NO1200.MSG/NO2400.MSG');
              sprint(#3#5+'will be printed each time a 300, 1200, or 2400 baud caller connects,');
              sprint(#3#5+'and the user will be hung up.');
              nl;
              sprint('300 baud lockout  :'+aonoff(lock300,'Yes','No'));
              sprint('1200 baud lockout :'+aonoff(lock1200,'Yes','No'));
              sprint('2400 baud lockout :'+aonoff(lock2400,'Yes','No'));
              nl;
              lock300:=pynq('Should 300 baud callers be locked out? [No] ');
              lock1200:=pynq('Should 1200 baud callers be locked out? [No] ');
              lock2400:=pynq('Should 2400 baud callers be locked out? [No] ');
            end;
        'F':begin
              print('System Passwords');
              sprint('  ^1A. ^3SysOp password        ^4 ^5'+sysoppw);
              sprint('  ^1B. ^3New user password     ^4 ^5'+newuserpw);
              sprint('  ^1C. ^3Matrix Logon password ^4 ^5'+shuttlepw);
              (*
              print('  D. 300 baud lockout PW   :'+300pw);
              print('  E. 1200 baud lockout PW  :'+1200pw);
              print('  F. 2400 baud lockout PW  :'+2400pw);
              *)
              nl;
              prt('^3Change [A-C] ^4 ^5'); onek(c,'QABC'^M);
              if (c in ['A'..'C']) then begin
                case c of
                  'A':prt('^3New SysOp password ^4 ^5');
                  'B':prt('^3New new-user password ^4 ^5');
                  'C':prt('^3New Matrix Logon password ^4 ^5');
                  'D':prt('New 300 baud lockout password: ');
                  'E':prt('New 1200 baud lockout password: ');
                  'F':prt('New 2400 baud lockout password: ');
                end;
                mpl(20); input(s,20);
                nl; print('New password: "'+s+'"');
                if (wantit) then
                  case c of
                    'A':sysoppw:=s;
                    'B':newuserpw:=s;
                    'C':shuttlepw:=s;
                    (*
                    'D':300pw:=s;
                    'E':1200pw:=s;
                    'F':2400pw:=s;
                    *)
                  end;
              end;
            end;
        'G':gettimerange('Do you want to declare 300 baud hours? ',
                          b300lowtime,b300hitime);
        'H':gettimerange('Do you want to declare 300 baud download hours? ',
                          b300dllowtime,b300dlhitime);
        'I':closedsystem:=pynq('Should new users be REJECTED? [No] ');
        'J':swapshell:=pynq('Should the swap shell function be used? [No] ');
        'K':begin
              prt('New pre-event warning time ['+cstr(eventwarningtime)+'] : ');
              inu(i);
              if (not badini) then eventwarningtime:=i;
            end;
	'L':begin
	      useprism:=pynq('Use PrISM for auto-sysop functions? [No] ');
	      if(useprism) then begin
		usenuv:=FALSE;
	      end;
	    end;
        'M':begin
              dossim:=pynq('Use DOS Simulator instead of Matrix? [No] ');
              if dossim then begin
                pulls:=FALSE;
                shuttlelog:=FALSE;
              end;
            end;
        'N':begin
              prt('^3New % chance of PrISM chatting ^4 ^5');
              inu(i);
              if (not badini) and (i>=0) and (i<=100) then prismchance:=i;
            end;
        'O':sb:=pynq('Use SoundBlaster for Chat? (have CHATCALL.VOC in bbs dir) [No] ');
        'P':chrome:=pynq('Use Chrome bars for some headers? [No] ');
        {'R':fade:=pynq('Use Fading in Yes/No prompts? [No] ');}
        'S':spincur:=pynq('User Spinning Cursor for input? [No] ');
        'T':begin
              pulls:=pynq('Use Pulldown Matrix for logon? [No] ');
              if pulls then begin
                shuttlelog:=FALSE;
                dossim:=FALSE;
              end;
            end;
        'U':begin
              {newmodemstring(netcall,'net callout',80);}
              sprint('Password required to logon at locked out baud rate.');
              inputl(s,20);
              if s<>'' then lockoutpass:=s;
	    end;
	'V':begin
	      usenuv:=pynq('Use new user voting? [No] ');
	      if(usenuv) then begin
		 useprism:=FALSE;
	      end;
	    end;
        '0'..'8':begin
              prt('^3Enter new ');
              case c of
                '1':prt('GFILES');   '2':prt('AFILES');
                '3':prt('EMAIL');    '4':prt('MENUS');
                '5':prt('TFILES');   '6':prt('TRAP');
                '7':prt('TEMP');     '0':prt('SWAP');
                '8':prt('SOUNDBLASTER');
              end;
              prt(' path ^4 ^5');
              nl; mpl(79); input(s,79);
              if (s<>'') then begin
                if (copy(s,length(s),1)<>'\') then s:=s+'\';
                if (wantit) then
                  case c of
                    '1':gfilepath:=s;     '2':afilepath:=s;
                    '3':msgpath:=s;       '4':menupath:=s;
                    '5':tfilepath:=s;     '6':trappath:=s;
                    '7':temppath:=s;      '0':swappath:=s;
                    '8':soundpath:=s;
                  end;
              end
              else noch;
            end;
        '-':begin
              prt('^3Enter new date in the form "MM/DD/YY" ^4 ^5');
              nl; mpl(10); input(s,10);
              if (s='') or (copy(s,3,1)<>'/') or (copy(s,6,1)<>'/') then
                noch
              else
                tfiledate:=s;
            end;

(*        '9':begin
              sprint(#3#7+'!!!WARNING!!!'+#3#1);
              sprint(#3#5+'Do NOT use this command unless you know EXACTLY '+
                     'what you''re doing!!!');
              nl;
              prt('Change (A-C) [Q]uit :');
              onek(c,'QABC'^M);
              case c of
                'A':begin
                      prt('New letter (A-Z) :');
                      getkey(c); c:=upcase(c);
                      if (c in ['A'..'Z']) then hmsg.ltr:=c
                        else noch;
                    end;
                'B':begin
                      prt('New number (-32767-32768) :');
                      input(s,6); i:=value(s);
                      if ((i>=-32767) and (i<=32768)) then hmsg.number:=i
                        else noch;
                    end;
                'C':begin
                      prt('New extension (1-128) :');
                      inu(i);
                      if ((i>=1) and (i<=128)) then hmsg.ext:=i
                        else noch;
                    end;
                end;
            end;*)
      end;
    end;
  until (done) or (hangup);
end;

end.
