(*****************************************************************************)
(*>                                                                         <*)
(*>  Insanity Bulletin Board System - Copyright 1990,91,92 by               <*)
(*>  Raven and Robozapp - All rights reserved.                              <*)
(*>                                                                         <*)
(*>  Module name:       SYSOP2A.PAS                                         <*)
(*>  Module purpose:    System Configuration "A" command                    <*)
(*>                     (Modem Configuration)                               <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2a;

interface

uses
  crt, dos, overlay,
  cuser,
  common;

procedure pomodem;
procedure newmodemstring(var vs:astr;what:astr;len:integer);

implementation

const
  aresure='Are you sure this is what you want? [No] ';

function wantit:boolean;
begin
  nl; wantit:=pynq(aresure);
end;

procedure noch;
begin
  print('No change.');
end;

function showmodemstring(s:astr):astr;
var o:astr;
    i:integer;
begin
  o:='';
  for i:=1 to length(s) do
    case s[i] of
      ^@..^L,^N..^[:
         o:=o+'^'+chr(ord(s[i])+64);
      ^M:o:=o+'|';
    else
         o:=o+s[i];
    end;
  showmodemstring:=o;
end;

procedure newmodemstring(var vs:astr; what:astr; len:integer);
var i:integer;
    changed:boolean;
begin
  print('^3Current modem '+what+' string: ^4"^6'+showmodemstring(vs)+'^4"');
  nl;
  print('Use: "^" preceding control codes (^@..^[)');
  print('     "|" for a carriage return');
  print('     "~" for a half-second delay');
  nl;
  print('Enter NEW modem '+what+' string:');
  prt('^4 ^5');
  if (len>78) then mpl(78) else mpl(len);
  inputwn(vs,len,changed);
  if (changed) then begin
    for i:=1 to length(vs) do
      case vs[i] of
        '|':vs[i]:=^M;
        '^':if ((i<>length(vs)) and (vs[i+1] in ['@'..'['])) then begin
              vs[i]:=chr(ord(vs[i+1])-64);
              delete(vs,i+1,1);
            end;
      end;
  end else
    noch;
end;

(*
function whatflags:astr;
var s:string[64];
begin
  with modemr do begin
    if (ctschecking) then s:='CTS check ON, ' else s:='CTS check OFF, ';
    if (dsrchecking) then s:=s+'DSR check ON, ' else s:=s+'DSR check OFF, ';
    if (usexonxoff) then s:=s+'XON/XOFF ON, ' else s:=s+'XON/XOFF OFF, ';
    if (hardwired) then s:=s+'"Hard-wired" carrier' else s:=s+'Normal carrier';
  end;
  whatflags:=s;
end;
*)

procedure pomodem;
var modemrf:file of modemrec;
    s:string[80];
    i,c1,c2,cc:integer;
    c,ccc:char;
    abort,next,done:boolean;
begin
  done:=FALSE;
  repeat
    with modemr do begin
      cls;
      sprint(#3#5+'Modem configuration');
      nl;
      abort:=FALSE; next:=FALSE;
      printacr('^11. ^3Maximum baud rate     ^4 ^5'+cstrl(waitbaud),abort,next);
      printacr('^12. ^3COM port number       ^4 ^5'+cstr(comport),abort,next);
      printacr('^13. ^3Modem initialization string ^4 ^5',abort,next);
      printacr('   ^4"^5'+showmodemstring(init)+'^4"',abort,next);
      printacr('^14. ^3Modem answer string   ^4 ^5"'+showmodemstring(answer)+'"',abort,next);
      printacr('^15. ^3Modem hangup string   ^4 ^5"'+showmodemstring(hangup)+'"',abort,next);
      printacr('^16. ^3Modem offhook string  ^4 ^5"'+showmodemstring(offhook)+'"',abort,next);
      printacr('^17. ^3No-call init time     ^4 ^5'+cstr(nocallinittime),abort,next);
      printacr('^1A. ^39600 ARQ rate baud    ^4 ^5'+cstrl(arq9600rate)+' baud',abort,next);
(*
      printacr('F. Comm flags: '+whatflags,abort,next);
*)
      printacr('^1F. ^3Force baud rates?     ^4 ^5'+syn(not noforcerate),abort,next);
      printacr('^1R. ^3Modem result codes ^4:',abort,next);
      printacr('^1                     Case 1   Case 2 (ARQ)',abort,next);
      printacr('    ^1RA. ^3NO CARRIER  ^4 ^5'+cstr(nocarrier),abort,next);
      printacr('    ^1RB. ^3NO DIALTONE ^4 ^5'+cstr(nodialtone),abort,next);
      printacr('    ^1RC. ^3BUSY        ^4 ^5'+cstr(busy),abort,next);
      for i:=0 to 8 do begin
        case i of
          0:s:='  300'; 1:s:=' 1200'; 2:s:=' 2400';
          3:s:=' 4800'; 4:s:=' 7200'; 5:s:=' 9600';
          6:s:='12000'; 7:s:='14400'; 8:s:='16800';
        end;
        s:='    ^1R'+cstr(i+1)+'. ^3'+s+' BAUD  ^4 ^5'+
         mn(resultcode[1][i],3)+'      '+
         mn(resultcode[2][i],3);
        printacr(s,abort,next);
      end;
      nl;
      prt('^3Enter selection or [Q]uit ^4 ^5');
      onek(c,'Q1234567AFR'^M); nl;
      case c of
        '1':if (incom) then begin
              sprint(#3#7+'This can only be changed locally!!@M');
              pausescr;
            end else begin
              print('This is the baud rate that Insanity will use when waiting for calls');
              print('at the WFC menu.  This should be your modem''s MAXIMUM BAUD RATE.');
              nl;
              print('The current rate is: '+cstrl(waitbaud)+' baud.');
              nl;
              sprint('A:300 B:1200 C:2400 D:4800 E:9600 F:12000 G:19200 H:38400');
              sprint('I:57600');
              prt('^3Modem speed? [A-I] ^4 ^5'); onek(ccc,'QABCDEFGHI'^M);
              if (ccc in ['A'..'I']) then
                case ccc of
                  'A':waitbaud:=300;
                  'B':waitbaud:=1200;
                  'C':waitbaud:=2400;
                  'D':waitbaud:=4800;
                  'E':waitbaud:=9600;
                  'F':waitbaud:=12000;
                  'G':waitbaud:=19200;
                  'H':waitbaud:=38400;
                  'I':waitbaud:=57600;
                end;
            end;
        '2':if (incom) then begin
              sprint(#3#7+'This can only be changed locally!!@M');
              pausescr;
            end else begin
              prt('^3Com port (1-4) ^4 ^5'); inu(cc);
              if (cc in [1..4]) then
                if (wantit) then begin
                  remove_port;
                  comport:=cc;
                  iport;
                end
                else noch;
            end;
        '3':newmodemstring(init,'init',80);
        '4':newmodemstring(answer,'answer',40);
        '5':newmodemstring(hangup,'hangup',40);
        '6':newmodemstring(offhook,'offhook',40);
        '7':begin
              prt('^3No call modem re-initialization ^4 ^5'); inu(c1);
              if (not badini) then nocallinittime:=c1;
            end;
        'A':begin
              print('This is the baud rate Insanity will USE between Insanity and your');
              print('modem when a 9600 ARQ result code is received.  Note that in most');
              print('9600+ modems, the rate is 19,200 baud.  Some even newer modems');
              print('support 38,400 baud.  OLDER modems (very old ones) only support 9600');
              print('baud.  CONSULT YOUR MODEM MANUAL, and make the best choice!');
              nl;
              print('The current rate is: '+cstrl(arq9600rate)+' baud.');
              nl;
              print('Valid SUPPORTED rates are 9600, 19200, 38400, and 57600 bauds.');
              nl;
              prt('^3[A] 9600  [B] 19200  [C] 38400  [D] 57600 or [Q]uit ^4 ^5');
              onek(ccc,'QABCD'^M);
              if (ccc in ['A'..'D']) then
                case ccc of
                  'A':arq9600rate:=9600;
                  'B':arq9600rate:=19200;
                  'C':arq9600rate:=38400;
                  'D':arq9600rate:=57600;
                end;
            end;
(*
        'F':begin
              print('These are communications flags used by Insanity.');
              print('Do NOT change them unless you are having problems with');
              print('your *current* setup, and you KNOW what you are doing!');
              nl;
              print('Current flag setup: '+whatflags);
              nl;
              print('[C]TS checking, [D]SR checking,');
              print('[X]ON/XOFF, [H]ard-wired carrier');
              nl;
              prt('^3Which flag ^4 ^5'); onek(c,'QCDHX'^M);
              case c of
                'C':ctschecking:=not ctschecking;
                'D':dsrchecking:=not dsrchecking;
                'H':hardwired:=not hardwired;
                'X':usexonxoff:=not usexonxoff;
              end;
              c:=#0;
            end;
*)
        'F':noforcerate:=not noforcerate;
        'R':begin
              prt('^3Which result code ^4 ^5');
              onek(ccc,'ABCQ123456789');
              cc:=ord(ccc)-48;
              begin

                if (ccc in ['A','B','C']) then begin
                  prt('^3Enter new result code ^4 ^5');
                  inu(c1);
                  if not badini then
                    if wantit then
                      case ccc of
                        'A':nocarrier:=c1;
                        'B':nodialtone:=c1;
                        'C':busy:=c1;
                      end
                    else noch;
                end else begin
                  
                  prt('^3Enter case 1 result code ^3 ^5');
                  inu(c1);
                  if (not badini) then begin
                    resultcode[1][cc-1]:=c1;
                    resultcode[2][cc-1]:=c1;
                  end;
                  {
                  prt('Enter case 2 result code: '); 
                  inu(c2);
                  if (not badini) then resultcode[2][cc-1]:=c2;
                  }
                end;
              end;
            end;
        'Q':done:=TRUE;
      end;
    end;
  until ((done) or (hangup));
  assign(modemrf,start_dir+'\modem.'+cstr(thisnode));
  reset(modemrf);
  seek(modemrf,0);
  write(modemrf,modemr);
  close(modemrf);
end;

end.
