(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2  .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor.                          <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2;

interface

uses
  crt, dos, overlay,
  sysop2a, sysop2b, sysop2c, sysop2d, sysop2e, sysop2f, sysop2g, sysop2h,
  sysop2i, sysop2z, sysop2s, sysop21, sysop2j,
  common;

procedure changestuff;

implementation

const
  aresure='Is This Correct? [No] ';

function wantit:boolean;
begin
  nl; wantit:=pynq(aresure);
end;

procedure changestuff;
var c:char;
    done,abort,next,savepause:boolean;
begin
  usingmci:=FALSE;
  systat.temppath:=copy(systat.temppath,1,length(systat.temppath)-1);
  while(systat.temppath[length(systat.temppath)]<>'\') do begin
    systat.temppath:=copy(systat.temppath,1,length(systat.temppath)-1);
  end;
  repeat
    done:=FALSE;
    cls;
    sprint(#3#5+'System Configuration for '+systat.bbsname);
    abort:=FALSE; next:=FALSE; savepause:=FALSE;
    printacr('^4Ŀ',abort,next);
    printacr('^4 ^3A ^4 ^5Modem configuration                     ^4',abort,next);
    printacr('^4 ^3B ^4 ^5File Paths & BBS Configuration          ^4',abort,next);
    printacr('^4 ^3C ^4 ^5System ACS Settings                     ^4',abort,next);
    printacr('^4 ^3D ^4 ^5System Variables                        ^4',abort,next);
    printacr('^4 ^3E ^4 ^5System Flagged Functions                ^4',abort,next);
    printacr('^4 ^3F ^4 ^5File Section Configuration              ^4',abort,next);
    printacr('^4 ^3G ^4 ^5New User and Auto-Validation settings   ^4',abort,next);
    printacr('^4 ^3H ^4 ^5Miscellaneous Configuration             ^4',abort,next);
    printacr('^4 ^3I ^4 ^5INSANEnet Configuration                 ^4',abort,next);
    printacr('^4 ^3J ^4 ^5Node Configuration                      ^4',abort,next);
    printacr('^4 ^3S ^4 ^5String Configuration                    ^4',abort,next);
    printacr('^4 ^3Z ^4 ^5Default Colors                          ^4',abort,next);
    printacr('^4͵',abort,next);
    printacr('^4 ^31 ^4 ^5Time Limitations                        ^4',abort,next);
    printacr('^4 ^32 ^4 ^5Call Allowance/Day                      ^4',abort,next);
    printacr('^4 ^33 ^4 ^5UL/DL # Files Ratio                     ^4',abort,next);
    printacr('^4 ^34 ^4 ^5UL/DL K-Bytes Ratio                     ^4',abort,next);
    printacr('^4 ^35 ^4 ^5Post/Call Ratio                         ^4',abort,next);
    printacr('^4',abort,next);
    nl;
    prt('Enter Option [A-J,S,Z,1-5] [Q]uit  ');
    onek(c,'QABCDEFGHIJZS12345'^M);
    case c of
      'A':pomodem;
      'B':pofile;
      'C':poslsettings;
      'D':pogenvar;
      'E':poflagfunc;
      'F':pofilesconfig;
      'G':ponewauto;
      'H':pomisc1;
      'I':pofido;
      'J':ponode;
      'S':postring;
      'Z':pocolors;
      '1':getsecrange('Time limitations',systat.timeallow);
      '2':getsecrange('Call allowance per day',systat.callallow);
      '3':getsecrange('UL/DL # files ratio (# files can DL per UL)',systat.dlratio);
      '4':getsecrange('UL/DL K-bytes ratio (#k can DL per 1k UL)',systat.dlkratio);
      '5':getsecrange('Post to Call ratio (Average number of calls between posts)',systat.postratio);
      'Q':done:=TRUE;
    end;
  until ((done) or (hangup));
  systat.temppath:=systat.temppath+cstr(thisnode)+'\';
  savesystat;
  if (savepause) then thisuser.ac:=thisuser.ac+[pause];
  usingmci:=TRUE;
end;

end.
