(*****************************************************************************)
(*>                                                                         <*)
(*>  SysOp functions: ANSI fonts editor                                     <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop14;

interface

uses
  crt, dos, overlay,
  common,
  file0,
  sysop1;

procedure afontedit;

implementation

procedure afontedit;
const ltype:integer=1;
var f1:file;
    s:string;
    i1,i2,ii:integer;
    c:char;
    abort,next:boolean;
    afont,tempfont:ansifontrec;

  procedure afed(x:integer);
  var i,j:integer;
  begin
    if ((x>0) and (x<=systat.numansifont)) then begin
      i:=x-1;
      if (i>=0) and (i<=filesize(afontf)-2) then
	for j:=i to filesize(afontf)-2 do begin
	  seek(afontf,j+1); read(afontf,afont);
	  seek(afontf,j); write(afontf,afont);
	end;
      seek(afontf,filesize(afontf)-1); truncate(afontf);

      dec(systat.numansifont);
    end;
  end;

  procedure afei(x:integer);
  var i,j:integer;
  begin
    i:=x-1;
    if ((i>=0) and (i<=filesize(afontf)) and (systat.numansifont<255)) then begin
      for j:=filesize(afontf)-1 downto i do begin
	seek(afontf,j); read(afontf,afont);
	write(afontf,afont); { ...to next record }
      end;
      with afont do begin
	desc:='New';
	uploader:=copy(nam,1,pos('#',nam)-2);
	filename:='NEW.AFT';
      end;
      seek(afontf,i); write(afontf,afont);
      inc(systat.numansifont);

    end;
  end;

  procedure afep(x,y:integer);
  var tempboard:boardrec;
      i,j,k:integer;
  begin
(*
	    y   x
	  012345678901234567890
   (k) 1> xxxxxxOxxx...........
   (j) 2> xxOxxxxxxx...........

            x   y
          012345678901234567890
   (k) 1> xxOxxxxxxx...........
   (j) 2> xxxxxxOxxx...........

           y  x         x  y
          0123456      0123456
          XxxxOXX      XOxxxXX
          X.xxxXX      Xxxx.XX
          XOxxxXX      XxxxOXX
          0312456      0231456

*)

    k:=y; if (y>x) then dec(y);
    dec(x); dec(y);
    seek(afontf,x); read(afontf,afont);
    i:=x; if (x>y) then j:=-1 else j:=1;
    while (i<>y) do begin
      if (i+j<filesize(afontf)) then begin
	seek(afontf,i+j); read(afontf,tempfont);
	seek(afontf,i); write(afontf,tempfont);
      end;
      inc(i,j);
    end;
    seek(afontf,y); write(afontf,afont);
    inc(x); inc(y); {y:=k;}

  end;

  procedure afem;
  var f:file;
      dirinfo:searchrec;
      anontemp:anontyp;
      s,s1,s2,s3:string;
      i,i1,i2,ii,xloaded:integer;
      c,c1:char;
      b:byte;
      changed,err:boolean;
  begin
    prt('Begin editing at which? (1-'+cstr(systat.numansifont)+') : '); inu(ii);
    c:=' '; xloaded:=-1;
    if ((ii>0) and (ii<=systat.numansifont)) then begin
      while (c<>'Q') and (not hangup) do begin
	if (xloaded<>ii) then begin
	  seek(afontf,ii-1); read(afontf,afont);
	  xloaded:=ii; changed:=FALSE;
	end;
	with afont do
	  repeat
	    if (c<>'?') then begin
	      cls;
	      print('ANSI Font #'+cstr(ii)+' of '+cstr(systat.numansifont));
	      nl;
	      sprint('1. Name        : '+#3#5+desc);
	      print('2. Uploader    : '+uploader);
	      print('3. Filename    : '+filename);
	      print('Q. Quit');
	    end;
	    nl; prt('Edit menu (?=help) : ');
	    onek(c,^M'?[]FJLQ123'); nl;
	    case c of
	      '1':begin
		    prt('New name: ');
		    cl(5); inputwnwc(desc,40,changed);
		  end;
	      '2':begin
		    prt('New Uploader: ');
		    cl(5); inputcaps(uploader,40);
		    changed:=TRUE;
		  end;
	      '3':begin
		    prt('New Filename: ');
		    cl(5);  input(filename,40);
                    changed:=TRUE;
		    if(pos('.',filename)=0) then begin
		      filename:=filename+'.AFT';
		    end;
		  end;
	      '[':if (ii>1) then dec(ii) else c:=' ';
	      ']':if (ii<systat.numansifont) then inc(ii) else c:=' ';
	      'F':if (ii<>1) then ii:=1 else c:=' ';
	      'J':begin
                    prt('Jump to entry: ');
                    input(s,3);
		    if (value(s)>=1) and (value(s)<=systat.numansifont) then ii:=value(s) else c:=' ';
                  end;
	      'L':if (ii<>systat.numansifont) then ii:=systat.numansifont else c:=' ';
              '?':begin
                    sprint(' #:Modify item   <CR>Redisplay screen');
                    lcmds(15,3,'[Back entry',']Forward entry');
                    lcmds(15,3,'Jump to entry','First entry in list');
                    lcmds(15,3,'Quit and save','Last entry in list');
                  end;
            end;
          until (pos(c,'Q[]FJL')<>0) or (hangup);
        if (changed) then begin
	  seek(afontf,xloaded-1); write(afontf,afont);
          changed:=FALSE;
        end;
      end;
    end;
  end;

  procedure afepi;
  var i,j:integer;
  begin
    prt('Move which ANSI font? (1-'+cstr(systat.numansifont)+') : '); inu(i);
    if ((not badini) and (i>=1) and (i<=systat.numansifont)) then begin
      prt('Move before which ANSI font? (1-'+cstr(systat.numansifont+1)+') : ');
      inu(j);
      if ((not badini) and (j>=1) and (j<=systat.numansifont+1) and
          (j<>i) and (j<>i+1)) then begin
        nl;
        afep(i,j);
      end;
    end;
  end;

begin
  c:=#0;
  reset(bf);
  repeat
    if (c<>'?') then begin
      cls; abort:=FALSE; next:=FALSE;
      printacr(#3#5+'###'+#3#4+''+#3#5+'Description                            '+
	       #3#4+''+#3#5+'Uploader',abort,next);
      printacr(#3#4+''+             ''+
	       '',abort,next);
      ii:=1;
      reset(afontf);
      while (ii<=systat.numansifont) and (not abort) and (not hangup) and (systat.numansifont>0) do begin
	seek(afontf,ii-1); read(afontf,afont);
	s:=#3#0+mn(ii,3)+#3#4+''+#3#3+mln(afont.desc,39)+#3#4+''+#3#3+afont.uploader;
        printacr(s,abort,next);
        inc(ii);
      end;
    end;
    nl;
    prt('ANSI font editor (?=help) : ');
    onek(c,'QDIMP?'^M);
    reset(afontf);
    case c of
      '?':begin
	    nl;
	    print('<CR>Redisplay screen');
	    lcmds(12,3,'Delete font','Insert font');
	    lcmds(12,3,'Modify font','Position font');
	    lcmds(12,3,'Quit','');
          end;
      'D':begin
	    prt('Font number to delete? (1-'+cstr(systat.numansifont)+') : '); inu(ii);
	    if ((not badini) and (ii>=1) and (ii<=systat.numansifont)) then begin
	      seek(afontf,ii-1);  read(afontf,afont);
	      nl; sprint('Font: '+#3#5+afont.desc);
	      if pynq('Delete this? ') then begin
		sysoplog('* Deleted ANSI font: '+afont.desc);
		afed(ii);
	      end;
	    end;
	  end;
      'I':begin
	    prt('Font number to insert before? (1-'+cstr(systat.numansifont+1)+') : '); inu(ii);
	    if ((not badini) and (ii>0) and (ii<=systat.numansifont+1) and
		(systat.numansifont<255)) then begin
	      sysoplog('* Inserted new ANSI font');
	      afei(ii);
	    end;
	  end;
      'M':afem;
      'P':afepi;
    end;
  until ((c='Q') or (hangup));
  reset(afontf);
  savesystat;
end;

end.

