(*****************************************************************************)
(*>                                                                         <*)
(*>  SysOp functions: File conference editor                                <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop13;

interface

uses
  crt, dos, overlay,
  common,
  file0,
  sysop1;

procedure fileconfedit;

implementation

procedure fileconfedit;
const ltype:integer=1;
var f1:file;
    s:string;
    i1,i2,ii:integer;
    c:char;
    abort,next:boolean;
    conf,tempconf:confrec;

  procedure fced(x:integer);
  var i,j:integer;
  begin
    if ((x>0) and (x<=systat.numfileconf)) then begin
      i:=x-1;
      if (i>=0) and (i<=filesize(fileconff)-2) then
        for j:=i to filesize(fileconff)-2 do begin
          seek(fileconff,j+1); read(fileconff,conf);
          seek(fileconff,j); write(fileconff,conf);
        end;
      seek(fileconff,filesize(fileconff)-1); truncate(fileconff);

      dec(systat.numfileconf);
    end;
  end;

  procedure fcei(x:integer);
  var i,j:integer;
  begin
    i:=x-1;
    if ((i>=0) and (i<=filesize(fileconff)) and (systat.numfileconf<255)) then begin
      for j:=filesize(fileconff)-1 downto i do begin
        seek(fileconff,j); read(fileconff,conf);
        write(fileconff,conf); { ...to next record }
      end;
      with conf do begin
        desc:='New';
        acs:='s50';
      end;
      seek(fileconff,i); write(fileconff,conf);
      inc(systat.numfileconf);

    end;
  end;

  procedure fcep(x,y:integer);
  var tempboard:boardrec;
      i,j,k:integer;
  begin
(*
            y   x
          012345678901234567890
   (k) 1> xxxxxxOxxx...........
   (j) 2> xxOxxxxxxx...........

            x   y
          012345678901234567890
   (k) 1> xxOxxxxxxx...........
   (j) 2> xxxxxxOxxx...........

           y  x         x  y
          0123456      0123456
          XxxxOXX      XOxxxXX
          X.xxxXX      Xxxx.XX
          XOxxxXX      XxxxOXX
          0312456      0231456

*)

    k:=y; if (y>x) then dec(y);
    dec(x); dec(y);
    seek(fileconff,x); read(fileconff,conf);
    i:=x; if (x>y) then j:=-1 else j:=1;
    while (i<>y) do begin
      if (i+j<filesize(fileconff)) then begin
        seek(fileconff,i+j); read(fileconff,tempconf);
        seek(fileconff,i); write(fileconff,tempconf);
      end;
      inc(i,j);
    end;
    seek(fileconff,y); write(fileconff,conf);
    inc(x); inc(y); {y:=k;}

  end;

  procedure fcem;
  var f:file;
      dirinfo:searchrec;
      anontemp:anontyp;
      s,s1,s2,s3:string;
      i,i1,i2,ii,xloaded:integer;
      c,c1:char;
      b:byte;
      changed,err:boolean;
  begin
    prt('Begin editing at which? (1-'+cstr(systat.numfileconf)+') : '); inu(ii);
    c:=' '; xloaded:=-1;
    if ((ii>0) and (ii<=systat.numfileconf)) then begin
      while (c<>'Q') and (not hangup) do begin
        if (xloaded<>ii) then begin
          seek(fileconff,ii-1); read(fileconff,conf);
          xloaded:=ii; changed:=FALSE;
        end;
        with conf do
          repeat
            if (c<>'?') then begin
              cls;
              print('File conference #'+cstr(ii)+' of '+cstr(systat.numfileconf));
              nl;
              sprint('1. Name        : '+#3#5+desc);
              print('2. ACS         : '+acs);
              print('Q. Quit');
            end;
            nl; prt('Edit menu (?=help) : ');
            onek(c,^M'?[]FJLQ12'); nl;
            case c of
              '1':begin
                    prt('New name: ');
                    cl(5); inputwnwc(desc,40,changed);
                  end;
              '2':begin
                    prt('New ACS: ');
                    cl(5); inputwn(acs,20,changed);
                  end;
              '[':if (ii>1) then dec(ii) else c:=' ';
              ']':if (ii<systat.numfileconf) then inc(ii) else c:=' ';
              'F':if (ii<>1) then ii:=1 else c:=' ';
              'J':begin
                    prt('Jump to entry: ');
                    input(s,3);
                    if (value(s)>=1) and (value(s)<=systat.numfileconf) then ii:=value(s) else c:=' ';
                  end;
              'L':if (ii<>systat.numfileconf) then ii:=systat.numfileconf else c:=' ';
              '?':begin
                    sprint(' #:Modify item   <CR>Redisplay screen');
                    lcmds(15,3,'[Back entry',']Forward entry');
                    lcmds(15,3,'Jump to entry','First entry in list');
                    lcmds(15,3,'Quit and save','Last entry in list');
                  end;
            end;
          until (pos(c,'Q[]FJL')<>0) or (hangup);
        if (changed) then begin
          seek(fileconff,xloaded-1); write(fileconff,conf);
          changed:=FALSE;
        end;
      end;
    end;
  end;

  procedure fcepi;
  var i,j:integer;
  begin
    prt('Move which file conference? (1-'+cstr(systat.numfileconf)+') : '); inu(i);
    if ((not badini) and (i>=1) and (i<=systat.numfileconf)) then begin
      prt('Move before which file conference? (1-'+cstr(systat.numfileconf+1)+') : ');
      inu(j);
      if ((not badini) and (j>=1) and (j<=systat.numfileconf+1) and
          (j<>i) and (j<>i+1)) then begin
        nl;
        fcep(i,j);
      end;
    end;
  end;

begin
  c:=#0;
  reset(bf);
  repeat
    if (c<>'?') then begin
      cls; abort:=FALSE; next:=FALSE;
      printacr(#3#5+'###'+#3#4+''+#3#5+'Conference name                        '+
               #3#4+''+#3#5+'ACS',abort,next);
      printacr(#3#4+''+             ''+
               '',abort,next);
(*
###Conference name                        ACS
..etc.etc.
*)
      ii:=1;
      reset(fileconff);
      while (ii<=systat.numfileconf) and (not abort) and (not hangup) and (systat.numfileconf>0) do begin
        seek(fileconff,ii-1); read(fileconff,conf);
        s:=#3#0+mn(ii,3)+#3#4+''+#3#3+mln(conf.desc,39)+#3#4+''+#3#3+conf.acs;
        printacr(s,abort,next);
        inc(ii);
      end;
    end;
    nl;
    prt('File conference editor (?=help) : ');
    onek(c,'QDIMP?'^M);
    reset(fileconff);
    case c of
      '?':begin
            nl;
            print('<CR>Redisplay screen');
            lcmds(12,3,'Delete conference','Insert conferece');
            lcmds(12,3,'Modify conference','Position conference');
            lcmds(12,3,'Quit','');
          end;
      'D':begin
            prt('Conference number to delete? (1-'+cstr(systat.numfileconf)+') : '); inu(ii);
            if ((not badini) and (ii>=1) and (ii<=systat.numfileconf)) then begin
              seek(fileconff,ii-1);  read(fileconff,conf);
              nl; sprint('File conference: '+#3#5+conf.desc);
              if pynq('Delete this? ') then begin
                sysoplog('* Deleted file conference: '+conf.desc);
                fced(ii);
              end;
            end;
          end;
      'I':begin
            prt('Conference number to insert before? (1-'+cstr(systat.numfileconf+1)+') : '); inu(ii);
            if ((not badini) and (ii>0) and (ii<=systat.numfileconf+1) and
                (systat.numfileconf<255)) then begin
              sysoplog('* Inserted new file conference');
              fcei(ii);
            end;
          end;
      'M':fcem;
      'P':fcepi;
    end;
  until ((c='Q') or (hangup));
  reset(fileconff);
end;

end.

