(*****************************************************************************)
(*>                                                                         <*)
(*>  SysOp functions: Message conference editor                             <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop12;

interface

uses
  crt, dos, overlay,
  common,
  file0,
  sysop1;

procedure messconfedit;

implementation

procedure messconfedit;
const ltype:integer=1;
var f1:file;
    s:string;
    i1,i2,ii:integer;
    c:char;
    abort,next:boolean;
    conf,tempconf:confrec;

  procedure mced(x:integer);
  var i,j:integer;
  begin
    if ((x>0) and (x<=systat.nummessconf)) then begin
      i:=x-1;
      if (i>=0) and (i<=filesize(messconff)-2) then
        for j:=i to filesize(messconff)-2 do begin
          seek(messconff,j+1); read(messconff,conf);
          seek(messconff,j); write(messconff,conf);
        end;
      seek(messconff,filesize(messconff)-1); truncate(messconff);

      dec(systat.nummessconf);
    end;
  end;

  procedure mcei(x:integer);
  var i,j:integer;
  begin
    i:=x-1;
    if ((i>=0) and (i<=filesize(messconff)) and (systat.nummessconf<255)) then begin
      for j:=filesize(messconff)-1 downto i do begin
        seek(messconff,j); read(messconff,conf);
        write(messconff,conf); { ...to next record }
      end;
      with conf do begin
        desc:='New';
        acs:='s50';
      end;
      seek(messconff,i); write(messconff,conf);
      inc(systat.nummessconf);

    end;
  end;

  procedure mcep(x,y:integer);
  var tempboard:boardrec;
      i,j,k:integer;
  begin
(*
            y   x
          012345678901234567890
   (k) 1> xxxxxxOxxx...........
   (j) 2> xxOxxxxxxx...........

            x   y
          012345678901234567890
   (k) 1> xxOxxxxxxx...........
   (j) 2> xxxxxxOxxx...........

           y  x         x  y
          0123456      0123456
          XxxxOXX      XOxxxXX
          X.xxxXX      Xxxx.XX
          XOxxxXX      XxxxOXX
          0312456      0231456

*)

    k:=y; if (y>x) then dec(y);
    dec(x); dec(y);
    seek(messconff,x); read(messconff,conf);
    i:=x; if (x>y) then j:=-1 else j:=1;
    while (i<>y) do begin
      if (i+j<filesize(messconff)) then begin
        seek(messconff,i+j); read(messconff,tempconf);
        seek(messconff,i); write(messconff,tempconf);
      end;
      inc(i,j);
    end;
    seek(messconff,y); write(messconff,conf);
    inc(x); inc(y); {y:=k;}

  end;

  procedure mcem;
  var f:file;
      dirinfo:searchrec;
      anontemp:anontyp;
      s,s1,s2,s3:string;
      i,i1,i2,ii,xloaded:integer;
      c,c1:char;
      b:byte;
      changed,err:boolean;
  begin
    prt('Begin editing at which? (1-'+cstr(systat.nummessconf)+') : '); inu(ii);
    c:=' '; xloaded:=-1;
    if ((ii>0) and (ii<=systat.nummessconf)) then begin
      while (c<>'Q') and (not hangup) do begin
        if (xloaded<>ii) then begin
          seek(messconff,ii-1); read(messconff,conf);
          xloaded:=ii; changed:=FALSE;
        end;
        with conf do
          repeat
            if (c<>'?') then begin
              cls;
              print('Message conference #'+cstr(ii)+' of '+cstr(systat.nummessconf));
              nl;
              sprint('1. Name        : '+#3#5+desc);
              print('2. ACS         : '+acs);
              print('Q. Quit');
            end;
            nl; prt('Edit menu (?=help) : ');
            onek(c,^M'?[]FJLQ12'); nl;
            case c of
              '1':begin
                    prt('New name: ');
                    cl(5); inputwnwc(desc,40,changed);
                  end;
              '2':begin
                    prt('New ACS: ');
                    cl(5); inputwn(acs,20,changed);
                  end;
              '[':if (ii>1) then dec(ii) else c:=' ';
              ']':if (ii<systat.nummessconf) then inc(ii) else c:=' ';
              'F':if (ii<>1) then ii:=1 else c:=' ';
              'J':begin
                    prt('Jump to entry: ');
                    input(s,3);
                    if (value(s)>=1) and (value(s)<=systat.nummessconf) then ii:=value(s) else c:=' ';
                  end;
              'L':if (ii<>systat.nummessconf) then ii:=systat.nummessconf else c:=' ';
              '?':begin
                    sprint(' #:Modify item   <CR>Redisplay screen');
                    lcmds(15,3,'[Back entry',']Forward entry');
                    lcmds(15,3,'Jump to entry','First entry in list');
                    lcmds(15,3,'Quit and save','Last entry in list');
                  end;
            end;
          until (pos(c,'Q[]FJL')<>0) or (hangup);
        if (changed) then begin
          seek(messconff,xloaded-1); write(messconff,conf);
          changed:=FALSE;
        end;
      end;
    end;
  end;

  procedure mcepi;
  var i,j:integer;
  begin
    prt('Move which message conference? (1-'+cstr(systat.nummessconf)+') : '); inu(i);
    if ((not badini) and (i>=1) and (i<=systat.nummessconf)) then begin
      prt('Move before which message conference? (1-'+cstr(systat.nummessconf+1)+') : ');
      inu(j);
      if ((not badini) and (j>=1) and (j<=systat.nummessconf+1) and
          (j<>i) and (j<>i+1)) then begin
        nl;
        mcep(i,j);
      end;
    end;
  end;

begin
  c:=#0;
  reset(bf);
  repeat
    if (c<>'?') then begin
      cls; abort:=FALSE; next:=FALSE;
      printacr(#3#5+'###'+#3#4+''+#3#5+'Conference name                        '+
               #3#4+''+#3#5+'ACS',abort,next);
      printacr(#3#4+''+             ''+
               '',abort,next);
(*
###Conference name                        ACS
..etc.etc.
*)
      ii:=1;
      reset(messconff);
      while (ii<=systat.nummessconf) and (not abort) and (not hangup) and (systat.nummessconf>0) do begin
        seek(messconff,ii-1); read(messconff,conf);
        s:=#3#0+mn(ii,3)+#3#4+''+#3#3+mln(conf.desc,39)+#3#4+''+#3#3+conf.acs;
        printacr(s,abort,next);
        inc(ii);
      end;
    end;
    nl;
    prt('Message conference editor (?=help) : ');
    onek(c,'QDIMP?'^M);
    reset(messconff);
    case c of
      '?':begin
            nl;
            print('<CR>Redisplay screen');
            lcmds(12,3,'Delete conference','Insert conferece');
            lcmds(12,3,'Modify conference','Position conference');
            lcmds(12,3,'Quit','');
          end;
      'D':begin
            prt('Conference number to delete? (1-'+cstr(systat.nummessconf)+') : '); inu(ii);
            if ((not badini) and (ii>=1) and (ii<=systat.nummessconf)) then begin
              seek(messconff,ii-1);  read(messconff,conf);
              nl; sprint('Message conference: '+#3#5+conf.desc);
              if pynq('Delete this? ') then begin
                sysoplog('* Deleted message conference: '+conf.desc);
                mced(ii);
              end;
            end;
          end;
      'I':begin
            prt('Conference number to insert before? (1-'+cstr(systat.nummessconf+1)+') : '); inu(ii);
            if ((not badini) and (ii>0) and (ii<=systat.nummessconf+1) and
                (systat.nummessconf<255)) then begin
              sysoplog('* Inserted new message conference');
              mcei(ii);
            end;
          end;
      'M':mcem;
      'P':mcepi;
    end;
  until ((c='Q') or (hangup));
  reset(messconff);
end;

end.

