(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP1  .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: Protocol editor.                                      <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop1;

interface

procedure ee_help;
procedure exproedit;

implementation

uses
  crt, dos, overlay,
  common,
  file1,
  menus2;

var menuchanged:boolean;
    x:integer;

procedure ee_help;
begin
  sprint(' #:Modify item   <CR>Redisplay screen');
  lcmds(15,3,'[Back entry',']Forward entry');
  lcmds(15,3,'Jump to entry','First entry in list');
  lcmds(15,3,'Quit and save','Last entry in list');
end;

procedure exproedit;
var wrd:word;
    i1,i2,ii,xloaded:integer;
    c:char;
    abort,next:boolean;
    st:astr;

  procedure xed(i:integer);
  var x:integer;
  begin
    if (i>=0) and (i<=filesize(xf)-1) then begin
      if (i>=0) and (i<filesize(xf)-1) then
        for x:=i to filesize(xf)-2 do begin
          seek(xf,x+1); read(xf,protocol);
          seek(xf,x); write(xf,protocol);
        end;
      seek(xf,filesize(xf)-1); truncate(xf);
    end;
  end;

  function newindexno:longint;
  var xpr:protrec;
      i,j:integer;
  begin
    reset(xf);
    j:=-1;
    for i:=1 to filesize(xf) do begin
      read(xf,xpr);
      if (xpr.permindx>j) then j:=xpr.permindx;
    end;
    inc(j);
    newindexno:=j;
  end;

  procedure xei(i:integer);
  var x:integer;
  begin
    if (i>=0) and (i<=filesize(xf)) and (filesize(xf)<maxprotocols) then begin
      for x:=filesize(xf)-1 downto i do begin
        seek(xf,x); read(xf,protocol);
        write(xf,protocol);  (* to next record *)
      end;
      with protocol do begin
        xbstat:=[xbxferokcode];
        ckeys:='!';
        descr:=#3#4+'('+#3#3+'!'+#3#4+') New Protocol';
        acs:='';
        templog:='';
        uloadlog:=''; dloadlog:='';
        ulcmd:='QUIT'; dlcmd:='QUIT';
        for x:=1 to 6 do begin ulcode[x]:=''; dlcode[x]:=''; end;
        envcmd:='';
        dlflist:='';
        maxchrs:=128;
        logpf:=0; logps:=0;
        permindx:=newindexno;
        for x:=1 to 11 do res[x]:=0;
      end;
      seek(xf,i); write(xf,protocol);
    end;
  end;

  function udq:integer;
  var c:char;
  begin
    prt('What type? (U)pload (D)ownload : ');
    onek(c,'DU'); nl;
    if (c='U') then udq:=1 else udq:=2;
  end;

  function substone(src,old,new:astr):astr;
  var p:integer;
  begin
    p:=pos(old,src);
    if (p>0) then begin
      insert(new,src,p+length(old));
      delete(src,p,length(old));
    end;
    substone:=src;
  end;

  function showpmci(s:astr):astr;
  begin
    s:=substone(s,'%B',#3#3+'%B'+#3#1);
    s:=substone(s,'%C',#3#3+'%C'+#3#1);
    s:=substone(s,'%F',#3#3+'%F'+#3#1);
    s:=substone(s,'%G',#3#3+'%G'+#3#1);
    s:=substone(s,'%L',#3#3+'%L'+#3#1);
    s:=substone(s,'%P',#3#3+'%P'+#3#1);
    s:=substone(s,'%T',#3#3+'%T'+#3#1);
    showpmci:=s;
  end;

  procedure xem;
  var s:astr;
      i,j,i1,i2,ii:integer;
      c,c1:char;
      bb:byte;
      changed,b:boolean;

    function cfip(pt:integer; s:astr):astr;
    begin
      if (pt<1) or (pt>5) then cfip:=s else cfip:='';
    end;

    function nnon(s:astr):astr;
    begin
      if (s<>'') then nnon:='"'+s+'"' else nnon:='*None*';
    end;

    procedure pprint(s:astr);
    var i:integer;
    begin
      s:=showpmci(s);
      cl(1);
      for i:=1 to length(s) do
        if ((s[i]=#3) and (i<>length(s))) then begin
          cl(ord(s[i+1]));
          inc(i);
        end else
          outkey(s[i]);
      nl;
    end;

  begin
    xloaded:=-1;
    prt('^3Begin editing at which? [0-'+cstr(filesize(xf)-1)+'] ^4 ^5'); inu(ii);
    c:=' ';
    if (ii>=0) and (ii<=filesize(xf)-1) then begin
      while (c<>'Q') and (not hangup) do begin
        if (xloaded<>ii) then begin
          seek(xf,ii); read(xf,protocol);
          xloaded:=ii; changed:=FALSE;
        end;
        with protocol do
          repeat
            if (c<>'?') then begin
              cls;
              abort:=FALSE; next:=FALSE; i:=1;
              while ((i<=15) and (not abort)) do begin
                case i of
                  1:sprint('^0Protocol #'+cstr(ii)+' of '+cstr(filesize(xf)-1));
                  2:sprint('^1!. ^3Type/protocl ^4 ^5'+
                      aonoff(xbactive in xbstat,'Active','NOT ACTIVE')+' - '+
                      aonoff(xbisbatch in xbstat,'Batch protocol','Single protocol')+
                      aonoff(xbisresume in xbstat,' - Resume','')+
                      aonoff(xbisbidirec in xbstat,' - Bidirectional',''));
                  3:sprint('^11. ^3Keys/descrip ^4 ^5"'+ckeys+'" / "'+descr+'"');
                  4:sprint('^12. ^3ACS required ^4 ^5"'+acs+'"');
                  5:sprint('^13. ^3Temp. log    ^4 ^5'+nnon(templog));
                  6:sprint('^14. ^3[U]L log     ^4 ^5'+nnon(uloadlog));
                  7:sprint('   ^3[D]L log     ^4 ^5'+nnon(dloadlog));
                  8:sprint('^15. ^3[U]L command ^4 ^5'+nnon(ulcmd));
                  9:sprint('   ^3[D]L command ^4 ^5'+nnon(dlcmd));
                  10:sprint('^16. ^3Codes mean   ^4 ^5'+aonoff(xbxferokcode in xbstat,
                     'Transfer OK','Transfer bad'));
                  11:begin
                       s:='^17. ^3[U]L codes   ^4 ^5';
                       for j:=1 to 6 do
                         s:=s+mln('('+cstr(j)+')"'+ulcode[j]+'" ',10);
                       sprint(copy(s,1,length(s)-1));
                     end;
                  12:begin
                       s:='   ^3[D]L codes   ^4 ^5';
                       for j:=1 to 6 do
                         s:=s+mln('('+cstr(j)+')"'+dlcode[j]+'" ',10);
                       sprint(copy(s,1,length(s)-1));
                     end;
                  13:sprint('^1E. ^3Environ. cmd ^4 ^5'+nnon(envcmd));
                  14:sprint('^1I. ^3DL File list ^4 ^5'+nnon(dlflist));
                  15:sprint('^1C. ^3Max DOS chrs ^4 ^5'+cstr(maxchrs)+
                           '   P. Log position: Filename: '+cstr(logpf)+
                           ' - Status: '+cstr(logps));
                end;
                inc(i);
                wkey(abort,next);
              end;
            end;
            nl;
            prt('^3Edit menu [?=help] ^4 ^5'); onek(c,'Q!1234567CEIP[]FJL?'^M);
            nl;
            case c of
              '!':begin
                    repeat
                      sprint('^11. ^3Protocol active    ^4 ^5'+syn(xbactive in xbstat));
                      sprint('^12. ^3Is batch protocol  ^4 ^5'+syn(xbisbatch in xbstat));
                      sprint('^13. ^3Is resume protocol ^4 ^5'+syn(xbisresume in xbstat));
                      sprint('^14. ^3Is bidirectional   ^4 ^5'+syn(xbisbidirec in xbstat));
                      nl;
                      prt('^3Select [1-4,Q=Quit] ^4 ^5'); onek(c,'Q1234'^M);
                      nl;
                      if (c in ['1'..'4']) then begin
                        changed:=TRUE;
                        case c of
                          '1':if (xbactive in xbstat) then
                                xbstat:=xbstat-[xbactive]
                              else xbstat:=xbstat+[xbactive];
                          '2':if (xbisbatch in xbstat) then
                                xbstat:=xbstat-[xbisbatch]
                              else xbstat:=xbstat+[xbisbatch];
                          '3':if (xbisresume in xbstat) then
                                xbstat:=xbstat-[xbisresume]
                              else xbstat:=xbstat+[xbisresume];
                          '4':if (xbisbidirec in xbstat) then
                                xbstat:=xbstat-[xbisbidirec]
                              else xbstat:=xbstat+[xbisbidirec];
                        end;
                      end;
                    until ((not (c in ['1'..'4'])) or (hangup));
                    c:=#0;
                  end;
              '1':begin
                    prt('^3New command keys ^4 ^5'); mpl(14); input(s,14);
                    if (s<>'') then begin
                      if (s<>ckeys) then changed:=TRUE;
                      ckeys:=s;
                    end;
                    nl;
                    print('New description:');
                    prt('^4 ^5'); cl(1); inputwc(s,40);
                    if (s<>'') then begin
                      if (s<>descr) then changed:=TRUE;
                      descr:=s;
                    end;
                  end;
              '2':begin
                    prt('^3New ACS ^4 ^5'); mpl(20);
                    inputwn(acs,20,changed);
                  end;
              '3':begin
                    print('New temp. log:');
                    prt('^4 ^5'); inputwn(templog,25,changed);
                  end;
              '4':case udq of
                    1:begin
                        print('New permanent upload log:');
                        prt('^4 ^5'); inputwn(uloadlog,25,changed);
                      end;
                    2:begin
                        print('New permanent download log:');
                        prt('^4 ^5'); inputwn(dloadlog,25,changed);
                      end;
                  end;
              '5':begin
                    s:=#0#0#0; j:=udq;
                    prt('^3Type: [A]scii [C]ommand [E]xternal [O]ff ^4 ^5');
                    onek(c,^M'ACEO'); nl;
                    case c of
                      'A':s:='ASCII';
                      'C':begin
                            prt('^3[B]atch [N]ext [Q]uit ^4 ^5');
                            onek(c,'BNQ'^M);
                            case c of
                              'B':s:='BATCH';
                              'N':s:='NEXT';
                              'Q':s:='QUIT';
                            end;
                          end;
                      'E':begin
                            if (j=1) then print('New upload commandline:')
                              else print('New download commandline:');
                            prt('^4 ^5'); inputwn(s,78,changed);
                          end;
                      'O':if pynq('Set to NULL string? [No] ') then s:='';
                    end;
                    if (s<>#0#0#0) then begin
                      changed:=TRUE;
                      case j of
                        1:ulcmd:=s;
                        2:dlcmd:=s;
                      end;
                    end;
                    c:=#0;
                  end;
              '6':begin
                    if (xbxferokcode in xbstat) then
                      xbstat:=xbstat-[xbxferokcode]
                      else xbstat:=xbstat+[xbxferokcode];
                    changed:=TRUE;
                  end;
              '7':begin
                    case udq of
                      1:begin
                          print('New upload codes:'); nl;
                          for i:=1 to 6 do begin
                            prt('^3Code #'+cstr(i)+' ["'+ulcode[i]+'"] ^4 ^5');
                            inputwn(ulcode[i],6,changed);
                          end;
                        end;
                      2:begin
                          print('New download codes:'); nl;
                          for i:=1 to 6 do begin
                            prt('^3Code #'+cstr(i)+' ["'+dlcode[i]+'"] ^4 ^5');
                            inputwn(dlcode[i],6,changed);
                          end;
                        end;
                    end;
                  end;
              'C':begin
                    prt('^3New max DOS chrs in commandline ^4 ^5'); inu(i);
                    if (not badini) then begin
                      if (i<>maxchrs) then changed:=TRUE;
                      maxchrs:=i;
                    end;
                  end;
              'E':begin
                    print('New environment setup commandline:');
                    prt('^4 ^5'); inputwn(envcmd,60,changed);
                  end;
              'I':begin
                    print('New batch file list:');
                    prt('^4 ^5'); inputwn(dlflist,25,changed);
                  end;
              'P':begin
                    prt('^3New "Filename" log position? ['+cstr(logpf)+'] ^4 ^5');
                    inu(i);
                    if (not badini) then begin
                      if (i<>logpf) then changed:=TRUE;
                      logpf:=i;
                    end;
                    prt('^3New "Status" log position? ['+cstr(logps)+'] ^4 ^5');
                    inu(i);
                    if (not badini) then begin
                      if (i<>logpf) then changed:=TRUE;
                      logps:=i;
                    end;
                  end;
              '[':if (ii>0) then dec(ii) else c:=' ';
              ']':if (ii<filesize(xf)-1) then inc(ii) else c:=' ';
              'F':if (ii<>0) then ii:=0 else c:=' ';
              'J':begin
                    prt('^3Jump to entry ^4 ^5');
                    input(s,3);
                    if ((value(s)>=0) and (value(s)<=filesize(xf)-1)) then
                      ii:=value(s) else c:=' ';
                  end;
              'L':if (ii=filesize(xf)-1) then c:=' ' else ii:=filesize(xf)-1;
              '?':ee_help;
            end;
          until (pos(c,'Q[]FJL')<>0) or (hangup);
        if (changed) then begin
          seek(xf,xloaded); write(xf,protocol);
          changed:=FALSE;
        end;
      end;
    end;
  end;

  procedure xep;
  var i,j,k:integer;
  begin
    prt('^3Move which protocol? (0-'+cstr(filesize(xf)-1)+') ^4 ^5'); inu(i);
    if ((not badini) and (i>=0) and (i<=filesize(xf)-1)) then begin
      prt('^3Move before which protocol? (0-'+cstr(filesize(xf))+') ^4 ^5'); inu(j);
      if ((not badini) and (j>=0) and (j<=filesize(xf)) and
          (j<>i) and (j<>i+1)) then begin
        xei(j);
        if (j>i) then k:=i else k:=i+1;
        seek(xf,k); read(xf,protocol);
        seek(xf,j); write(xf,protocol);
        if (j>i) then xed(i) else xed(i+1);
      end;
    end;
  end;

  function nar(c:char):char;
  begin
    if c='@' then nar:=' ' else nar:=c;
  end;

begin
  usingmci:=FALSE;
  reset(xf); xloaded:=-1; c:=#0;
  repeat
    if (c<>'?') then
    begin
      cls; abort:=FALSE;
      printacr(#3#3+' NNN^4^3ACS       ^4^3Description',abort,next);
      printacr(#3#4+' ',abort,next);
      ii:=0;
      seek(xf,0);
      while (ii<=filesize(xf)-1) and (not abort) do begin
        read(xf,protocol);
        with protocol do begin
          printacr(aonoff((xbactive in xbstat),#3#5+'+',#3#1+'-')+
                   #3#0+mn(ii,3)+'^4'+#3#9+mln(acs,10)+'^4'+
                   #3#1+descr,abort,next);
          inc(ii);
        end;
      end;
    end;
    nl;
    prt('^3Protocol editor (?=help) ^4 ^5');
    onek(c,'QDIMP?'^M);
    case c of
      '?':begin
            nl;
            print('<CR>Redisplay screen');
            lcmds(16,3,'Delete protocol','Insert protocol');
            lcmds(16,3,'Modify protocol','Position protocol');
            lcmds(16,3,'Quit','');
          end;
      'D':begin
            prt('^3Protocol to delete? (0-'+cstr(filesize(xf)-1)+') ^4 ^5'); inu(ii);
            if (ii>=0) and (ii<=filesize(xf)-1) then begin
              seek(xf,ii); read(xf,protocol);
              nl; sprint('Protocol: '+#3#4+protocol.descr);
              if pynq('Delete this? [No] ') then
              begin
                sysoplog(' Deleted protocol: '+protocol.descr); xed(ii);
              end;
            end;
          end;
      'I':begin
            prt('^3Protocol to insert before? (0-'+cstr(filesize(xf))+') ^4 ^5'); inu(ii);
            if (ii>=0) and (ii<=filesize(xf)) then
            begin
              xei(ii); sysoplog(' Inserted new protocol');
            end;
          end;
      'M':xem;
      'P':xep;
    end;
  until ((c='Q') or (hangup));
  close(xf);
  usingmci:=TRUE;
end;

end.
