(*****************************************************************************)
(*>                                                                         <*)
(*>  NEWUSERS.PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  Logon functions -- New users.                                          <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit newusers;

interface

uses
  crt, dos, overlay,
  mail0, mail1, mail2, mail3,
  misc2, misc3, misc4, miscx,
  cuser,
  doors,
  archive1,
  menus,
  common;

procedure newuser;
procedure newuserinit(nam:astr);

implementation

var
  newusername:astr;

procedure p1;
var c:char;
    tries,i,ii,t:integer;
    s,s1,s2:astr;
    atype,pw:astr;
    done,abort,next,choseansi,chosecolor:boolean;

  procedure showstuff;
  begin
    nl;
    nl;
    printf('system');
    nl;
    nl;
    printf('newuser');
    pausescr;
    cls;
  end;

  procedure doitall;
  type neworderrec=array[1..22] of integer;
  const neworder:neworderrec=(7,10,9,23,4,14,8,12,2,1,6,30,28,26,11,3,5,27,31,33,13,-1);
  var i:integer;
      c:char;
  begin
    showstuff;
    if (newusername<>'') then begin
      thisuser.name:=newusername;
      newusername:='';
      i:=2;
    end else
      i:=1;
    cls;
    repeat
      cstuff(neworder[i],1,thisuser);
      inc(i);
    until ((neworder[i]=-1) or (hangup));
  end;

  procedure dc(var abort:boolean; c:char; n,v:astr);
  begin
    printacr(#3#3+c+#3#1+' - '+
             #3#4+mln(n,20)+#3#2+' - '+#3#5+v,abort,next);
  end;

begin
  t:=0;
  doitall;
  if (not hangup) then
    repeat
      done:=FALSE;
      cls;
      abort:=FALSE; next:=FALSE;
      printacr(#3#5+'User Information for '+caps(thisuser.name),abort,next);
      nl;
      if (ansi in thisuser.ac) then begin
        atype:='Enabled';
        if (color in thisuser.ac) then atype:=atype+' & Color'
        else atype:=atype+' & NO Color!';
      end else
        atype:='Disabled';
      with thisuser do begin
         sprint('');
        dc(abort,'A',' Handle/Alias         ',name);
        dc(abort,'B',' Real Name            ',realname);
        dc(abort,'C',' VOICE Phone Number   ',ph);
	dc(abort,'D',' Computer Type        ',computer);
        dc(abort,'E',' Sex                  ',sex);
        dc(abort,'F',' Birthdate            ',bday+' ('+cstr(ageuser(bday))+' years old)');
        dc(abort,'G',' City, State          ',citystate);
        dc(abort,'H',' Years Modem Exper.   ',street);
        dc(abort,'I',' Zip Code             ',zipcode);
        dc(abort,'J',' Modem Speed          ',occupation);
        dc(abort,'K',' Reference(s)         ',wherebbs);
        dc(abort,'L',' ANSI                 ',atype);
        dc(abort,'M',' Screen Size          ',cstr(linelen)+'x'+cstr(pagelen));
        dc(abort,'N',' Your Password        ',pw);
         sprint('');
      end;
      nl;
      prt('Last minute changes - [A-N] [Q]uit  ');
      onek(c,'QABCDEFGHIJKLMN');
      if (c<>'Q') then begin
       cstuff(pos(c,'HFLGDJACNBMEKI'),1,thisuser)
      end
      else done:=TRUE;
    until ((done) or (hangup));
    sl1('New user applied for access : '+caps(thisuser.name));
end;

procedure p2;
var user:userrec;
    pw:string;
    tries,i,j:integer;
    nuvfile:file of nuvrec;
    thisnuv:nuvrec;
    c:char;
    done:boolean;
begin
  if (not hangup) then begin
    sprompt(#3#5+' '+#3#0+'Saving New User Record... ');

    reset(uf);
    j:=0;
    for i:=1 to filesize(uf)-1 do begin
      seek(uf,i); read(uf,user);
      if ((user.deleted) and (j=0)) then j:=i;
    end;
    if (j<>0) then usernum:=j else usernum:=filesize(uf);

    with thisuser do begin
      deleted:=FALSE; waiting:=0; firston:=date; laston:=date;
      loggedon:=0; msgpost:=0; emailsent:=0; feedback:=0; ontoday:=0;
      illegal:=0; forusr:=0;
      downloads:=0; uploads:=0; dk:=0; uk:=0;
      linelen:=80; pagelen:=25; ttimeon:=0;

      for i:=1 to 5 do boardsysop[i]:=255;
      lastmsg:=1; lastfil:=1; credit:=0; timebank:=0;

      for i:=1 to 70 do res[i]:=0;
      for i:=1 to 20 do vote[i]:=0;

      readinzscan; { load old / create new zscan.dat record }
      with zscanr do begin
        for i:=1 to maxboards do
          for j:=1 to 6 do mhiread[i][j]:=0;
        mzscan:=[]; fzscan:=[];
        for i:=1 to maxboards do mzscan:=mzscan+[i];
	for i:=0 to maxuboards do fzscan:=fzscan+[i];
      end;
      savezscanr;

      trapactivity:=FALSE; trapseperate:=FALSE;
      timebankadd:=0;
      mpointer:=-1;
      chatauto:=FALSE; chatseperate:=FALSE;
      slogseperate:=FALSE;

      flistopt:=1;
      avadjust:=0;
      ownerdls:=0;
      reset(uf); seek(uf,0); read(uf,user); close(uf);
      cols:=user.cols;
      sl:=systat.newsl; dsl:=systat.newdsl; realsl:=sl; realdsl:=dsl;
      filepoints:=systat.newfp;

      ar:=systat.newar;
      tltoday:=systat.timeallow[sl];
      if (systat.useprism) then begin
        cls;
        nl;
        printf('eval');
        if (nofile) then begin
          sprint('You are now about to be evaluated for validation by the Insanity I.S.M.');
          sprint('If you are denied access, and you feel that you may have forgotten something');
          sprint('in the newuser application section, you may try again, or e-mail the sysop');
          sprint('on another local system.');
          nl;
        end;
        autovalidate1(thisuser,usernum);
        if thisuser.sl=systat.newsl then thisuser.deleted:=TRUE;
        if thisuser.deleted=TRUE then hangup:=TRUE;
        nl;
      end else if(systat.usenuv) then begin
        cls;
	nl;
	printf('nuvalert');
	if(nofile) then begin
	  sprint('^0To gain access, you will be voted on by the users of this system.  They will');
	  sprint('determine whether or not you will get access to this system.  You will need');
	  sprint('^3'+cstr(systat.nuvyes)+'^0 votes to be validated, and ^3'+cstr(systat.nuvno)+'^0 votes will delete your account.');
	  sprint('The users will vote of the infoform that you are about to fill out.  Good luck.');
	end;
        assign(nuvfile,systat.gfilepath+'nuv.dat');
        {$I-} reset(nuvfile); {$I+}
        if(ioresult<>0) then begin
          rewrite(nuvfile);
        end else begin
          done:=FALSE;
          while(not eof(nuvfile)) and (not done) do begin  { Find unused slot }
            read(nuvfile,thisnuv);
            if(not thisnuv.exists) then begin
              done:=TRUE;
              seek(nuvfile,filepos(nuvfile)-1);
            end;
          end;
        end;
        with thisnuv do begin
          unum:=usernum;
          handle:=thisuser.name;
          no:=0;
          yes:=0;
          totvoted:=0;
	  exists:=TRUE;
	  commentptr:=0;
        end;
        write(nuvfile,thisnuv);
        close(nuvfile);
        pausescr;
      end;
    end;

    reset(uf);
    seek(uf,usernum); write(uf,thisuser);
    close(uf);

    isr(thisuser.name,usernum);
    sprint(#3#4+' [ '+#3#0+'Saved'+#3#4' ]');
    repeat
      cls;
      nl; nl;
      sprint(#3#4+'ͻ');
      sprint(#3#4+' ^3Handle      -                                                               ^4');
      sprint(#3#4+' ^3User Number -                                                               ^4');
      sprint(#3#4+' ^3Password    -                                                               ^4');
      sprint(#3#4+'ͼ');
      ansig(17,4); sprompt(#3#1+'"'+#3#4+allcaps(thisuser.name)+#3#1+'"');
      ansig(17,5); sprompt(' '+#3#4+cstr(usernum)+#3#1);
      ansig(17,6); sprompt('"'+#3#4+thisuser.pw+#3#1+'"');
      ansig(1,8);
      nl;
      sprint(#3#4+'Ŀ');
      sprint(#3#4+'  '+#3#3+'Password Verification  '+#3#4+'');
      sprint(#3#4+'');
      sprompt(#3#0+'Password - '+#3#4); echo:=FALSE; input(pw,20); echo:=TRUE;
      if (pw<>thisuser.pw) then print(^G'WRONG!!'^G);
    until ((pw=thisuser.pw) or (hangup));
    nl; nl; nl;

    useron:=TRUE;
    window(1,1,80,25);
    clrscr;
    schangewindow(not cwindowon,systat.curwindow);

    if ((exist(systat.afilepath+'newuser.inf')) or
        (exist(systat.gfilepath+'newuser.inf'))) then
      readq('newuser',0);
    topscr;
(*    if (systat.newapp<>-1) then begin
      printf('newapp');
      irt:='New User Application';
    end; *)
    nl;
  end;
end;

procedure donewuseransi;
var t,trash:text;
    s1,s2:astr;
    s:string[255];
    code:char;
    mx,my,savx,savy:byte;
    sfo,good:boolean;
    sr:smalrec;
    i:integer;

  procedure num(mess:astr);
  var sx,sy:byte;
  begin
    sx:=wherex;  sy:=wherey;
    if(mx<>0) then begin
      ansig(mx,my);
      sprint(mess);
      ansig(sx,sy);
    end;
  end;

  procedure savxy;
  begin
    savx:=wherex; savy:=wherey;
  end;

  procedure resxy;
  begin
    ansig(savx,savy);
  end;

  procedure resaxy;
  begin
    ansig(savx+2,savy);
  end;

begin
  assign(t,systat.afilepath+'newapp.ans');
  reset(t);
  mx:=0; my:=0;
  thisuser.note:='Normal User';
  thisuser.computer:='';
  thisuser.calla:=0;
  thisuser.callb:=0;
  thisuser.callc:=0;
  thisuser.calld:=0;
  thisuser.calle:=0;
  thisuser.callf:=0;
  thisuser.callg:=0;
  thisuser.groups:='None known';
  thisuser.occupation:=spd;
  while((not eof(t)) and (not hangup)) do begin
    readln(t,s);
    while(s<>'') do begin
      if(s[1]='%') then begin
        code:=upcase(s[2]);
        s:=copy(s,3,length(s)-2);
        case code of
          'M':begin
                savxy;
                mx:=wherex;
                my:=wherey;
                resaxy;
              end;
          'H':begin
                savxy;
                if(newusername='') then begin
                  repeat
                    resxy;
                    input(thisuser.name,40);
                    good:=TRUE;
                    assign(trash,systat.afilepath+'trashcan.txt');
                    {$I-} reset(trash); {$I+}
                    if(ioresult=0) then begin
                      while(not eof(trash)) do begin
                        readln(trash,s1);
                        for i:=1 to length(s1) do s1[i]:=upcase(s1[i]);
                        s2:=thisuser.name;
                        for i:=1 to length(s2) do s2[i]:=upcase(s2[i]);
                        if(pos(s1,s2)<>0) then hangup:=TRUE;
                      end;
                      close(trash);
                    end;
                    if(not hangup) then begin
                      sfo:=(filerec(sf).mode<>fmclosed);
                      if(not sfo) then reset(sf);
                      for i:=1 to filesize(sf)-1 do begin
                        seek(sf,i);  read(sf,sr);
                        if(sr.name=thisuser.name) then begin
                          good:=FALSE;
                          num('That name is already in use!');
                        end;
                      end;
                    end;
                  until((good) or (hangup));
                end else begin
                  thisuser.name:=newusername;
                  sprint(newusername);
                end;
                resaxy;
              end;
          'R':begin
                savxy;
                repeat
                  resxy;
                  inputcaps(thisuser.realname,40);
                  if(pos(' ',thisuser.realname)=0) or (pos(' ',thisuser.realname)=length(thisuser.realname)) then begin
                    good:=FALSE;
                    num('You must enter your FULL name.');
                  end else begin
                    good:=TRUE;
                  end;
                until((good) or (hangup));
                resaxy;
              end;
          'P':begin
                savxy;
                inputph(thisuser.ph);
                resaxy;
              end;
          '$':begin
                savxy;
                input(thisuser.pw,20);
                resaxy;
              end;
          'Y':begin
                savxy;
                ansig(savx+length(fstring.newyes)-2,savy);
                thisuser.newyes:=pynq('');
                resaxy;
              end;
          'O':begin
                savxy;
                if(pynq('')) then ;
                resaxy;
              end;
          'L':begin
                savxy;
                thisuser.ld:=pynq('');
                resaxy;
              end;
          'C':begin
                savxy;
                inputl(thisuser.citystate,30);
                resaxy;
              end;
          'E':begin
                savxy;
                inputcaps(thisuser.wherebbs,40);
                resaxy;
              end;
          'S':begin
                savxy;
                input(thisuser.occupation,4);
                resaxy;
              end;
          'B':begin
                savxy;
                inputdate(thisuser.bday);
                resaxy;
              end;
          'Z':begin
                savxy;
                input(thisuser.zipcode,10);
                resaxy;
              end;
          '#':begin
                savxy;
                input(thisuser.street,2);
                resaxy;
              end;
          '1':begin
                assign(trash,'user.new');
                if(exist('user.new')) then append(trash) else rewrite(trash);
                inputl(s1,70);
                writeln(trash,thisuser.name);
                writeln(trash,'#1 - '+s1);
                close(trash);
              end;
          '2':begin
                assign(trash,'user.new');
                if(exist('user.new')) then append(trash) else rewrite(trash);
                inputl(s1,70);
                writeln(trash,'#2 - '+s1);
                close(trash);
              end;
          '3':begin
                assign(trash,'user.new');
                if(exist('user.new')) then append(trash) else rewrite(trash);
                inputl(s1,70);
                writeln(trash,'#3 - '+s1);
                close(trash);
              end;
        end;
      end else if(s[1]='@') then begin
        code:=upcase(s[2]);
        s:=copy(s,3,length(s)-2);
        case code of
          '-':begin
                savxy;
                sprompt(fstring.newyes);
                resaxy;
              end;
          '_':begin
                savxy;
                sprompt(fstring.guestline);
                resaxy;
              end;
        end;
      end else begin
        sprompt(s[1]);
        s:=copy(s,2,length(s)-1);
      end;
    end;
    nl;
  end;
  close(t);
  ansig(mx,my);
end;

procedure newuser;
var i,tries:integer;
    pw:astr;
begin
  if (systat.numusers>=5) and ((systat.bbsname<>regbbs) or (systat.sysopname<>regsysop)) then begin
    nl;
    nl;
    sprint(#3#0+'This is a DEMO copy of Insanity which allows a MAXIMUM of 5 users. This user');
    sprint(#3#0+'limit has been reached.  Please encourage your Sysop to register this copy of');
    sprint(#3#0+'Insanity v'+ver+'.  If you are interested in registering a copy, contact any');
    sprint(#3#0+'of our alpha or beta sites (listed in BBS listing), or contact from who/where');
    sprint(#3#0+'you received this demo copy.');
    pausescr;
    hangup:=TRUE;
  end;
  if (systat.numusers>=systat.maxusers) then begin
    sl1(#3#9+'Maximum user count has been reached.');
    printf('maximum');
    if (nofile) then sprint(#3#9+'The maximum number of users has been reached on this system.');
    hangup:=TRUE;
  end else begin
    if (systat.newuserpw<>'') then begin
      tries:=0; pw:='';
      while ((pw<>systat.newuserpw) and
	    (tries<systat.maxlogontries) and (not hangup)) do begin
	prt('Newuser Password  '); echo:=FALSE; input(pw,20); echo:=TRUE;
	if ((systat.newuserpw<>pw) and (pw<>'')) then begin
	  sl1(#3#8+'>>'+#3#1+' Illegal Newuser Password - "'+pw+'"');
	  inc(tries);
	end;
      end;
      if (tries>=systat.maxlogontries) then begin
	printf('nonewusr');
	hangup:=TRUE;
      end;
    end;

    if(exist(systat.afilepath+'newapp.ans')) then begin
      donewuseransi;
    end else begin
      p1;
    end;
    p2;
    if (systat.newapp<>-1) then begin
      reset(uf); i:=forwardm(systat.newapp); close(uf);
      if (i=0) then i:=systat.newapp;
      email1(i,'\Validation E-mail',FALSE,'','');
    end;
    inc(systat.todayzlog.newusers);
    wasnewuser:=TRUE;
  end;
  useron:=TRUE;
end;

procedure newuserinit(nam:astr);
var s:astr;
begin
  newusername:=nam;
  clrscr;
  window(1,1,80,25); gotoxy(1,1);
  tc(14); textbackground(1); clreol;
  if (spd<>'KB') then s:='  New User at '+spd+' Baud  '
    else s:='  New User on at Terminal  ';
  gotoxy(40-length(s) div 2,1); textbackground(4); write(s);
  tc(3); textbackground(0);
  window(1,1,80,25); gotoxy(1,2);
  if (systat.closedsystem) then begin
    printf('system');
    printf('nonewusr');
    hangup:=TRUE;
  end else begin
    with thisuser do begin
      name:='NEW USER';
      trapactivity:=FALSE;
      trapseperate:=FALSE;
    end;
    inittrapfile;
  end;
end;

end.
