(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *               Multi-node functions by RoboZapp - 10/23/92               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit multinod;

interface

uses
  crt, dos, overlay,
  common, timejunk;

procedure makenode(status:byte);
procedure makenodeon(name:astr; num:integer);
procedure whoson;
procedure sendnodemessage(node:byte; message:astr);
procedure readnodemessages;
procedure multichat(forum:byte);
procedure savenode;
procedure enternodemessage;
procedure entermultichat;

implementation

function pad(topad:astr; len:integer):astr;
var ps:astr;
begin
  if(length(topad)<len) then begin
    ps:=topad+copy('                                                                            ',1,len-length(topad));
  end else begin
    ps:=copy(topad,1,len);
  end;
  pad:=ps;
end;

function choosenode:byte;
var i:integer;
    node:noderec;
    gotvalnum:boolean;
begin
  assign(multinodef,'nodes.dat');
  reset(multinodef);
  nl;
  sprint(#3#4+'͸');
  seek(multinodef,0);
  for i:=1 to filesize(multinodef) do begin
    read(multinodef,node);
    sprint(#3#4+''+#3#0+pad(cstr(i),3)+#3#4+''+#3#0+pad(node.desc,20)+#3#4+
      ''+#3#0+pad(node.username+' #'+cstr(node.usernum),30)+#3#4+'');
  end;
  sprint(#3#4+';');
  gotvalnum:=FALSE;
  while(not gotvalnum) and (not hangup) do begin
    nl;
    prt(#3#4+'Node number: '); inu(i);
    if(i>0) and (i<=filesize(multinodef)) then begin
      gotvalnum:=TRUE;
      choosenode:=i;
    end else begin
      nl;
      sprint('Enter a number from 1-'+cstr(filesize(multinodef))+'.');
    end;
  end;
  close(multinodef);
end;

procedure makenode(status:byte);
begin
  assign(multinodef,'nodes.dat');
  reset(multinodef);
  nodeinfo.status:=status;
  seek(multinodef,thisnode-1);
  write(multinodef,nodeinfo);
  close(multinodef);
end;

procedure makenodeon(name:astr; num:integer);
begin
  assign(multinodef,'nodes.dat');
  reset(multinodef);
  nodeinfo.username:=name;
  nodeinfo.usernum:=num;
  seek(multinodef,thisnode-1);
  write(multinodef,nodeinfo);
  close(multinodef);
end;

procedure whoson;
var i:integer;
    node:noderec;
    s:astr;
begin
  assign(multinodef,'nodes.dat');
  reset(multinodef);
  nl;
  sprint(#3#9+'Node                 User                           Status');
  sprint(#3#4+'  ');
  seek(multinodef,0);  { Node 1 }
  for i:=1 to filesize(multinodef) do begin
    read(multinodef,node);
    case node.status of
      0:s:='Down';
      1:s:='Waiting for caller';
      2:s:='Logging in';
      3:s:='Menuing';
      4:s:='Uploading';
      5:s:='Downloading';
      6:s:='Entering a message';
      7:s:='Reading a message';
     11..20:s:='Chat forum #'+cstr(node.status-10);
    end;
    sprint(#3#0+pad(node.desc,20)+' '+#3#6+pad(node.username+' #'+cstr(node.usernum),30)+' '+#3#5+s);
  end;
  nl;
  close(multinodef);
end;

procedure sendnodemessage(node:byte; message:astr);
var nmf:file of nodemessrec;
    at:integer;
    nm:nodemessrec;
begin
  assign(nmf,'nodemess.dat');
  {$I-} reset(nmf); {$I+}
  at:=0;
  if(ioresult<>0) then begin
    rewrite(nmf);
  end else begin
    read(nmf,nm);
    while(not eof(nmf)) and (not nm.deleted) do begin
      inc(at);
      read(nmf,nm);
    end;
    if(not nm.deleted) then inc(at);
  end;
  seek(nmf,at);
  with nm do begin
    mess:=message;
    deleted:=FALSE;
    nodeto:=node;
    nodefrom:=thisnode;
    namefrom:=thisuser.name;
    numfrom:=usernum;
  end;
  write(nmf,nm);
  close(nmf);
end;

procedure readnodemessages;
var nmf:file of nodemessrec;
    nm:nodemessrec;
begin
  assign(nmf,'nodemess.dat');
  {$I-} reset(nmf); {$I+}
  if(ioresult=0) then begin
    while(not eof(nmf)) do begin
      read(nmf,nm);
      if(not nm.deleted) and (nm.nodeto=thisnode) then begin
        nl;
        sprint(#3#5+nm.namefrom+' #'+cstr(nm.numfrom)+#3#4+' on node #'+#3#3+cstr(nm.nodefrom)+#3#5+' says,');
        sprint(#3#4+'"'+#3#3+nm.mess+#3#4+'"');
        nm.deleted:=TRUE;
        seek(nmf,filepos(nmf)-1);
        write(nmf,nm);
      end;
    end;
    close(nmf);
  end;
end;

procedure multichat(forum:byte);
var forumf:file of forumrec;
    jaf:file of byte;
    ourfile,theirfile:text;
    theirnames:array[1..25] of astr;
    theirflags:array[1..25] of boolean;
    theirat:array[1..25] of longint;
    theirnodes:array[1..25] of integer;
    jafat:longint;
    numtheir,i,i1,good,jafr,sp:byte;
    ourforum,theirforum:forumrec;
    said,leftover,garb:astr;
    done,donesaid:boolean;
    fdt,sdt:ldatetimerec;
    c:char;
begin
  cls;
  sprint(#3#4+' '+#3#0+'Insanity MultiNode Chat (c) 1993,95 RoboZapp');
  sprint(#3#4+' '+#3#0+'Entering forum #'+cstr(forum)+'...');
  sprint(#3#4+' '+#3#0+'/Q = Quit  -  /W = Who''s on  -  /S = Send node message');
  nl;
  makenode(forum+10);

  assign(ourfile,'multicht.'+cstr(thisnode));
  rewrite(ourfile);
  close(ourfile);
  append(ourfile);

  assign(forumf,'forum'+cstr(forum)+'.gen');
  {$I-} reset(forumf); {$I+}
  if(ioresult<>0) then begin
    rewrite(forumf);
    close(forumf);
    reset(forumf);
  end;

  if(filesize(forumf)>=25) then begin
    sprint(#3#4+' '+#3#6+'Forum full!');
    close(ourfile);
    close(forumf);
    exit;
  end;

  good:=255;
  if(filesize(forumf)>0) then begin
    for i:=0 to filesize(forumf)-1 do begin
      if(good=255) then begin
        seek(forumf,i);
        read(forumf,theirforum);
        if(theirforum.deleted) then good:=i;
      end;
    end;
  end;
  if(good=255) then good:=filesize(forumf);

  ourforum.user:=thisuser.name;
  ourforum.deleted:=FALSE;
  ourforum.node:=thisnode;

  seek(forumf,good);
  write(forumf,ourforum);
  close(forumf);
  reset(forumf);

  assign(jaf,'forum'+cstr(forum)+'.jaf');
  {$I-} reset(jaf); {$I+}
  if(ioresult<>0) then begin
    rewrite(jaf);
    close(jaf);
    reset(jaf);
  end;
  seek(jaf,filesize(jaf));
  i:=1;
  write(jaf,i);
  write(jaf,good);
  jafat:=filesize(jaf);
  close(jaf);

  for i:=0 to 25 do begin
    theirflags[i]:=FALSE;
  end;
  for i:=0 to filesize(forumf)-1 do begin
    read(forumf,theirforum);
    if(not theirforum.deleted) and (theirforum.node<>thisnode) then begin
      theirflags[i]:=TRUE;
      theirnames[i]:=theirforum.user;
      theirnodes[i]:=theirforum.node;
      assign(theirfile,'multicht.'+cstr(theirforum.node));
      reset(theirfile);
      theirat[i]:=0;
      while(not eof(theirfile)) do begin
        readln(theirfile,garb);
        inc(theirat[i]);
      end;
      close(theirfile);
    end;
  end;
  close(forumf);

  done:=FALSE;
  leftover:='';

  while(not done) and (not hangup) do begin

    readnodemessages;

    reset(jaf);
    seek(jaf,jafat);
    while(not eof(jaf)) do begin
      jafat:=jafat+2;
      read(jaf,jafr);
      reset(forumf);
      if(jafr=0) then begin
        read(jaf,jafr);
        sprint(#3#4+' '+#3#6+theirnames[jafr]+' left.');
        theirflags[jafr]:=FALSE;
      end else begin
        read(jaf,jafr);
        seek(forumf,jafr);
        read(forumf,theirforum);
        sprint(#3#4+' '+#3#6+theirforum.user+' joined the forum.');
        theirflags[jafr]:=TRUE;
        theirnames[jafr]:=theirforum.user;
        theirnodes[jafr]:=theirforum.node;
        assign(theirfile,'multicht.'+cstr(theirforum.node));
        reset(theirfile);
        theirat[jafr]:=0;
        while(not eof(theirfile)) do begin
          inc(theirat[jafr]);
          readln(theirfile,garb);
        end;
        close(theirfile);
      end;
      close(forumf);
    end;
    close(jaf);

    for i:=0 to 25 do begin
      if(theirflags[i]) then begin
        assign(theirfile,'multicht.'+cstr(theirnodes[i]));
        reset(theirfile);
        for i1:=1 to theirat[i] do begin
          readln(theirfile,garb);
        end;
        while(not eof(theirfile)) do begin
          readln(theirfile,said);
          sprint(#3#3+theirnames[i]+#3#0+'> '+#3#4+said);
          inc(theirat[i]);
        end;
        close(theirfile);
      end;
    end;

    if(leftover='') then begin
      c:=#0;
      if(keypressed) then c:=inkey
      else if(incom) then c:=cinkey;
      if(c in [' '..'~']) then leftover:=c;
    end;

    if(leftover='/') then begin
      leftover:='';
      sprompt(#3#3+'Multinode Chat Command'+#3#0+'> '+#3#4);
      getkey(c);
      c:=upcase(c);
      case c of
        'Q':begin
              sprint('Quit');
              done:=TRUE;
            end;
        'W':begin
              sprint('Who''s on');
              whoson;
            end;
        'S':begin
              sprint('Send node message');
              enternodemessage;
            end;
        else begin
          for i:=1 to 80 do begin
            sprompt(^H+' '+^H);
          end;
        end;
      end;
    end;

    if(leftover<>'') then begin
      sprompt(#3#3+thisuser.name+#3#0+'> '+#3#4+leftover);
      said:=leftover;
      donesaid:=FALSE;
      repeat
        getkey(c);
        case c of
          ' '..'~':begin
                     if(length(said)>75-length(thisuser.name)) then begin
                       donesaid:=TRUE;
                       sp:=0;
                       for i:=1 to length(said) do begin
                         if(said[i]=' ') then sp:=i;
                       end;
                       if(sp<>0) then begin
                         leftover:=copy(said,sp+1,length(said)-sp)+c;
                         said:=copy(said,1,sp-1);
                         for i:=1 to length(leftover) do begin
                           sprompt(^H+' '+^H);
                         end;
                       end else begin
                         leftover:='';
                         said:=said+c;
                         sprompt(c);
                       end;
                     end else begin
                       sprompt(c);
                       said:=said+c;
                     end;
                   end;
          ^H:begin
               if(length(said)>0) then begin
                 sprompt(^H+' '+^H);
                 said:=copy(said,1,length(said)-1);
               end;
             end;
          ^M:begin
               donesaid:=TRUE;
               leftover:='';
             end;
        end;
      until(donesaid) or (hangup);
      nl;
      writeln(ourfile,said);
      close(ourfile);
      append(ourfile);
    end;
  end;

  ourforum.deleted:=TRUE;
  reset(forumf);
  seek(forumf,good);
  write(forumf,ourforum);
  close(forumf);
  i:=0;
  reset(jaf);
  seek(jaf,jafat);
  write(jaf,i);
  write(jaf,good);
  close(jaf);

  close(ourfile);

  cls;
  sprint(#3#4+' '+#3#6+'Forum abandoned');
end;

procedure savenode;
begin
  reset(multinodef);
  seek(multinodef,thisnode-1);
  write(multinodef,nodeinfo);
  close(multinodef);
end;

procedure enternodemessage;
var node,i:integer;
    mess:astr;
begin
  if(thisuser.sl=255) then begin
    if(pynq('Use loudspeaker? [No] ')) then begin
      node:=1001;
    end else begin
      node:=choosenode;
    end;
  end else begin
    node:=choosenode;
  end;
  nl;
  sprint(#3#3+'Enter message to send');
  prt(#3#4+' ');
  inputl(mess,75);
  if(node<>1001) then begin
    sendnodemessage(node,mess);
  end else begin
    assign(multinodef,'nodes.dat');
    reset(multinodef);
    for i:=1 to filesize(multinodef) do begin
      sendnodemessage(i,mess);
    end;
    close(multinodef);
  end;
end;

procedure entermultichat;
var i:integer;
begin
  sprint(#3#3+'Chat forum to enter?  (1-10)');
  prt(#3#4+' ');
  inu(i);
  if(i>0) and (i<11) then begin
    multichat(i);
  end else begin
    sprint(#3#3+'Aborted.');
  end;
end;

end.

