(********************************************************************************
*  Mouse Functions - RoboZapp 8/25/92                                           *
********************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}

unit mouse;

interface

uses
  crt, dos, common;

function initmouse:boolean;
procedure lightpenon;
procedure lightpenoff;
function leftbutton:boolean;
function middlebutton:boolean;
function rightbutton:boolean;
function mcolumn:integer;
function mrow:integer;

implementation

var hasvga,subinst,isdisp:boolean;
    savx,savy,savpar,savseg,savoff,vgaseg,vgaoff:word;
    savchar:array[1..6] of byte;

const screenmask:array[1..16] of word = (
  $ffff, (* 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 *)
  $f3ef, (* 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 *)
  $f3ef, (* 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 *)
  $f3ef, (* 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 *)
  $f3ef, (* 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 *)
  $f3ef, (* 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 *)
  $100c, (* 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 *)
  $180c, (* 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 *)
  $100c, (* 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 *)
  $f3ef, (* 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 *)
  $f3ef, (* 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 *)
  $f3ef, (* 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 *)
  $f3ef, (* 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 *)
  $f3ef, (* 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 *)
  $ffff, (* 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 *)
  $ffff  (* 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 *) );
cursormask:array[1..16] of word = (
 $0000,  (* 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 *)
 $0000,  (* 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 *)
 $0800,  (* 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 *)
 $0800,  (* 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 *)
 $0800,  (* 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 *)
 $0800,  (* 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 *)
 $0000,  (* 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 *)
 $c3e1,  (* 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 0 *)
 $0000,  (* 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 *)
 $0800,  (* 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 *)
 $0800,  (* 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 *)
 $0800,  (* 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 *)
 $0800,  (* 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 *)
 $0000,  (* 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 *)
 $0000,  (* 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 *)
 $0000   (* 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 *) );

function initmouse:boolean;
var regs:registers;
    state:array[1..32] of integer;
    funct:^byte;
begin
  subinst:=FALSE;

  hasvga:=FALSE;   (*  FALSE until I can get the writing the new chars right  *)
  regs.ax:=$1b00;
  regs.bx:=$0000;
  regs.es:=seg(state);
  regs.di:=ofs(state);
  intr($10,regs);
  if((regs.ax and $ff)<>$1b) then hasvga:=FALSE;
  funct:=ptr(state[2],state[1]+2);
  if((funct^ and $08)<>$08) then hasvga:=FALSE;

  if(hasvga) then begin
    regs.ax:=$1130;
    regs.bx:=$0600;
    intr($10,regs);
    vgaseg:=regs.es;
    vgaoff:=regs.bp;
  end;

  regs.ax:=0;
  intr($33,regs);
  if(regs.ax=$ffff) then begin
    initmouse:=TRUE;
  end else begin
    initmouse:=FALSE;
  end;
end;

procedure showvgamouse;
var regs:registers;
    vseg,off:word;
    i,i1,xoff,yoff,xp,yp:integer;
    mask:byte;
begin
  if(not isdisp) then begin
    isdisp:=TRUE;
    if(mem[0:$499]=7) then vseg:=$b000 else vseg:=$b800;
    regs.ax:=$03;
    intr($33,regs);
    savx:=round(regs.cx/8)+1;
    savy:=round(regs.dx/8)+1;
    off:=((savy-1)*80+savx-1)*2;
    savchar[1]:=mem[vseg:off];  savchar[2]:=mem[vseg:off+2];  savchar[3]:=mem[vseg:off+4];
    savchar[4]:=mem[vseg:off+160];  savchar[5]:=mem[vseg:off+162];  savchar[6]:=mem[vseg:off+164];

    xoff:=regs.cx mod 8;
    yoff:=regs.dx mod 8;
    xp:=0;  yp:=0;
    for i:=1 to 6 do begin
      for i1:=0 to 15 do begin
        if(yp+i1>=yoff) and (yp+i1<yoff+16) then begin  (* in y range? *)
          if(xp<xoff+16) then begin  (* in x range? *)
            if(xoff>xp) then begin
              mask:=screenmask[yp+i1-yoff] shr (xoff);
              if(xoff<>0) then
                mask:=mask or $FF shl (8-xoff);
              mem[vgaseg:vgaoff+i*16+i1]:=mem[vgaseg:vgaoff+savchar[i]*16+i1] and mask;
              mask:=cursormask[yp+i1-yoff] shr (xoff);
              mem[vgaseg:vgaoff+i*16+i1]:=mem[vgaseg:vgaoff+i*16+i1] or mask;
            end else begin
            end;
          end;
        end;
      end;
      if(i=3) or (i=6) then begin  (* new row *)
        yp:=yp+16;
        xp:=0;
      end else begin
        xp:=xp+8;
      end;
    end;

    regs.ax:=$1110;  (* write new video patterns for chars 1-6 *)
    regs.es:=vgaseg;
    regs.bp:=vgaoff+16;
    regs.cx:=6;
    regs.dx:=1;
    regs.bx:=$1000;
    intr($10,regs);

    mem[vseg:off]:=1;  mem[vseg:off+2]:=2;  mem[vseg:off+4]:=3;
    off:=off+160;
    mem[vseg:off]:=4;  mem[vseg:off+2]:=5;  mem[vseg:off+4]:=6;
  end;
end;

procedure hidevgamouse;
var vseg,off:word;
begin
  if(isdisp) then begin
    isdisp:=FALSE;
    if(mem[0:$499]=7) then vseg:=$b000 else vseg:=$b800;
    off:=((savy-1)*80+savx-1)*2;
    mem[vseg:off]:=savchar[1];  mem[vseg:off+2]:=savchar[2];  mem[vseg:off+4]:=savchar[3];
    off:=off+160;
    mem[vseg:off]:=savchar[4];  mem[vseg:off+2]:=savchar[5];  mem[vseg:off+4]:=savchar[6];
  end;
end;

procedure handlemove;
var regs:registers;
begin
  hidevgamouse;
  showvgamouse;
end;

procedure lightpenon;
var regs:registers;
begin
  if(not hasvga) then begin
    regs.ax:=$0d;
    intr($33,regs);
    regs.ax:=1;
    intr($33,regs);
  end else begin
    if(not subinst) then begin
      subinst:=TRUE;
      isdisp:=FALSE;
      regs.ax:=$14;
      regs.cx:=$01;
      regs.es:=seg(handlemove);
      regs.dx:=ofs(handlemove);
      intr($33,regs);
      savpar:=regs.cx;
      savseg:=regs.es;
      savoff:=regs.dx;
    end;
  end;
end;

procedure lightpenoff;
var regs:registers;
begin
  if(not hasvga) then begin
    regs.ax:=2;
    intr($33,regs);
  end else begin
    if(subinst) then begin
      subinst:=FALSE;
      regs.ax:=$14;
      regs.cx:=savpar;
      regs.es:=savseg;
      regs.dx:=savoff;
      intr($33,regs);
      hidevgamouse;
    end;
  end;
end;

function leftbutton:boolean;
var regs:registers;
begin
  regs.ax:=3;
  intr($33,regs);
  if((regs.bx and 1)=1) then begin
    leftbutton:=TRUE;
  end else begin
    leftbutton:=FALSE;
  end;
end;

function middlebutton:boolean;
var regs:registers;
begin
  regs.ax:=3;
  intr($33,regs);
  if((regs.bx and 4)=4) then begin
    middlebutton:=TRUE;
  end else begin
    middlebutton:=FALSE;
  end;
end;

function rightbutton:boolean;
var regs:registers;
begin
  regs.ax:=3;
  intr($33,regs);
  if((regs.bx and 2)=2) then begin
    rightbutton:=TRUE;
  end else begin
    rightbutton:=FALSE;
  end;
end;

function mcolumn:integer;
var regs:registers;
begin
  regs.ax:=3;
  intr($33,regs);
  if(not hasvga) then
    mcolumn:=round(regs.cx/8)+1
  else
    mcolumn:=round(regs.cx/8)+2;
end;

function mrow:integer;
var regs:registers;
begin
  regs.ax:=3;
  intr($33,regs);
  if(not hasvga) then
    mrow:=round(regs.dx/8)+1
  else
    mrow:=round(regs.dx/8)+2;
end;

end.