{*****************************************************************************
 *                                                                           *
 * Menus.Pas -                                                               *
 *      Menu Command Execution Routines.                                     *
 *                                                                           *
 * Modification History                                                      *
 * ====================                                                      *
 *   06/2/92 - 2.1 - Revision (a)                                            *
 *                                                                           *
 *   08/18/92 - 2.2 - Conferences - Revision (b)                             *
 *                                                                           *
 *   08/30/92 - 2.2 - ANSI Fonts - Revision (c)                              *
 *                                                                           *
 *****************************************************************************}

{$A+,B+,D-,E+,F+,I+,L+,N-,O-,R-,S+,V-}
Unit Menus;


Interface

Uses
  Crt,      Dos,      OverLay,  InitP,    Sysop1,   Sysop2,   Sysop3,
  Sysop4,   Sysop5,   Sysop6,   Sysop7,   Sysop8,   Sysop9,   Sysop10,
  Sysop11,  Mail0,    Mail1,    Mail2,    Mail3,    Mail4,    Mail5,
  Mail6,    Mail9,    File0,    File1,    File2,    File3,    File4,
  File5,    File6,    File7,    File8,    File9,    File10,   File11,
  File12,   File13,   File14,   Archive1, Archive2, Archive3, Misc1,
  Misc2,    Misc3,    Misc4,    MiscX,    CUser,    Doors,    Menus2,
  Menus3,   Menus4,   MyIO,     Common,   Sysop12,  Sysop13,  Confer,
  persdata, Sysop14,  Ansifont, Multinod, Mail7;

Var Rumfile:file of rumrec;
    bignote:string[12];


procedure nuv;
Procedure readin2;
Procedure mainmenuhandle(var cmd:string);
Procedure fcmd(cmd:string; var i:integer; noc:integer;
	       var cmdexists,cmdnothid:boolean);
Procedure domenuexec(cmd:string; var newmenucmd:string);
Procedure domenucommand(var done:boolean; cmd:string; var newmenucmd:string);
Procedure exescript(scriptfile:string);

Implementation

procedure nuv;
var nuvfile:file of nuvrec;
    i,max,nuf:integer;
    thisnuv:nuvrec;
    s:astr;
    done:boolean;
    vote:char;
    u:userrec;

  function checkvote:boolean;
  var i1:integer;
      checkstat:boolean;
  begin
    checkstat:=FALSE;
    for i1:=1 to thisnuv.totvoted do begin
      if(thisnuv.votedby[i1]=usernum) then begin
	checkstat:=TRUE;
      end;
    end;
    checkvote:=checkstat;
  end;

  function nuvreal:integer;
  var sofar:integer;
  begin
    seek(nuvfile,0);
    sofar:=0;
    while(not eof(nuvfile)) do begin
      read(nuvfile,thisnuv);
      if(thisnuv.exists) then inc(sofar);
    end;
    nuvreal:=sofar;
  end;

  procedure listnuv;
  var sofar:integer;
      votedon:boolean;
  begin
    seek(nuvfile,0);
    sprint('^4ͻ');
    sprint('^4^3###^4 ^0 Newusers                            ^4');
    sprint('^4Ķ');
    sofar:=0;
    while(not eof(nuvfile)) do begin
      read(nuvfile,thisnuv);
      if(thisnuv.exists) then begin
	inc(sofar);
	sprompt('^4^3'+mn(sofar,3)+'^4^7');
	votedon:=checkvote;
	if(votedon) then begin
	  sprompt('  ');
	end else begin
	  sprompt(' ');
	end;
	sprint('^5'+mln(caps(thisnuv.handle),36)+'^4');
      end;
    end;
    sprint('^4ͼ^0');
  end;

  procedure deletecomments(commptr:integer);
  var cf:file of nuvcomrec;
      thiscomm:nuvcomrec;
  begin
    assign(cf,systat.gfilepath+'nuvcmnt.dat');  reset(cf);
    while(commptr<>0) do begin
      seek(cf,commptr);
      read(cf,thiscomm);
      thiscomm.exists:=FALSE;
      seek(cf,commptr);
      write(cf,thiscomm);
      commptr:=thiscomm.nextcomment;
    end;
    close(cf);
  end;

  procedure valuser;
  begin
    sprint('^4 ^3User validated ^4');
    thisnuv.exists:=FALSE;
    reset(uf);
    seek(uf,thisnuv.unum);
    read(uf,u);
    autovalidate(u,thisnuv.unum);
    seek(uf,thisnuv.unum);
    write(uf,u);
    close(uf);
    if(thisnuv.commentptr<>0) then deletecomments(thisnuv.commentptr);
  end;

  procedure deluser;
  begin
    sprint('^4 ^3User deleted ^4');
    thisnuv.exists:=FALSE;
    reset(uf);
    seek(uf,thisnuv.unum);
    read(uf,u);
    u.deleted:=TRUE;
    seek(uf,thisnuv.unum);
    write(uf,u);
    close(uf);
    if(thisnuv.commentptr<>0) then deletecomments(thisnuv.commentptr);
  end;

  procedure readcomments(commptr:integer);
  var cf:file of nuvcomrec;
      thiscomm:nuvcomrec;
  begin
    assign(cf,systat.gfilepath+'nuvcmnt.dat');  reset(cf);
    while(commptr<>0) do begin
      seek(cf,commptr);
      read(cf,thiscomm);
      sprint('^4 ^5'+caps(thiscomm.user)+'^3 says...');
      sprint('^4"^3'+thiscomm.comm+'^4"');
      commptr:=thiscomm.nextcomment;
    end;
    close(cf);
  end;

  procedure chkforcmnt;
  var cf:file of nuvcomrec;
      thiscomm:nuvcomrec;
      newcommptr,at,commat,lastat:longint;
      done:boolean;
  begin
    if(pynq('Would you like to add a comment? [No] ')) then begin
      assign(cf,systat.gfilepath+'nuvcmnt.dat');  {$I-} reset(cf); {$I+}
      if(ioresult<>0) then begin
	rewrite(cf);
	thiscomm.comm:='Dummy comment';
	thiscomm.user:='NOBODY';
	thiscomm.exists:=TRUE;
	thiscomm.nextcomment:=0;
        write(cf,thiscomm);
	close(cf);
	reset(cf);
      end;
      newcommptr:=filesize(cf);
      at:=0;  done:=FALSE;
      while(not eof(cf)) and (not done) do begin
	read(cf,thiscomm);
	if(not thiscomm.exists) then begin
	  done:=TRUE;  newcommptr:=at;
	end;
	inc(at);
      end;
      thiscomm.user:=thisuser.name;
      thiscomm.nextcomment:=0;
      thiscomm.exists:=TRUE;
      sprint('^3Enter your comment on this user');
      sprompt('^4 ^3');
      inputl(thiscomm.comm,77);
      if(thiscomm.comm<>'') then begin
	seek(cf,newcommptr);
	write(cf,thiscomm);
	if(thisnuv.commentptr<>0) then begin
	  commat:=thisnuv.commentptr;
	  repeat
	    lastat:=commat;
	    seek(cf,commat);
	    read(cf,thiscomm);
	    commat:=thiscomm.nextcomment;
	  until(commat=0);
	  thiscomm.nextcomment:=newcommptr;
	  seek(cf,lastat);
	  write(cf,thiscomm);
	end else begin
	  thisnuv.commentptr:=newcommptr;
	end;
      end;
      close(cf);
    end;
  end;

begin
  nl;
  sprint('^4ͻ');
  sprint('^4  ^0New User Voting                         ^4');
  sprint('^4ͼ');
  assign(nuvfile,systat.gfilepath+'nuv.dat');
  {$I-} reset(nuvfile); {$I+}
  if(ioresult<>0) then begin
    rewrite(nuvfile);
  end;
  max:=nuvreal;
  if(max=0) then begin
    sprint('^4 ^0No users to vote on ^4');
  end else begin
    listnuv;
    done:=FALSE;
    while (not done) and (not hangup) do begin
      nl;
      sprompt('^3Number to vote on ^4[^31-'+cstr(max)+'^4] [^3Q=Quit^4] [^3?=list^4]  ^5');
      input(s,3);
      if(s='Q') then begin
	done:=TRUE;
      end;
      if(s='?') then listnuv;
      if(value(s)>=1) and (value(s)<=max) then begin
	nuf:=0;
	seek(nuvfile,0);
	while(nuf<value(s)) do begin
	  read(nuvfile,thisnuv);
	  if(thisnuv.exists) then inc(nuf);
	end;
	seek(nuvfile,filepos(nuvfile)-1);
	if(pynq('Read newuser infoform answers? [No] ')) then begin
	  readasw(thisnuv.unum,'newuser');
          pausescr;
	end;
	nl;
	if(thisnuv.commentptr<>0) then begin
	  readcomments(thisnuv.commentptr);
	end;
	nl;
	sprint('^3Yes votes so far      ^4 ^5'+cstr(thisnuv.yes));
	sprint('^3No votes so far       ^4 ^5'+cstr(thisnuv.no));
	nl;
	sprint('^3Yes votes to validate ^4 ^5'+cstr(systat.nuvyes));
	sprint('^3No votes to delete    ^4 ^5'+cstr(systat.nuvno));
	nl;
	if(checkvote) and (thisuser.sl<>255) then begin
	  sprint('^4 ^3You already voted on this user ^4');
	end else begin
	  if (fso) then begin
	    sprompt('^3Your vote? ^4[^5Y^3es^4/^5N^3o^4/^5A^3bstain^4/^5V^3alidate^4/^5D^3elete^4]  ^5');
	    onek(vote,'YNAVD');
	  end else begin
	    sprompt('^3Your vote? ^4[^5Y^3es^4/^5N^3o^4/^5A^3bstain^4]  ^5');
	    onek(vote,'YNA');
	  end;
	  case vote of
	    'Y':begin
		  inc(thisnuv.totvoted);
		  thisnuv.votedby[thisnuv.totvoted]:=usernum;
		  inc(thisnuv.yes);
		  if(thisnuv.yes>=systat.nuvyes) then begin
		    valuser;
		  end else begin
		    chkforcmnt;
		  end;
		end;
	    'N':begin
		  inc(thisnuv.totvoted);
		  thisnuv.votedby[thisnuv.totvoted]:=usernum;
		  inc(thisnuv.no);
		  if(thisnuv.no>=systat.nuvno) then begin
		    deluser;
		  end else begin
		    chkforcmnt;
		  end;
		end;
	    'V':begin
		  if (fso) then begin
		    valuser;
		  end;
		end;
	    'D':begin
		  if (fso) then begin
		    deluser;
		  end;
		end;
	  end;
	  write(nuvfile,thisnuv);  { Write changes to disk }
	  close(nuvfile);
	  reset(nuvfile);
	  max:=nuvreal;  { Recalculate # of valid users to vote on }
	end;
      end;
    end;
  end;
  close(nuvfile);
end;


procedure baudreport;
var zf:file of zlogrec;
    d1:zlogrec;
    s:astr;
    daysto:integer;
    highnum,cc,c,blockcount,i:integer;
    blockchar:string[3];
    blockline:string[75];
    abort,next:boolean;
    baud:array[0..8] of integer;
begin
  nl;
  assign(zf,systat.gfilepath+'zlog.dat');
  {$I-} reset(zf); {$I+}
  if (ioresult<>0) then print('ZLOG.DAT not found.')
  else begin
    sprompt('Number of days to report over : ');
    inu(daysto);
    if (not badini) then begin
    for c:=0 to 8 do baud[c]:=0;
    abort:=FALSE;
    read(zf,d1);
    sprint(#3#5+'                      '+cstr(daysto)+' Day Baud Report');
    nl;
    i:=-1;
    {seek(zf,0);}
    while (((i<=daysto-2) and (not abort)) or (not eof(zf))) do begin
      if (i>=0) then begin
	seek(zf,i);
	read(zf,d1);
	blockchar:=#3#3+'';
      end else begin
	d1:=systat.todayzlog;
	blockchar:=#3#3+'';
      end;
      for c:=0 to 8 do baud[c]:=baud[c]+d1.userbaud[c];
      inc(i);
    end; 

    {for c:=0 to 8 do baud[c]:=(baud[c] div 5);}
    
    highnum:=daysto*50;
    cc:=highnum+(highnum div 10);
    repeat
      cc:=cc-(highnum div 10);
      sprompt(#3#0+mln(cstr(cc),3)+' ');
      for c:=0 to 8 do
	if baud[c]>=cc then sprompt(blockchar+blockchar+'    ') else
	sprompt('      ');
      nl;
    until (cc<=(highnum div 10));
    {
    cc:=10;
    sprompt(#3#0+mln(cstr(cc),3)+' ');
    for c:=0 to 8 do
      if baud[c]>=cc then sprompt(blockchar+blockchar+'    ') else
      sprompt('      ');
    nl;
    }
    sprint(#3#0+'    300  1200  2400  4800  7200  9600  12.0  14.4  16.8');
    sprint(#3#5+'                         Baud Rate');
    for c:=0 to 8 do sprompt(cstr(baud[c])+'  ');
    close(zf);
    end;
  end;
end;

procedure TopTen;

      type
	   HighestPCR=
	   record
	     Name:string[36];
	     PCR:longint;
	   end;

      type
	   Tp=Array[1..10] of HighestPCR;

  Var done:boolean;
      TMPrec:userrec;
      blah:integer;
      uf:file of userrec;
      upnum,downnum,Uploaders,Downloaders:Tp;
      TmpPost:highestpcr;
      inputt:string[2];
      numusers,X1:Integer;
      shithead:string[55];

 Procedure InitIt;
 Var A,B,C,D,E,Cnt,UpToDown:LongInt;

     Procedure SortIt(Var ArofIt:Tp; Tempo:LongInt; UpOrDown:Boolean);
     Var Cnt,I:Integer;
     Begin
       Done:=False;
       For Cnt:=1 to 10 Do
       Begin
	 If UpOrDown then
	   Begin
	   If not Done and (Tempo>=ArofIt[Cnt].Pcr) then
	   Begin
	     If Cnt<10 then
	       For I:=9 downto cnt do ArofIt[I+1]:=ArofIt[I];
	     ArofIt[Cnt].Name:=TmpRec.name;
	     ArofIt[Cnt].PCR:=Tempo;
	     Done:=True;
	   End;
	   End
	 Else
	   If Not Done and (Tempo<ArofIt[Cnt].PCR) then
	   Begin
	    If Cnt>1 then
	      For I:=9 downto cnt do ArofIt[I+1]:=ArofIt[I];
	      ArofIt[Cnt].Name:=TmpRec.name;
	      ArofIt[Cnt].PCR:=Tempo;
	      Done:=True;
	    End;
       End;
     End;



   begin
     nl;
     sprompt(#3#0+'Calculating Statistics...');
       assign(uf,systat.gfilepath+'user.lst');
       reset(uf);
       numusers:=0;
       repeat
	 inc(numusers);
	 seek(uf,numusers);
	 read(uf,tmprec);
       until eof(uf);
       close(uf);
       for cnt:=1 to 10 do begin
	downnum[cnt].pcr:=0;
	downnum[cnt].name:='';
	upnum[cnt].pcr:=0;
	upnum[cnt].name:='';
	Downloaders[cnt].pcr:=0;
	downloaders[cnt].name:='';
	uploaders[cnt].pcr:=0;
	uploaders[cnt].name:='';
       end;
     for cnt:=1 to numusers do begin
      reset(uf);
      seek(uf,cnt);
      read(uf,TmpRec);
	begin
	  d:=tmprec.Uk;
	  SortIt(Uploaders,D,True);
	  d:=tmprec.DK;
	  SortIt(Downloaders,D,True);
	  d:=tmprec.downloads;
	  sortit(downnum,d,true);
	  d:=tmprec.uploads;
	  sortit(upnum,d,true);
	End;
      End;
      sprint(#3#0+'Done!');
    End;

     Procedure ShowSomething(TempOr:Tp; ToSay:string; SayK:Byte);
     Var Cnt:Integer;
	 limit:longint;
     Begin
       nl;
       limit:=999;
       sprint(#3#0+ToSay);
       sprint(#3#4+'ͻ');
       For Cnt:=1 to 10 Do
	 Begin
	   shithead:=#3#4+' '+#3#4+mln(cstr(Cnt)+'.',3)+' '+#3#0+caps(TempOr[Cnt].Name);
	   sprompt(mln(shithead,40));
	   if ((sayk=2) and (tempor[cnt].pcr>limit)) then begin
	     tempor[cnt].pcr:=tempor[cnt].pcr div 1000;
	     sayk:=4;
	   end;
	   shithead:=' - '+cstr(TempOr[Cnt].PCR);
	   if SayK=1 then shithead:=shithead+#3#3+' %';
	   If SayK=2 then shithead:=shithead+#3#3+' k';
	   if SayK=3 then shithead:=shithead+#3#3+'  ';
	   if SayK=4 then shithead:=shithead+#3#3+' M';
	   sprompt(mln(shithead,11));
	   sprint(#3#4+' ');
	   if sayk=4 then sayk:=2;
	 End;
       sprint(#3#4+'ͼ');
       pausescr;
     End;

     Begin
     InitIt;
     nl;
     sprint(#3#0+'Insanity v'+ver+' Top 10 Listing');
     nl;
     ShowSomething(Uploaders,'Top 10 Uploaders in K-Bytes/M-Bytes',2);
     ShowSomething(upnum,'Top 10 Uploaders in # Files',3); 
     ShowSomething(Downloaders,'Top 10 Downloaders in K-Bytes/M-Bytes',2);
     ShowSomething(downnum,'Top 10 Downloaders in # Files',3);
End;

Procedure readin2;
var s:string;
    nacc:boolean;
begin
  readin;
  nacc:=FALSE;
  with menur do begin
    if ((not aacs(acs)) or (password<>'')) then
    begin
      nacc:=TRUE;
      if (password<>'') then
      begin
	nl; prt('Password : '); input(s,15);
	if (s=password) then nacc:=FALSE;
      end;
      if (nacc) then
      begin
	nl; print('Access denied.'); pausescr;
	print('Dropping back to fallback menu...');
	curmenu:=systat.menupath+fallback+'.mnu';
	readin;
      end;
    end;
    if (not nacc) then
	if (novice in thisuser.ac) then chelplevel:=2 else chelplevel:=1;
  end;
end;

procedure getcmd(var s:string);
var s1,ss,oss,shas0,shas1:string;
    i,newarea:integer;
    c,cc:char;
    oldco:byte;
    achange,bb,gotcmd,has0,has1,has2:boolean;
begin
  s:='';
  if (buf<>'') then
    if (copy(buf,1,1)='`') then
    begin
      buf:=copy(buf,2,length(buf)-1);
      i:=pos('`',buf);
      if (i<>0) then
      begin
	s:=allcaps(copy(buf,1,i-1)); buf:=copy(buf,i+1,length(buf)-i);
	nl; exit;
      end;
    end;

  shas0:='?|'; shas1:='';
  has0:=FALSE; has1:=FALSE; has2:=FALSE;

  { find out what kind of 0:"x", 1:"/x", and 2:"//xxxxxxxx..." commands
    are in this menu. }

  for i:=1 to noc do
    if (aacs(cmdr^[i].acs)) then
      if (cmdr^[i].ckeys[0]=#1) then
      begin
	has0:=TRUE; shas0:=shas0+cmdr^[i].ckeys;
      end else 
	if ((cmdr^[i].ckeys[1]='/') and (cmdr^[i].ckeys[0]=#2)) then
	begin
	  has1:=TRUE; shas1:=shas1+cmdr^[i].ckeys[2];
	 end else
	   has2:=TRUE;

  oldco:=curco;

  gotcmd:=FALSE; ss:='';
  if (not (onekey in thisuser.ac)) then begin
    inputmain(s,60,'ul')
  end else begin
    repeat
      getkey(c); c:=upcase(c);
      oss:=ss;
      if (ss='') then begin
	if (c=#13) then gotcmd:=TRUE;
	if ((c='/') and ((has1) or (has2) or (thisuser.sl=255))) then ss:='/';
	if ((c='=') and (cso)) then begin gotcmd:=TRUE; ss:=c; end;
	if (((fqarea) or (mqarea)) and (c in ['0'..'9'])) then
	  ss:=c
	else
	  if (pos(c,shas0)<>0) then begin gotcmd:=TRUE; ss:=c; end;
      end else
	if (ss='/') then begin
	  if (c=^H) then ss:='';
	  if ((c='/') and ((has2) or (thisuser.sl=255))) then ss:=ss+'/';
	  if ((pos(c,shas1)<>0) and (has1)) then
	    begin gotcmd:=TRUE; ss:=ss+c; end;
	end else
	  if (copy(ss,1,2)='//') then begin
	    if (c=#13) then
	      gotcmd:=TRUE
	    else
	      if (c=^H) then
		ss:=copy(ss,1,length(ss)-1)
	      else
		if (c=^X) then begin
		  for i:=1 to length(ss)-2 do
		    prompt(^H' '^H);
		  ss:='//';
		  oss:=ss;
		end else
		  if ((length(ss)<62) and (c>=#32) and (c<=#127)) then
		    ss:=ss+c;
	  end else
	    if ((length(ss)>=1) and (ss[1] in ['0'..'9']) and
		((fqarea) or (mqarea))) then begin
	      if (c=^H) then ss:=copy(ss,1,length(ss)-1);
	      if (c=#13) then gotcmd:=TRUE;
	      if (c in ['0'..'9']) then begin
		ss:=ss+c;
		if (length(ss)=3) then gotcmd:=TRUE;
	      end;
	    end;

      if ((length(ss)=1) and (length(oss)=2)) then setc(oldco);
      if (oss<>ss) then begin
	if (length(ss)>length(oss)) then prompt(copy(ss,length(ss),1));
	if (length(ss)<length(oss)) then prompt(^H' '^H);
      end;
      if ((not (ss[1] in ['0'..'9'])) and
	((length(ss)=2) and (length(oss)=1))) then cl(6);

    until ((gotcmd) or (hangup));

    if (copy(ss,1,2)='//') then ss:=copy(ss,3,length(ss)-2);

    s:=ss;
  end;

  if (pos(';',s)<>0) then     (* changed *)            {* "command macros" *}
    if (copy(s,1,2)<>'\\') then begin
      if (onekey in thisuser.ac) then begin
	s1:=copy(s,2,length(s)-1);
	 if (copy(s1,1,1)='/') then s:=copy(s1,1,2) else s:=copy(s1,1,1);
	 s1:=copy(s1,length(s)+1,length(s1)-length(s));
      end else begin
	s1:=copy(s,pos(';',s)+1,length(s)-pos(';',s));  (* changed *)
	s:=copy(s,1,pos(';',s)-1);                      (* changed *)
      end;
      while (pos(';',s1)<>0) do s1[pos(';',s1)]:=^M;        (*changed *)
      dm(' '+s1,c);
    end;
end;


procedure mainmenuhandle(var cmd:string);
var newarea,i:integer;
    wantshow:boolean;
    rumfile:text;
begin
  tleft;
  makenode(3);
  macok:=TRUE;
  if ((forcepause in menur.menuflags) and (chelplevel>1) and (lastcommandgood))
    then pausescr;
  lastcommandgood:=FALSE;
  showthismenu;
  readnodemessages;
  if (not (nomenuprompt in menur.menuflags)) then begin
    if(menur.fixedprompt<>0) then begin
      for i:=1 to 27-menur.fixedprompt do begin
        nl;
      end;
      sprompt('[99D[99B['+cstr(25-menur.fixedprompt)+'A');
    end else begin
      nl;
    end;
    if (autotime in menur.menuflags) then sprint(#3#4+' '+#3#3+'Time Left ^4 ^3'+tlef+#3#4+' ');
    sprompt(menur.menuprompt);
  end;

  getcmd(cmd);
  if (cmd='?') then
  begin
    sprompt(^H+#3#0+'Help');
    nl;
    if(menur.fixedprompt<>0) then cls;
    cmd:='';
    inc(chelplevel);
    if (chelplevel>3) then chelplevel:=3;
    if ((menur.tutorial='*OFF*') and (chelplevel>=3)) then chelplevel:=2;
  end else
    if (novice in thisuser.ac) then chelplevel:=2 else chelplevel:=1;

  if (fqarea) or (mqarea) then begin
    newarea:=value(cmd);
    if ((newarea<>0) or (copy(cmd,1,1)='0')) then begin
      if (fqarea) then begin
	nl;
	if (newarea>=1) and (newarea<=numfbavail) then
	  changefileboard(fbpointer[newarea]);
      end else
      if (mqarea) then begin
	nl;
	if (newarea>=1) and (newarea<=nummbavail) then
	  changeboard(mbpointer[newarea]);
      end;
      cmd:='';
    end;
  end;
end;

procedure fcmd(cmd:string; var i:integer; noc:integer;
	       var cmdexists,cmdnothid:boolean);
var done:boolean;
begin
  done:=FALSE;
  repeat
    inc(i);
    if (cmd=cmdr^[i].ckeys) then begin
      cmdexists:=TRUE;
      if (oksecurity(i,cmdnothid)) then done:=TRUE;
    end;
  until ((i>noc) or (done));
  if (i>noc) then i:=0;
end;

procedure domenuexec(cmd:string; var newmenucmd:string);
var cmdacs,cmdnothid,cmdexists,done,first:boolean;
    nocsave,i,i1:integer;
begin
  if (newmenucmd<>'') then begin cmd:=newmenucmd; newmenucmd:=''; end;
  if (cmd<>'') then begin
    cmdacs:=FALSE; cmdexists:=FALSE; cmdnothid:=FALSE; done:=FALSE; first:=TRUE;
    nocsave:=noc; i:=0;
    repeat
      fcmd(cmd,i,nocsave,cmdexists,cmdnothid);
      if (i<>0) then begin
	if (first) then begin
	  if(lenn(cmdr^[i].ldesc)=0) then begin
	    nl;
	  end else begin
	    first:=FALSE;
	    for i1:=1 to length(cmd) do begin
	      sprompt(^H+' '+^H);
	    end;
	    sprint(#3#0+cmdr^[i].ldesc);
	  end;
	end;
	cmdacs:=TRUE;
        if(menur.fixedprompt<>0) then cls;
	domenucommand(done,cmdr^[i].cmdkeys+cmdr^[i].mstring,newmenucmd);
      end;
    until ((i=0) or (done));
    if (not done) then
      if ((not cmdacs) and (cmd<>'')) then begin
	nl;
	if ((cmdnothid) and (cmdexists)) then
	  print('You don''t have enough access for this command.')
	else
	  print(' ');
      end;
  end;
end;

procedure domenucommand(var done:boolean; cmd:string; var newmenucmd:string);
var filvar:text;
    u:userrec;
    temp:file of userrec;
    new:newsrec;
    news:file of newsrec;
    title:string[35];
    rumor1:string[78];
    rrec:rumrec;
    rfile:file of rumrec;
    tempcount,newscount,i,rumcount:integer;
    mheader:mheaderrec;
    cms,s,s1,s2:string;
    newsline:string[79];
    rcode,max,sortthis,by,nm,nd,ny,lm,ld,ly:integer;
    sysrum,k,c1,c2,c:char;
    save,stopitnow,abort,next,b,nocmd:boolean;
    fstringf:file of fstringrec;

  function semicmd(x:integer):string;
  var s:string;
      i,p:integer;
  begin
    s:=cms; i:=1;
    while (i<x) and (s<>'') do begin
      p:=pos(';',s); (* changed *)
      if (p<>0) then s:=copy(s,p+1,length(s)-p) else s:='';
      inc(i);
    end;
    while (pos(';',s)<>0) do s:=copy(s,1,pos(';',s)-1);   (* changed *)
    semicmd:=s;
  end;

begin
  newmenutoload:=FALSE;
  newmenucmd:='';
  c1:=cmd[1]; c2:=cmd[2];
  cms:=copy(cmd,3,length(cmd)-2);
  nocmd:=FALSE;
  lastcommandovr:=FALSE;
  case c1 of
    '-':case c2 of
	  'A':changedata;
	  'B':baudreport;
	  'T':topten;
	  'E':exescript(cms);
	  '+':begin
		save:=TRUE;
		if exist ('RUMORS.DAT') then begin
		  nl;
		  printf('rumentr');
		  if (nofile) then begin
		    if systat.chrome then begin
		      sprint('[0;1m');
		      sprint('[47m   [0;30;47mAdd a Rumor   [40m');
		      sprint('[47m[1;40m[0m');
		    end else
		    begin
		      sprint(#27+'[1;30mͻ');
		      sprint('  [34mAdd a Rumor  [30m');
		      sprint('ͼ'+#27+'[0m');
		    end;
		    sprint(#3#0+'Enter Title for this rumor [20 Chars Max.]');
		    prt(#3#5+' '+#3#0);
		    inputwc(title,35);
		    sprint(#3#0+'Enter Rumor [78 Chars Max.] '+#3#4+'[CR Aborts]');
		  end;
		  save:=TRUE;
		  prt(#3#5+' '+#3#0);
		  inputwc(Rumor1,78);

		  { ***** implimented later when refined rumors are ready ****
		  if pynq('Would you like to use a psuedo-name? [No] ') then begin
		    sprint(#3#0+'Enter a psuedo-name to post under. [CR]=Anonymous');
		    prt(#3#5+''+#3#0);
		    inputwc(rrec.pname,36);
		    if rrec.pname='' then rrec.pname:='Anonymous';
		  end else rrec.pname:=caps(thisuser.name);
		  }

		  rrec.pname:=caps(thisuser.name);
		  if rumor1 = '' then begin
		    save:=FALSE;
		    printf('rumntsav');
		    if (nofile) then sprint(#3#0+'Nothing Saved.');
		  end;
		  if (save) then begin
		    printf('rumsav');
		    if (nofile) then begin
		      sprint(#3#0+'Rumor Saved.');
		      sysoplog(#3#0+' '+#3#4+'Added Rumor - '+#3#0+'"'+rumor1+#3#0+'"');
		    end;
		    assign(rfile,'RUMORS.DAT');
		    reset(rfile);
		    seek(rfile,filesize(rfile)-1);
		    read(rfile,rrec);
		    rrec.author:=caps(thisuser.name);
		    rrec.title:=title;
		    rrec.rumor:=rumor1;
		    rrec.date:=date;
		    write(rfile,rrec);
		    close(rfile);
		    lastcommandgood:=TRUE;
		  end;
		end else begin
		  sprint('Cannot add a rumor at this time...Rumor data file is missing.');
		  writeln(sysopf,'ERROR : RUMORS.DAT is MISSING! - Please Make One!');
		end;
	      end;

	  '%':begin
		if exist('RUMORS.DAT') then begin
		  cls;
		  sprint(#3#0+' Insanity v'+ver+#3#4+' Rumor Listing');
		  nl;
		  rumcount:=0;
		  assign(rfile,'RUMORS.DAT');
		  reset(rfile);
		  sprint('^5###^4^5Title');
		  sprint(#3#4+'');
		  repeat
		    inc(rumcount);
		    seek(rfile,rumcount);
		    read(rfile,rrec);
		    sprint(mln(#3#3+mln(cstr(rumcount),3)+'^4'+#3#0+rrec.rumor,79));
		  until eof(rfile);
		  sprompt('^4 ^5'+cstr(rumcount)+' Rumor');
		  if rumcount>1 then sprompt('s');
		  sprint(' Total');
		  nl;
		  repeat
		  prt('[1-'+cstr(rumcount)+'][CR] :');
		  inu(by);
		  if (not badini) and (by in [1..rumcount]) then begin
		    seek(rfile,by);
		    read(rfile,rrec);
		    nl;
		    sprint(mln('^3Title  ^4 ^5'+rrec.title,79));
		    sprint(mln('^3Rumor  ^4 ^5'+rrec.rumor,79));
		    sprint(mln('^3Author ^4 ^5'+rrec.author,79));
		    sprint(mln('^3Date   ^4 ^5'+rrec.date,79));
		    nl;
		    if (thisuser.sl=255) or (caps(rrec.author)=caps(thisuser.name)) then begin
			  prt('^4[^5D^4]^3elete^4/[^5C^4]^3hange ^4 ^5');
		      onek(sysrum,'DC'+^M);
		      case sysrum of
			'D':begin
			      for i:=by to (filesize(rfile)-2) do begin
				seek(rfile,i+1);
				read(rfile,rrec);
				seek(rfile,i);
				write(rfile,rrec);
			      end;
			      seek(rfile,filesize(rfile)-1);
			      truncate(rfile);
			      dec(rumcount);
			    end;
			'C':begin
			      prt('Title:'+#3#0);
			      inputl(rrec.title,35);
			      prt('Rumor:'+#3#0);
			      inputl(rrec.rumor,78);
			      prt('Author:'+#3#0);
			      inputl(rrec.author,36);
			      prt('Date:'+#3#0);
			      inputl(rrec.date,8);
			      seek(rfile,by);
			      write(rfile,rrec);
			    end;
		      end;
		    end;
		  end;
		  until badini;
		  close(rfile);
		end else sprint('^4 ^3No Rumors Available to List! ^4');
	      end;

	  'C':commandline(cms);
	  'F':printf(cms);
	  'L':begin sprint(cms); end;
	  'N':nuv;
	  'Q':readq(systat.afilepath+cms,0);
	  'R':readasw1(cms);
	  'S':sysoplog(cms);
	  'U':begin
		nl;
		if fstring.note[2]<>'' then
		  sprint(#3#4+'Current BIG Message : '+#3#0+fstring.note[2]) else
		    sprint(#3#0+'There is currently no BIG Message defined.');
		sprompt(#3#0+'Enter NEW BIG Message : '+#3#0);
		bignote:='';
		input(bignote,12);
		if bignote<>'' then fstring.note[2]:=bignote;
		fstring.ansifont:=getfont;
		sprint('BIG Message will be displayed at logon as "'+fstring.note[2]+'".');
		assign(fstringf,systat.gfilepath+'string.dat');
		reset(fstringf); seek(fstringf,0);
		write(fstringf,fstring); close(fstringf);
		nl;
	      end;
	  'V':newsadd;
	  ';':begin
		s:=cms;
		while (pos(';',s)<>0) do s[pos(';',s)]:=^M;
		dm(' '+s,c);
	      end;
	  '$':if (semicmd(1)<>'') then begin
		if (semicmd(2)='') then prt(':') else prt(semicmd(2));
		input(s,20);
		if (s<>semicmd(1)) then begin
		  done:=TRUE;
		  if (semicmd(3)<>'') then sprint(semicmd(3));
		end;
	      end;
	  'P':begin
		nl;
		if(thisuser.msgpost<1) then begin
		  sprint('^4 ^0No messages posted?  Post a damn message!');
		  done:=TRUE;
		end else begin
		  sprint('^4 ^0Your PCR     - ^51^4:^5'+cstr(thisuser.loggedon div thisuser.msgpost));
		  sprint('^4 ^0Required PCR - ^51^4:^5'+cstr(systat.postratio[thisuser.sl]));
		  if(fnopostratio in thisuser.ac) then sprint('^4 ^4(^0You are exempt!^4)');
		  nl;
		  if(thisuser.loggedon div thisuser.msgpost<=systat.postratio[thisuser.sl]) or (fnopostratio in thisuser.ac) then begin
		    if(semicmd(1)='') then sprint('^4 ^1PCR check ^5succeeded^1.')
		      else sprint(semicmd(1));
		  end else begin
		    if(semicmd(2)='') then sprint('^4 ^1PCR check ^7failed^1!')
		      else sprint(semicmd(2));
		      done:=TRUE;
		  end;
		end;
		nl;
	      end;
	  '^','/','\':dochangemenu(done,newmenucmd,c2,cms);
	else  nocmd:=TRUE;
	end;
    'A':sprint('^3Archive commands have been disables due to hacking.');
        (*case c2 of
	  'A','C','M','T','X':doarccommand(c2);
	  'E':extracttotemp;
	  'G':userarchive;
	  'R':rezipstuff;
	else  nocmd:=TRUE;
	end;*)
    'B':case c2 of
	  '?':batchinfo;
	  'C':if (cms='U') then clearubatch else clearbatch;
	  'D':batchdl;
	  'L':if (cms='U') then listubatchfiles else listbatchfiles;
	  'R':if (cms='U') then removeubatchfiles else removebatchfiles;
	  'U':batchul;
	else  nocmd:=TRUE;
	end;
    'D':case c2 of
	  'C','D','G','S','W','-':dodoorfunc(c2,cms);
	else  nocmd:=TRUE;
	end;
    'F':case c2 of
	  'A':fbasechange(done,cms);
	  'B':browse;
          'C':recalcfp;
	  'D':idl;
	  'F':searchd;
	  'I':listopts;
	  'L':listfiles;
	  'N':nf(cms);
	  'P':pointdate;
	  'R':remove;
	  'S':search;
	  'U':iul;
	  'V':lfii;
	  'Y':yourfileinfo;
	  'Z':setdirs;
	  '@':createtempdir;
	  '#':begin
		nl;
		print('Enter the NUMBER of the file base.');
	      end;
	  '$':fbasestats;
	else  nocmd:=TRUE;
	end;
    'H':case c2 of
	  'C':begin
		nl;
		if pynq('@M@M'+cms) then
		begin
		  cls;
		  printf('logoff');
		  hangup:=TRUE;
		  hungup:=FALSE;
		end;
	      end;
	  'I':begin
		nl;
		hangup:=TRUE;
	      end;
	  'M':begin
		nl;
		sprint(cms);
		hangup:=TRUE;
	      end;
	else  nocmd:=TRUE;
	end;
    'K':case c2 of
	  'F':begin
		if(semicmd(1)='') then
		  choosefileconf
		else
		  setfileconf(value(semicmd(1)),FALSE);
	      end;
	  'M':begin
		if(semicmd(1)='') then
		  choosemessconf
		else
		  setmessconf(value(semicmd(1)),FALSE);
	      end;
	end;
    'M':case c2 of
	  'A':mbasechange(done,cms);
	  'E':ssmail(cms);
	  'J':dopurgepub(cms);
	  'K':purgepriv;
	  'L':smail(TRUE);
	  'M':readmail;
	  'N':nscan(cms);
	  'P':begin
		post(-1,mheader.fromi);
		closebrd;
	      end;
	  'Q':sendqwk;
	  'R':recieverep;
	  'S':scanmessages;
	  'U':ulist;
	  'Z':chbds;
	  '#':begin
		nl;
		print('Enter the NUMBER of the message base.');
	      end;
	  '$':mbasestats;
	else  nocmd:=TRUE;
	end;
    'N':case c2 of
	  'C':entermultichat;
	  'S':enternodemessage;
	  'W':whoson;
	end;
    'O':case c2 of
	  '1'..'3':tshuttlelogon:=ord(c2)-48;
	  'A':autovalidationcmd(cms);
	  'B':abbs;
	  'C':reqchat(cms);
	  'N':begin
		if exist('news.dat') then begin
		assign(news,'news.dat');
		reset(news);
		newscount:=0;
		repeat
		  inc(newscount);
		  seek(news,newscount);
		  read(news,new);
		  val(copy(new.date,1,2),nm,rcode);
		  val(copy(thisuser.laston,1,2),lm,rcode);
		  val(copy(new.date,4,2),nd,rcode);
		  val(copy(thisuser.laston,4,2),ld,rcode); 
		  val(copy(new.date,7,2),ny,rcode);
		  val(copy(thisuser.laston,7,2),ly,rcode); 
		  if (nm>=lm) and (nd>=ld) and (ny>=ly) then begin
		    cls;
		    sprint(#3#0+'Insanity v'+ver+' Smart News.  '+#3#9+'[Space Aborts]');
		    sprint(#3#4+'Number : '+#3#0+'['+#3#9+cstr(newscount)+#3#0+'/'+#3#4+cstr(filesize(news)-1)+#3#0+
		      ']   '+mln(#3#4+'Title :'+#3#0+new.title,44)+#3#4+'Date :'+#3#0+new.date);
		    sprint(#3#3+''+#3#0);
		    printf(new.display);
		    pausescr;
		  end;
		until eof(news);
		close(news);
		end else sprint('No News!');
	      end;
	  'I':begin
		nl; nl; sprint(#3#3+centre(verline(1)));
		sprint(#3#3+centre(verline(2))); nl; abort:=FALSE;
		printf('logon');
	      end;
	  'M':mmacro;
	  'O':sysopstatus;
	  'P':cstuff(value(cms),2,thisuser);
	  'S':bulletins(cms);
	  'T':tfiles;
	  'V':vote;
	  'Y':yourinfo;
	  '$':TimeBank(cms);
	else  nocmd:=TRUE;
	end;
    'U':case c2 of
	  'A':replyamsg;
	  'R':readamsg;
	  'W':wamsg;
	else  nocmd:=TRUE;
	end;
    '*':case c2 of
	  'A':if (checkpw) then begin
		sysoplog('- Edited ANSI Fonts');
		afontedit;
	      end;
	  'B':if (checkpw) then begin
		sysoplog('- Edited Message Bases');
		boardedit;
	      end;
	  'C':if (checkpw) then chuser;
	  'D':begin
		sysoplog('- Entered MiniDos');
		minidos;
	      end;
	  'E':if (checkpw) then begin
		sysoplog('- Edited Events');
		eventedit;
	      end;
	  'F':if (checkpw) then begin
		sysoplog('- Edited File Bases');
		dlboardedit;
	      end;
	  'I':if (checkpw) then begin
		sysoplog('- Edited Votes');
		initvotes;
	      end;
	  'G':if(checkpw) then begin
		sysoplog('- Edited File Conferences');
		fileconfedit;
	      end;
	  'L':showlogs;
	  'M':if(checkpw) then begin
		sysoplog('- Edited Message Conferences');
		messconfedit;
	      end;
	  'N':tedit1;
	  'P':if (checkpw) then begin
		sysoplog('- Edited System Configuration');
		changestuff;
	      end;
	  'T':if (checkpw) then begin
		sysoplog('- Edited Textfile Bases');
		tfileedit;
	      end;
	  'U':if (checkpw) then begin
		sysoplog('- Edited Users');
		uedit1;
	      end;
	  'V':begin
		nl;
		sprint(#3#9+'Counting Votes...');
		voteprint;
		begin
		  sysoplog('- Viewed Voting Results');
		  printfile(systat.afilepath+'votes.txt');
		end;
	      end;
	  'X':if (checkpw) then begin
		sysoplog('- Edited Protocols');
		exproedit;
	      end;
	  'Z':begin
		sysoplog('- Viewed ZLOG');
		zlog;
	      end;
	  '1':begin
		sysoplog('- Edited Files'); editfiles;
	      end;
	  '2':begin
		sysoplog('- Sorted Files'); sort;
	      end;
	  '3':if (checkpw) then begin
		sysoplog('- Read Private Mail (nosey bastard)'); mailr;
	      end;
	  '4':if (cms='') then do_unlisted_download
		else unlisted_download(cms);
	  '5':move;
	  '6':uploadall;
	  '7':validatefiles;
	  '8':addgifspecs;
	  '9':packmessagebases;
	  '#':if (checkpw) then begin
		sysoplog('- Edited Menus');
		last_menu:=curmenu;
		menu_edit;
		first_time:=TRUE;
		curmenu:=last_menu;
		readin2;
	      end;
	  '$':dirf(TRUE);
	  '%':dirf(FALSE);
	else  nocmd:=TRUE;
	end;
  else
	nocmd:=TRUE;
  end;
  lastcommandgood:=not nocmd;
  if (lastcommandovr) then lastcommandgood:=FALSE;
  if (nocmd) then
    if (cso) then
    begin
      sysoplog('Invalid Command - Command Keys "'+cmd+'"');
      nl; 
      sprint('Invalid Command - Command Keys "'+cmd+'"');
    end;
  if (newmenutoload) then
  begin
    readin2;
    lastcommandgood:=FALSE;
    if (newmenucmd='') then begin
      i:=1;
      while ((i<=noc) and (newmenucmd='')) do
      begin
	if (cmdr^[i].ckeys='FIRSTCMD') then
	  if (aacs(cmdr^[i].acs)) then newmenucmd:='FIRSTCMD';
	inc(i);
      end;
    end;
  end;
end;

(*  Command Script Module was idealized by Robozapp and Master of Puppets.
    Written by Raven. *)

procedure exescript(scriptfile:string);

var scf:text;
    outp,lin,s,mult,got,lastinp,ps,ns,es:astr;
    i:integer;
    abort,next,plin:boolean;
    c:char;

  procedure gotolabel(got:astr);
  var s:astr;
  begin
    got:=':'+allcaps(got);
    {$I-} reset(scf); {$I+}
    repeat
      readln(scf,s);
    until (eof(scf)) or (allcaps(s)=got);
  end;

begin
  if (exist(scriptfile+'.SCR')) then begin
    assign(scf,scriptfile+'.SCR');
    {$I-} reset(scf); {$I+}
    repeat
      abort:=FALSE;
      readln(scf,outp);
      if (pos('*',outp)<>0) and (copy(outp,1,1)<>';') then outp:=';A'+outp;
      if (length(outp)=0) then nl else
	case outp[1] of
	  ';':begin
		if (pos('*',outp)<>0) then
		  if (outp[2]<>'D') then outp:=copy(outp,1,pos('*',outp)-1);
		lin:=copy(outp,3,length(outp)-2);
		i:=80-length(lin);
		s:=copy(outp,1,2);
		if (s[1]=';') then
		  case s[2] of
		    'C','D','G','I','K','L','Q','T',';':i:=1; { do nothing }
		  else
		    sprompt(lin);
		  end;
		s:=#1#1#1;
		case outp[2] of
		  'A':inputl(s,i);
		  'B':input(s,i);
		  'C':begin
			mult:=''; i:=1;
			s:=copy(outp,pos('"',outp),length(outp)-pos('"',outp));
			repeat
			  mult:=mult+s[i];
			  inc(i);
			until (s[i]='"') or (i>length(s));
			lin:=copy(outp,i+3,length(s)-(i-1));
			sprompt(lin);
			onek(c,mult);
			s:=c;
		      end;
		  'D':begin
			sysoplog('** Executed Door from within CSM');
			dodoorfunc(outp[3],copy(outp,4,length(outp)-3));
			s:=#0#0#0;
		      end;
		  'G':begin
			got:=copy(outp,3,length(outp)-2);
			gotolabel(got);
			s:=#0#0#0;
		      end;
		  'H':hangup:=TRUE;
		  'I':begin
			mult:=copy(outp,3,length(outp)-2);
			i:=pos(',',mult);
			if i<>0 then begin
			  got:=copy(mult,i+1,length(mult)-i);
			  mult:=copy(mult,1,i-1);
			  if allcaps(lastinp)=allcaps(mult) then
			    gotolabel(got);
			end;
			s:=#0#0#0;
		      end;
		  'K':begin
			close(scf);
			sysoplog('** Aborted Command Script Module.');
			printingfile:=FALSE; cfilteron:=FALSE;
			exit;
		      end;

		  'Q':begin
			close(scf);
			s:=#0#0#0;
		      end;
		  'T':begin
			s:=copy(outp,3,length(outp)-2);
			printf(s);
			s:=#0#0#0;
		      end;
		  'Y':if yn then s:='YES' else s:='NO';
		  ';':s:=#0#0#0;
		end;
		if (s<>#1#1#1) then begin
		  outp:=lin+s;
		  lastinp:=s;
		end;
		if (s=#0#0#0) then outp:=#0#0#0;
	      end;
	  ':':outp:=#0#0#0;
	else
	  printacr(outp,abort,next);
	end;
      if (outp<>#0#0#0) then begin
	if (pos('@7',outp)<>0) then delete(outp,pos('@7',outp),2);
      end;
    until ((eof(scf)) or (hangup));
    close(scf);
  end else sprint('No Command Script Module found!');
end;

end.
