(* Here is all the stuff from insanity's rec25.pas that you will need.  It *)
(* is the way that insanity stores messages, and you will either have to   *)
(* use it or to convert net messages as they go out and come in.  Anyway   *)


  netpassword:string[20]='pHUckInsCReweYcaYse';

  msgindexstatr=
   (miexist,                      { does message actually exist? }
    milocal,                      { is it encrypted? encrypted}
    miunvalidated,                { is message unvalidated? }
    mipermanent,                  { is the message permanent? }
    miallowmci,                   { DID owner have access to MCI? }
    mithreads,                    { is message referenced? (threaded) }
    mimassmail,                   { is it private, mass mail? }
    mihigher);                    { is message scanned for FidoNet? scanned}

  msgindexrec=                         { *.MIX : Message index records }
  record
    messagenum:word;                   { message number, tonum in EMAIL.MIX }
    hdrptr:longint;                    { pointer to message header }
    msgid:longint;                     { message ID (sequential) }
    isreplytoid:longint;               { ID of replied message }
    msgdate:cpackdatetime;             { message date/time (packed) }
    msgdowk:byte;                      { message day-of-week (0=Sun ...) }
    msgindexstat:set of msgindexstatr; { status flags }
    isreplyto:word;                    { reply this message is to (-1=None) }
    numreplys:word;                    { number of replies to THIS message }
    lowernode:byte;                    { Signifigant node it is from if lower }
				       { (if 1.6.3.6.0.0 then it's 6) }
    lowerpos:byte;                     { Position in Node ID that the signifigant }
				       { is in.  (if 1.6.3.6.0.0 then it's 4), if lower }
  end;

  fromtoinfo=                  { from/to information for mheaderrec }
  record
    anon:byte;                 { anonymous type }
    usernum:word;              { user number }
    as:string[62];             { given name for this case }
    real:string[36];           { user real name }
    alias:string[46];          { user alias }
  end;

  mheaderrec=                  { *.BRD : Message header records }
  record
    signature:longint;         { header signature - $FFFFFFFF }
    msgptr:longint;            { pointer to message text }
    msglength:longint;         { length of message text }
    fromi:fromtoinfo;          { from information }
    toi:fromtoinfo;            { to information }
    title:string[60];          { title of message }
    origindate:string[19];     { Echo/Group original msg date }
  end;


  mbflags=
   (mbunhidden,                   { whether *VISIBLE* to users w/o access }
    mbrealname,                   { whether real names are forced }
    mbisdir,                      { if a message base directory }
    mbmsgpath,                    { if *.BRD file stored in MSGPATH }
    mbfilter,                     { whether to filter ANSI/8-bit ASCII }
    mbskludge,                    { strip IFNA kludge lines }
    mbsseenby,                    { strip SEEN-BY lines }
    mbsorigin,                    { strip origin lines }
    mbscenter,                    { strip centering codes }
    mbsbox,                       { strip box codes }
    mbmcenter,                    { center boxed/centered lines }
    mbaddtear,                    { add tear/origin lines }
    mbtopstar);                   { whether Top Star for GroupMail base }

  boardrec=                       { BOARDS.DAT : Message base records }
  record
    name:string[40];              { message base description }
    filename:string[8];           { BRD/MIX/TRE data filename }
    lastmsgid:longint;            { last message ID number }
    msgpath:string[40];           { messages pathname   }
    acs,                          { access requirement }
    postacs,                      { post access requirement }
    mciacs:acstring;              { MCI usage requirement }
    maxmsgs:word;                 { max message count }
    anonymous:anontyp;            { anonymous type }
    password:string[20];          { base password }
    mbstat:set of mbflags;        { message base status vars }
    permindx:longint;             { permanent index # }
    mbtype:integer;               { base type (0=Local,1=Echo,2=Group) }
    origin:string[50];            { origin line }
    text_color,                   { color of standard text }
    quote_color,                  { color of quoted text }
    tear_color,                   { color of tear line }
    origin_color:byte;            { color of origin line }
    zone,                         { alternate address     }
    net,                          { (zone:net/node.point) }
    node,
    point:integer;
    conf:byte;                    { Conference it is in }
    netboard:integer;
  end;


