(*****************************************************************************)
(*>                                                                         <*)
(*>  LOGON2  .PAS -  Written by Eric Schmitter                              <*)
(*>                                                                         <*)
(*>  Logon functions -- Part 2.                                             <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit logon2;

interface

uses
  crt, dos, overlay,
  mail0, mail1, mail2, mail3, mail4, mail5, mail9,
  misc2, miscx,
  cuser,
  doors,
  archive1,
  menus,
  common, confer, ansifont, multinod;

procedure zlog2;
procedure logon;
procedure logoff;
procedure endday;
procedure pver;
procedure checkmailbox;

implementation

procedure checkmailbox;
begin
    if (thisuser.waiting<>0) then begin
      nl;   (* ESC[80D, is more reliable to terminal programs with non standard lines *)
      tc(15);
      sprompt(#27+'[1;37m'+'You have Mail.');
      delay(150);
(*      ansig(1,wherey); *)
      sprompt('[80D'+#27+'[0;37m'+'You have Mail.');
      delay(100);
(*      ansig(1,wherey); *)
      sprompt('[80D'+#27+'[1;30m'+'You have Mail.');
      delay(100);
(*      ansig(1,wherey); *)
      sprompt('[80D                           ');
      delay(150);
(*      ansig(1,wherey); *)
      sprompt('[80D'+#27+'[1;30m'+'You have Mail.');
      delay(100);
(*      ansig(1,wherey); *)
      sprompt('[80D'+#27+'[0;37m'+'You have Mail.');
      delay(100);
(*      ansig(1,wherey); *)
      sprint('[80D'+#27+'[1;37m'+'You have Mail.'+#27+'[0m');
      if pynq('Read it now? [No] ') then readmail;
    end;
end;

procedure zlog2;
var zf:file of zlogrec;
    d1:zlogrec;
    s,dd:astr;
    blockcount,i:integer;
    blockchar:string[3];
    blockline:string[75];
    abort,next:boolean;

begin
  nl;
  assign(zf,systat.gfilepath+'zlog.dat');
  {$I-} reset(zf); {$I+}
  if (ioresult<>0) then print('ZLOG.DAT not found.')
  else begin
    abort:=FALSE;
    read(zf,d1);
    sprint(#3#0+'Call Activity');
    i:=-1;
    seek(zf,0);
    while ((i<=6) and (not abort) and (d1.date<>'')) do begin
      if (i>=0) then begin
	read(zf,d1);
	dd:=d1.date;
	blockchar:=#3#3+'';
      end else begin
	d1:=systat.todayzlog;
	dd:=#3#5+'Today''s ';
	blockchar:=#3#0+'';
      end;
      blockline:='';
      for blockcount:=1 to (d1.calls div 2) do blockline:=blockline+blockchar;
      if d1.calls=1 then blockline:=blockchar;
      if d1.calls<>0 then printacr(#3#4+mln(dd,8)+' '+#3#5+mln(cstr(d1.calls),3)+blockline,abort,next);
      inc(i);
    end;
    close(zf);
  end;
end;

procedure logon;
var ul:text;
    news:file of newsrec;
    new:newsrec;
    vdata:file of vdatar;
    lcallf:file of lcallers;
    numberreal:real;
    numbernow:integer;
    u:userrec;
    arcd:string[5];
    vd:vdatar;
    lcall:lcallers;
    lo:array[1..8] of astr;
    nt:astr;
    s:astr;
    zz:string[5];
    big:array[1..6] of string[255];
    newsline:string[79];
    lng:longint;
    newscount,blah,num,lcts,hilc,vna,callsleft,ct,z,qq,rcode:integer;
    lne,zzzzz,nd,nm,ny,lm,ld,ly:integer;
    c:char;
    abort,lastinit:boolean;
    nuvfile:file of nuvrec;
    anyyet,votedyet,next:boolean;
    i:integer;
    thisnuv:nuvrec;
    oldboard:boardrec;
    mheader:mheaderrec;
    mix:msgindexrec;

  procedure day_desc(dat:astr);
  var d:astr;
      hs:boolean;

    procedure p(s:astr);
    begin
      sprompt(#3#0+s);
      hs:=TRUE;
    end;

  begin

    hs:=FALSE;
    d:=copy(date,1,5);
    if (d='01/01') then sprint('Happy New Year!   ') else
    if (d='07/04') then sprint('Happy '+#3#7+'4th '+#3#0+'of '+#3#4+'July   '+#3#3) else
    if (d='12/24') then sprint('Happy Christmas Eve   ') else
    if (d='12/25') then sprint(#3#9+'Merry '+#3#7+'Christmas   '+#3#3) else
    if (d='12/31') then sprint('The New Year is around the corner!  ') else
    if (d='10/31') then sprint('Happy Halloween!  Haha.  ') else
    if (d='09/24') then sprint('What a great day, no?   ') else
    if (d='04/01') then sprint(^G^G+'Your account has been deleted.'+^G+'(AprilFools!)   ');
    if (not hs) then;
    begin
      if (timer<21600) or (timer>=64800) then p('Good evening') else
      if (timer<43200) and (timer>=21600) then p('Good morning') else
      p('Good afternoon');
    end;
  end;

  function checkbday:boolean;
  var i,j:integer;
  begin
    i:=85;
    repeat
      j:=daynum(copy(thisuser.bday,1,6)+tch(cstr(i)));
      if (daynum(date)>=j) and (daynum(thisuser.laston)<j) then begin
	checkbday:=TRUE;
	exit;
      end;
      inc(i);
    until (i>value(copy(date,7,2)));
    checkbday:=FALSE;
  end;

  function bsince:boolean;
  begin
    bsince:=(not (copy(thisuser.bday,1,5)=copy(date,1,5)));
  end;

  procedure showbday(s:astr);
  begin
    nofile:=TRUE;
    if (bsince) then printf('bdys'+s);      {* birthday occured SINCE laston *}
    if (nofile) then printf('bday'+s);      {* birthday TODAY *}
  end;

  procedure findchoptime;
  var lng,lng2,lng3:longint;

    procedure onlinetime;
    var dt:datetimerec;
	secs:longint;
    begin
      secs:=trunc(nsl);
      dt.day:=secs div 86400; secs:=secs-(dt.day*86400);
      dt.hour:=secs div 3600; secs:=secs-(dt.hour*3600);
      dt.min:=secs div 60; secs:=secs-(dt.min*60);
      dt.sec:=secs;
      sprint(^G);
      sprint(#3#0+'System event approaching...  Time adjusted to '+longtim(dt));
      sprint(^G);
    end;

  begin
    if (exteventtime<>0) then
    begin
      lng:=exteventtime;
      if (lng<trunc(nsl/60.0)) then
      begin
	choptime:=(nsl-(lng*60.0))+120.0; 
	onlinetime;
	exit;
      end;
    end;
    lng:=1;
    lng2:=trunc(nsl/60);
    if (lng2>180) then lng2:=180;
    while (lng<=lng2) do
    begin
      lng3:=lng*60;
      if (checkevents(lng3)<>0) then
      begin
	choptime:=(nsl-(lng*60.0))+60.0;
	onlinetime;
	exit;
      end;
      inc(lng,2);
    end;
  end;

begin
  getdatetime(timeon);
  mread:=0;
  extratime:=0.0;
  freetime:=0.0;
  useron:=TRUE;
  com_flush_rx;
  logon1st;

  if ((thisuser.sl=255) and (not fastlogon) and (spd<>'KB')) then
  begin
    if pynq('Quick logon? [No] ') then fastlogon:=TRUE;
    nl;
  end;
    setmessconf(1,FALSE);
    setfileconf(1,FALSE);
    if (systat.yourinfoinlogon) and (not fastlogon) then begin
      pausescr;
      yourinfo;
      nl;
    end;

    if not fastlogon then begin
      for blah:=1 to length(stripcolor(fstring.ansiq))-1 do
	sprompt(#3#4+'');
      sprint(#3#4+'');
      sprint(fstring.ansiq);
      for blah:=1 to length(stripcolor(fstring.ansiq))-1 do
	sprompt(#3#4+'');
      sprint(#3#4+'');
      nl;
    end;

  if not fastlogon then begin
    if (fstring.note[2]<>'') and (fstring.ansifont<>0) then begin
      fstring.note[2]:=stripcolor(fstring.note[2]);
      nl;
      sprint(fstring.note[1]);
      nl;
      printafont(fstring.note[2],fstring.ansifont);
    end;
  end;
  lastinit:=FALSE; assign(lcallf,systat.gfilepath+'laston.dat');
  {$I-} reset(lcallf); {$I+}
  if (ioresult<>0) and (spd<>'KB') then begin
    lastinit:=TRUE;
    rewrite(lcallf);
    with lcall do
    begin
      callernum:=-1;
      name:='';
      number:=0;
      citystate:='';
      areacode:=copy(systat.bbsphone,1,3);
    end;
    for z:=0 to 4 do write(lcallf,lcall);
  end;

  if systat.callernum=0 then systat.callernum:=1;
  if thisuser.loggedon=0 then thisuser.loggedon:=1;

  whoson;

  if (systat.lcallinlogon) and (not fastlogon) then
  begin
    if (cso) then lcts:=5 else lcts:=5;
    lcall.callernum:=0; z:=0; hilc:=1;
    for z:=0 to 1 do
    begin
      seek(lcallf,z);
      read(lcallf,lcall);
      if (lcall.callernum=-1) and (hilc=1) then hilc:=z-1;
    end;
    if (hilc<>-1) then
    begin
      if (not cso) and (hilc>1) then hilc:=1;
      if systat.chrome then begin
	sprint('[0;1;37m');
	sprint('[47m   [0;30;47mLast Callers   [40m');
	sprint('[47m[1;40m[0m');
      end else
      begin
	sprint(#27+'[0;1;30mͻ');
	sprint('  [34mLast Callers  [30m');
	sprint('ͼ'+#27+'[0m');
      end;
      for z:=0 to 4 do
      begin
	seek(lcallf,z);
	read(lcallf,lcall);
	with lcall do
	  begin
	    if areacode=copy(systat.bbsphone,1,3) then arcd:='local' else arcd:=areacode;
	    sprint(' '+#3#9+mln(caps(name),30)+#3#4+' - '+#3#0+mln(citystate,22)+' '+mln(#3#3+'['+#3#0+arcd+#3#3+']',7)+#3#0);
	  end;
      end;
      nl;


      { Draws bar graph of user's percent use of system }
      {*************************************************}
      sprint(#3#0+systat.bbsname+#3#0+' has had over '+#3#4+cstr(systat.callernum-1)+#3#0+' callers.');
      numberreal:=(thisuser.loggedon / systat.callernum)*100;
      numbernow:=round(numberreal);
      if numbernow=0 then numbernow:=1;  { Rounds down - add one because no one has called 0% }
      if numbernow>100 then numbernow:=100;
      sprompt(#3#3+cstr(numbernow)+'% '+#3#0);
      for zzzzz:=1 to (numbernow div 2) do sprompt(#3#0+'');
      for zzzzz:=1 to (50-(numbernow div 2)) do sprompt(#3#0+'');
      nl;
      sprint(#3#0+'Your calls represent '+cstr(numbernow)+'% of total calls.');
    end;
  end;

  if (not fastlogon) then begin
  zlog2;
		(**
		   News only displays if user's last call was before the date
		   the news was created... this way, user only sees it once.
		**)

{		if exist('news.dat') then begin
		nl;
		assign(news,'news.dat');
		reset(news);
		newscount:=0;
		repeat
		  inc(newscount);
		  seek(news,newscount);
		  read(news,new);
		  val(copy(new.date,1,2),nm,rcode);
		  val(copy(thisuser.laston,1,2),lm,rcode);
		  val(copy(new.date,4,2),nd,rcode);
		  val(copy(thisuser.laston,4,2),ld,rcode);
		  val(copy(new.date,7,2),ny,rcode);
		  val(copy(thisuser.laston,7,2),ly,rcode);
		  if (nm>=lm) and (nd>=ld) and (ny>=ly) then begin
		    sprint(' News to Come...');
		    pausescr;
		    cls;
		    sprint(#3#0+'Insanity v'+ver+' Smart News.  '+#3#9+'[Space Aborts]');
		    sprint(#3#4+'Number : '+#3#0+'['+#3#9+cstr(newscount)+#3#0+'/'+#3#4+cstr(filesize(news)-1)+#3#0+
		      ']   '+mln(#3#4+'Title :'+#3#0+new.title,44)+#3#4+'Date :'+#3#0+new.date);
		    sprint(#3#3+''+#3#0);
		    printf(new.display);
		  end;
		until eof(news);
		close(news);
		pausescr;
		end; }
    initbrd(-3);
    seek(mixf,0);
    i:=0;
    while(i<=himsg) do begin
      ensureloaded(i);
      mix:=mintab^[getmixnum(i)];
      loadmhead(i,mheader);

      ny:=(mix.msgdate[1] shl 7)+((mix.msgdate[2] and 254) shr 1)-100;
      val(copy(thisuser.laston,1,2),lm,rcode);
      nm:=((mix.msgdate[2] and 1) shl 3)+((mix.msgdate[3] and 224) shr 5);
      val(copy(thisuser.laston,4,2),ld,rcode);
      nd:=(mix.msgdate[3] and 31);
      val(copy(thisuser.laston,7,2),ly,rcode);
{      sprint('Date calc - '+cstr(nm)+'/'+cstr(nd)+'/'+cstr(ny));
      pausescr; }
      if (nm>=lm) and (nd>=ld) and (ny>=ly) then begin
	abort:=FALSE;  next:=FALSE;  oldboard:=memboard;  memboard.name:='System News';
	readmsg(0,i,i+1,himsg+1,abort,next);
        memboard:=oldboard;
        pausescr;
      end;
      inc(i);
    end;
    initbrd(board);
  end;

  if ((spd<>'KB') or (lastinit)) then
  begin
    for z:=4 downto 1 do
    begin
      seek(lcallf,z-1);
      read(lcallf,lcall);
      seek(lcallf,z);
      write(lcallf,lcall);
    end;
    with lcall do
    begin
      callernum:=systat.callernum;
      name:=thisuser.name;
      number:=usernum;
      citystate:=thisuser.citystate;
      areacode:=copy(thisuser.ph,1,3);
    end;
    seek(lcallf,0);
    write(lcallf,lcall);
  end;
  close(lcallf);

  if ((not fastlogon) and (not hangup)) then
  begin
    sprint(#3#0+'');
    printf('logon');
    nofile:=FALSE;
    z:=0;
    repeat
      inc(z);
      printf('logon'+cstr(z));
    until (z=9) or (nofile) or (hangup);
    printf('sl'+cstr(thisuser.sl));
    printf('dsl'+cstr(thisuser.dsl));
    for c:='A' to 'Z' do
      if (c in thisuser.ar) then printf('arlevel'+c);
    printf('user'+cstr(usernum));

    if (checkbday) then
    begin
      showbday(cstr(usernum));
      if nofile then showbday('');
      if nofile then
	if bsince then begin
	  sprint(#3#3+'Happy Birthday, '+thisuser.name+'!');
	  sprint(#3#3+'You turned '+cstr(ageuser(thisuser.bday))+' on '+
	    copy(thisuser.bday,1,5)+copy(date,6,3)+' !');
	end else begin
	  sprint(#3#3+'Happy Birthday, '+thisuser.name+'!');
	  sprint(#3#3+'You turn '+cstr(ageuser(thisuser.bday))+' today!');
	end;
    end;

    if (exist('logon.bat')) and (systat.logonenable) then
    begin
      shelldos(FALSE,process_door('logon.bat @F @L @B @G @T @R'),rcode);
      topscr;
    end;
    cl(5);
    if (sysop) then begin
    printf('sysopin');
    if (nofile) then sprint(fstring.sysopin);
    end;
    if (not sysop) then begin
    printf('sysopout');
    if (nofile) then sprint(fstring.sysopout);
    end;
    if (systat.autominlogon) then begin
      nl;
      readamsg;
    end;
  end;

  if (not wasguestuser) then
  begin
    if (thisuser.flistopt=0) then thisuser.flistopt:=1;
    if (thisuser.bday='00/00/00') then begin
      print('Updating System Records -');
      cstuff(2,1,thisuser);
      nl;
    end;
    if (thisuser.citystate='') or (thisuser.citystate='Unknown') then
      cstuff(4,1,thisuser);
    if (thisuser.clsmsg=0) then thisuser.clsmsg:=1;
    if (thisuser.avadjust=0) then
    begin
      thisuser.avadjust:=1;
      thisuser.ac:=thisuser.ac-[avatar];
    end;
  end;

  if (thisuser.computer='Unknown') then
  begin
    cstuff(5,1,thisuser);
    nl;
  end;
  savesystat;

  with thisuser do
  begin
    if ((not fastlogon) and (not hangup)) then begin
      cl(14); day_desc(dat); sprompt(', '+#3#1+caps(thisuser.name)+', ');
      sprint(#3#1+'you are caller number '+#3#4+cstr(systat.callernum)+#3#1+'.');
      if (systat.todayzlog.calls<>0) then
      begin
	sprompt(#3#1+'You are the ');
	zz:=cstr(systat.todayzlog.calls); zz:=copy(zz,length(zz),1);
	z:=value(zz); ct:=systat.todayzlog.calls;
	if (ct in [11..13]) then z:=4;
	sprompt(#3#5+cstr(systat.todayzlog.calls));
	case z of
	  1:sprompt('st');
	  2:sprompt('nd');
	  3:sprompt('rd');
	else
	    sprompt('th');
	end;
	sprint(#3#1+' caller for today.');
      end;


      lmsg:=FALSE;
      if (daynum(laston)<=daynum(systat.tfiledate)) and
	(daynum(laston)>0) then begin
	  ssm(usernum,'There are new text files.');
	end;

      if thisuser.ownerdls <> 0 then begin
	ssm(usernum,cstr(thisuser.ownerdls)+' users download your file.');
	thisuser.ownerdls:=0;
       end;
      vna:=0;
      assign(vdata,systat.gfilepath+'voting.dat');
      {$I-} reset(vdata); {$I+}
      if (ioresult=0) then begin
	for num:=1 to 20 do begin
	  seek(vdata,num-1); read(vdata,vd);
	  if (vd.numa<>0) then
	    if (vote[num]=0) then inc(vna);
	end;
	close(vdata);
	if (vna>0) then
	begin
	  sprompt(#3#0+'You have not voted on '+#3#9+cstr(vna)+#3#0+' voting question');
	  if (vna>1) then sprint('s.') else sprint('.');
	  if (systat.forcevoting) and (not (rvoting in thisuser.ac)) then begin
	    pausescr;
	    misc1.vote;
	  end;
	end;
      end;

      if (forusr<>0) then
	ssm(usernum,'NOTE : Your mail is being forwarded to user #'+cstr(forusr));
      topscr;
    end;
  end;

  findchoptime;

 if(thisuser.sl>systat.newsl) then begin  { Can't have unvalidated users voting on themselves }
  assign(nuvfile,systat.gfilepath+'nuv.dat');  { Checks to see if we need to vote on any users }
  {$I-} reset(nuvfile); {$I+}
  if(ioresult=0) then begin
    anyyet:=FALSE;
    while(not eof(nuvfile)) and (not anyyet) do begin
      read(nuvfile,thisnuv);
      if(thisnuv.exists) then begin
        votedyet:=FALSE;
        for i:=1 to thisnuv.totvoted do begin
          if(thisnuv.votedby[i]=usernum) then votedyet:=TRUE;
        end;
        if(not votedyet) then anyyet:=TRUE;
      end;
    end;
    close(nuvfile);
    if(anyyet) then nuv;
  end;
 end;

 realsl:=thisuser.sl;
 realdsl:=thisuser.dsl;
 if(not fastlogon) then begin
  with thisuser do
  begin
    if (smw in ac) then begin
      nl;
      sprint(#3#0+'  NOTICE');
      sprint(#3#4+'');
      rsm;
    end;
    ac:=ac-[smw];
    if ((alert in ac) and (sysop)) then chatcall:=TRUE;
  end;
  if ((not fastlogon) and (systat.bullinlogon)) then bulletins('');
 end;

  fastlogon:=FALSE;
end;

procedure logoff;
var ddt,dt:datetimerec;
    i,tt,rcode:integer;

begin
  if ((useron) and (usernum>0)) then
    if (exist('logoff.bat')) and (systat.logonenable) then
      shelldos(FALSE,process_door('logoff.bat @F @L @B @G @T @R'),rcode);

  term_ready(FALSE);

  if ((useron) and (usernum>0)) then
  begin
    purgedir(systat.temppath+'1\');
    purgedir(systat.temppath+'2\');
    purgedir(systat.temppath+'3\');
    slogging:=TRUE;
    if (trapping) then
    begin
      if (hungup) then
      begin
	writeln(trapfile);
	writeln(trapfile,'NO CARRIER');
      end;
      close(trapfile); trapping:=FALSE;
    end;
    getdatetime(dt);
    timediff(ddt,timeon,dt);
    tt:=trunc((dt2r(ddt)+30)/60);
    thisuser.laston:=systat.lastdate;
    inc(thisuser.loggedon);
    thisuser.illegal:=0;
    thisuser.ttimeon:=thisuser.ttimeon+tt;
    if (choptime<>0.0) then inc(thisuser.tltoday,trunc(choptime/60.0));
    thisuser.tltoday:=trunc(nsl/60.0);
    thisuser.lastmsg:=board;
    thisuser.lastfil:=fileboard;
    thisuser.sl:=realsl;
    thisuser.dsl:=realdsl;
    reset(uf);
    if ((usernum>=1) and (usernum<=filesize(uf)-1)) then
      begin
	seek(uf,usernum);
	write(uf,thisuser);
      end;
    close(uf);
    inc(systat.todayzlog.active,tt);
    inc(systat.todayzlog.fback,ftoday);
    inc(systat.todayzlog.privpost,etoday);
    systat.encrypt:=false;
    savesystat;

    for i:=1 to hiubatchv do release(ubatchv[i]); {* release dynamic memory *}
    window(1,1,80,25); clrscr;
    if (hungup) then sl1(#3#7+'*** Dropped Carrier! ***');
    sl1(#3#4+'Read '+#3#3+cstr(mread)+#3#4+' messages / Time on was '+#3#3+cstr(tt));
  end;
end;

procedure endday;
var d,i,tu,fu:integer;
begin
  useron:=FALSE;
  d:=daynum(date);
  if (d<>ldate) then
    if (d-ldate)=1 then
      inc(ldate)
    else begin
      writeln('Date corrupted.');
      halt(1);
    end;

(*****
  reset(mailfile);
  for i:=0 to filesize(mailfile)-1 do begin
    seek(mailfile,i); read(mailfile,mr);
    if (old(mr.date,mr.mage) and (mr.destin<>-1)) then begin
      fu:=abs(mr.from);
      is:=rmail(i);
      ssm(fu,is+' never got your letter.');
    end;
  end;
  close(mailfile);
  reset(uf);
  for board:=1 to numboards do begin
    iscan;
    cn:=1;
    while (cn<=tnum) do begin
      if (old(mary[cn].date,mary[cn].mage)) or
	 (mary[cn].messagestat=deleted) then
	deletem(cn)
      else
	inc(cn);
    end;
    savebase;
  end;
  close(uf);
 *****)
end;

procedure pver;
var abort,next,aa:boolean;
begin
  abort:=FALSE; next:=FALSE;
  aa:=allowabort; allowabort:=FALSE;
  printacr(verline(1),abort,next);
  printacr(verline(2),abort,next);
  nl;
  sprint('<> '+regis+' to '+regsysop+' of '+regbbs);
  sprint('<> INSANEnet Node # '+clasicnode);
  sprint('<> Serial # '+ser);
  nl;
  allowabort:=aa;
end;

end.
