(*****************************************************************************)
(*>                                                                         <*)
(*>  LOGON1  .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  Logon functions -- Part 1.                                             <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit logon1;

interface

uses
  crt, dos, overlay,
  logon2, newusers,
  mail0, mail1, mail2, mail3, mail4,
  misc2, miscx,
  cuser,
  doors,
  archive1,
  menus, menus2,
  tmpcom,common, nsanenet, multinod;

var tit,it,zit,xphone,yphone,zzz,ddd,qqq,ccc,
    xpw,ypw,xhandle,yhandle,code:integer;
    sfile:text;
    showfile:array[1..3] of string;
    beep,clsnow:array[1..3] of boolean;
    pcolor:array[1..3] of integer;
    line:array[1..12] of string[79];
    templine:string[1];
    temp,temp2:string[79];
    nf:text;
    
function getuser:boolean;
procedure ansig(x,y:integer);

implementation

const
  ilogon=^G^G' ILLEGAL LOGON '^G^G;

procedure ansig(x,y:integer);
begin
  if (spd<>'KB') then pr1(#27+'['+cstr(y)+';'+cstr(x)+'H');
  if (wantout) then gotoxy(x,y);
  pap:=0;
end;

procedure getpws(var ok:boolean; var tries:integer);
var phone,pw,s:astr;
    zzzz:integer;
begin
  ok:=TRUE; 
  echo:=FALSE;
  if (not fastlogon) then begin
  if (clsnow[2]) then cls;
  printf(showfile[2]);
  if (beep[2]) then sprompt(^G);
  commandline('');
  commandline('This user''s password is "'+thisuser.pw+'"');
  ansig(xpw,ypw);
  tc(15);
  if ((xpw=0) and (ypw=0)) then sprompt('Password :');
  inputl(pw,20);
  for zzzz:=1 to length(pw) do pw[zzzz]:=upcase(pw[zzzz]);
  if (systat.phonepw) then
  begin
    if (clsnow[3]) then cls;
    printf(showfile[3]);
    if (beep[3]) then sprompt(^G);
    commandline('');
    commandline('This user''s phone # is "'+thisuser.ph+'"');
    ansig(xphone,yphone);
    tc(15);
    if ((xphone=0) and (yphone=0)) then sprompt('Phone # xxx-xxx-');
    input(phone,4); 
    echo:=TRUE;
    cls;
  end else begin
    phone:=(copy(thisuser.ph,9,4));
    cls;
  end;
  
  echo:=TRUE;
  if ((thisuser.pw<>pw) or (copy(thisuser.ph,9,4)<>phone)) then
  begin
    nl; print(ilogon); nl;
    if (not hangup) and (usernum<>0) then begin
      s:=#3#8+'>>'+#3#1+' Illegal Logon Attempt!  Tried: '+
         caps(thisuser.name)+' #'+cstr(usernum);
      if (usernum<>1) then
      begin
        s:=s+' Tried Password "'+pw+'"';
        if (systat.phonepw) then s:=s+' with PH# "'+phone+'"';
      end;
      sl1(s);
    end;
    inc(thisuser.illegal);
    ssm(usernum,'"'+pw+'" was attempted password during illegal logon.');
    seek(uf,usernum); 
    write(uf,thisuser);
    inc(tries);
    if (tries>=systat.maxlogontries) then hangup:=TRUE;
    ok:=FALSE;
  end;
  if ((aacs(systat.spw)) and (ok) and (incom) and (not hangup)) then
  begin
    echo:=FALSE;
    nl;
    sprompt(#3#0+'Sysop Password :'+#3#5);
    inputl(pw,20);
    for zzzz:=1 to length(pw) do pw[zzzz]:=upcase(pw[zzzz]);
    if (pw<>systat.sysoppw) then
    begin
      nl; 
      print(ilogon); 
      nl;
      sl1(#3#8+'!'+#3#1+'  Illegal System Password'); inc(tries);
      if (tries>=systat.maxlogontries) then hangup:=TRUE;
      ok:=FALSE;
    end;
    echo:=TRUE;
  end;
  if ((ok) and (systat.shuttlelog) and (thisuser.lockedout)) then
  begin
    printf(thisuser.lockedfile);
    sysoplog(#3#7+'['+#3#8+'!'+#3#7+'] '+#3#3+thisuser.name+#3#5+
             'Attempt to access system when locked out!');
    hangup:=TRUE;
  end;
  end; (* not fastlogon *)
end;

procedure dopulls;
var c:char;
    s,phone,pw:astr;
    yee,numberofchoices:integer;
    count,choice,tries,zz,xx,yy,i:integer;
    line:array[1..5] of string[70];
    fn:array[1..5] of string[70];
    ufn:array[1..5] of string[70];
    gotname,loggedon:boolean;

begin
  repeat
  cls;
  thisuser.ac:=thisuser.ac+[ansi];
  thisuser.ac:=thisuser.ac-[avatar];
  loggedon:=FALSE;
  gotname:=FALSE;
  tries:=0;
  yee:=29;  { what is the y value of the choices display }
  numberofchoices:=4;  { how many choices total are active }
  xx:=0;
  yy:=0;
  line[1]:='Logon to System 1';
  line[2]:='Goodbye (Hangup)';
  line[3]:='Apply for Access';
  line[4]:='Check for Validation';
  fn[1]:='PULLLOG.ANS';
  fn[2]:='PULLHAN.ANS';
  fn[3]:='PULLNEW.ANS';
  fn[4]:='PULLCHE.ANS';
  ufn[1]:='PULLULOG.ANS';
  ufn[2]:='PULLUHAN.ANS';
  ufn[3]:='PULLUNEW.ANS';
  ufn[4]:='PULLUCHE.ANS';
  (*
  line[5]:='Leave Email to Sysop';
  line[6]:='Chat with Sysop';
  *)
  nl;
  sprint(centre(#3#0+'Insanity '+ver+' Pulldown Matrix Logon'));
  sprint(centre(#3#0+'Use arrow keys to navigate, ENTER to select'));
  nl;
  sprint(centre(#3#0+'Registered to '+regbbs));
  nl;
  if(exist(systat.afilepath+'PULLDOWN.ANS')) then begin
    printf(systat.afilepath+'PULLDOWN.ANS');
  end else begin
    sprint(#27+'[26C'+'[0;1;30mͻ');
    sprint(#27+'[26C'+'[0;1;30m[0mLogon to System 1        [0;1;30m');
    sprint(#27+'[26C'+'[0;1;30m[0mGoodbye (Hangup)         [0;1;30m');
    sprint(#27+'[26C'+'[0;1;30m[0mApply for Access         [0;1;30m');
    sprint(#27+'[26C'+'[0;1;30m[0mCheck for Validation     [0;1;30m');
    sprint(#27+'[26C'+'[0;1;30mͼ[0m');
    nl;
    nl;
  end;
  printf('mnews');
{  count:=7;  (* line to start choices on *)
  for zz:=1 to numberofchoices do
    begin
      inc(count);
      ansig(yee,count);
      sprint(#27+'[0m'+line[zz]);
    end; }
  choice:=1;
  if(exist(systat.afilepath+fn[1])) then begin
    printf(systat.afilepath+fn[1]);
  end else begin
    ansig(yee,8);
    sprompt(#27+'[1;32m'+line[1]+#27+'[0m');
  end;
  repeat
    xx:=wherex;
    yy:=wherey;
    c:=inkey;
    if ((c='A') or (c='8') or (c='H')) then begin   {Cursor Up}  { ESC[A is cursor up }
      if(exist(systat.afilepath+ufn[choice])) then begin
        printf(systat.afilepath+ufn[choice]);
      end else begin
        ansig(yee,choice+7);                                   { and is what most   }
        sprint(#27+'[0m'+line[choice]);                            { terms send for up  }
      end;
      if choice=1 then choice:=numberofchoices+1;
      choice:=choice-1;
      if(exist(systat.afilepath+fn[choice])) then begin
        printf(systat.afilepath+fn[choice]);
      end else begin
        ansig(yee,7+choice);
        sprompt(#27+'[0;1;32m'+line[choice]+#27+'[0m');
      end;
    end;
    if ((c='B') or (c='2') or (c='P')) then begin   {Cursor Down}
      if(exist(systat.afilepath+ufn[choice])) then begin
        printf(systat.afilepath+ufn[choice]);
      end else begin
        ansig(yee,choice+7);
        sprint(#27+'[0m'+line[choice]);
      end;
      if choice=numberofchoices then choice:=0;
      choice:=choice+1;
      if(exist(systat.afilepath+fn[choice])) then begin
        printf(systat.afilepath+fn[choice]);
      end else begin
        ansig(yee,7+choice);
        sprompt(#27+'[1;32m'+line[choice]+#27+'[0m');
      end;
    end;

  until ((c=#13) or (hangup));

  if c=#13 then begin
    ansig(1,23);
    case choice of

      1:begin
          if systat.shuttlepw='' then loggedon:=TRUE
          else begin
            nl;
            echo:=FALSE;
            sprompt(#3#0+'System Password :'); input(pw,20); nl;
            echo:=TRUE;
            if (pw=systat.shuttlepw) then begin loggedon:=TRUE; gotname:=TRUE; end
            else begin
	      sl1('Illegal Matrix Password "'+pw+'"');
              print(ilogon);
              inc(tries);
            end;
          end;
        end;

      2:begin
          hangup:=true;
        end;

      3:begin
          if (gotname) then begin
            sprint('You are already a user.');
            nl;
          end else
         begin
          if pynq('Apply for account here? [No] ') then
          begin
            newuserinit('');
            newuser;
            if (usernum>0) and (not hangup) then
            begin
              gotname:=TRUE;
              useron:=TRUE;
              logon1st;
            end;
          end;
         end;

        end;

      4:begin

        sprint(#3#0+'Checking Validation...');
        nl;
        sprompt(#3#0+'Handle/Alias :');
        finduser(s,usernum);
        if (usernum>=1) then begin
         reset(uf); seek(uf,usernum); read(uf,thisuser);
         nl;
         sprompt('Password :');
         input(pw,20);
         if (systat.phonepw) then
         begin
           sprompt('Phone # xxx-xxx-');
           input(phone,4);
           echo:=TRUE;
         end else begin
           phone:=(copy(thisuser.ph,9,4));
         end;
         echo:=TRUE;
         if ((thisuser.pw=pw) and (copy(thisuser.ph,9,4)=phone)) then
         begin

        if ((thisuser.sl>systat.newsl) or (thisuser.dsl>systat.newdsl)) then
        begin
          sysoplog('Found out matrix password');
          nl;
          printf('val');
          sprint('^4The System Password is '+#3#5+systat.shuttlepw);
          nl;
          loggedon:=pynq('Would you like to log on now? [No] ');
        end else
        begin
          nl;
          printf('notval');
          if (nofile) then sprint('You have not been validated yet.');
          pausescr;
        end;
        end else sprint('That password is incorrect.');
       end;

        end;

      5:begin
        end;
    end;
  end;
  until (loggedon) or (hangup);

end;


procedure dodossim;
var s,phone,cmd,pw,newmenucmd:astr;
    what:string[20];
    backme,blahblah,tries,i,countmenow,nocsave:integer;
    loggedon,rightone,gotname,formatted,noneedname,ok,cmdnothid,cmdexists:boolean;
begin
  thisuser.ac:=thisuser.ac+[ansi];
  thisuser.ac:=thisuser.ac-[avatar];
  formatted:=false;
  rightone:=TRUE;
  loggedon:=FALSE;
  gotname:=FALSE;
  tries:=0;
  cls;
  nl;
  repeat
    if (not rightone) then begin
      sprint('Bad command or file name');
      nl;
      rightone:=TRUE;
    end;
    sprompt(#3#0+systat.startdir+'>');
    what:='';
    inputl(what,20);
    for blahblah:=1 to length(what) do
      what[blahblah]:=upcase(what[blahblah]);
    rightone:=FALSE;
    if (formatted) and (what<>'DIR') then what:='';
    if (what='DIR') then begin
      nl;
      rightone:=TRUE;
      sprint('Volume in drive C is INSANITY');
      sprint('Volume Serial Number is 20A0-3D92');
      sprint('Registered to '+regbbs);
      sprint('Directory of C:\DOS');
      nl;
      sprint('.            <DIR>     02-04-92  12:02a');
      sprint('..           <DIR>     02-04-92  12:02a');
      if (not formatted) then begin
      sprint('LOGON    EXE     20932 02-17-92  12:02p');
      sprint('APPLY    EXE      9856 02-17-92  12:02p');
      sprint('CHECK    EXE      3073 02-17-92  12:02p');
      sprint('INFO     COM       234 02-17-92  12:02p');
      sprint('NEWS     COM      4903 02-17-92  12:02p');
      sprint('GOODBYE  EXE      5435 02-17-92  12:02p');
      sprint('        6 file(s)      38296 bytes');
      sprint('                     3598336 bytes free');
      end else begin
        nl;
        sprint('File not found');
        nl;
      end;
      nl;
    end;
    if what='VER' then begin
      nl;
      rightone:=true;
      sprint('Insanity DOS Simulator v'+ver);
      sprint('          (c)Copyright 1993,95 RoboZapp');
      nl;
    end;
    if what='FDISK' then begin
      nl;
      rightone:=true;
      sprint('FDisk v'+ver+' - Insanity BBS Software');
      nl;
      sprint('Access denied.');
      nl;
    end;
    if what='GOODBYE' then begin rightone:=true; hangup:=TRUE; end;
    if pos('FORMAT',what)<>0 then begin
      nl;
      rightone:=true;
      sprompt('Formatting current drive...');
      sprompt('0%');
      for countmenow :=1 to 49 do
      begin
        sprompt(cstr(countmenow*2)+'%');
        delay(200);
        ansig(28,wherey);
      end;
      sprint('100%');
      formatted:=TRUE;
      nl;
    end;
    if (what='NEWS') or (what='NEWS.COM') then begin
      rightone:=true;
      printf('mnews');
      if (nofile) then begin
        nl;
        sprint('Sorry, no news today.');
        nl;
      end;
    end;
    if (what='INFO') or (what='INFO.COM') then begin
      rightone:=true;
      nl;
      sprint(' Welcome to '+stripcolor(systat.bbsname)+'...'+cstr(systat.numusers)+' users.');
      sprint('Date/Time is [ '+date+' '+time+' ]');
      sprint(' - Insanity v'+ver);
      sprint(' = Registered to '+regsysop);
      sprint('  (c)Copyright 1992, All Rights Reserved.');
      sprint(' Modem Information');
      sprint(' Serial Port   : COM'+cstr(modemr.comport));
      sprint(' Current speed : '+spd);
      nl;
    end;
    if what='CHKDSK' then begin
      rightone:=true;
      nl;
      sprint('Volume Serial Number is 36A0-6BD2');
      sprint('Errors found, F parameter not specified');
      sprint('Corrections will not be written to disk');
      nl;
      nl;
      delay(2000);
      sprint('   92 lost allocation units found in 11 chains.');
      sprint('    182272 bytes disk space would be freed');
      nl;
      sprint(' 212716096 bytes total disk space');
      sprint('     73728 bytes in 2 hidden files');
      sprint('     53952 bytes in 2 directories');
      sprint('    109856 bytes in 7 user files');
      sprint(' 201596288 bytes available on disk');
      nl;
      sprint('      2048 bytes in each allocation unit');
      sprint('    140877 total allocation units on disk');
      sprint('      1756 available allocation units on disk');
      nl;
      sprint('    655360 total bytes memory');
      sprint('    640768 bytes free');
      nl;
    end;
    if what='CLS' then begin cls; rightone:=true; end;
    if ((what='LOGON') or (what='LOGON.EXE')) then begin
      rightone:=true;
      begin
        if systat.shuttlepw='' then loggedon:=TRUE
        else begin
          nl;
          echo:=FALSE;
          sprompt(#3#0+'System Password :'); input(pw,20); nl;
          echo:=TRUE;
          if (pw=systat.shuttlepw) then begin loggedon:=TRUE; gotname:=TRUE; end
          else begin
	    sl1('Illegal Matrix Password "'+pw+'"');
            print(ilogon);
            inc(tries);
          end;
        end;
      end;
    end; 
      if ((what='APPLY') or (what='APPLY.EXE')) then begin
          rightone:=true;
          nl;
          if (gotname) then begin
            sprint('You are already a user.');
            nl;
          end else 
         begin
          if pynq('Apply for account here? [No] ') then
          begin
            newuserinit('');
            newuser;
            if (usernum>0) and (not hangup) then
            begin
              gotname:=TRUE;
              useron:=TRUE;
              logon1st;
            end;
          end;
         end;
      end;

      if ((what='CHECK') or (what='CHECK.EXE')) then begin
        rightone:=true;

        sprint(#3#0+'Checking Validation...');
        nl;
        sprompt(#3#0+'Handle/Alias :');
        finduser(s,usernum);
        if (usernum>=1) then begin
         reset(uf); seek(uf,usernum); read(uf,thisuser);
         nl;
         sprompt('Password :');
         input(pw,20);
         if (systat.phonepw) then
         begin
           sprompt('Phone # xxx-xxx-');
           input(phone,4);
           echo:=TRUE;
         end else begin
           phone:=(copy(thisuser.ph,9,4));
         end;
         echo:=TRUE;
         if ((thisuser.pw=pw) and (copy(thisuser.ph,9,4)=phone)) then
         begin
        
        if ((thisuser.sl>systat.newsl) or (thisuser.dsl>systat.newdsl)) then
        begin
          sysoplog('Found out matrix password');
          nl;
          printf('val');
          sprint('^4The System Password is '+#3#5+systat.shuttlepw);
          nl;
          loggedon:=pynq('Would you like to log on now? [No] ');
        end else
        begin
          nl;
          printf('notval');
          if (nofile) then sprint('You have not been validated yet.');
          pausescr;
        end;
        end else sprint('That password is incorrect.');
       end;
      end;
  
  until (loggedon) or (hangup);
end;

procedure linelogon;
var pw,phone,s,what:astr;
    tries,checkwhat:integer;
    loggedon,gotname:boolean;
begin
  printf('preask');
  with thisuser do
  begin
    ac:=ac+[ansi];
    ac:=ac-[avatar];
  end;
  loggedon:=FALSE; 
  gotname:=FALSE; 
  tries:=0;
  begin
    printf('matrix');
    repeat
    if serialnumber<>0 then sprint(#3#0+'['+cstr(serialnumber)+']');
    sprompt(#3#0+'Logon Command:');
    inputl(what,15);
    for checkwhat:= 1 to length(what) do
      what[checkwhat]:=upcase(what[checkwhat]);

    if (what='L') or (what='1') then begin
      if systat.shuttlepw='' then loggedon:=TRUE
      else begin
        nl;
        echo:=FALSE;
        sprompt(#3#0+'System Password :'); 
        input(pw,20); 
        nl;
        echo:=TRUE;
        if (pw=systat.shuttlepw) then begin
          loggedon:=TRUE; 
          gotname:=TRUE; 
        end else begin
	  sl1('Illegal Matrix Password "'+pw+'"');
          print(ilogon);
          inc(tries);
        end;
      end;
    end;
    
    if (what='C') or (what='2') then begin
      sprint(#3#0+'Checking Validation...');
      nl;
      sprompt(#3#0+'Handle/Alias :');
      finduser(s,usernum);
      if (usernum>=1) then begin
       reset(uf);
       seek(uf,usernum); 
       read(uf,thisuser);
       nl;
       sprompt('Password :');
       input(pw,20);
       if (systat.phonepw) then
         begin
           sprompt('Phone # xxx-xxx-');
           input(phone,4);
           echo:=TRUE;
         end else begin
           phone:=(copy(thisuser.ph,9,4));
         end;
       echo:=TRUE;
       if ((thisuser.pw=pw) and (copy(thisuser.ph,9,4)=phone)) then
         begin
           if ((thisuser.sl>systat.newsl) or (thisuser.dsl>systat.newdsl)) then
           begin
             sysoplog('Found out matrix password');
             nl;
             printf('val');
             sprint('^4The System Password is '+#3#5+systat.shuttlepw);
             nl;
             loggedon:=pynq('Would you like to log on now? [No] ');
           end else
           begin
             nl;
             printf('notval');
             if (nofile) then sprint('You have not been validated yet.');
             pausescr;
           end;
         end else sprint('That password is incorrect.');
      end;
    end;
    if (what='H') or (what='?') then printf('matrix');  
    if (what='A') or (what='3') then begin
      nl;
      if (gotname) then
      begin
        sprint('You are already a user.');
        nl;
      end else 
      begin
        if pynq('Apply for account here? [No] ') then
        begin
          newuserinit('');
          newuser;
          if (usernum>0) and (not hangup) then
          begin
            gotname:=TRUE;
            useron:=TRUE;
            logon1st;
          end;
        end;
      end;
    end;

    if (what='G') or (what='H') or (what='4') then begin
      hangup:=TRUE;
    end;
    until (loggedon) or (hangup);
  end;
end;  

procedure getacsuser(eventnum:integer; acsreq:astr);
var user:userrec;
    sr:smalrec;
    r:real;
    s,pw:astr;
    cp,un,i:integer;
    c:char;
    sfo:boolean;

  procedure dobackspace;
  begin
    dec(cp);
    outkey(^H); outkey(' '); outkey(^H);
  end;

begin
  printf('acsea'+cstr(eventnum));
  if (nofile) then begin
    print('');
    print('   You have entered a restricted time zone   ');
    print('      - AUTHORIZED CALLERS ONLY -            ');
    print('    Illegal logon attempts are logged        ');
    print('');
    nl;
  end;
  nl;
  print('Current Date/Time - '+date+' [ '+time+' ]');
  print('** Failure to respond w/ valid account within 20 seconds, terminates connection.');
  nl;
  print('  Enter Username or ID #');
  print('  ');
  prt('     ');
  checkhangup;
  if (hangup) then exit;
  r:=timer; s:=''; cp:=1; echo:=TRUE;
  repeat
    checkhangup;
    c:=inkey;
    if (c<>#0) then
      case c of
        ^H:if (cp>1) then dobackspace;
        ^X:while (cp<>1) do dobackspace;
        #32..#255:
           if (cp<=36) then begin
             c:=upcase(c);
             outkey(c);
             s[cp]:=c; inc(cp);
           end;
      end;
    if (timer-r>20.0) then hangup:=TRUE;
  until ((c=^M) or (hangup));
  s[0]:=chr(cp-1);
  if (not hangup) then begin
    nl; nl;
    un:=value(s);
    if (un<>0) then begin
      reset(uf);
      if (un>filesize(uf)-1) then un:=0
      else begin
        seek(uf,un);
        read(uf,user);
      end;
      close(uf);
    end else begin
      sfo:=(filerec(sf).mode<>fmclosed);
      if (not sfo) then reset(sf);
      un:=0; i:=1;
      while ((i<=filesize(sf)-1) and (un=0)) do begin
        seek(sf,i); read(sf,sr);
        if (s=sr.name) then un:=sr.number;
        inc(i);
      end;
      if (un>filesize(sf)-1) then un:=0;
      if (not sfo) then close(sf);
      if (un<>0) then begin
        reset(uf);
        seek(uf,un); read(uf,user);
        close(uf);
      end;
    end;
    if (un<>0) then usernum:=un;
    if ((user.deleted) or (not aacs1(user,usernum,acsreq))) then un:=0;
    if (un=0) then begin
      print('Invalid Account'); nl;
      printf('acseb'+cstr(eventnum));
      if (nofile) then begin
        print('This restricted time window allows authorized users ONLY.');
        print('Call back when public access has been restored.');
      end;
      hangup:=TRUE;
    end else begin
      print('Valid Account.');
      nl;
      echo:=FALSE;
      sprompt('Enter your password  '); input(pw,20);
      if (pw<>user.pw) then begin
        nl;
        print('Invalid password.  Hanging up.'); nl;
        printf('acseb'+cstr(eventnum));
        if (nofile) then begin
        print('This restricted time window allows authorized users ONLY.');
        print('Call back when public access has been restored.');
        end;
        hangup:=TRUE;
      end else
        nl;
      echo:=TRUE;
    end;
  end;
end;

function getuser:boolean;

var blp,pw,s,phone,newusername,acsreq:astr;
    lng:longint;
    x,cras,cnt,tries,i,ttimes,z,zz,eventnum:integer;
    cont,done,nu,ok,toomuch,wantnewuser,acsuser:boolean;
begin
  wasnewuser:=FALSE; wasguestuser:=FALSE;
  thisuser.tltoday:=15;  { allow user 15 minutes to log on >MAX< }
  extratime:=0.0; freetime:=0.0; choptime:=0.0;
  with thisuser do begin
    usernum:=-1;
    name:='Nobody Yet'; realname:='Nobody Yet';
    sl:=0; dsl:=0; ar:=[];
    ac:=[onekey,pause,novice,color]; ac:=ac+systat.newac;
    linelen:=80; pagelen:=25;
  end;
  getdatetime(timeon);
  mread:=0; extratime:=0.0; freetime:=0.0;
  realsl:=-1; realdsl:=-1;
  newusername:='';

  (* Turn off encryption until user logon *)
  systat.encrypt:=false;

  sl1('');
  s:=#3#3+'Logon '+#3#5+'['+dat+']'+#3#4+' (';
  if (spd<>'KB') then s:=s+spd+' baud)' else s:=s+'Keyboard)';
  sl1(s);
  sprint('(Connect '+spd+')');
  wantnewuser:=FALSE;
  macok:=FALSE; nu:=FALSE;
  echo:=TRUE; nl;
  pw:='';

  donetstuff;

  (* 300 baud lockout *)

  if (spd='300') then
  begin
    if (systat.lock300) then
    begin
      prt('Baud lockout password :');
      inputl(blp,20);
      if blp<>systat.lockoutpass then 
      begin
        printf('no300.msg');
        if (nofile) then print('300 baud callers not allowed on this BBS.');
        hangup:=TRUE;
      end;
    end;
    if ((systat.b300lowtime<>0) or (systat.b300hitime<>0)) then
      if (not intime(timer,systat.b300lowtime,systat.b300hitime)) then begin
        printf('no300h.msg');
        if (nofile) then
          print('300 baud calling hours are from '+ctim(systat.b300lowtime)+
                ' to '+ctim(systat.b300hitime));
        hangup:=TRUE;
      end;
    if (not hangup) then
      if ((systat.b300lowtime<>0) or (systat.b300hitime<>0)) then begin
        printf('yes300h.msg');
        if (nofile) then begin
          print('NOTE: 300 baud calling times are');
          print('restricted to the following hours ONLY:');
          print('  '+ctim(systat.b300lowtime)+' to '+ctim(systat.b300hitime));
        end;
      end;
  end;

  (* 1200 baud lockout *)

  if (spd='1200') then
  begin
    if (systat.lock1200) then
    begin
      prt('Baud lockout password :');
      inputl(blp,20);
      if blp<>systat.lockoutpass then 
      begin
        printf('no1200.msg');
        if (nofile) then print('1200 baud callers not allowed on this BBS.');
        hangup:=TRUE;
      end;
    end;
  end;

  (* 2400 baud lockout *)

  if (spd='2400') then
  begin
    if (systat.lock2400) then
    begin
      prt('Baud lockout password :');
      inputl(blp,20);
      if blp<>systat.lockoutpass then 
      begin
        printf('no2400.msg');
        if (nofile) then print('2400 baud callers not allowed on this BBS.');
        hangup:=TRUE;
      end;
    end;
  end;

  acsuser:=FALSE;
  for i:=0 to numevents do
    with events[i]^ do
      if ((etype='A') and (active) and (checkeventtime(i,0))) then begin
        acsuser:=TRUE;
        acsreq:=events[i]^.execdata;
        eventnum:=i;
      end;
  if (acsuser) then getacsuser(eventnum,acsreq);
  if ((systat.shuttlelog) and (not fastlogon) and (not hangup)) then linelogon;
  if ((systat.dossim) and (not fastlogon) and (not hangup)) then dodossim;
  if ((systat.pulls) and (not fastlogon) and (not hangup)) then begin dopulls;
  end;
  nl;
  if (not wantnewuser) and (not fastlogon) then begin
    thisuser.ac:=thisuser.ac+[ansi];
    thisuser.ac:=thisuser.ac-[avatar];
    printf('welcome');
    z:=0;
    repeat
      inc(z);
      printf('welcome'+cstr(z));
    until (z=9) or (nofile) or (hangup);
  end;

 (***    H E R E   S T A R T S   T H E   S C R I P T   F I L E !   ***) 

  assign(sfile,'script.dat');
  reset(sfile);
  it:=0;
  repeat
    it:=it+1;
    readln(sfile,line[it]);
  until eof(sfile);
  zzz:=0;
  ddd:=0;
  qqq:=0;
  clsnow[1]:=FALSE;
  clsnow[2]:=FALSE;
  clsnow[3]:=FALSE;
  pcolor[1]:=-1;
  pcolor[2]:=-1;
  pcolor[3]:=-1;
  beep[1]:=FALSE;
  beep[2]:=FALSE;
  beep[3]:=FALSE;
  for tit:= 1 to it do
    begin
      if length(line[tit])=1 then begin
        ccc:=ccc+1;
        templine:=line[tit];
        val(templine,pcolor[ccc],code);
      end;
      if line[tit] = 'CLS' then begin ddd:=ddd+1; clsnow[ddd]:=TRUE; end;
      if line[tit] = 'BEEP' then begin qqq:=qqq+1; beep[qqq]:=TRUE; end;
      if copy(line[tit],1,4)='SHOW' then begin
        zzz:=zzz+1;
        showfile[zzz]:=copy(line[tit],6,length(line[tit]));
      end;
      if copy(line[tit],1,6)='HANDLE' then begin
        temp:=copy(line[tit],8,length(line[tit]));
        xhandle:=0;
        yhandle:=0;
        zit:=pos(',',temp);
        val(copy(temp,1,zit-1),xhandle,code);
        val(copy(temp,zit+1,length(temp)),yhandle,code);
      end;
      if copy(line[tit],1,2)='PW' then begin
        temp:=copy(line[tit],4,length(line[tit]));
        xpw:=0;
        ypw:=0;
        zit:=pos(',',temp);
        val(copy(temp,1,zit-1),xpw,code);
        val(copy(temp,zit+1,length(temp)),ypw,code);
      end;
      if copy(line[tit],1,5)='PHONE' then begin
        temp:=copy(line[tit],7,length(line[tit]));
        xphone:=0;
        yphone:=0;
        zit:=pos(',',temp);
        val(copy(temp,1,zit-1),xphone,code);
        val(copy(temp,zit+1,length(temp)),yphone,code);
      end;
    end;
  close(sfile);

  ttimes:=0; tries:=0; s:='';
  repeat
    repeat
      if (not wantnewuser) then begin
        if (clsnow[1]) then cls;
        printf(showfile[1]);
        if(beep[1]) then sprompt(^G);
        ansig(xhandle,yhandle);
        tc(15);
      end;
      if (systat.shuttlelog) and (wantnewuser) then begin
        s:='';
        usernum:=-1;
      end else
        finduser(s,usernum);

      if (pos('@',s)<>0) then begin
        cls;
        nl;
        print('Haha.  You dickhead.');
        sl1('Idiot tried to gain illegal system info with @@ MCI usage at logon');
        hangup:=TRUE;
      end;

      if (not hangup) then begin
        newusername:='';
        if (usernum=0) then
          if (s<>'') then begin
            cls;
            nl;
            sprint(fstring.namenotfound);
            if pynq('Apply for account here? [No] ') then usernum:=-1;
            nl;
            newusername:=s;
          end else begin
            inc(ttimes);
            if (ttimes>systat.maxlogontries) then hangup:=TRUE;
          end;
      end;
    until ((usernum<>0) or (hangup));
    ok:=TRUE; done:=FALSE;
    if (not hangup) then
      case usernum of
       -1:begin
            nl;
            newuserinit(newusername);
            nu:=TRUE;
            done:=TRUE; ok:=FALSE;
          end;
       -2:begin
            nl;
            reset(uf);
            usernum:=systat.guestuser;
            if (usernum>filesize(uf)-1) then begin
              sl1(#3#0+'Guest account unavailable!');
              print('Guest account has been disabled.');
              hangup:=TRUE;
            end else begin
              seek(uf,systat.guestuser); read(uf,thisuser);
              print('Terminal Configuration -');
              cstuff(11,1,thisuser);
              cstuff(3,1,thisuser);
              nl;
              print('As a guest user we ask that you enter a unique name for our system records.');
              cstuff(7,1,thisuser);
              nl;
              wasguestuser:=TRUE; done:=TRUE;
            end;
            close(uf);
          end;
      else
          if (usernum=-3) then begin
            nl;
            print('Haha.  You bastard.');
            sl1('Idiot tried to crash system with negative number entry at logon');
            hangup:=TRUE;
          end else begin
            reset(uf);
            seek(uf,usernum); read(uf,thisuser);
            echo:=FALSE;
            if (not systat.localsec) then begin
              if (not useron) then begin
                useron:=TRUE;
                schangewindow(TRUE,systat.curwindow);
              end else
                schangewindow(FALSE,systat.curwindow);
              commandline('This user''s password is "'+thisuser.pw+'"');
              useron:=FALSE;
            end;

              (*
              You know, dammit... there wasn't code in there for this!
              *)
            if (thisuser.deleted) then begin
              cls;
              cnt:=0;
              repeat
                inc(cnt);
                sprompt('Account deleted!   ');
              until (hangup) or (cnt=100);
              hangup:=true;
            end;

            getpws(ok,tries);
            if (ok) then
            begin
              done:=TRUE;
              readinmacros; readinzscan;
            end;

            close(uf);
            if (not ok) then begin
              useron:=TRUE; sclearwindow; useron:=FALSE;
            end;
          end;
    end;
  until ((done) or (hangup));
  if ((thisuser.lockedout) and (not hangup)) then begin
    printf(thisuser.lockedfile);
    sysoplog(#3#7+'['+#3#8+'*'+#3#7+'] '+#3#3+thisuser.name+#3#5+
             'Attempt to access system when locked out.');
    delay(1000);
    hangup:=TRUE;
  end;
  if ((not nu) and (not hangup)) then
  begin
    toomuch:=FALSE;
    if (thisuser.laston<>date) then begin
      thisuser.ontoday:=0;
      thisuser.tltoday:=systat.timeallow[thisuser.sl];
    end;
    if (((rlogon in thisuser.ac) or (systat.callallow[thisuser.sl]=1)) and
       (thisuser.ontoday>=1) and (thisuser.laston=date)) then begin
      printf('2manycal');
      if (nofile) then print('You have logged on too many times today!');
      toomuch:=TRUE;
    end else
      if ((thisuser.ontoday>=systat.callallow[thisuser.sl]) and
          (thisuser.laston=date)) then begin
        printf('2manycal');
        if (nofile) then
          print('You can only log on '+cstr(systat.callallow[thisuser.sl])+' times per day.');
        toomuch:=TRUE;
      end else
        if ((thisuser.tltoday<=0) and (thisuser.laston=date)) then begin
          printf('notlefta');
          if (nofile) then
            prompt('You can only log on for '+cstr(systat.timeallow[thisuser.sl])+' minutes per day.');
          toomuch:=TRUE;
          if (thisuser.timebank>0) then begin
            nl; nl;
            sprint(#3#5+'However, you have '+cstrl(thisuser.timebank)+
                   ' minutes left in your System Bank(tm)');
            dyny:=TRUE;
            if pynq('Withdraw from System Bank(tm)? [No] ') then begin
              prt('Withdraw how many minutes? '); inu(zz); lng:=zz;
              if (lng>0) then begin
                if (lng>thisuser.timebank) then lng:=thisuser.timebank;
                dec(thisuser.timebankadd,lng);
                if (thisuser.timebankadd<0) then thisuser.timebankadd:=0;
                dec(thisuser.timebank,lng);
                inc(thisuser.tltoday,lng);
                sprint('^5In your account: ^3'+cstr(thisuser.timebank)+
                        '^5   Time left online: ^3'+cstr(trunc(nsl) div 60));
                sysoplog('System Bank(tm): No time left at logon, withdrew '+cstrl(lng)+' minutes.');
              end;
            end;
            if (nsl>=0) then toomuch:=FALSE else sprint(#3#7+'Hanging up.');
          end;
        end;
    if (toomuch) then
    begin
      sl1(#3#7+' [*] '+#3#1+thisuser.name+' #'+cstr(usernum)+' tried logging on more than allowed.');
      hangup:=TRUE;
    end;

    if(not aacs(nodeinfo.acs)) then begin
      sl1(#3#7+' [*] '+#3#1+thisuser.name+' #'+cstr(usernum)+' tried to log on to a restriced node.');
      cls;
      sprint('You do not have access to this node!');
      delay(1000);
      hangup:=TRUE;
    end;

    if (tries=systat.maxlogontries) then hangup:=TRUE;
    if (not hangup) then inc(thisuser.ontoday);
  end;
  checkit:=FALSE;
  if ((usernum>0) and (not hangup)) then
  begin

    if (systat.cras) then begin
      cls;
      printf('crasmesg');
      if (nofile) then sprint('Challenge-Response Authentication System');
      x:=random(99)+1;
      sprompt(cstr(x)+' : ');
      inu(cras);
      if (not cras=(x+69)*3) then begin
        sprint('Invalid authenticator code.');
        sprint('Disconnecting...');
        hangup:=true;
      end;
    end;

    if (not aacs(systat.encryptacs)) then
      begin
        cls;
        printf('encrypt');
        if (nofile) then sprint('Data security has been enabled.  All material has been encrypted.');
        delay(1000);
        systat.encrypt:=TRUE;
      end;

    getuser:=nu;
    useron:=TRUE;
    schangewindow(not cwindowon,systat.curwindow);

    commandline('[ Successful Logon ]');
    useron:=FALSE;

    inittrapfile;
    makenode(2);
    makenodeon(thisuser.name,usernum);
    s:=#3#0+systat.bbsname+#3#5+'  '+#3#4+'Insanity v^5'+ver;
(*    if (fidor.net<>0) then s:=s+' NETTED ['+cstr(fidor.zone)+':'+cstr(fidor.net)+'/'+
      cstr(fidor.node)+'.'+cstr(fidor.point)+']'; *)
    nl;
    nl;
    sprint(s);
    sprint('^3InsaneNet node ^4 ^6'+clasicnode);
    nl;
  end;
  if (hangup) then getuser:=FALSE;
end;
end.
