{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit driver;

interface

uses crt,dos;

function driverres:boolean;
function drivergetver:integer;
procedure ssactivate;
procedure ssdeactivate;
function ssgetstatus:boolean;
procedure sseffkeypress;
procedure ssforceon;
procedure ssforceoff;
procedure sssetmins(mins:byte);

implementation

function driverres:boolean;
var regs:registers;
begin
  regs.ax:=$4E49; (* AX='NI' the indentification string *)
  regs.dx:=$0000; (* Function: Detection, Subfunction: Is Installed? *)
  intr($2F,regs); (* Call Multiplexer Interrupt *)
  if(regs.ax=$2477) then driverres:=TRUE else driverres:=FALSE; (* Did it return 2/4/77 id string? *)
end;

function drivergetver:integer;
var regs:registers;
begin
  regs.ax:=$4E49; (* ID string *)
  regs.dx:=$0001; (* Function: Detection, Subfunction: Get version *)
  intr($2F,regs);
  drivergetver:=regs.ax;  (* should return $1002 (2.10=2.1...) *)
end;

procedure ssactivate;
var regs:registers;
begin
  regs.ax:=$4E49;  (* ID string *)
  regs.dx:=$0100;  (* Function: Screen Saver, Subfunction: Activate *)
  intr($2F,regs);
end;

procedure ssdeactivate;
var regs:registers;
begin
  regs.ax:=$4E49;  (* ID string *)
  regs.dx:=$0101;  (* Function: SS, Subfunction: Deactivate *)
  intr($2F,regs);
end;

function ssgetstatus:boolean;
var regs:registers;
begin
  regs.ax:=$4E49; (* ID string *)
  regs.dx:=$0102; (* Function: SS, Subfunction: Get status *)
  intr($2F,regs);
  if(regs.ax=0) then ssgetstatus:=FALSE else ssgetstatus:=TRUE;  (* Return TRUE if active *)
end;

procedure sseffkeypress;
var regs:registers;
begin
  regs.ax:=$4E49; (* ID string *)
  regs.dx:=$0103; (* Function: SS, Subfunction: Effective Key Press *)
  intr($2F,regs);
end;

procedure ssforceon;
var regs:registers;
begin
  regs.ax:=$4E49;  (* ID string *)
  regs.dx:=$0104;  (* Function: SS, Subfunction: Force SS on *)
  intr($2F,regs);
end;

procedure ssforceoff;
var regs:registers;
begin
  regs.ax:=$4E49;  (* ID string *)
  regs.dx:=$0105;  (* Function: SS, Subfunction: Force SS off *)
  intr($2F,regs);
end;

procedure sssetmins(mins:byte);
var regs:registers;
begin
  regs.ax:=$4E49;  (* ID string *)
  regs.dx:=$0106;  (* Function: SS, Subfunction: Set mins to plasma *)
  regs.bl:=mins;   (* Pass along mins as parameter *)
  intr($2F,regs);
end;

end.