(****************************************************************************
*   Conference functions - creation 08/18/92 - 2.2                          *
****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit confer;

interface

uses
  crt, dos, overlay,
  common, mail0;

procedure choosemessconf;
procedure choosefileconf;
procedure setmessconf(nconf:byte; echo:boolean);
procedure setfileconf(nconf:byte; echo:boolean);

implementation


procedure choosemessconf;
var  thisconf:confrec;
     confaccess:array[1..255] of byte;
     numval:byte;
     i:integer;
     gotvalnum:boolean;
begin
  gotvalnum:=FALSE;
  numval:=0;
  for i:=1 to systat.nummessconf do begin
    seek(messconff,i-1);
    read(messconff,thisconf);
    if(aacs(thisconf.acs)) then begin
      numval:=numval+1;
      confaccess[numval]:=i;
    end;
  end;

  if(numval=1) then begin
    setmessconf(confaccess[1],TRUE);
  end else if(numval>1) then begin
    sprint(#3#4+'Ŀ');
    sprint(#3#4+''+#3#5+'###'+#3#4+''+#3#5+'Description                             '+#3#4+'');
    sprint(#3#4+'Ĵ');
    for i:=1 to numval do begin
      seek(messconff,confaccess[i]-1);
      read(messconff,thisconf);
      sprint(#3#4+''+#3#5+mn(i,3)+#3#4+''+#3#0+mln(thisconf.desc,40)+#3#4+'');
    end;
    sprint(#3#4+'');
    while(gotvalnum=FALSE) and (hangup=FALSE) do begin
      nl;
      prt(#3#0+'Message Conference'+#3#5+': '+#3#6); inu(i);
      if((i>0) and (i<=numval)) then begin
	setmessconf(confaccess[i],TRUE);
        gotvalnum:=TRUE;
      end else begin
        nl;
        sprint('Enter a number from 1-'+cstr(numval)+'.');
      end;
    end;
  end;
end;

procedure choosefileconf;
var  thisconf:confrec;
     confaccess:array[1..255] of byte;
     numval:byte;
     i:integer;
     gotvalnum:boolean;
begin
  gotvalnum:=FALSE;
  numval:=0;
  for i:=1 to systat.numfileconf do begin
    seek(fileconff,i-1);
    read(fileconff,thisconf);
    if(aacs(thisconf.acs)) then begin
      numval:=numval+1;
      confaccess[numval]:=i;
    end;
  end;

  if(numval=1) then begin
    setfileconf(confaccess[1],TRUE);
  end else if(numval>1) then begin
    sprint(#3#4+'Ŀ');
    sprint(#3#4+''+#3#5+'###'+#3#4+''+#3#5+'Description                             '+#3#4+'');
    sprint(#3#4+'Ĵ');
    for i:=1 to numval do begin
      seek(fileconff,confaccess[i]-1);
      read(fileconff,thisconf);
      sprint(#3#4+''+#3#5+mn(i,3)+#3#4+''+#3#0+mln(thisconf.desc,40)+#3#4+'');
    end;
    sprint(#3#4+'');
    while(gotvalnum=FALSE) and (hangup=FALSE) do begin
      nl;
      prt(#3#0+'File Conference'+#3#5+': '+#3#6); inu(i);
      if((i>0) and (i<=numval)) then begin
	setfileconf(confaccess[i],TRUE);
        gotvalnum:=TRUE;
      end else begin
        nl;
        sprint('Enter a number from 1-'+cstr(numval)+'.');
      end;
    end;
  end;
end;

procedure setmessconf(nconf:byte; echo:boolean);
var  i:integer;
     thisconf:confrec;
     mco,bo:boolean;
begin
  mco:=(filerec(messconff).mode<>fmclosed);
  if(not mco) then reset(messconff);
  seek(messconff,nconf-1); read(messconff,thisconf);
  bo:=(filerec(bf).mode<>fmclosed);
  if(not bo) then reset(bf);
  if(echo) then begin
    prt(#3#4+' '+#3#5+thisconf.desc+#3#3+' message conference joined.');
    nl;
  end;
  nummbavail:=0;
  for i:=1 to numboards do begin
    seek(bf,i-1); read(bf,memboard);
    if((memboard.conf=nconf) and (aacs(memboard.acs))) then begin
      nummbavail:=nummbavail+1;
      mbpointer[nummbavail]:=i;
    end;
  end;
  changeboard(mbpointer[1]);
  if(not bo) then close(bf);
  if(not mco) then close(messconff);
end;

procedure setfileconf(nconf:byte; echo:boolean);
var  i:integer;
     thisconf:confrec;
     ulfo:boolean;
begin
  seek(fileconff,nconf-1); read(fileconff,thisconf);
  if(echo) then begin
    prt(#3#4+' '+#3#5+thisconf.desc+#3#3+' file conference joined.');
    nl;
  end;
  numfbavail:=0;
  ulfo:=(filerec(ulf).mode<>fmclosed);
  if(not ulfo) then reset(ulf);
  for i:=1 to maxulb+1 do begin
    seek(ulf,i-1); read(ulf,memuboard);
    if((memuboard.conf=nconf) and (aacs(memuboard.acs))) then begin
      numfbavail:=numfbavail+1;
      fbpointer[numfbavail]:=i-1;
    end;
  end;
  if(not ulfo) then close(ulf);
  changefileboard(fbpointer[1]);
end;

end.

