program convert_new_user_voting;
uses crt,dos;

type
  astr=string[160];
  nuvrec=
  record
    unum:integer;                   { User number being voted on }
    handle:astr;                    { Handle of user being voted on }
    no,                             { No votes }
    yes,                            { Yes votes }
    totvoted:integer;               { # of users voted on him already }
    votedby:array[1..255] of integer;{ #'s of users that have voted on him, so they can't vote more than once }
    exists:boolean;                 { Still exists to be voted upon? }
    commentptr:longint;             { Pointer to comments in comment file }
    res:array[1..156] of byte;      { RESERVED }
  end;

var test:file;
    nuvf:file of nuvrec;
    thisnuv:nuvrec;
    at,i:integer;

begin
  textcolor(3);
  write('Conversion from ');
  textcolor(11);
  write('Insanity 2.6');
  textcolor(3);
  write(' new user voting to ');
  textcolor(11);
  write('Insanity 2.7');
  textcolor(3);
  writeln(' message headers');
  if(paramcount<1) then begin
    textcolor(15);
    write('Usage: ');
    textcolor(3);
    write('CNVNUV {');
    textcolor(11);
    write('Full gfile path');
    textcolor(3);
    writeln('}');
  end else begin
    chdir(paramstr(1));
    assign(test,'INS27NUV.CNV');  { Check for existance of conversion file }
    {$I-} reset(test); {$I+}
    if(ioresult=0) then begin
      textcolor(12);
      writeln('You have already converted your new user voting!');
    end else begin
      assign(nuvf,'nuv.dat');
      reset(nuvf);  at:=0;
      while(not eof(nuvf)) do begin
	seek(nuvf,at);
	read(nuvf,thisnuv);
	thisnuv.commentptr:=0;
	for i:=1 to 156 do begin
	  thisnuv.res[i]:=0;
	end;
	seek(nuvf,at);
	write(nuvf,thisnuv);
	inc(at);
      end;
      close(nuvf);
    end;
    rewrite(test);
    close(test);
  end;
end.

