program convert_message_headers;
uses crt,dos;

type

fromtoinfo=                  { from/to information for mheaderrec }
record
  anon:byte;                 { anonymous type }
  usernum:word;              { user number }
  as:string[62];             { given name for this case }
  real:string[36];           { user real name }
  alias:string[46];          { user alias }
end;

oldmheaderrec=                  { *.BRD : Message header records }
record
  signature:longint;         { header signature - $FFFFFFFF }
  msgptr:longint;            { pointer to message text }
  msglength:longint;         { length of message text }
  fromi:fromtoinfo;          { from information }
  toi:fromtoinfo;            { to information }
  title:string[60];          { title of message }
  origindate:string[19];     { Echo/Group original msg date }
end;

cpackdatetime=array[1..6] of byte;

msgindexstatr=
 (miexist,                      { does message actually exist? }
  milocal,                      { is it encrypted? encrypted}
  miunvalidated,                { is message unvalidated? }
  mipermanent,                  { is the message permanent? }
  miallowmci,                   { DID owner have access to MCI? }
  mithreads,                    { is message referenced? (threaded) }
  mimassmail,                   { is it private, mass mail? }
  mihigher);                    { is message scanned for FidoNet? scanned}

oldmsgindexrec=                         { *.MIX : Message index records }
record
  messagenum:word;                   { message number, tonum in EMAIL.MIX }
  hdrptr:longint;                    { pointer to message header }
  msgid:longint;                     { message ID (sequential) }
  isreplytoid:longint;               { ID of replied message }
  msgdate:cpackdatetime;             { message date/time (packed) }
  msgdowk:byte;                      { message day-of-week (0=Sun ...) }
  msgindexstat:set of msgindexstatr; { status flags }
  isreplyto:word;                    { reply this message is to (-1=None) }
  numreplys:word;                    { number of replies to THIS message }
  lowernode:byte;                    { Signifigant node it is from if lower }
																		 { (if 1.6.3.6.0.0 then it's 6) }
  lowerpos:byte;                     { Position in Node ID that the signifigant }
																			 { is in.  (if 1.6.3.6.0.0 then it's 4), if lower }
end;

var
  oldbrdfn,oldmixfn,newbrdfn,newmixfn:string;
  filefound:searchrec;
  convbrd:oldmheaderrec;
  convmix:oldmsgindexrec;
  oldbrd,newbrd,oldmix,newmix,test:file;
  blank:array[1..100] of char;
  arr:array[1..255] of char;
  numread,msgleft:integer;
  i:integer;

begin
  textcolor(3);
  write('Conversion from ');
  textcolor(11);
  write('Insanity 2.6');
  textcolor(3);
  write(' message headers to ');
  textcolor(11);
  write('Insanity 2.7');
  textcolor(3);
  writeln(' message headers');
  if(paramcount<1) then begin
    textcolor(15);
    write('Usage: ');
    textcolor(3);
    write('CNVMHEAD {');
    textcolor(11);
    write('Full message path');
    textcolor(3);
    writeln('}');
  end else begin
    chdir(paramstr(1));
    assign(test,'INS27MB.CNV');  { Check for existance of conversion file }
    {$I-} reset(test); {$I+}
    if(ioresult=0) then begin
      textcolor(12);
      writeln('You have already converted your message bases!');
    end else begin
      findfirst('*.BRD',Archive,filefound);
      while(doserror=0) do begin
	oldbrdfn:=copy(filefound.name,1,pos('.',filefound.name)-1)+'.OLB';
	newbrdfn:=filefound.name;
	oldmixfn:=copy(filefound.name,1,pos('.',filefound.name)-1)+'.OLM';
	newmixfn:=copy(filefound.name,1,pos('.',filefound.name)-1)+'.MIX';
	assign(oldbrd,oldbrdfn);  assign(newbrd,filefound.name);
	assign(oldmix,oldmixfn);  assign(newmix,newmixfn);

	textcolor(9);
	write(' ');
	textcolor(3);
	write('Converting ');
	textcolor(11);
	write(newbrdfn);
	textcolor(3);
	write(' and ');
	textcolor(11);
	write(newmixfn);
	textcolor(3);
	writeln('...');

	rewrite(oldbrd,1);  reset(newbrd,1);   { Copies .BRD into .OLB }
	while(not eof(newbrd)) do begin
	  blockread(newbrd,arr,255,numread);
	  blockwrite(oldbrd,arr,numread);
	end;
	close(oldbrd);  close(newbrd);

	rewrite(oldmix,1);  reset(newmix,1);   { Copies .MIX into .OLM }
	while(not eof(newmix)) do begin
	  blockread(newmix,arr,255,numread);
	  blockwrite(oldmix,arr,numread);
	end;
	close(oldmix);  close(newmix);

	for i:=1 to 100 do blank[i]:=#0;

	reset(oldbrd,1);    reset(oldmix,1);
	rewrite(newbrd,1);  rewrite(newmix,1);
	while(not eof(oldmix)) do begin
	  blockread(oldmix,convmix,sizeof(oldmsgindexrec));  { Read old index }

	  if(convmix.hdrptr<>-1) then begin
	    seek(oldbrd,convmix.hdrptr);
	    blockread(oldbrd,convbrd,sizeof(oldmheaderrec));   { Read old header }

	    if(convbrd.msgptr<>-1) then begin
	      seek(oldbrd,convbrd.msgptr);
	      convbrd.msgptr:=filepos(newbrd);  { Adjust message pointer }
	      msgleft:=convbrd.msglength;

	      while(msgleft>0) do begin       { Rewrite actual message }
		if(msgleft>255) then numread:=255 else numread:=msgleft;
		blockread(oldbrd,arr,numread);
		blockwrite(newbrd,arr,numread);
	      end;
	    end;

	    convmix.hdrptr:=filepos(newbrd);   { Adjust header pointer }
	    blockwrite(newbrd,convbrd,sizeof(oldmheaderrec));  { Write new header }
	    blockwrite(newbrd,blank,100);
	  end;

	  blockwrite(newmix,convmix,sizeof(oldmsgindexrec));  { Write new index }
	  blockwrite(newmix,blank,40);
	end;
	close(oldbrd);    close(oldmix);
	close(newbrd);    close(newmix);

	findnext(filefound);
      end;

      rewrite(test);  { Create file so that we know we have converted }
      close(test);

      textcolor(15);
      write('Note: ');
      textcolor(3);
      writeln('Original .BRD files saved as .OLB, and original .MIX files saved as .OLM');
    end;
  end;

  { I would appreciate it if you leave these last few lines, but go ahead and }
  { change anything else you feel like changing.  You will probably only want }
  { to change the title line. }
  writeln;
  textcolor(9);
  write(' ');
  textcolor(3);
  write('Original InsaneNet message base conversion code by RoboZapp');
  textcolor(9);
  writeln(' ');
end.

