(********************************************************************************
*  ANSI Font Functions - RoboZapp 8/30/92                                       *
********************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}

unit ansifont;

interface

uses
  crt, dos, common;

procedure printafont(message:string; font:byte);
function getfont:byte;

implementation

procedure printafont(message:string; font:byte);
var afont:ansifontrec;
    actfont:file of byte;
    fonttable:array[1..12] of byte;
    i:integer;

  function isdefined(check:char):boolean;
  begin
    check:=chr(ord(check)-32);
    if((fonttable[(ord(check) div 8)+1]) and ((1) shl (ord(check) mod 8))<>0) then begin
{      sprint('debug: '+chr(ord(check)+32)+'->true ('+cstr(ord(fonttable[round(ord(check)/8)+1]))+')'); }
      isdefined:=TRUE;
    end else begin
{      sprint('debug: '+chr(ord(check)+32)+'->false ('+cstr(ord(fonttable[round(ord(check)/8)+1]))+')'); }
      isdefined:=FALSE;
    end;
  end;

  function numbefore(upto:char):byte;
  var nbi:integer;
      nbc:byte;
  begin
    nbc:=0;
    for nbi:=32 to (ord(upto)-1) do begin
      if(isdefined(chr(nbi))=TRUE) then begin
	nbc:=nbc+1;
      end;
    end;
    numbefore:=nbc;
  end;

  procedure seekto(upto:char);
  var sti:integer;
      len,hei:byte;
  begin
{    sprint('debug: seeking to '+upto); }
    reset(actfont);
    seek(actfont,92);
    for sti:=1 to numbefore(upto) do begin
{      sprint('debug: jump '+cstr(sti)); }
      read(actfont,len);
      read(actfont,hei);
      seek(actfont,filepos(actfont)+(len*hei*2));
    end;
  end;

  function heightbig:integer;
  var hsofar,hbi:integer;
      heightthis:byte;
  begin
    hsofar:=0;
    for hbi:=1 to length(message) do begin
      if(isdefined(message[hbi])=FALSE) then begin
	message[hbi]:=upcase(message[hbi]);
      end;
      if(isdefined(message[hbi])=TRUE) then begin
	seekto(message[hbi]);
	read(actfont,heightthis);  {Just a garbage read to position right}
	read(actfont,heightthis);
	if(heightthis>hsofar) then hsofar:=heightthis;
      end;
    end;
    heightbig:=hsofar;
  end;

  procedure printline(line:integer);
  var pli,pli1:integer;
      colssofar,len,hei,ac,cc:byte;
  begin
    colssofar:=0;
    for pli:=1 to length(message) do begin
      if((isdefined(message[pli])=FALSE) and (message[pli]>='a') and (message[pli]<='z')) then begin
	message[pli]:=upcase(message[pli]);
      end;
      if((colssofar<81) and (isdefined(message[pli])=TRUE)) then begin
	seekto(message[pli]);
	read(actfont,len);
	read(actfont,hei);
	colssofar:=colssofar+len;
	if(colssofar>79) then begin
	  colssofar:=81;
	end else begin
	  if(hei>=line) then begin
	    seek(actfont,filepos(actfont)+((line-1)*len*2));
	    for pli1:=1 to len do begin
	      read(actfont,ac);
	      read(actfont,cc);
	      setc(cc);
	      prompt(chr(ac));
	    end;
	  end else begin
	    for pli1:=1 to len do begin
	      prompt(' ');
	    end;
	  end;
	end;
      end;
    end;
    print('');
  end;

begin
  if(font>0) and (font<=systat.numansifont) then begin
    reset(afontf); seek(afontf,font-1); read(afontf,afont);
    assign(actfont,systat.gfilepath+afont.filename); reset(actfont);
    seek(actfont,80);
    for i:=1 to 12 do begin
      read(actfont,fonttable[i]);
    end;

    for i:=1 to heightbig do begin
      printline(i);
    end;

    close(actfont);
    cl(1);
  end else begin
    sprint(#3#0+'Invalid font number: '+#3#5+cstr(font));
  end;
end;

function getfont:byte;
var  afont:ansifontrec;
     confaccess:array[1..255] of byte;
     numval:byte;
     i:integer;
     gotvalnum:boolean;
begin
 if(systat.numansifont>1) then begin
  reset(afontf);
  gotvalnum:=FALSE;
  sprint(#3#4+'Ŀ');
  sprint(#3#4+''+#3#5+'###'+#3#4+''+#3#5+'Description                             '+#3#4+''+
    #3#5+'Uploader                        '+#3#4+'');
  sprint(#3#4+'Ĵ');
  for i:=1 to systat.numansifont do begin
    seek(afontf,i-1);
    read(afontf,afont);
    sprint(#3#4+''+#3#5+mn(i,3)+#3#4+''+#3#0+mln(afont.desc,40)+#3#4+''+#3#0+mln(afont.uploader,32)+#3#4+'');
  end;
  sprint(#3#4+'');
  while(gotvalnum=FALSE) and (hangup=FALSE) do begin
    nl;
    prt(#3#0+'Font Selection'+#3#5+': '+#3#6); inu(i);
    if((i>0) and (i<=systat.numansifont)) then begin
      gotvalnum:=TRUE;
      end else begin
	nl;
	sprint('Enter a number from 1-'+cstr(systat.numansifont)+'.');
    end;
  end;
  getfont:=i;
 end else begin
  getfont:=0;
 end;
end;

end.
