(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2E .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "E" command.           <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,G+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2e;

interface

uses
  crt, dos, overlay,
  common;

procedure poflagfunc;
procedure poflagfunc2;

implementation

function sltype(i:integer):string;
begin
  case i of
    0:sltype:='File only';
    1:sltype:='Printer & File';
    2:sltype:='Printer only';
    end;
end;

procedure poflagfunc2;
var
 c:char;
 tmpshit:string;
 bbsinfoF: file of bbsinfo;
 ii:integer;

 procedure yesorno(that:boolean);
  begin
   if that=TRUE  then sprint (': '+#3#5+bbsinfoz.stryes);
   if that=FALSE then sprint (': '+#3#5+bbsinfoz.strno);
  end;

 procedure tog(var bbb:boolean);
 begin bbb:=not bbb; end;

 procedure ask(crap:string);
  begin
    tmpshit:='';
    nl;
    sprint ('|14Old: '+crap);
    sprint ('|03Hit |09[|11ENTER|09]|03 to abort, or enter NEW string below.');
    inputWC (tmpshit,80);
  end;

begin
 tmpshit:='';
 repeat
  cls;
  sprompt(#3#3+'[1]'+#3#0+' Use oneliners in logons?                  '); yesorno(bbsinfoZ.useoneliners);
  sprompt(#3#3+'[2]'+#3#0+' Use color quotes in messages?             '); yesorno(bbsinfoZ.usecolorquote);
  sprompt(#3#3+'[3]'+#3#0+' Let normal users see rumor authors?       '); yesorno(bbsinfoZ.seeauthors);
  sprompt(#3#3+'[4]'+#3#0+' Let normal users /TYPE in chat?           '); yesorno(bbsinfoZ.usetype);
  sprompt(#3#3+'[5]'+#3#0+' Display color 6 "prompts" for all input?  '); yesorno(bbsinfoZ.usempl);
  sprompt(#3#3+'[6]'+#3#0+' Use special "toggle" yes/no prompts?      '); yesorno(bbsinfoZ.useDEF);
  sprompt(#3#3+'[7]'+#3#0+' Use Auto-ANSI detect?                     '); yesorno(bbsinfoZ.useAD);
  nl;
  sprint (#3#3+'[A]'+#3#0+' "Yes"          : '+#3#5+bbsinfoz.STRyes);
  sprint (#3#3+'[B]'+#3#0+' "No"           : '+#3#5+bbsinfoz.STRno);
  sprint (#3#3+'[C]'+#3#0+' Annonomus User : '+#3#5+bbsinfoz.STRanon);
  sprint (#3#3+'[D]'+#3#0+' Down for events: '+#3#5+bbsinfoz.STRevents);
  sprint (#3#3+'[E]'+#3#0+' TimeBank Prompt: '+#3#5+bbsinfoz.STRbank);
  sprint (#3#3+'[F]'+#3#0+' Voting Prompt  : '+#3#5+bbsinfoz.STRvote);
  sprint (#3#3+'[G]'+#3#0+' Voting required: '+#3#5+bbsinfoz.STRvote2);
  sprint (#3#3+'[H]'+#3#0+' Multitasking   : '+#3#5+bbsinfoz.STRmulti);
  sprint (#3#3+'[I]'+#3#0+' "Aborted."     : '+#3#5+bbsinfoz.STRabort);
  sprint (#3#3+'[J]'+#3#0+' Dear "Abby"    : '+#3#5+bbsinfoz.STRabby);
  sprint (#3#3+'[K]'+#3#0+' Protocol Prompt: '+#3#5+bbsinfoz.STRprot);
  sprint (#3#3+'[L]'+#3#0+' File Scanning  : '+#3#5+bbsinfoz.STRfscan);
  sprint (#3#3+'[M]'+#3#0+' TimeLeft Prompt: '+#3#5+bbsinfoz.STRtleft);
  nl;
  sprint (#3#3+'[Z]'+#3#0+' "LSD BoX" Style: '+#3#1+bbsinfoz.lsdstyle);
  nl;
  sprompt ('|10Selection |09[Q:Quit]|02 : ');
  onek (c,'1234567ABCDEFGHIJKLMQZ'^M);
 (* ===================================================================== *)
  if (c='1') then tog(bbsinfoZ.useoneliners) else
  if (c='2') then tog(bbsinfoZ.usecolorquote) else
  if (c='3') then tog(bbsinfoZ.seeauthors) else
  if (c='4') then tog(bbsinfoZ.usetype) else
  if (c='5') then tog(bbsinfoZ.usempl) else
  if (c='6') then tog(bbsinfoZ.useDEF) else
  if (c='7') then tog(bbsinfoZ.useAD);
 (* ===================================================================== *)
 if (c in ['A'..'M'] ) then begin
  lsdbox('String Configuration');

  if (c='A') then begin
    print ('This is the "Yes" shown after y/n questions, such as "Send Mail? [Yes] ...');
    print ('This is usually "Yes", but you could make it somthing like "Yup!"..');
    print ('Note: If you use the "TOGGLE" y/n prompts, DO NOT use COLOR in this!');
    ASK(bbsinfoZ.STRyes);
    if tmpshit <> '' then bbsinfoZ.STRyes:=tmpshit;
  end else
  if (c='B') then begin
    print ('This is the "No" shown after y/n questions, such as "Send Mail? [No] ...');
    print ('This is usually "No", but you could make it somthing like "Naw!"..');
    print ('Note: If you use the "TOGGLE" y/n prompts, DO NOT use COLOR in this!');
    ASK(bbsinfoZ.STRno);
    if tmpshit <> '' then bbsinfoZ.STRno:=tmpshit;
  end else
  if (c='C') then begin
    print ('This is the string shown in message bases when a post is anonymous.');
    print ('This is usually "[Anonymous]"');
    ASK(bbsinfoZ.STRanon);
    if tmpshit <> '' then bbsinfoZ.STRanon:=tmpshit;
  end else
  if (c='D') then begin
    print ('When the BBS goes down to do an event, and a user is already online, the');
    print ('BBS will show this string, hang up, and do the event.');
    print ('This is usually "Shutting Down For System Events, Call Back Later"...');
    ASK(bbsinfoZ.STRevents);
    if tmpshit <> '' then bbsinfoZ.STRevents:=tmpshit;
  end else
  if (c='E') then begin
    print ('This is the command prompt for the internal time bank.');
    print ('This is usually "Time Bank Command: " or something simple.');
    ASK(bbsinfoZ.STRbank);
    if tmpshit <> '' then bbsinfoZ.STRbank:=tmpshit;
  end else
  if (c='F') then begin
    print ('This is the command prompt for the internal voting menu.');
    print ('This is usually "Which Question [#,L:ist Questions,A:nswer all,Q:uit] : "..');
    ASK(bbsinfoZ.STRvote);
    if tmpshit <> '' then bbsinfoZ.STRvote:=tmpshit;
  end else
  if (c='G') then begin
    print ('If voting is REQUIRED, and the user tries to quit without answering the');
    print ('questions, then this prompt is shown.');
    print ('Usually "Voting is REQUIRED - Answer all the questions!" ..');
    ASK(bbsinfoZ.STRvote2);
    if tmpshit <> '' then bbsinfoZ.STRvote2:=tmpshit;
  end else
  if (c='H') then begin
    print ('Shown at logons if the BBS happens to be multitasking.');
    print ('Usually "System running under <windows,os/2,desqview,ect>."');
    ASK(bbsinfoZ.STRmulti);
    if tmpshit <> '' then bbsinfoZ.STRmulti:=tmpshit;
  end else
  if (c='I') then begin
    print ('The "Aborted." string - usually in bright red.');
    ASK(bbsinfoZ.STRabort);
    if tmpshit <> '' then bbsinfoZ.STRabort:=tmpshit;
  end else
  if (c='J') then begin
    print ('The Dear "Abby" string - Do not include the word "Dear"..');
    print ('You are only changing the "ABBY" part.');
    ASK(bbsinfoZ.STRabby);
    if tmpshit <> '' then bbsinfoZ.STRabby:=tmpshit;
  end else
  if (c='K') then begin
    print ('Protocol selection prompt. Shown at downloads & uploads.');
    print ('Usually "Protocol (?=List) :');
    ASK(bbsinfoZ.STRprot);
    if tmpshit <> '' then bbsinfoZ.STRprot:=tmpshit;
  end else
  if (c='L') then begin
    print ('Scanning file base string. Shown when newscanning, searching,');
    print ('or listing. Usually "Scanning [File Base Name MCI Code]');
    ASK(bbsinfoZ.STRfscan);
    if tmpshit <> '' then bbsinfoZ.STRfscan:=tmpshit;
  end else
  if (c='M') then begin
    print ('Defualt "[Time Left: XXX]" string. This string is only shown');
    print ('when you have a menu set to "display generic time prompt". If this');
    print ('setting is on, this string is shown right before the prompt.');
    ASK(bbsinfoZ.STRtleft);
    if tmpshit <> '' then bbsinfoZ.STRtleft:=tmpshit;
  end;
 end;
 (* ===================================================================== *)
 if (c='Z') then begin
   clrscr;
   ii:=41-length      ('xxxxxxxxxxxxxxxxxxxxx') div 2; (* Get Center *)
   sda (ii,25 ,16 ,31, 'Hey, this is style 1!');
   sda (ii,127,120,112,'Hey, this is style 2!');
   sprompt ('|02(0 to use generic mode) |10New Choice: ');
   onek (c,'012'^M);
   if (c <> ^M) then bbsinfoz.lsdstyle:=c;
 end;
 (* ===================================================================== *)
 until (c='Q') or (hangup);
  (*-Save shit-*)
  assign(bbsinfoF,systat.gfilepath+'\bbsinfo.dat');
  rewrite(bbsinfoF); write(bbsinfoF,bbsinfoZ); close(bbsinfoF);
end;

procedure poflagfunc;
var s:string[80];
    c,cc:char;
    nuu,i:integer;
    abort,next,done:boolean;
    bbb:byte;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'System flagged functions');
      nl;
      abort:=FALSE; next:=FALSE;
      printacr('A. Special effects          :'+onoff(specialfx)+
             '  B. Use FOSSIL comm driver    :'+onoff(fossil),abort,next);
      printacr('C. Handles allowed on system:'+onoff(allowalias)+
             '  D. Phone number in logon     :'+onoff(phonepw),abort,next);
      printacr('E. Local security protection:'+onoff(localsec)+
             '  F. Local screen security     :'+onoff(localscreensec),abort,next);
      printacr('G. Global activity trapping :'+onoff(globaltrap)+
             '  H. Auto chat buffer open     :'+onoff(autochatopen),abort,next);
      printacr('I. AutoMessage in logon     :'+onoff(autominlogon)+
             '  J. Bulletins in logon        :'+onoff(bullinlogon),abort,next);
      printacr('K. Last few callers in logon:'+onoff(lcallinlogon)+
             '  L. "Your info" in logon      :'+onoff(yourinfoinlogon),abort,next);
      printacr('M. BBS is multi-tasking     :'+onoff(multitask)+
             '  N. Offhook in local logon    :'+onoff(offhooklocallogon),abort,next);
      printacr('O. Mandatory voting         :'+onoff(forcevoting)+
             '  P. Compress file/msg numbers :'+onoff(compressbases),abort,next);
      printacr('R. UL duplicate file search :'+onoff(searchdup)+
             '  S. SysOp Log type            :'+sltype(slogtype),abort,next);
      printacr('T. Strip color off SysOp log:'+onoff(stripclog)+
             '  U. Use WFC menu logo         :'+onoff(usewfclogo),abort,next);
      printacr('V. Use BIOS for video output:'+onoff(usebios)+
             '  W. Suppress snow on CGA      :'+onoff(cgasnow),abort,next);
      printacr('X. Use EMS for overlay file :'+onoff(useems),abort,next);

      printacr('',abort,next);
      s:='1. New user message sent to :';
      if (newapp=-1) then s:=s+'Off' else s:=s+mn(newapp,3);
      s:=s+'  2. Guest user number         :';
      if (guestuser=-1) then s:=s+'Off' else s:=s+mn(guestuser,3);
      printacr(s,abort,next);
      s:='3. Mins before timeout bell :';
      if (timeoutbell=-1) then s:=s+'Off' else s:=s+mn(timeoutbell,3);
      s:=s+'  4. Mins before timeout       :';
      if (timeout=-1) then s:=s+'Off' else s:=s+mn(timeout,3);
      printacr(s,abort,next);
      nl;
      prt('Enter selection (A-X,1-4) [Q]uit : ');
      onek(c,'QABCDEFGHIJKLMNOPRSTUVWX1234'^M); nl;

      case c of
        'Q':done:=TRUE;
        'A':specialfx:=not specialfx;
        'B':begin
              remove_port;
              fossil:=not fossil;
              iport;
            end;
        'C':allowalias:=not allowalias;
        'D':phonepw:=not phonepw;
        'E':localsec:=not localsec;
        'F':localscreensec:=not localscreensec;
        'G':globaltrap:=not globaltrap;
        'H':autochatopen:=not autochatopen;
        'I':autominlogon:=not autominlogon;
        'J':bullinlogon:=not bullinlogon;
        'K':lcallinlogon:=not lcallinlogon;
        'L':yourinfoinlogon:=not yourinfoinlogon;
        'M':multitask:=not multitask;
        'N':offhooklocallogon:=not offhooklocallogon;
        'O':forcevoting:=not forcevoting;
        'P':begin
              compressbases:=not compressbases;
              nl;
              if (compressbases) then print('Compressing bases!')
                else print('De-compressing bases!');
              newcomptables;
            end;
        'R':searchdup:=not searchdup;
        'S':begin
              print('Current SysOp Log type: '+sltype(slogtype));
              nl;
              for i:=0 to 2 do print(cstr(i)+': '+sltype(i));
              nl;
              prt('New type: '); ini(bbb);
              if ((not badini) and (bbb in [0..2])) then slogtype:=bbb;
            end;
        'T':stripclog:=not stripclog;
        'U':usewfclogo:=not usewfclogo;
        'V':begin
              usebios:=not usebios;
              directvideo:=not usebios;
            end;
        'W':begin
              cgasnow:=not cgasnow;
              checksnow:=cgasnow;
            end;
        'X':useems:=not useems;
        '1'..'4':
          begin
            prt('(E)nable/(D)isable function: ');
            onek(cc,'Q ED'^M);
            if cc in ['E','D'] then begin
              badini:=FALSE;
              case cc of
                'D':i:=-1;
                'E':begin
                      prt('Range ');
                      case c of
                        '1','2':begin
                             reset(uf); nuu:=filesize(uf)-1; close(uf);
                             prt('(1-'+cstr(nuu)+')');
                           end;
                        '3','4':prt('(1-20)');
                      else
                           prt('(0-32767)');
                      end;
                      nl; prt('Enter value for this function: ');
                      inu(i);
                    end;
              end;
              if (not badini) then
                case c of
                  '1':if ((i>=1) and (i<=nuu)) or (cc='D') then newapp:=i;
                  '2':if ((i>=1) and (i<=nuu)) or (cc='D') then guestuser:=i;
                  '3':if ((i>=1) and (i<=20)) or (cc='D') then timeoutbell:=i;
                  '4':if ((i>=1) and (i<=20)) or (cc='D') then timeout:=i;
                end;
            end
            else print('No change.');
          end;
      end;
    end;
  until (done) or (hangup);
end;

end.
