{$I+,S+}
unit xfer;

interface

uses crt,dos,inout,mdm,modem,records,strunit,usermisc,windows(*,ooabspcl,ooascii,
     ooxmodem,ooymodem,oozmodem,apmisc,apport,aptimer,oocom,comutil,winttt5*),execswap,
     inp;

const asciiinterchar:word=0;
      asciiinterline:word=0;

var cline,execprog:string[80];
    prot:integer;
    {p:abstractprotocolptr;}

function numarea:integer;
procedure editxarea;
procedure setarea (i:integer; status:boolean);
function getarea:integer;
procedure changearea;
procedure listfiles (showcommand:boolean);
procedure xferload;
procedure filesearch;
procedure newscan;
procedure sysopupload;
procedure changefile;
procedure deletefile;
procedure upload;
procedure download;
procedure deletearea;
procedure listarch;
procedure typefile;
procedure sortarea;
procedure movefile;
procedure openarea;
procedure closearea;
procedure openfile;
procedure closefile;
function udpercent:boolean;
function pcpercent:boolean;
function searchexist (s:string):boolean;
procedure reset_loc;
procedure reset_fpoints;

implementation

function priv_for_you (f:filerec):boolean;
begin
  priv_for_you:=match (user.handle,f.prvfile);
end;

function upl:boolean;
begin
  upl:=user.xflevel>=area.up;
end;

function downl:boolean;
begin
  downl:=user.xflevel>=area.down;
end;

procedure runuploadevent (s:string);
  var status:word;
begin
  if length (setup.uploadevent)>0 then begin
    wwiv_chain;
    dorinfo1;
    def_user;
    header ('Running Upload Event');
    {deactivateport;}
    status:=execwithswap (getenv ('COMSPEC'),' /C '+setup.uploadevent+' '+s);
    {activateport;}
  end;
end;

procedure zipcomment (pathname:string);
  var s:string[80];
      status:word;
begin
  s:=fsearch ('PKZIP.EXE',GetEnv ('PATH'));
  if length (setup.zipcomment)>0 then begin
    header ('Adding ZIP Comment');
    {deactivateport;}
    status:=execwithswap (getenv ('COMSPEC'),' /C '+s+' '+pathname+' -Z <'+setup.zipcomment+' >NUL');
    {activateport;}
  end;
end;

procedure addbbsad (pathname:string);
  var s:string[80];
      status:word;
begin
  s:=fsearch ('PKZIP.EXE',GetEnv ('PATH'));
  if length (setup.bbsad)>0 then begin
    header ('Adding File');
    {deactivateport;}
    status:=execwithswap (getenv ('COMSPEC'),' /C '+s+' '+pathname+' '+setup.bbsad+' >NUL');
    {activateport;}
  end;
end;

(*{$F+}
procedure WindowStatus(AP : AbstractProtocolPtr; Starting, Ending : Boolean);
  var dir:dirstr;
      fil:namestr;
      ext:extstr;
begin
  if starting then begin
    FillScreen(1,1,80,24,white,blue,chr(176));
    mkwin (20,9,60,20,11,1,5);
    textcolor (11);
    textbackground (1);
    gotoxy (22,10);
    write ('Filename: '); {32,10}
    gotoxy (22,11);
    write ('Path: '); {28,11}
    gotoxy (22,12);
    write ('Total bytes: '); {35,12}
    gotoxy (22,13);
    write ('Bytes transferred: '); {41,13}
    gotoxy (22,14);
    write ('Bytes remaining: '); {39,14}
    gotoxy (22,15);
    write ('Block size: '); {34,15}
    gotoxy (22,16);
    write ('Time total: '); {34,16}
    gotoxy (22,17);
    write ('Time elapsed: '); {36,17}
    gotoxy (22,18);
    write ('Time remaining: '); {38,18}
    gotoxy (22,19);
    write ('Protocol: '); {32,19}
  end;
  cursor (false);
  textcolor (15);
  textbackground (1);
  gotoxy (32,10);
  write (ap^.getfilename);
  fsplit (ap^.getpathname,dir,fil,ext);
  gotoxy (28,11);
  write (dir);
  gotoxy (35,12);
  write (ap^.getfilesize);
  gotoxy (41,13);
  write (ap^.getbytestransferred);
  write ('           ');
  gotoxy (39,14);
  write (ap^.getbytesremaining);
  write ('           ');
  gotoxy (34,15);
  write (ap^.getblocksize);
  write ('           ');
  gotoxy (34,16);
  write (FormatMinSec(ap^.EstimateTransferSecs(ap^.getfilesize)));
  write ('           ');
  gotoxy (36,17);
  write (FormatMinSec(Tics2Secs(ap^.getelapsedtics)));
  write ('           ');
  gotoxy (38,18);
  write (FormatMinSec(ap^.EstimateTransferSecs(ap^.getbytesremaining)));
  write ('           ');
  gotoxy (32,19);
  write (protocoltypestring[ap^.getprotocol]);
  textbackground (0);
  if ending then begin
    rmwin;
    textbackground (0);
    clrscr;
    cursor (true);
    if asyncstatus = ecOk then sendwriteln (^M^Y'Transfer complete!'^M);
  end;
end;*)

procedure autovalidate (var f:filerec);
  var l:longint;
begin
  if setup.pointvalue>0 then begin
    l:=f.filesize div 1024;
    f.new:=false;
    f.cost:=l div setup.pointvalue;
    inc (user.fpoint,f.cost*setup.uploadfactor);
    sendwriteln (^Z+f.filename+^Y' receives '^Z+strr (f.cost)+^Y' file point(s).');
    sendwriteln (^Z+user.handle+^Y' receives '^Z+strr (f.cost*setup.uploadfactor)+^Y' file point(s).');
  end;
end;

function minstr (blocks:integer):string;
var min,sec:integer;
    rsec:real;
    ss:string[8];
begin
  rsec:=1.38 * blocks * (1200/connectbaud);
  min:=trunc (rsec/60.0);
  sec:=trunc (rsec-(min*60.0));
  ss:=strr(sec);
  if length(ss)<2 then ss:='0'+ss;
  minstr:=strr(min)+':'+ss;
end;

function asysop:boolean;
begin
  asysop:=cosysop (2) or match (area.asysop,user.handle);
end;

procedure assignarea;
begin
  assign (areaf,setup.xferdir+'AREALIST.'+strr (curconf));
end;

function numfile:integer;
begin
  numfile:=filesize (xferf);
end;

function nofiles (show:boolean):boolean;
begin
  nofiles:=false;
  if numfile<1 then begin
    if show then sendwriteln (^M^Y'No files!'^M);
    nofiles:=true;
  end;
end;

procedure seekfile (i:integer);
begin
  seek (xferf,i-1);
end;

procedure assignfile;
begin
  assign (xferf,setup.xferdir+'AREA'+strr (curarea)+'.'+strr (curconf));
end;

function numarea:integer;
begin
  numarea:=filesize (areaf);
end;

procedure seekarea (i:integer);
begin
  seek (areaf,i-1);
end;

procedure openarea;
begin
  assignarea;
  {$I-}reset (areaf);{$I+}
  if ioresult<>0 then {$I-}rewrite (areaf);{$I+}
end;

procedure closearea;
begin
  close (areaf);
end;

procedure openfile;
begin
  assignfile;
  {$I-}reset (xferf);{$I+}
  if ioresult<>0 then {$I-}rewrite (xferf);{$I+}
end;

procedure closefile;
begin
  close (xferf);
end;

procedure addfile (f:filerec);
begin
  seekfile (numfile+1);
  write (xferf,f);
end;

procedure displayfile (var ffinfo:searchrec);
  var i:integer;
begin
  i:=ffinfo.attr;
  if (i and 8)=8 then exit;
  spacewrite (^Y+ffinfo.name,15);
  if (i and 16)=16 then sendwrite (^Z'Directory') else sendwrite (^Z+strr (ffinfo.size));
  if (i and 1)=1 then sendwrite (^X' ['^Y'read-only'^X']');
  if (i and 2)=2 then sendwrite (^X' ['^Y'hidden'^X']');
  if (i and 4)=4 then sendwrite (^X' ['^Y'system'^X']');
  nl;
end;

function getpathname (s:string):string;
  var _dir:dirstr;
      _name:namestr;
      _ext:extstr;
begin
  fsplit (s,_dir,_name,_ext);
  getpathname:=_dir;
end;

function getfname (path:string; name:string):string;
  var s:string;
begin
  s:=path;
  if length(s)<>0 then if not (s[length (s)] in [':','\']) then s:=s+'\';
  s:=s+name;
  getfname:=s;
end;

procedure getpname (fname:string; var path:string; var name:string);
  var _name:namestr;
      _ext :extstr;
begin
  fsplit (fname,path,_name,_ext);
  name:=_name+_ext;
end;

procedure getfsize (var f:filerec);
  var ff:file of byte;
begin
  f.filesize:=-1;
  assign (ff,getfname (f.path,f.filename));
  {$I-}reset (ff);{$I+}
  if ioresult<>0 then exit;
  f.filesize:=filesize (ff);
  close (ff);
end;

function getpath:string;
begin
  if not {asysop}sysop (2) then exit;
  prompt ('Upload Path'^X' ['^Z+area.xferdir+^X']: ');
  if not online then exit;
  if input='' then input:=area.xferdir;
  if input[length (input)]<>'\' then input:=uppercase (input)+'\';
  {$I-}mkdir (copy (input,1,length (input)-1));{$I+}
  if ioresult=0 then sendwriteln (^Y+input+^X' - '^Y'directory was created.') else
  sendwriteln (^Y'Directory was not created.  May already exist!');
  getpath:=input;
end;

function unsigned (i:integer):real;
begin
  if i>=0 then unsigned:=i else unsigned:=65536.0+i;
end;

procedure writefreespace (path:string);
  var csize,free,total:real;
      drive:byte;
      r:registers;
begin
  r.ah:=$36;
  r.dl:=ord (upcase (path[1]))-64;
  intr ($21,r);
  if r.ax=-1 then begin
    sendwriteln (^Y'Invalid drive!');
    exit;
  end;
  csize:=unsigned (r.ax)*unsigned (r.cx);
  free:=csize*unsigned (r.bx);
  total:=csize*unsigned (r.dx);
  if free<1024*1024 then sendwrite (^Z+streal (free/1024)+^Y' k out of '^Z) else
  sendwrite (^Z+streal (free/(1024*1024))+^Y' megs out of '^Z);
  if total<1024*1024 then sendwrite (streal (total/1024)+^Y' k') else
  sendwrite (^Z+streal (total/(1024*1024))+^Y' megs');
  if free/1024<100.0 then sendwrite (^G^X' - '^Y'Low space!');
  nl;
end;

function freespace (path:string):boolean;
  var csize,free:real;
      b:boolean;
      drive:byte;
      l:longint;
      r:registers;
begin
  b:=false;
  r.ah:=$36;
  r.dl:=ord (upcase (path[1]))-64;
  intr ($21,r);
  if r.ax=-1 then begin
    sendwriteln (^Y'Invalid drive!');
    freespace:=b;
    exit;
  end;
  csize:=unsigned (r.ax)*unsigned (r.cx);
  free:=csize*unsigned (r.bx);
  l:=trunc(free/1024);
  if l>511 then b:=true;
  freespace:=b;
end;

procedure editarea;
  var a:arearec;
      c:char;
begin
  seekarea (curarea);
  read (areaf,a);
  repeat
    clearscreen;
    {sendwriteln (^Y'Transfer Area Information'^M);}
    header ('Transfer Area Information');
    sendwriteln (^X' ['^Z'A'^X']'^Y' Name'^X': '^Z+a.name);
    sendwriteln (^X' ['^Z'B'^X']'^Y' Area Sysop'^X': '^Z+a.asysop);
    sendwriteln (^X' ['^Z'C'^X']'^Y' Access Level'^X': '^Z+strr (a.level));
    sendwriteln (^X' ['^Z'D'^X']'^Y' Upload Level'^X': '^Z+strr (a.up));
    sendwriteln (^X' ['^Z'E'^X']'^Y' Download Level'^X': '^Z+strr (a.down));
    sendwriteln (^X' ['^Z'F'^X']'^Y' Path'^X': '^Z+a.xferdir+^M);
    sendwrite (^Y'Command'^X': '^Y);
    c:=upcase (shinchar);
    case c of
      'A':inputstr ('Name of Area',a.name,30);
      'B':inputstr ('Area Sysop',a.asysop,30);
      'C':inputbyte ('Access Level',a.level,5,0,100);
      'D':inputbyte ('Upload Level',a.up,5,0,100);
      'E':inputbyte ('Download Level',a.down,5,0,100);
      'F':a.xferdir:=getpath;
    end;
  until (c='Q') or not online;
  nl;
  seekarea (curarea);
  write (areaf,a);
  curareaname:=a.name;
end;

procedure editxarea;
begin
  openarea;
  editarea;
  closearea;
  writesysoplog ('Edited xfer area #'+strr (curarea),user.handle);
end;

function createarea (b:boolean):boolean;
  var a:arearec;
      i:integer;
begin
  createarea:=false;
  i:=numarea+1;
  with a do begin
    name:='Temporary';
    asysop:=user.handle;
    level:=0;
    up:=0;
    down:=0;
    xferdir:=setup.xferdir;
  end;
  seekarea (i);
  write (areaf,a);
  area:=a;
  curarea:=i;
  curareaname:=area.name;
  if b then editarea;
  sendwriteln (^Y'Area created.');
  createarea:=true;
  writesysoplog ('Created xfer area #'+strr (i),user.handle);
end;

procedure setarea (i:integer; status:boolean);
  var b:boolean;

  procedure areaex;
  begin
    sendwriteln (^Y'Area does not exist'^X': '^Z+strr (i));
  end;

begin
  curarea:=i;
  openarea;
  if (curarea>numarea) or (curarea<1) then begin
    areaex;
    if sysop (2) then begin
      b:=createarea (true);
      closearea;
      if b then setarea (curarea,true) else setarea (1,true);
    end else if createarea (false) then begin
      closearea;
      setarea (curarea,true){ else exitxfer:=true};
    end;
    exit;
  end;
  seekarea (i);
  read (areaf,area);
  closearea;
  curareaname:=area.name;
  if user.xflevel>=area.level then begin
    {openfile;
    closefile;}
    if status then
      sendwrite (^M^Y'Transfer Area'^X': ['^Z+strr (curarea)+^X'] '^Z+area.name+^M);
  end else if curarea=1 then begin
    sendwriteln (^Y'User cannot access first transfer area!');
    exit;
  end else begin
    areaex;
    setarea (1,true);
    exit;
  end;
end;

procedure listarea;
  var c:char;
      i:integer;
      xfile:file of filerec;
begin
  clearscreen;
  sendwrite (^Y);
  spacewrite ('#',5);
  spacewrite ('Area Name',32);
  spacewrite ('Level',7);
  sendwriteln ('Transfer');
  writeline (79);
  for i:=1 to numarea do begin
    seekarea (i);
    read (areaf,area);
    while inout.charready do c:=inchar;
    sendwrite (^Z);
    spacewrite (strr (i),5);
    with area do begin
      spacewrite (name,32);
      spacewrite (strr (level),7);
      {assign (xfile,setup.xferdir+'AREA'+strr (i)+'.'+strr (curconf));
      reset (xfile);
      if ioresult<>0 then rewrite (xfile);
      spacewrite (strr (filesize (xfile)),7);
      close (xfile);}
      if (upl and not downl) then sendwriteln ('Upload') else
      if (not upl and downl) then sendwriteln ('Download') else
      if (upl and downl) then sendwriteln ('Up/Down');
    end;
  end;
  nl;
end;

function getarea:integer;
  var i,ii:integer;
begin
  getarea:=0;
  ii:=valu (copy (input,2,255));
  if ii<1 then begin
    repeat
      prompt ('Area # '^X'['^Z'?'^X'/'^Y'List'^X']: ');
      if input='?' then listarea;
    until (input<>'?') or not online;
    if length (input)<1 then exit;
    i:=valu (input);
  end else i:=ii;
  if (i>0) and (i<=numarea) then getarea:=i else begin
    sendwriteln (^Y'Area does not exist'^X': '^Y'#'+strr (i));
    if cosysop (2) then if doyesno ('Create this area?') then
    if i>maxtbases then sendwriteln ('This conference can only hold up to '+strr (maxtbases)+' base(s).') else
    if createarea (true) then getarea:=numarea;
  end;
end;

procedure changearea;
  var i:integer;
begin
  {assignarea;
  resetarea;}
  openarea;
  i:=getarea;
  closearea;
  if i<>0 then setarea (i,true);
  {closearea;}
end;

procedure listheader;
begin
  clearscreen;
  sendwriteln (^Y'Listing Area #'^Z+strr (curarea)+^X' - '^Y'Name'^X': '^Z+curareaname+^M);
  sendwrite (^Y'#    ');
  with user do begin
    if filelist[1] then spacewrite ('Filename',9);
    if filelist[2] then spacewrite ('Ext',5);
    if filelist[3] then spacewrite ('Cost',6);
    if filelist[4] then spacewrite ('(k)',6);
    if filelist[5] then spacewrite ('Description',35);
    if filelist[6] then spacewrite ('Category',10);
    if filelist[7] then spacewrite ('Dl',4);
    if filelist[8] then spacewrite ('Uploader',13);
    if filelist[9] then spacewrite ('Uploaded',10);
  end;
  nl;
  writeline (79);
end;

procedure listfile (i:integer);
  var off:boolean;
      f:filerec;
      ii:integer;
      s,path,name,ext:string[80];
      t:string[6];
      sze:longint;
begin
  seekfile (i);
  read (xferf,f);
  s:=getfname (f.path,f.filename);
  off:=not exist (s);
  sendwrite (^Z);
  spacewrite (strr (i),5);
  fsplit (f.filename,path,name,ext);
  ext:=copy (ext,2,length (ext)-1);
  with user do begin
    if filelist[1] then spacewrite (uppercase (name),9);
    if filelist[2] then spacewrite (uppercase (ext),5);
    if filelist[3] then begin
      if f.prvfile='' then if f.new then spacewrite ('New',6) else
      if f.ask then spacewrite ('Ask',6) else
      if (f.cost>0) and (not setup.freefiles) then spacewrite (strr (f.cost),6) else
      spacewrite ('Free',6) else if priv_for_you (f) then spacewrite ('Take',6) else spacewrite ('Priv',6);
    end;
    if filelist[4] then begin
      getfsize (f);
      sze:=f.filesize div 1024;
      if not exist (getfname (f.path,f.filename)) then spacewrite ('Off',6) else
      spacewrite (strr (sze),6);
    end;
    if filelist[5] then spacewrite (copy (f.descrip,1,33),35);
    if filelist[6] then spacewrite (copy (f.group,1,8),10);
    if filelist[7] then spacewrite (strr (f.numdown),4);
    if filelist[8] then spacewrite (copy (f.uploader,1,11),13);
    if filelist[9] then spacewrite (f.dateup,10);
  end;
  nl;
end;

procedure listfiles (showcommand:boolean);
  label exit;
  var b,bb:boolean;
      c,cc:char;
      i,ii,low,high:integer;
begin
  {assignfile;
  resetfile;}
  openfile;
  if nofiles (true) then goto exit;
  range (numfile,low,high);
  if low=0 then goto exit;
  repeat
    b:=false;
    ii:=0;
    for i:=low to high do begin
      if not b then begin
        b:=true;
        listheader;
      end;
      while inout.charready do cc:=inchar;
      listfile (i);
      inc (ii);
      if (ii=18) or (i=numfile) then begin
        b:=false;
        bb:=false;
        ii:=0;
        if showcommand then begin
          prompt (^M^Z'D'^Y'ownload  '^Z'Q'^Y'uit  '^Z'U'^Y'pload  '^Z'V'^Y'iew'^X': ');
          if length (input)<1 then input:=#0;
          c:=upcase (input[1]);
          case c of
            'D':begin
                  closefile;
                  download;
                  openfile;
                end;
            #0,'N':bb:=true;
            'Q':goto exit;
            'U':begin
                  closefile;
                  upload;
                  openfile;
                end;
            'V':begin
                  closefile;
                  listarch;
                  openfile;
                end;
          end;
        end else begin
          nl;
          pause;
          bb:=true;
        end;
      end;
    end;
  until bb or not online;
  if ii>0 then nl;
  exit:
  closefile;
end;

procedure xferload;
  {label load;}
begin
  {assignarea;
  reset (areaf);
  if (ioresult<>0) or (numarea<1) then begin
    rewrite (areaf);
    sendwriteln (^Y'No areas exist!');
  end;
  closearea;}
  if exist (setup.textdir+'AREANEWS.'+strr (curconf)) then begin
    header ('Transfer Conference News');
    printfile (setup.textdir+'AREANEWS.'+strr (curconf),false);
    nl;
    pause;
  end;
  setarea (1,true);
  {s:=setup.xferdir+'AREALIST.'+strr (curconf);
  assign (areaf,s);
  if not exist (s) then begin
    rewrite (areaf);
    sendwriteln (^Y'No areas exist!');
    goto load;
  end else begin
    reset (areaf);
    if numarea<1 then goto load;
  end;
  seekarea (1);
  read (areaf,area);
  load:
  closearea;
  setarea (1,true);}
end;

procedure sysopaddfile (fname:string);
  var f:filerec;
      i:integer;
      l:longint;
begin
  getpname (fname,f.path,f.filename);
  getfsize (f);
  if f.filesize=-1 then begin
    sendwriteln (^Y'File cannot be accessed');
    if not doyesno ('Add file as offline?') then exit;
  end;
  l:=f.filesize div 1024;
  i:=l div setup.pointvalue;
  inlen:=5;
  prompt ('Cost '^X'['^Z+strr (i)+^X']: ');
  if length (input)<1 then f.cost:=i else f.cost:=valu (input);
  inlen:=30;
  prompt ('Private file '^X'['^Y'User  '^Z'CR'^X'/'^Y'None'^X']: ');
  f.prvfile:=input;
  inlen:=20;
  prompt ('File password '^X'['^Z'CR'^X'/'^Y'None'^X']: ');
  f.pass:=input;
  inlen:=30;
  prompt ('Uploader '^X'['^Z'CR'^X'/'^Y+user.handle+^X']: ');
  f.uploader:=input;
  if length (f.uploader)<1 then f.uploader:=user.handle;
  repeat
    inlen:=33;
    prompt ('Description'^X': ');
    f.descrip:=input;
  until length (f.descrip)>0;
  repeat
    inlen:=15;
    prompt ('Group'^X'/'^Y'Category'^X': ');
    f.group:=input;
  until length (f.group)>0;
  f.ask:=doyesno ('Special request?');
  f.dateup:=curdate;
  f.new:=false;
  f.numdown:=0;
  user.uploadk:=user.uploadk+f.filesize div 1024;
  inc (user.numup);
  if stat.numup>=2147483647 then stat.numup:=0;
  inc (stat.numup);
  inc (stat.uptoday);
  inc (stat.newup);
  inc (stat.ups);
  writeuser (user,usernum);
  {assignfile;
  resetfile;}
  openfile;
  addfile (f);
  closefile;
  {closefile;}
  if length (setup.zipcomment)>0 then if doyesno ('Add ZIP Comment?') then zipcomment (getfname (f.path,f.filename));
  if length (setup.bbsad)>0 then if doyesno ('Add BBS Ad/File to ZIP?') then addbbsad (getfname (f.path,f.filename));
  if length (setup.uploadevent)>0 then if doyesno ('Run upload event on file?') then
    runuploadevent (getfname (f.path,f.filename));
  sendwriteln (^Y'File added!');
  writesysoplog ('Added '+f.filename,user.handle);
end;

procedure filesearch;
  var a:arearec;
      i,ii,iii:integer;
      searchfor:longstr;

    procedure totalmatch;
    begin
      sendwriteln (^M^Y'Total file(s) found'^X': '^Z+strr (iii)+^M);
    end;

    procedure searchareatext (s:string);
      var b,bb:boolean;
          f:filerec;
          i,ii:integer;
    begin
      bb:=false;
      ii:=0;
      openfile;
      for i:=1 to numfile do begin
        b:=false;
        seekfile (i);
        read (xferf,f);
        s:=uppercase (s);
        if pos (s,uppercase (f.filename))>0 then b:=true;
        if pos (s,uppercase (f.descrip))>0 then b:=true;
        if pos (s,uppercase (f.group))>0 then b:=true;
        if pos (s,uppercase (f.uploader))>0 then b:=true;
	if b then begin
	  if not bb then begin
            listheader;
            bb:=true;
          end;
	  listfile (i);
	  inc (ii);
          inc (iii);
	end;
      end;
      closefile;
      nl;
      if ii>0 then begin
        sendwrite (^Y'File(s) found'^X': '^Z+strr (ii)+^M^M);
        pause;
      end;
    end;

begin
  {assignarea;
  resetarea;}
  iii:=0;
  nl;
  prompt (^Y'Enter search text'^X': ');
  if length (input)<1 then exit;
  searchfor:=input;
  if doyesno (^Y'Search all areas?') then begin
    i:=curarea;
    openarea;
    for ii:=1 to numarea do begin
      seekarea (ii);
      read (areaf,area);
      if (user.xflevel>=area.level) or asysop then begin
        sendwriteln (^Y'Searching Area #'^Z+strr (ii)+^X' - '^Z+area.name);
        curarea:=ii;
        curareaname:=area.name;
        {closearea;
        setarea (ii,false);}
        searchareatext (searchfor);
        {openarea;}
      end;
    end;
    closearea;
    setarea (i,true);
  end else searchareatext (searchfor);
  totalmatch;
  writesysoplog ('Searched for file(s)',user.handle);
end;

function getfile:integer; forward;

function nscan:boolean;
  label donen;
  var b,done:boolean;
      c:char;
      f:filerec;
      i,ii,iii,j,jj:integer;
      l:longint;
      u:userrec;
begin
  {assignfile;
  resetfile;}
  openfile;
  done:=false;
  nscan:=true;
  if nofiles (false) then begin
    nscan:=true;
    goto donen;
  end;
  repeat
    b:=false;
    i:=0;
    ii:=0;
    while i<filesize (xferf) do begin
      inc (i);
      seekfile (i);
      read (xferf,f);
      if ii=18 then repeat
        ii:=0;
        sendwrite (^M^Z'D'^Y'ownload  ');
        if asysop then sendwrite (^Z'F'^Y'ile Validation  ');
        prompt (^Z'Q'^Y'uit  '^Z'U'^Y'pload  '^Z'V'^Y'iew'^X': ');
        if length (input)<1 then input:=#0;
        c:=upcase (input[1]);
        case c of
          'D':begin
                closefile;
                download;
                openfile;
              end;
          'F':if asysop then begin
                iii:=getfile;
                if not (iii=0) then begin
                  seekfile (iii);
                  read (xferf,f);
                  f.new:=false;
                  l:=f.filesize div 1024;
                  j:=l div setup.pointvalue;
                  prompt ('Points to give file '^X'['^Z+strr (j)+^X']: ');
                  if length (input)<1 then else j:=valu (input);
                  f.cost:=j;
                  jj:=finduser (f.uploader);
                  if not (jj=0) then begin
                    readuser (u,jj);
                    prompt ('Points to give '^Z+u.handle+^X' ['^Z+strr (j)+^X']: ');
                    if length (input)<1 then else j:=valu (input);
                    inc (u.fpoint,j);
                    writeuser (u,jj);
                  end;
                  seekfile (iii);
                  write (xferf,f);
                end;
              end;
          'Q':begin
                done:=true;
                nscan:=false;
                sendwriteln (^M^Y'Newscan aborted!');
                goto donen;
              end;
          'U':begin
                closefile;
                upload;
                openfile;
              end;
          'V':begin
                closefile;
                listarch;
                openfile;
              end;
        end;
      until (c='N') or (c=#0) or not online;
      if f.dateup>=laston then begin
        inc (ii);
        if not b then begin
          listheader;
          b:=true;
        end;
        listfile (i);
      end;
    end;
    if b then begin
      sendwrite (^M^Z'D'^Y'ownload  ');
      if asysop then sendwrite (^Z'F'^Y'ile Validation  ');
      prompt (^Z'Q'^Y'uit  '^Z'U'^Y'pload  '^Z'V'^Y'iew'^X': ');
      if not (input='') then begin
        c:=upcase (input[1]);
        case c of
          'D':begin
                closefile;
                download;
                openfile;
              end;
          'F':if asysop then begin
                iii:=getfile;
                if not (iii=0) then begin
                  seekfile (iii);
                  read (xferf,f);
                  f.new:=false;
                  l:=f.filesize div 1024;
                  j:=l div setup.pointvalue;
                  prompt ('Points to give file '^X'['^Z+strr (j)+^X']: ');
                  if length (input)<1 then else j:=valu (input);
                  f.cost:=j;
                  jj:=finduser (f.uploader);
                  if not (jj=0) then begin
                    readuser (u,jj);
                    prompt ('Points to give '^Z+u.handle+^X' ['^Z+strr (j)+^X']: ');
                    if length (input)<1 then else j:=valu (input);
                    inc (u.fpoint,j);
                    writeuser (u,jj);
                  end;
                  seekfile (iii);
                  write (xferf,f);
                end;
              end;
          'Q':begin
                done:=true;
                nscan:=false;
                sendwriteln (^M^Y'Newscan aborted!');
                goto donen;
              end;
          'U':begin
                closefile;
                upload;
                openfile;
              end;
          'V':begin
                closefile;
                listarch;
                openfile;
              end;
        end;
      end;
      if pos (c,'ADQRV')=0 then done:=true;
    end;
    if not b then done:=true;
  until done;
  if ii>0 then nl;
  donen:
  closefile;
end;

procedure newscan;
  var b:boolean;
      i,ii:integer;
begin
  if doyesno ('Newscan all areas?') then begin
    clearscreen;
    header ('Newscanning all areas.');
    b:=true;
    i:=0;
    ii:=curarea;
    {assignarea;
    resetarea;}
    openarea;
    for i:=1 to numarea do begin
      seekarea (i);
      read (areaf,area);
      if (user.xflevel>=area.level) or asysop then begin
        sendwriteln (^Y'Newscanning Area #'^Z+strr (i)+^X' - '^Z+area.name);
        curarea:=i;
        curareaname:=area.name;
        {closearea;
        setarea (i,false);}
        b:=nscan;
        {openarea;}
      end;
    end;
    closearea;
    nl;
    pause;
    setarea (ii,true);
  end else b:=nscan;
  writesysoplog ('Newscanned xfer areas',user.handle);
end;

procedure sysopupload;
  var b,skiponline:boolean;
      f:file;
      ffinfo:searchrec;
      s:string;
      spath,pathpart:string[80];
  {var fn,fp,name,path:string[80];}

    function fexist (s:smstr; skip:boolean):boolean;
      var b:boolean;
          ff:filerec;
          i:integer;
    begin
      b:=false;
      if skip then begin
        openfile;
        for i:=1 to numfile do begin
          seekfile (i);
          read (xferf,ff);
          if match (ff.filename,s) then b:=true;
        end;
        closefile;
      end;
      fexist:=b;
    end;

begin
  if not asysop then begin
     sendwriteln (^Y'Only an area sysop or a sysop can add files!');
     exit;
  end;
  clearscreen;
  header ('Sysop Upload');
  {fp:=uppercase (prompt ('Upload Path '^X'['^Y'CR'^X'/'^Y+area.xferdir+^X']: '));
  if length (fp)<1 then fp:=area.xferdir;
  if fp[length (fp)]<>'\' then fp:=fp+'\';
  fn:=uppercase (prompt ('Filename'^X': '));
  fn:=fp+fn;
  if exist (fn) then begin
    if doyesno ('Add file'^X': '^Z+fn+^Y'?') then sysopaddfile (fn);
  end else begin
    sendwriteln (^Y'File cannot be opened!');
    if doyesno ('Still add file?') then sysopaddfile (fn);
  end;
end;}
  {}prompt (^Y'Path (wildcards accepted) '^X'['^Z'CR'^X'/'^Y+area.xferdir+^X']: ');
  spath:=input;
  if length (spath)<1 then spath:=area.xferdir+'*.*' else if spath[length (spath)]='\' then dec (spath[0]);
  assign (f,spath+'\CON');
  {$I-}reset (f);{$I+}
  if ioresult=0 then begin
    close (f);
    spath:=spath+'\*.*';
  end;
  getpname (spath,pathpart,s);
  findfirst (spath,$17,ffinfo);
  skiponline:=doyesno ('Skip files which are already online?');
  if doserror<>0 then sendwriteln (^Y'No files found!') else while doserror=0 do begin
    if not fexist (ffinfo.name,skiponline) then begin
      s:=getfname (pathpart,ffinfo.name);
      nl;
      displayfile (ffinfo);
      prompt (^Y'Add/process file? '^Z'Y'^Y'es  '^Z'N'^Y'o  '^Z'Q'^Y'uit'^X': ');
      input:=uppercase (input);
      if not (input='') then if input[1]='Y' then sysopaddfile (s) else
      if (length (input)>0) and (input[1]='Q') then exit;
    end;
    findnext (ffinfo);
  end;
end;{}

function allowxfer:boolean;
begin
  allowxfer:=true;
  if local then begin
    sendwriteln (^M^Y'You may only transfer from remote!'^M);
    allowxfer:=false;
  end;
end;

function getfile:integer;
  label done;
  var i,ii:integer;

    function filesearch (s:string):integer;
      label donen;
      var f:filerec;
          i:integer;
    begin
      for i:=1 to numfile do begin
        seekfile (i);
        read (xferf,f);
        if match (s,f.filename) then begin
          filesearch:=i;
          goto donen;
        end;
      end;
      filesearch:=0;
      donen:
    end;

begin
  getfile:=0;
  ii:=valu (copy (input,2,255));
  if ii<1 then begin
    repeat
      prompt ('File #'^X'/'^Y'Filename'^X': ['^Z'?'^X'/'^Y'List'^X']: ');
      if length (input)<1 then goto done;
      if input='?' then begin
        closefile;
        listfiles (false);
        openfile;
        nl;
        input:='';
      end;
    until (input<>'') or not online;
    ii:=valu (input);
  end;
  if ii<1 then begin
    ii:=filesearch (input);
    if ii=0 then begin
      sendwriteln (^Y'File not found!');
      goto done;
    end;
  end;
  if (ii<1) and (ii>numfile) then sendwriteln (^Y'File # out of range!');
  done:
  getfile:=ii;
end;

procedure transferstatus;
begin
  nl;
  sendwriteln (^Y'Uploads'^X': '^Z+strr (user.numup)+'  '+strr (user.uploadk)+^Y'k');
  sendwriteln (^Y'Downloads'^X': '^Z+strr (user.numdn)+'  '+strr (user.downloadk)+^Y'k');
  sendwriteln (^Y'File points'^X': '^Z+strr (user.fpoint));
  sendwriteln (^Y'Download K left'^X': '^Z+strr (user.kleft));
  nl;
end;

function getprot (i:integer; c:char; fn:string):boolean;
  var code:integer;

    procedure listprotocol (i:integer);
      var protfile:file of protocolrec;
          prot:protocolrec;
          b:boolean;
          ii:integer;
          s:medstr;
    begin
      {if i=0 then s:='Upload Protocols' else if i=1 then s:='Download Protocols';
      header (s);
      sendwriteln (^X'['^Z'1'^X'] '^Y'Ascii');
      sendwriteln (^X'['^Z'2'^X'] '^Y'Xmodem');
      sendwriteln (^X'['^Z'3'^X'] '^Y'Xmodem-1k');
      sendwriteln (^X'['^Z'4'^X'] '^Y'Ymodem');
      sendwriteln (^X'['^Z'5'^X'] '^Y'Ymodem-G');
      sendwriteln (^X'['^Z'6'^X'] '^Y'Zmodem');
      nl;
    end;}
      if exist ('PROTOCOL.BBS') then printfile ('PROTOCOL.BBS',false) else begin
        if i=0 then s:='Upload Protocols' else if i=1 then s:='Download Protocols';
        header (s);
        b:=true;
        assign (protfile,setup.bbsdir+'PROTOCOL.DAT');
        reset (protfile);
        if ioresult<>0 then begin
          rewrite (protfile);
          seek (protfile,0);
          prot.exec:='DSZ.COM';
          prot.ucline:='port %1 speed %2 rb -g %3';
          prot.dcline:='port %1 speed %2 sb -g %3';
          {prot.exec:='PROTOCOL.EXE';
          prot.ucline:='-C %1 -B %2 -R -G %3';
          prot.dcline:='-C %1 -B %2 -T -G %3';}
          prot.desc:='YmodemG';
          prot.key:='G';
          write (protfile,prot);
          seek (protfile,1);
          prot.exec:='DSZ.COM';
          prot.ucline:='port %1 speed %2 rz -m %3';
          prot.dcline:='port %1 speed %2 sz -m %3';
          {prot.exec:='PROTOCOL.EXE';
          prot.ucline:='-C %1 -B %2 -R -Z %3';
          prot.dcline:='-C %1 -B %2 -T -Z %3';}
          prot.desc:='Zmodem';
          prot.key:='Z';
          write (protfile,prot);
          sendwriteln (^Y'Protocol file re-created!');
        end;
        for ii:=1 to filesize (protfile) do begin
          seek (protfile,ii-1);
          read (protfile,prot);
          spacewrite (^X'['^Z+prot.key+^X'] '^Y+prot.desc,39);
          b:=not b;
          if b or ((ii mod 2)=0) then nl;
        end;
        close (protfile);
        if not b then nl;
        nl;
      end;
    end;

    function getprotocol (i:integer; c:char; fn:string):boolean;
      label doprot;
      var protfile:file of protocolrec;
          prot:protocolrec;
          b:boolean;
          cc,cc2:char;
          ii,iii:integer;
          s,ss:string[80];
    begin
      assign (protfile,setup.bbsdir+'PROTOCOL.DAT');
      {$I-}reset (protfile);{$I+}
      b:=false;
      for iii:=1 to filesize (protfile) do begin
        seek (protfile,iii-1);
        read (protfile,prot);
        if match (prot.key,c) then begin
          b:=true;
          goto doprot;
        end;
      end;
      doprot:
      {getprotocol:=false;
      prot:=0;
      case c of
        '1'..'6':begin
                   getprotocol:=true;
                   execprog:='';
                   cline:='';
                   prot:=valu (c);
                 end;
      end;}
      if (length (prot.ucline)>0) and (length (prot.dcline)>0) then begin
        if i=0 then s:=prot.ucline else if i=1 then s:=prot.dcline;
       {while pos (s,'%')>0 do begin
          ii:=pos (s,'%');
          case valu (s[ii+1]) of
            1:begin
                delete (s,ii,2);
                insert (strr (setup.com),s,ii);
              end;
            2:begin
                delete (s,ii,2);
                insert (strr (baudrate),s,ii);
              end;
            3:begin
                delete (s,ii,2);
                insert (fn,s,ii);
              end;
          end;
        end;}
        ss:='';
        ii:=0;
        while ii<>length (s) do begin
          inc (ii);
          cc:=s[ii];
          if cc='%' then begin
            inc (ii);
            cc2:=s[ii];
            case valu (cc2) of
              1:ss:=ss+strr (setup.com);
              2:ss:=ss+strr (connectbaud);
              3:ss:=ss+fn;
              else ss:=ss+cc2;
            end;
          end else ss:=ss+cc;
        end;
        execprog:=prot.exec;
        cline:=ss{s};
      end;
      close (protfile);
      getprotocol:=b;
    end;

begin
  clearscreen;
  listprotocol (i);
  prompt ('Protocol '^X'['^Z'CR'^X'/'^Y'Abort'^X']: ');
  if length (input)<1 then getprot:=false else begin
    c:=upcase (input[1]);
    getprot:=getprotocol (i,c,fn);
  end;
end;

procedure removefile (i:integer; b:boolean);
  var f:filerec;
      ii,iii:integer;
      u:userrec;

    procedure removepoints;
    begin
      if not doyesno ('Take points from '^Z+f.uploader+^Y'?') then exit;
      iii:=finduser (f.uploader);
      if iii=-1 then begin
        sendwriteln (^R'User has disappeared!');
        exit;
      end;
      readuser (u,iii);
      dec (u.numup);
      u.fpoint:=u.fpoint-(f.cost*setup.uploadfactor);
      u.uploadk:=u.uploadk-(f.filesize div 1024);
      writeuser (u,iii);
      readuser (user,usernum);
    end;

begin
  openfile;
  seekfile (i);
  read (xferf,f);
  if b then removepoints;
  sendwriteln (^Y'Deleting file from records.');
  for iii:=i to numfile-1 do begin
    seekfile (iii+1);
    read (xferf,f);
    seekfile (iii);
    write (xferf,f);
  end;
  seekfile (numfile);
  truncate (xferf);
  closefile;
end;

procedure changefile;
  var c:char;
      f:filerec;
      i:integer;

    procedure showinfo (f:filerec);
    begin
      clearscreen;
      with f do begin
        sendwriteln (^X'['^Z'F'^X'] '^Y'Filename'^X': '^Z+uppercase (filename));
        sendwriteln (^X'['^Z'L'^X'] '^Y'Path    '^X': '^Z+uppercase (path));
        sendwriteln (^X'['^Z'S'^X'] '^Y'Size    '^X': '^Z+strr (filesize));
        sendwriteln (^X'['^Z'C'^X'] '^Y'Cost    '^X': '^Z+strr (cost));
        sendwriteln (^X'['^Z'D'^X'] '^Y'Description'^X': '^Z+descrip);
        sendwriteln (^X'['^Z'U'^X'] '^Y'Uploader'^X': '^Z+uploader);
        sendwrite (^X'['^Z'P'^X'] '^Y'Private for'^X': '^Z);
        if length (prvfile)>0 then sendwriteln (prvfile) else sendwriteln ('Nobody');
        sendwriteln (^X'['^Z'V'^X'] '^Y'Uploaded'^X': '^Z+dateup);
        sendwriteln (^X'['^Z'G'^X'] '^Y'Group   '^X': '^Z+group);
        sendwriteln (^X'['^Z'#'^X'] '^Y'# of D/L''s'^X': '^Z+strr (numdown));
        sendwriteln (^X'['^Z'A'^X'] '^Y'Ask'^X': '^Z+boostr (ask)+^X'  ['^Z'N'^X'] '^Y'New'^X': '^Z+boostr (new));
        sendwrite (^X'['^Z'Z'^X'] '^Y'Password'^X': '^Z);
        if length (pass)>0 then sendwriteln (pass) else sendwriteln ('None');
        sendwriteln (^X'['^Z'R'^X'] '^Y'Grant uploader points');
        sendwriteln (^X'['^Z'-'^X'] '^Y'Add ZIP Comment');
        sendwriteln (^X'['^Z'+'^X'] '^Y'Add BBS Ad/File to ZIP');
        sendwriteln (^X'['^Z'='^X'] '^Y'Run Upload Event');
      end;
      nl;
    end;

begin
  {assignfile;
  resetfile;}
  openfile;
  if nofiles (true) then begin
    closefile;
    {closefile;}
    exit;
  end;
  i:=getfile;
  if i=0 then begin
    {closefile;}
    closefile;
    exit;
  end;
  seekfile (i);
  read (xferf,f);
  showinfo (f);
  repeat
    sendwrite (^Y'Command '^X'['^Z'?'^X'/'^Y'Help'^X']: ');
    c:=upcase (inchar);
    nl;
    case c of
      'F':inputstr ('Filename',f.filename,12);
      'L':begin
            inputstr ('Path'^X'/'^Y'Location',f.path,60);
            if f.path[length (f.path)]<>'\' then f.path:=f.path+'\';
          end;
      'S':begin
            if doyesno ('Change file to offline?') then f.filesize:=-1 else getfsize (f);
            if f.filesize=-1 then sendwriteln (^Y'This file is now set to Offline');
          end;
      'C':inputint ('Cost',f.cost,5,0,32767);
      'D':inputstr ('Description',f.descrip,30);
      'U':inputstr ('Uploader',f.uploader,30);
      'P':inputstr ('Private for',f.prvfile,30);
      'V':repeat
            inputstr ('Date Uploaded '^X'['^Z+curdate+^X']',f.dateup,8);
          until ((validdate (f.dateup)) and (length (f.dateup)=8)) or not online;
      'X':inputstr ('Send file to',f.prvfile,30);
      'Z':inputstr ('Password',f.pass,15);
      'G':inputstr ('Group',f.group,15);
      '#':inputint ('# of downloads',f.numdown,5,0,32767);
      'A':f.ask:=doyesno ('Special file?');
      'N':f.new:=doyesno ('New file?');
      '-':zipcomment (getfname (f.path,f.filename));
      '+':addbbsad (getfname (f.path,f.filename));
      '=':runuploadevent (getfname (f.path,f.filename));
      '?':showinfo (f);
    end;
  until (c='Q') or not online;
  seekfile (i);
  write (xferf,f);
  closefile;
  {closefile;}
  showinfo (f);
  writesysoplog ('Changed '+f.filename,user.handle);
end;

procedure deletefile;
  var f:filerec;
      ff:file;
      fn:string[80];
      i,ii:integer;
begin
  {assignfile;
  resetfile;}
  openfile;
  if nofiles (true) then begin
    closefile;
    exit;
  end;
  i:=getfile;
  if i=0 then exit;
  seekfile (i);
  read (xferf,f);
  fn:=getfname (f.path,f.filename);
  sendwriteln (^M^Y'Filename'^X': '^Z+fn);
  sendwriteln (^Y'Description'^X': '^Z+f.descrip+^M);
  closefile;
  if not doyesno ('Delete file?') then exit;
  removefile (i,true);
  if not doyesno ('Erase file'^X': '^Z+fn+^Y'?') then exit;
  assign (ff,fn);
  {$I-}erase (ff);{$I+}
  if ioresult<>0 then sendwriteln (^Z+fn+^Y' is not online!');
  writesysoplog ('Deleted '+f.filename,user.handle);
end;

function transfer (i:integer):integer;
  var code,ii:integer;
      ff:file;
      s:string[80];

    procedure checkcode (var code:integer);
    begin
      clearscreen;
      case code of
        0:begin
            sendwrite (^Y'Successful!');
            code:=0;
          end;
        else begin
          sendwrite (^Y'Aborted!');
          code:=1;
        end;
      end;
      sendwriteln (^G^M);
    end;

begin
  updatenode (setup.nodenum,3,user.handle);
  code:=0;
  clrscr;
  textcolor (15);
  textbackground (1);
  s:=user.handle+' is ';
  if i=0 then s:=s+'uploading' else
  if i=1 then s:=s+'downloading';
  ii:=(80-length (s)) div 2;
  gotoxy (1,1);
  clreol;
  gotoxy (ii,1);
  write (s);
  textbackground (0);
  writeln;
  writeln;
  {s:='Using Protocol ';
  case prot of
    1:s:=s+'Ascii';
    2:s:=s+'Xmodem';
    3:s:=s+'Xmodem-1k';
    4:s:=s+'Ymodem';
    5:s:=s+'Ymodem-G';
    6:s:=s+'Zmodem';
  end;
  ii:=(80-length (s)) div 2;
  gotoxy (1,2);
  clreol;
  gotoxy (ii,2);
  write (s);
  textbackground (0);
  writeln;
  statusline (0);
  case prot of
    1:begin
        P := New(AsciiProtocolPtr, Init(@uart));
        if P <> Nil then with AsciiProtocolPtr(P)^ do begin
          SetDelays(AsciiInterChar, AsciiInterLine);
          apOptionsOn(apSuppressCtrlZ);
        end;
      end;
    2,3:begin
          P := New(XModemProtocolPtr, Init(@uart, prot = 3, False));
          if P <> Nil then with XModemProtocolPtr(P)^ do begin
            SetBlockWait(RelaxedBlockWait);
            SetHandshakeWait(DefHandShakeWait, 0);
          end;
        end;
    4,5:begin
          P := New(YModemProtocolPtr, Init(@uart, True, prot = 5));
          if P <> Nil then with YModemProtocolPtr(P)^ do begin
            SetBlockWait(RelaxedBlockWait);
            SetHandshakeWait(DefHandShakeWait, 0);
          end;
        end;
    6:begin
        P := New(ZModemProtocolPtr, Init(@uart));
        if P <> Nil then with ZModemProtocolPtr(P)^ do SetFileMgmtOptions(True, False, WriteClobber);
      end;
    else P := Nil;
  end;
  if p = nil then begin
    code:=1;
    checkcode (code);
    transfer:=code;
    exit;
  end;
  cursor (false);
  if p <> Nil then p^.SetShowStatusProc(WindowStatus);
  if connectbaud<9600 then p^.setactualbps (connectbaud);
  if i=0 then with p^ do begin
    setreceivefilename (fn);
    setdestinationdirectory (dir);
    protocolreceive;
  end else if i=1 then with p^ do begin
    setfilemask (fn);
    protocoltransmit;
  end;
  cursor (true);
  code:=AsyncStatus;
  dispose (p,done);}
  s:=fsearch (execprog,GetEnv ('PATH'));
  {deactivateport;}
  exec (s,cline); {+' '+fn}
  {activateport;}
  cursor (true);
  if doserror<>0 then begin
    sendwrite (^Y'DOS Error #'^Z+strr (doserror)+^X' - ');
    case doserror of
      2:sendwrite (^Y'File not found');
      3:sendwrite (^Y'Path not found');
      5:sendwrite (^Y'Access denied');
      8:sendwrite (^Y'Not enough memory');
      else sendwrite (^Y'Unknown');
    end;
    sendwriteln (^Y'.'^M);
    pause;
    code:=1;
  end else code:=dosexitcode;
  chdir (copy (setup.bbsdir,1,length (setup.bbsdir)-1));
  com_set_baud (baudrate,'N',8,1);
  checkcode (code);
  updatenode (setup.nodenum,4,user.handle);
  transfer:=code;
end;

procedure clearbatch;
  var i:integer;
begin
  for i:=1 to maxbatch do fillchar (batch[i],sizeof (batch[i]),0);
  numbatch:=0;
end;

procedure upload;
  label afbatch,exitit;
  var b,hang:boolean;
      c,cc:char;
      ff:file;
      fn:string[80];
      i,ii,j,jj:integer;
begin
  if not upl then begin
    sendwriteln (^G^Y'You cannot upload to this area!'^M);
    exit;
  end;
  if not allowxfer then exit;
  if (timeevent<30) then begin
    sendwriteln (^G^Y'You cannot upload before a planned event.');
    exit;
  end;
  clearbatch;
  {if ansi or avatar then begin
    clearscreen;
    (*sendwriteln (^Y'Upload Entry Information'^M);*)
    header ('Upload Entry Information');
    sendxy (25,9,^Y'Free Space'^X': ');
    writefreespace (area.xferdir);
    if not freespace (area.xferdir) then begin
      clearscreen;
      sendwriteln (^Y'There is not enough free space for an upload!');
      exit;
    end;
    sendxy (25,10,^Y'Filename'^X':');
    repeat
      sendxy (35,10,'');
      cleareol;
      sendxy (35,10,'');
      inlen:=12;
      f.filename:=uppercase (prompt (''));
      if not (length (f.filename)>0) then begin
        clearscreen;
        goto exitit;
      end;
      if not validfname (f.filename) then begin
        clearscreen;
        goto exitit;
      end;
      f.path:=area.xferdir;
      fn:=getfname (f.path,f.filename);
      if searchexist (f.filename) then begin
        sendwriteln (^Y'File already exists!');
        goto exitit;
      end else b:=true;
    until b or not online;
    sendxy (35,10,^Z+f.filename);
    cleareol;
    sendxy (25,11,^Y'Description'^X':');
    repeat
      sendxy (38,11,'');
      cleareol;
      sendxy (38,11,'');
      inlen:=33;
      f.descrip:=prompt ('');
    until (length (f.descrip)>0) or not online;
    sendxy (38,11,^Z+f.descrip);
    cleareol;
    sendxy (25,12,^Y'Group'^X'/'^Y'Category'^X':');
    repeat
      sendxy (41,12,'');
      cleareol;
      sendxy (41,12,'');
      inlen:=15;
      f.group:=prompt ('');
    until (length (f.group)>0) or not online;
    sendxy (41,12,^Z+f.group);
    cleareol;
    sendxy (25,13,^Y'Private'^X'/'^Y'Send to'^X': ');
    inlen:=30;
    f.prvfile:=prompt ('');
    sendxy (42,13,^Z+f.prvfile);
    cleareol;
    sendxy (25,14,^Y'File Password'^X': ');
    inlen:=15;
    f.pass:=prompt ('');
    sendxy (40,14,^Z+f.pass);
    cleareol;
  end else}while (numbatch<maxbatch) do begin
    inc (numbatch);
    repeat
      sendwrite (^Y'Free Space'^X': ');
      writefreespace (area.xferdir);
      nl;
      if not freespace (area.xferdir) then begin
        sendwriteln (^Y'There is not enough free space for an upload!');
        dec (numbatch);
        goto afbatch;
      end;
      inlen:=12;
      prompt (^Y'Filename #'^Z+strr (numbatch)+^X': ');
      batch[numbatch].filename:=uppercase (input);
      if not (length (batch[numbatch].filename)>0) then begin
        clearscreen;
        dec (numbatch);
        goto afbatch;
      end;
      batch[numbatch].path:=area.xferdir;
      fn:=getfname (batch[numbatch].path,batch[numbatch].filename);
      b:=validfname (batch[numbatch].filename);
      if not b then sendwriteln (^Y'Invalid filename!') else begin
        b:=not searchexist (batch[numbatch].filename);
        if not b then sendwriteln (^Y'File already exists!');
      end;
    until b or not online;
    repeat
      inlen:=35;
      prompt (^Y'Description'^X': ');
      batch[numbatch].descrip:=input;
    until (length (batch[numbatch].descrip)>0) or not online;
    repeat
      inlen:=15;
      prompt (^Y'Group/Category'^X': ');
      batch[numbatch].group:=input;
    until (length (batch[numbatch].group)>0) or not online;
    inlen:=30;
    prompt (^Y'Private/Send to'^X': ');
    batch[numbatch].prvfile:=input;
    inlen:=15;
    prompt (^Y'Password'^X': ');
    batch[numbatch].pass:=input;
  end;
  afbatch:
  if numbatch<1 then exit;
  b:=getprot (0,c,area.xferdir);
  if not b then exit;
  hang:=doyesno ('Hang up after transfer?');
  clearscreen;
  sendwriteln (^Y'Ready to receive.  '^X'['^Z'Ctrl-X'^X'/'^Y'Abort'^X']');
  i:=timeleft;
  ii:=transfer (0);
  if ii>0 then begin
    for jj:=1 to numbatch do begin
      fn:=getfname (batch[numbatch].path,batch[numbatch].filename);
      if exist (fn) then begin
        assign (ff,fn);
        {$I-}erase (ff);{$I+}
        if ioresult<>0 then ;
      end;
    end;
    exit;
  end;
  for jj:=1 to numbatch do begin
    with batch[jj] do begin
      uploader:=user.handle;
      path:=area.xferdir;
      new:=true;
      ask:=false;
      numdown:=0;
      cost:=0;
      dateup:=curdate;
    end;
    getfsize (batch[jj]);
    autovalidate (batch[jj]);
    inc (user.uploadk,(batch[jj].filesize div 1024));
    inc (user.numup);
    if stat.numup>=32767 then stat.numup:=0;
    inc (stat.numup);
    inc (stat.uptoday);
    inc (stat.newup);
    inc (stat.ups);
    writeuser (user,usernum);
   {assignfile;
    resetfile;}
    openfile;
    addfile (batch[jj]);
    closefile;
   {closefile;}
    fn:=getfname (batch[numbatch].path,batch[numbatch].filename);
    zipcomment (fn);
    addbbsad (fn);
    runuploadevent (fn);
    writesysoplog ('Uploaded '+batch[jj].filename,user.handle);
  end;
  transferstatus;
  j:=timeleft;
  if setup.returntime then settimeleft (i);
  if hang then begin
    sendwriteln (^Y'Logging off after transfer.');
    hangupmodem;
  end else begin
    sendwriteln (^Y'Transfer took '^Z+strr (i-j)+^Y' minute(s).');
    if setup.returntime then
    sendwriteln (^Y'But the system will give it back to you.');
    nl;
    pause;
  end;
  exitit:
end;

function checkdl (f:filerec):boolean;
  var b:boolean;
      i:integer;

    procedure writedl (s:string);
    begin
      sendwriteln (^Y+s);
      b:=false;
    end;

begin
  b:=true;
  if connectbaud<setup.mindlbaud then
  writedl ('The minimum baud rate to download is '^Z+strr (setup.mindlbaud)+^Y'!');
  if (f.filesize div 1024>user.kleft) and not setup.freefiles then
  writedl ('Download K per day limit is too low for this file!');
  if not udpercent and b and not setup.freefiles then
  writedl ('Upload/Download Percent is unacceptable!  Please upload more!');
  if not pcpercent and b then
  writedl ('Post/Call Percent is unacceptable!  Please post more!');
  if (length (f.pass)>0) and b then begin
    prompt ('File Password'^X': ');
    if not (match (input,f.pass) or (match (input,'AUTOSENSE'))) then writedl ('Invalid password!');
  end;
  checkdl:=b;
end;

function checkfile (f:filerec):boolean;
  var b:boolean;

    procedure writedl (s:string);
    begin
      sendwriteln (^Y+s);
      b:=false;
    end;

begin
  b:=true;
  if not (priv_for_you (f)) and (length (f.prvfile)>0) and b then writedl ('This file is not for you!');
  if f.new and not asysop and b then
  writedl ('That file has not been validated yet!');
  if f.ask and not asysop and b then
  writedl ('That file has to be requested!');
  if not exist (getfname (f.path,f.filename)) and b then
  writedl ('That file is offline and has to be requested!');
  checkfile:=b;
end;

procedure download;
  var b,hang:boolean;
      c:char;
      f:filerec;
      ff:file;
      fn,ss:string[80];
      i,ii,iii,m,s,t:integer;
      fsize:longint;
begin
  {assignfile;
  resetfile;}
  openfile;
  if not downl then begin
    sendwriteln (^G^Y'You cannot download from this area!');
    exit;
  end;
  if not allowxfer then exit;
  if nofiles (true) then begin
    closefile;
    {closefile;}
    exit;
  end;
  iii:=getfile;
  if iii=0 then begin
    {closefile;}
    closefile;
    exit;
  end;
  seekfile (iii);
  read (xferf,f);
  if not checkdl (f) then begin
    closefile;
    exit;
  end;
  if not (asysop) and (f.cost>user.fpoint) and not (setup.freefiles) then begin
    sendwriteln (^Y'I''m sorry this file costs '^Z+strr (f.cost)+^Y' point(s).');
    closefile;
    exit;
  end;
  if not checkfile (f) then begin
    closefile;
    exit;
  end;
  fn:=getfname (f.path,f.filename);
  assign (ff,fn);
  reset (ff);
  if ioresult<>0 then begin
    sendwriteln (^Y'File does not exist!');
    exit;
  end;
  fsize:=filesize (ff);
  close (ff);
  ss:=minstr (fsize);
  m:=valu (copy (ss,1,pos (':',ss)-1));
  if (m>timeleft) and not (asysop) then begin
    sendwriteln (^Y'Not enough time for transfer!');
    exit;
  end;
  if (m-5>timeevent) then begin
    sendwriteln (^G^Y'You cannot download before a planned event.');
    exit;
  end;
  b:=getprot (1,c,fn);
  if not b then begin
    closefile;
    exit;
  end;
  hang:=doyesno ('Hang up after transfer?');
  clearscreen;
  sendwriteln (^Y'Filename      '^X': '^Z+f.filename);
  sendwrite (^Y'File Cost     '^X': '^Z);
  if (f.cost>0) and (not setup.freefiles) then sendwriteln (strr (f.cost)) else sendwriteln ('Free');
  sendwriteln (^Y'File Size     '^X': '^Z+strr (f.filesize));
  sendwriteln (^Y'Uploaded by   '^X': '^Z+f.uploader);
  sendwriteln (^Y'Estimated Time'^X': '^Z+ss);
  sendwriteln (^Y'Time Left     '^X': '^Z+strr (timeleft)+' minutes'^M);
  sendwriteln (^Y'Ready to send.  '^X'['^Z'Ctrl-X'^X'/'^Y'Abort'^X']');
  i:=timeleft;
  ii:=transfer (1);
  if ii<{2}1{} then begin
    inc (user.downloadk,(f.filesize div 1024));
    inc (user.numdn);
    if stat.numdn>=2147483647 then stat.numdn:=0;
    inc (stat.numdn);
    inc (stat.dntoday);
    inc (f.numdown);
    if not (asysop or setup.freefiles) then begin
      dec (user.fpoint,f.cost);
      dec (user.kleft,f.filesize div 1024);
    end;
    writeuser (user,usernum);
    seekfile (iii);
    write (xferf,f);
    closefile;
    writesysoplog ('Downloaded '+f.filename,user.handle);
    {closefile;}
    transferstatus;
    if hang then begin
      sendwriteln (^Y'Logging off after transfer.');
      hangupmodem;
    end;
  end;
end;

procedure removearea (i:integer);
  var ii:integer;
begin
  openarea;
  sendwriteln (^Y'Deleting area.');
  for ii:=i to numarea-1 do begin
    seekarea (ii+1);
    read (areaf,area);
    seekarea (ii);
    write (areaf,area);
  end;
  seekarea (numarea);
  truncate (areaf);
  closearea;
end;

procedure deletearea;
  var i:integer;
      f:file;
      area:arearec;
begin
  if not doyesno ('Delete area?') then exit;
  sendwriteln (^Y'Deleting files.');
  {assignarea;
  assignfile;
  resetarea;
  resetfile;
  for i:=numfile downto 1 do removefile (i,false);}
  {closefile;}
  assignfile;
  {$I-}erase (xferf);{$I+}
  if ioresult<>0 then sendwriteln (^Y'Error erasing xfer file.');
  removearea (curarea);
  sendwriteln (^Y'Area erased!');
  writesysoplog ('Erased xfer area #'+strr (curarea),user.handle);
  setarea (1,true);
  {closearea;}
end;

procedure zipview (fn:string);
  var f:file;
      s:string[80];
      status:word;
begin
  sendwriteln ('ZIP');
  s:=fsearch ('PKUNZIP.EXE',GetEnv ('PATH'));
  {deactivateport;}
  status:=execwithswap (getenv ('COMSPEC'),' /C '+s+' '+fn+' -Q -V >ARCHIVE.LST');
  {activateport;}
  printfile (setup.bbsdir+'ARCHIVE.LST',false);
  assign (f,setup.bbsdir+'ARCHIVE.LST');
  erase (f);
end;

procedure lzhview (fn:string);
  var f:file;
      s:string[80];
      status:word;
begin
  if pos ('.ICE',fn)>0 then sendwriteln ('LH-ICE') else sendwriteln ('LH-ARC');
  s:=fsearch ('LHARC.EXE',GetEnv ('PATH'));
  {deactivateport;}
  status:=execwithswap (getenv ('COMSPEC'),' /C '+s+' '+fn+' /V >ARCHIVE.LST');
  {activateport;}
  printfile (setup.bbsdir+'ARCHIVE.LST',false);
  assign (f,setup.bbsdir+'ARCHIVE.LST');
  erase (f);
end;

procedure listarch;
  var fname:string[127];
      f:filerec;
      i:integer;
begin
  {assignfile;
  resetfile;}
  openfile;
  if nofiles (true) then begin
    {closefile;}
    closefile;
    exit;
  end;
  i:=getfile;
  if i=0 then begin
    {closefile;}
    closefile;
    exit;
  end;
  seekfile (i);
  read (xferf,f);
  closefile;
  if not checkfile (f) then exit;
  {closefile;}
  fname:=getfname (f.path,f.filename);
  fname:=uppercase (fname);
  {}nl;{}
  header (bbsname+' Archive Viewer');
  {sendwriteln (^M^Y+bbsname+' Archive Viewer');}
  sendwrite (^Y'Archive type'^X': '^Z);
  if pos ('.ZIP',fname)>0 then zipview (fname) else
  if (pos ('.LZH',fname)>0) or (pos ('.ICE',fname)>0) then lzhview (fname) else begin
    sendwriteln ('File is not an archive!'^M);
    exit;
  end;
  nl;
  pause;
  writesysoplog ('Viewed '+f.filename,user.handle);
end;

procedure typefile;
  var fname:string[127];
      f:filerec;
      i:integer;
begin
  {assignfile;
  resetfile;}
  openfile;
  if nofiles (true) then begin
    {closefile;}
    closefile;
    exit;
  end;
  i:=getfile;
  if i=0 then begin
    {closefile;}
    closefile;
    exit;
  end;
  seekfile (i);
  read (xferf,f);
  if not checkfile (f) then begin
    closefile;
    exit;
  end;
  {closefile;}
  fname:=getfname (f.path,f.filename);
  fname:=uppercase (fname);
  if not (pos ('.ZIP', fname)>0) and not (pos ('.ARC',fname)>0) and
  not (pos ('.LZH',fname)>0) and not (pos ('.ICE',fname)>0) and not (pos ('.ARJ',fname)>0) then begin
    printfile (uppercase (getfname (f.path,f.filename)),false);
    nl;
    pause;
  end else sendwriteln (^Y'File is an archive, cannot type.');
  writesysoplog ('Typed/viewed '+f.filename,user.handle);
end;

procedure sortarea;
  var i:integer;

    procedure sort (i,ii:integer);
      label again;
      var f1,f2,f3,f4:filerec;
          j,jj,jjj:integer;

    begin
      jj:=i;
      jjj:=ii;
      j:=(i+ii) div 2;
      seek (xferf,j);
      read (xferf,f1);
      while jj<=jjj do begin
        seek(xferf,jj);
        read(xferf,f2);
        while (uppercase (f2.filename)<uppercase (f1.filename)) do begin
          inc (jj);
	  seek (xferf,jj);
          read (xferf,f2);
        end;
        seek (xferf,jjj);
        read (xferf,f3);
        while (uppercase (f1.filename)<uppercase (f3.filename)) do begin
          dec (jjj);
          seek (xferf,jjj);
          read (xferf,f3);
        end;
        if jj>jjj then goto again;
        f4:=f3;
        f3:=f2;
        f2:=f4;
        seek (xferf,jj);
        write (xferf,f2);
        seek (xferf,jjj);
        write (xferf,f3);
        inc (jj);
        dec (jjj);
      end;
      again:
      if i<jjj then sort (i,jjj);
      if jj<ii then sort (jj,ii);
    end;

begin
  header ('Sort Area');
  if not doyesno ('Sort files in area?') then exit;
  openfile;
  i:=numfile-1;
  if i<>0 then begin
    sendwriteln (^M^Y'Sorting in progress.');
    sort (0,i);
  end;
  closefile;
  writesysoplog ('Sorted file area',user.handle);
end;

procedure movefile;
  label done;
  var drive1,drive2:char;
      i,fn,ii:integer;
      s,ss,t:string[255];
      status:word;
      f:file;
      xf:filerec;
begin
  ii:=curarea;
  openfile;
  fn:=getfile;
  if fn=0 then begin
    closefile;
    exit;
  end;
  seekfile (fn);
  read (xferf,xf);
  closefile;
  sendwriteln (^M^Y'Filename'^X': '^Z+getfname (xf.path,xf.filename));
  sendwriteln (^Y'Description'^X': '^Z+xf.descrip+^M);
  openarea;
  i:=getarea;
  closearea;
  if i=0 then exit;
  sendwriteln (^Y'Moving file.');
  removefile (fn,false);
  setarea (i,false);
  ss:=xf.path;
  s:=getfname (xf.path,xf.filename);
  drive1:=upcase (area.xferdir[1]);
  drive2:=upcase (xf.path[1]);
  if ss<>area.xferdir then if doyesno ('Move file to correct directory?') then begin
    xf.path:=area.xferdir;
    t:=getfname (area.xferdir,xf.filename);
    if setup.fatmove and (drive1=drive2) then begin
      assign (f,s);
      rename (f,t);
      if ioresult<>0 then sendwriteln (^Y'File exists in that directory!');
    end else begin
      {deactivateport;}
      status:=execwithswap (getenv ('COMSPEC'),' /C COPY '+s+' '+t+' >NUL');
      {activateport;}
    end;
    assign (f,s);
    if exist (t) then begin
      erase (f);
      goto done;
    end else begin
      xf.path:=ss;
      sendwriteln (^Y'Error moving file!'^M);
      goto done;
    end;
  end;
  done:
  openfile;
  addfile (xf);
  closefile;
  writesysoplog ('Moved '+xf.filename+' to area #'+strr (i),user.handle);
  setarea (ii,true);
end;

function udpercent:boolean;
  var i,ii:integer;
begin
  udpercent:=false;
  i:=udp;
  ii:=user.minud;
  if ii<1 then ii:=setup.minud;
  if (i>ii) or asysop then udpercent:=true;
end;

function pcpercent:boolean;
  var i,ii:integer;
begin
  pcpercent:=false;
  i:=pcp;
  ii:=user.minpc;
  if ii<1 then ii:=setup.minpc;
  if (i>ii) or asysop then pcpercent:=true;
end;

function searchexist (s:string):boolean;
  label exit;
  var b:boolean;
      i,ii,j:integer;
      f:filerec;
begin
  b:=false;
  ii:=curarea;
  {for i:=1 to numarea do begin
    curarea:=i;}
    openfile;
    for j:=1 to numfile do begin
      seekfile (j);
      read (xferf,f);
      if match (f.filename,s) then begin
        b:=true;
        closefile;
        goto exit;
      end;
    end;
    closefile;
  {end;}
  exit:
  curarea:=ii;
  searchexist:=b;
end;

procedure reset_fpoints;
  var f:filerec;
      i:integer;
      l:longint;
begin
  sendwriteln (^Y'You are about to change the cost of all the files in');
  sendwriteln (^Y'this area to the settings of Infinity.'^M);
  if not doyesno ('Are you sure?') then exit;
  openfile;
  for i:=1 to numfile do begin
    seekfile (i);
    read (xferf,f);
    l:=f.filesize div 1024;
    f.cost:=l div setup.pointvalue;
    seekfile (i);
    write (xferf,f);
  end;
  closefile;
  sendwriteln (^M^Y'Done!'^M^M);
end;

procedure reset_loc;
  var f:filerec;
      i:integer;
begin
  sendwriteln (^Y'You are about to change the paths of all the files in');
  sendwriteln (^Y'this area to the pathname as the current settings.'^M);
  if not doyesno ('Are you sure?') then exit;
  openfile;
  for i:=1 to numfile do begin
    seekfile (i);
    read (xferf,f);
    f.path:=area.xferdir;
    seekfile (i);
    write (xferf,f);
  end;
  closefile;
  sendwrite (^M^Y'Done!'^M^M);
end;

begin
end.