{$I+,S+}
unit windows;

interface

uses crt,records,strunit;

type windowrec=record
       x1,y1,x2,y2,
       cx,cy:byte
     end;

var winds:array [0..2] of windowrec;
    split,inuse:integer;

procedure getcoor;
procedure usewind (n:byte);
procedure setwind (n:byte; nx1,ny1,nx2,ny2:byte);
procedure initwind (n,nx1,ny1,nx2,ny2:byte);
procedure drawsplit;
procedure initwinds;
procedure statusline (i:integer);

implementation

procedure getcoor;
begin
  with winds[inuse] do begin
    cx:=wherex;
    cy:=wherey;
    if cy<1 then cy:=1;
    if cy>(y2-y1)+1 then cy:=(y2-y1)+1;
  end
end;

procedure usewind (n:byte);
begin
  getcoor;
  inuse:=n;
  with winds[n] do begin
    window (x1,y1,x2,y2);
    gotoxy (cx,cy);
    textbackground (0);
    lasty:=y2-y1+1;
  end
end;

procedure setwind (n:byte; nx1,ny1,nx2,ny2:byte);
var i:integer;
begin
  i:=inuse;
  usewind(n);
  with winds[n] do begin
    x1:=nx1;
    y1:=ny1;
    x2:=nx2;
    y2:=ny2;
  end;
  usewind(n);
  if n<>i then usewind(i);
end;

procedure initwind (n,nx1,ny1,nx2,ny2:byte);
begin
  with winds[n] do begin
    x1:=nx1;
    y1:=ny1;
    x2:=nx2;
    y2:=ny2;
    cx:=1;
    cy:=1;
  end;
end;

procedure drawsplit;
var cnt:integer;
begin
  usewind (0);
  textbackground (0);
  gotoxy (1,split);
  for cnt:=1 to 80 do write (' ');
  usewind (2);
end;

procedure initwinds;
begin
  splitmode:=false;
  initwind (1,1,1,80,25);
  initwind (2,1,1,80,24);
  split:=0;
  stati:=1;
  usewind (2);
end;

{procedure getcolorvar (attr:byte; var fg,bk:integer);
begin
  fg:=attr and 15;
  bk:=attr div 16;
end;}

procedure statusline (i:integer);
  var ii,j,jj,{fg,bk,}cur:integer;
begin
  cur:=textattr;
  ii:=inuse;
  cursor (false);
  jj:=i;
  if jj=0 then jj:=stati else stati:=jj;
  usewind (1);
  gotoxy (1,25);
  {getcolorvar (setup.statusbarcolor,fg,bk);
  textcolor (fg);
  textbackground (0);}textcolor (setup.statusbarcolor and 15);
  if (length (user.handle)>0) and not (jj=0) then begin
    textbackground ({bk}setup.statusbarcolor div 16);
    write (' '+user.handle+'  ');
    write ('Main: '+strr (user.mlevel)+'  Msg: '+strr (user.msglevel)+
    '  Xfer: '+strr (user.xflevel)+'  ');
    if jj=1 then write ('Time: '+strr (timeleft)) else if jj=2 then begin
      write ('Baud: ');
      if not local then write (strr (baudrate)) else write ('Local');
    end else if jj=3 then write ('AV: '+boostr (sysopavail));
  end;
  clreol;
  usewind (ii);
  cursor (true);
  textattr:=cur;
  {textcolor (cur and $8f);
  textbackground (0);}
end;

begin
end.