{$I+,S+}
unit voting;

interface

uses crt,dos,inout,records,strunit,usermisc;

procedure openvotef;
procedure closevotef;
procedure showresults (i:integer);
procedure addvoting;
procedure editvote (i:integer);

implementation

procedure seekvote (i:integer);
begin
  seek (votef,i-1);
end;

function numvote:integer;
begin
  numvote:=filesize (votef);
end;

procedure openvotef;
begin
  assign (votef,setup.datadir+'VOTING.DAT');
  {$I-}reset (votef);{$I+}
  if ioresult<>0 then {$I-}rewrite (votef);{$I+}
end;

procedure closevotef;
begin
  close (votef);
end;

procedure seekvotef (i:integer);
begin
  seek (votef,i-1);
end;

procedure showresults (i:integer);
  var j:integer;
      ii:real;
begin
  if i>0 then begin
    seekvotef (i);
    read (votef,vote);
    with vote do begin
      clearscreen;
      ii:=100.0*numvoted/numusers;
      sendwriteln (^Y'Topic'^X': '^Z+topic);
      sendwriteln (^Z+streal (ii)+^Y'% of '^Z+strr (numusers)+^Y' have voted.'^M);
      sendwriteln (^Y'#    Choice                          Votes');
      writeline (79);
      for j:=1 to maxchoices do begin
        if length (choice[j])>0 then begin
          spacewrite (strr (j),5);
          spacewrite (choice[j],32);
          sendwriteln (strr (choicevote[j]));
        end;
      end;
    end;
    nl;
    pause;
  end;
end;

{procedure editarea;
  var a:arearec;
      c:char;
      s:string;
begin
  seekarea (curarea);
  read (areaf,a);
  repeat
    clearscreen;
    header ('Transfer Area Information');
    sendwriteln (^X' ['^Z'A'^X']'^Y' Name'^X': '^Z+a.name);
    sendwriteln (^X' ['^Z'B'^X']'^Y' Area Sysop'^X': '^Z+a.asysop);
    sendwriteln (^X' ['^Z'C'^X']'^Y' Level'^X': '^Z+strr (a.level));
    sendwriteln (^X' ['^Z'D'^X']'^Y' Uploading'^X': '^Z+boostr (a.up));
    sendwriteln (^X' ['^Z'E'^X']'^Y' Downloading'^X': '^Z+boostr (a.down));
    sendwriteln (^X' ['^Z'F'^X']'^Y' Path'^X': '^Z+a.xferdir+^M);
    sendxy (1,10,^Y'Command'^X': ');
    cleareol;
    c:=upcase (inchar);
    case c of
      'A':begin
            sendxy (1,10,'');
            cleareol;
            inlen:=30;
            s:=prompt ('Name of Area'^X': ');
            if length (s)>0 then a.name:=s;
          end;
      'B':begin
            sendxy (1,10,'');
            cleareol;
            inlen:=30;
            s:=prompt ('Area Sysop'^X': ');
            if length (s)>0 then a.asysop:=s;
          end;
      'C':begin
            sendxy (1,10,'');
            cleareol;
            inlen:=5;
            s:=prompt ('Level'^X': ');
            if valu (s)>-1 then a.level:=valu (s);
          end;
      'D':begin
            sendxy (1,10,'');
            cleareol;
            a.up:=doyesno ('Allow uploading?');
          end;
      'E':begin
            sendxy (1,10,'');
            cleareol;
            a.down:=doyesno ('Allow downloading?');
          end;
      'F':begin
            sendxy (1,10,'');
            cleareol;
            a.xferdir:=getpath;
          end;
    end;
  until (c='Q') or not online;
  nl;
  seekarea (curarea);
  write (areaf,a);
  curareaname:=a.name;
end;}
procedure editvote (i:integer);
  var c:char;
begin
end;

procedure addvoting;
  var i,ii:integer;
begin
  i:=numvote+1;
  with vote do begin
    topic:='New Voting Question';
    level:=0;
    addlevel:=setup.vmlevel;
    numvoted:=0;
    add:=true;
    mandatory:=true;
    for ii:=1 to maxchoices do choice[ii]:='';
    for ii:=1 to maxchoices do choicevote[ii]:=0;
  end;
  seekvote (i);
  write (votef,vote);
  editvote (i);
  sendwriteln (^Y'Question created.');
  writesysoplog ('Added question #'+strr (i),user.handle);
end;

begin
end.